#include "Voltage.h"

Voltage::Voltage(byte pin, ReferenceVoltages referenceVolatage, float voltageDivider, int readings) {
  m_Pin = pin;
  m_Readings = readings;
  m_voltageDivider = voltageDivider;
  switch (referenceVolatage) {
    case ReferenceVoltage11:
      m_ReferenceVoltage = 1.1;
      break;
    case ReferenceVoltage33:
      m_ReferenceVoltage = 3.3;
      break;
    case ReferenceVoltage50:
      m_ReferenceVoltage = 5.0;
      break;
  }
}

float Voltage::ReadVoltage() {
  float voltage = 0;
  for (int i = 0; i < m_Readings; i++) {
    voltage += (analogRead(m_Pin) * m_ReferenceVoltage) / 1024;
  }
  voltage /= m_Readings;

  voltage *= m_voltageDivider;

  return voltage;
}

