#include "SRF02.h"
#include "Wire.h"

SRF02::SRF02(byte address, byte mode) {
  m_Address = address;
  m_Mode = mode;
}

float SRF02::ReadDistance() {
  unsigned int result = -1;

  Wire.begin();
  
  // Start measuring
  Wire.beginTransmission(m_Address);
  Wire.write((unsigned char)SRF_COMMAND_REGISTER);
  Wire.write(m_Mode);
  Wire.endTransmission();
  delay(65);

  Wire.beginTransmission(m_Address);
  Wire.write(SRF_RESULT_REGISTER);
  Wire.endTransmission();

  Wire.requestFrom(m_Address, (byte)2);
  unsigned long started = millis();
  bool failed = false;
  while (Wire.available() < 2) {
    delay(1);
    if (millis() > started + 500) {
      failed = true;
      break;
    }
  }
 
  if(!failed) {
    result = Wire.read() << 8;
    result += Wire.read();
  }

  return float(result);
}

