/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff;

import cz.startnet.utils.pgdiff.PgDiffArguments;
import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.SearchPathHelper;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgSequence;
import cz.startnet.utils.pgdiff.schema.PgSequencePrivilege;
import java.io.PrintWriter;

public class PgDiffSequences {
    public static void createSequences(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        for (PgSequence pgSequence : pgSchema2.getSequences()) {
            if (pgSchema != null && pgSchema.containsSequence(pgSequence.getName())) continue;
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.println(pgSequence.getCreationSQL());
            for (PgSequencePrivilege pgSequencePrivilege : pgSequence.getPrivileges()) {
                printWriter.println("REVOKE ALL ON SEQUENCE " + PgDiffUtils.getQuotedName(pgSequence.getName()) + " FROM " + pgSequencePrivilege.getRoleName() + ";");
                if (!"".equals(pgSequencePrivilege.getPrivilegesSQL(true))) {
                    printWriter.println("GRANT " + pgSequencePrivilege.getPrivilegesSQL(true) + " ON SEQUENCE " + PgDiffUtils.getQuotedName(pgSequence.getName()) + " TO " + pgSequencePrivilege.getRoleName() + " WITH GRANT OPTION;");
                }
                if ("".equals(pgSequencePrivilege.getPrivilegesSQL(false))) continue;
                printWriter.println("GRANT " + pgSequencePrivilege.getPrivilegesSQL(false) + " ON SEQUENCE " + PgDiffUtils.getQuotedName(pgSequence.getName()) + " TO " + pgSequencePrivilege.getRoleName() + ";");
            }
        }
    }

    public static void alterCreatedSequences(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        for (PgSequence pgSequence : pgSchema2.getSequences()) {
            if (pgSchema != null && pgSchema.containsSequence(pgSequence.getName()) || pgSequence.getOwnedBy() == null || pgSequence.getOwnedBy().isEmpty()) continue;
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.println(pgSequence.getOwnedBySQL());
        }
    }

    public static void dropSequences(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        if (pgSchema == null) {
            return;
        }
        for (PgSequence pgSequence : pgSchema.getSequences()) {
            if (pgSchema2.containsSequence(pgSequence.getName())) continue;
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.println(pgSequence.getDropSQL());
        }
    }

    public static void alterSequences(PrintWriter printWriter, PgDiffArguments pgDiffArguments, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        if (pgSchema == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        for (PgSequence pgSequence : pgSchema2.getSequences()) {
            String string;
            String string2;
            PgSequence pgSequence2 = pgSchema.getSequence(pgSequence.getName());
            if (pgSequence2 == null) continue;
            stringBuilder.setLength(0);
            String string3 = pgSequence2.getDataType();
            String string4 = pgSequence.getDataType();
            if (string4 != null && !string4.equals(string3)) {
                stringBuilder.append(System.getProperty("line.separator"));
                stringBuilder.append("\tAS ");
                stringBuilder.append(string4);
            }
            String string5 = pgSequence2.getIncrement();
            String string6 = pgSequence.getIncrement();
            if (string6 != null && !string6.equals(string5)) {
                stringBuilder.append(System.getProperty("line.separator"));
                stringBuilder.append("\tINCREMENT BY ");
                stringBuilder.append(string6);
            }
            String string7 = pgSequence2.getMinValue();
            String string8 = pgSequence.getMinValue();
            if (string8 == null && string7 != null) {
                stringBuilder.append(System.getProperty("line.separator"));
                stringBuilder.append("\tNO MINVALUE");
            } else if (string8 != null && !string8.equals(string7)) {
                stringBuilder.append(System.getProperty("line.separator"));
                stringBuilder.append("\tMINVALUE ");
                stringBuilder.append(string8);
            }
            String string9 = pgSequence2.getMaxValue();
            String string10 = pgSequence.getMaxValue();
            if (string10 == null && string9 != null) {
                stringBuilder.append(System.getProperty("line.separator"));
                stringBuilder.append("\tNO MAXVALUE");
            } else if (string10 != null && !string10.equals(string9)) {
                stringBuilder.append(System.getProperty("line.separator"));
                stringBuilder.append("\tMAXVALUE ");
                stringBuilder.append(string10);
            }
            if (!pgDiffArguments.isIgnoreStartWith()) {
                string2 = pgSequence2.getStartWith();
                string = pgSequence.getStartWith();
                if (string != null && !string.equals(string2)) {
                    stringBuilder.append(System.getProperty("line.separator"));
                    stringBuilder.append("\tRESTART WITH ");
                    stringBuilder.append(string);
                }
            }
            string2 = pgSequence2.getCache();
            string = pgSequence.getCache();
            if (string != null && !string.equals(string2)) {
                stringBuilder.append(System.getProperty("line.separator"));
                stringBuilder.append("\tCACHE ");
                stringBuilder.append(string);
            }
            boolean bl = pgSequence2.isCycle();
            boolean bl2 = pgSequence.isCycle();
            if (bl && !bl2) {
                stringBuilder.append(System.getProperty("line.separator"));
                stringBuilder.append("\tNO CYCLE");
            } else if (!bl && bl2) {
                stringBuilder.append(System.getProperty("line.separator"));
                stringBuilder.append("\tCYCLE");
            }
            String string11 = pgSequence2.getOwnedBy();
            String string12 = pgSequence.getOwnedBy();
            if (string12 != null && !string12.equals(string11)) {
                stringBuilder.append(System.getProperty("line.separator"));
                stringBuilder.append("\tOWNED BY ");
                stringBuilder.append(string12);
            }
            if (stringBuilder.length() > 0) {
                searchPathHelper.outputSearchPath(printWriter);
                printWriter.println();
                printWriter.print("ALTER SEQUENCE " + PgDiffUtils.getQuotedName(pgSequence.getName()));
                printWriter.print(stringBuilder.toString());
                printWriter.println(';');
            }
            if (pgSequence2.getComment() == null && pgSequence.getComment() != null || pgSequence2.getComment() != null && pgSequence.getComment() != null && !pgSequence2.getComment().equals(pgSequence.getComment())) {
                searchPathHelper.outputSearchPath(printWriter);
                printWriter.println();
                printWriter.print("COMMENT ON SEQUENCE ");
                printWriter.print(PgDiffUtils.getQuotedName(pgSequence.getName()));
                printWriter.print(" IS ");
                printWriter.print(pgSequence.getComment());
                printWriter.println(';');
            } else if (pgSequence2.getComment() != null && pgSequence.getComment() == null) {
                searchPathHelper.outputSearchPath(printWriter);
                printWriter.println();
                printWriter.print("COMMENT ON SEQUENCE ");
                printWriter.print(pgSequence.getName());
                printWriter.println(" IS NULL;");
            }
            PgDiffSequences.alterPrivileges(printWriter, pgSequence2, pgSequence, searchPathHelper);
        }
    }

    private static void alterPrivileges(PrintWriter printWriter, PgSequence pgSequence, PgSequence pgSequence2, SearchPathHelper searchPathHelper) {
        PgSequencePrivilege pgSequencePrivilege;
        boolean bl = false;
        for (PgSequencePrivilege pgSequencePrivilege2 : pgSequence.getPrivileges()) {
            pgSequencePrivilege = pgSequence2.getPrivilege(pgSequencePrivilege2.getRoleName());
            if (pgSequencePrivilege == null) {
                if (!bl) {
                    printWriter.println();
                }
                printWriter.println("REVOKE ALL ON SEQUENCE " + PgDiffUtils.getQuotedName(pgSequence.getName()) + " FROM " + pgSequencePrivilege2.getRoleName() + ";");
                continue;
            }
            if (pgSequencePrivilege2.isSimilar(pgSequencePrivilege)) continue;
            if (!bl) {
                printWriter.println();
            }
            printWriter.println("REVOKE ALL ON SEQUENCE " + PgDiffUtils.getQuotedName(pgSequence2.getName()) + " FROM " + pgSequencePrivilege.getRoleName() + ";");
            if (!"".equals(pgSequencePrivilege.getPrivilegesSQL(true))) {
                printWriter.println("GRANT " + pgSequencePrivilege.getPrivilegesSQL(true) + " ON SEQUENCE " + PgDiffUtils.getQuotedName(pgSequence2.getName()) + " TO " + pgSequencePrivilege.getRoleName() + " WITH GRANT OPTION;");
            }
            if ("".equals(pgSequencePrivilege.getPrivilegesSQL(false))) continue;
            printWriter.println("GRANT " + pgSequencePrivilege.getPrivilegesSQL(false) + " ON SEQUENCE " + PgDiffUtils.getQuotedName(pgSequence2.getName()) + " TO " + pgSequencePrivilege.getRoleName() + ";");
        }
        for (PgSequencePrivilege pgSequencePrivilege2 : pgSequence2.getPrivileges()) {
            pgSequencePrivilege = pgSequence.getPrivilege(pgSequencePrivilege2.getRoleName());
            if (pgSequencePrivilege != null) continue;
            if (!bl) {
                printWriter.println();
            }
            printWriter.println("REVOKE ALL ON SEQUENCE " + PgDiffUtils.getQuotedName(pgSequence2.getName()) + " FROM " + pgSequencePrivilege2.getRoleName() + ";");
            if (!"".equals(pgSequencePrivilege2.getPrivilegesSQL(true))) {
                printWriter.println("GRANT " + pgSequencePrivilege2.getPrivilegesSQL(true) + " ON SEQUENCE " + PgDiffUtils.getQuotedName(pgSequence2.getName()) + " TO " + pgSequencePrivilege2.getRoleName() + " WITH GRANT OPTION;");
            }
            if ("".equals(pgSequencePrivilege2.getPrivilegesSQL(false))) continue;
            printWriter.println("GRANT " + pgSequencePrivilege2.getPrivilegesSQL(false) + " ON SEQUENCE " + PgDiffUtils.getQuotedName(pgSequence2.getName()) + " TO " + pgSequencePrivilege2.getRoleName() + ";");
        }
    }

    private PgDiffSequences() {
    }
}

