#!/usr/bin/perl

# this creates the Test::DoubleEncodedEntities::Entities file

use 5.012;
use warnings;
use IO::Handle;
use XML::LibXML;
use Path::Class qw(file dir);
use Findbin qw($FindBin::Bin);

# mirror the entities file from the server
use LWP::Simple qw(mirror);
my $url      = "http://www.w3.org/TR/html5/named-character-references.html";
my $filename = "named-character-references.html";
#mirror($url,$filename);
my $doc =  XML::LibXML->new()->parse_html_file( $filename );
my @ent = map { $_ ->textContent(); } $doc->findnodes("//code");
s/;\s*// foreach @ent;

use DateTime;
my $date = DateTime->now();

my $version = 1326304652 - $date->epoch;

dir($FindBin::Bin)->parent->file("lib","Test","DoubleEncodedEntities","Entities.pm")->openw->print(<<"PERL");

##############################################
# This file is autogenerated by create_deee.pl
# do not edit!
##############################################

package Test::DoubleEncodedEntities::Entities;

use 5.006;

use strict;
use warnings;

our \$VERSION = $version;

use base qw(Exporter);
our \@EXPORT = qw(\@entities);

our \@entities = qw(
 @ent
);

=head1 NAME

Test::DoubleEncodedEntities::Entities - HTML 4.0 entities

=head1 SYNOPSIS

  # exports \@entities;
  use Test::DoubleEncodedEntities::Entities;

=head1 DESCRIPTION

Exports the one array \@entities that contains the HTML 5
entities as defined in $url on $date.

These are:

=over 

@{[ join "\n\n", map { "=item $_"} @ent ]}

=back

=head1 AUTHOR

Generated by Mark Fowler from
http://www.w3.org/TR/html5/named-character-references.html

=head1 BUGS

Technically HTML5 is only a draft spec, so data in the module is subject to
change without notice.

=head1 SEE ALSO

L<Test::DoubleEncodedEntities>

L<$url>

=cut

1;

PERL

