# Generated by default/object.tt
package Paws::MediaConvert::XavcSettings;
  use Moose;
  has AdaptiveQuantization => (is => 'ro', isa => 'Str', request_name => 'adaptiveQuantization', traits => ['NameInRequest']);
  has EntropyEncoding => (is => 'ro', isa => 'Str', request_name => 'entropyEncoding', traits => ['NameInRequest']);
  has FramerateControl => (is => 'ro', isa => 'Str', request_name => 'framerateControl', traits => ['NameInRequest']);
  has FramerateConversionAlgorithm => (is => 'ro', isa => 'Str', request_name => 'framerateConversionAlgorithm', traits => ['NameInRequest']);
  has FramerateDenominator => (is => 'ro', isa => 'Int', request_name => 'framerateDenominator', traits => ['NameInRequest']);
  has FramerateNumerator => (is => 'ro', isa => 'Int', request_name => 'framerateNumerator', traits => ['NameInRequest']);
  has Profile => (is => 'ro', isa => 'Str', request_name => 'profile', traits => ['NameInRequest']);
  has SlowPal => (is => 'ro', isa => 'Str', request_name => 'slowPal', traits => ['NameInRequest']);
  has Softness => (is => 'ro', isa => 'Int', request_name => 'softness', traits => ['NameInRequest']);
  has SpatialAdaptiveQuantization => (is => 'ro', isa => 'Str', request_name => 'spatialAdaptiveQuantization', traits => ['NameInRequest']);
  has TemporalAdaptiveQuantization => (is => 'ro', isa => 'Str', request_name => 'temporalAdaptiveQuantization', traits => ['NameInRequest']);
  has Xavc4kIntraCbgProfileSettings => (is => 'ro', isa => 'Paws::MediaConvert::Xavc4kIntraCbgProfileSettings', request_name => 'xavc4kIntraCbgProfileSettings', traits => ['NameInRequest']);
  has Xavc4kIntraVbrProfileSettings => (is => 'ro', isa => 'Paws::MediaConvert::Xavc4kIntraVbrProfileSettings', request_name => 'xavc4kIntraVbrProfileSettings', traits => ['NameInRequest']);
  has Xavc4kProfileSettings => (is => 'ro', isa => 'Paws::MediaConvert::Xavc4kProfileSettings', request_name => 'xavc4kProfileSettings', traits => ['NameInRequest']);
  has XavcHdIntraCbgProfileSettings => (is => 'ro', isa => 'Paws::MediaConvert::XavcHdIntraCbgProfileSettings', request_name => 'xavcHdIntraCbgProfileSettings', traits => ['NameInRequest']);
  has XavcHdProfileSettings => (is => 'ro', isa => 'Paws::MediaConvert::XavcHdProfileSettings', request_name => 'xavcHdProfileSettings', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConvert::XavcSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConvert::XavcSettings object:

  $service_obj->Method(Att1 => { AdaptiveQuantization => $value, ..., XavcHdProfileSettings => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConvert::XavcSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->AdaptiveQuantization

=head1 DESCRIPTION

Required when you set (Codec) under
(VideoDescription)E<gt>(CodecSettings) to the value XAVC.

=head1 ATTRIBUTES


=head2 AdaptiveQuantization => Str

Keep the default value, Auto (AUTO), for this setting to have
MediaConvert automatically apply the best types of quantization for
your video content. When you want to apply your quantization settings
manually, you must set Adaptive quantization (adaptiveQuantization) to
a value other than Auto (AUTO). Use this setting to specify the
strength of any adaptive quantization filters that you enable. If you
don't want MediaConvert to do any adaptive quantization in this
transcode, set Adaptive quantization to Off (OFF). Related settings:
The value that you choose here applies to the following settings:
Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial
adaptive quantization (spatialAdaptiveQuantization), and Temporal
adaptive quantization (temporalAdaptiveQuantization).


=head2 EntropyEncoding => Str

Optional. Choose a specific entropy encoding mode only when you want to
override XAVC recommendations. If you choose the value auto,
MediaConvert uses the mode that the XAVC file format specifies given
this output's operating point.


=head2 FramerateControl => Str

If you are using the console, use the Frame rate setting to specify the
frame rate for this output. If you want to keep the same frame rate as
the input video, choose Follow source. If you want to do frame rate
conversion, choose a frame rate from the dropdown list. The framerates
shown in the dropdown list are decimal approximations of fractions. If
you are creating your transcoding job specification as a JSON file
without the console, use FramerateControl to specify which value the
service uses for the frame rate for this output. Choose
INITIALIZE_FROM_SOURCE if you want the service to use the frame rate
from the input. Choose SPECIFIED if you want the service to use the
frame rate that you specify in the settings FramerateNumerator and
FramerateDenominator.


=head2 FramerateConversionAlgorithm => Str

Choose the method that you want MediaConvert to use when increasing or
decreasing the frame rate. We recommend using drop duplicate
(DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to
30 fps. For numerically complex conversions, you can use interpolate
(INTERPOLATE) to avoid stutter. This results in a smooth picture, but
might introduce undesirable video artifacts. For complex frame rate
conversions, especially if your source video has already been converted
from its original cadence, use FrameFormer (FRAMEFORMER) to do
motion-compensated interpolation. FrameFormer chooses the best
conversion method frame by frame. Note that using FrameFormer increases
the transcoding time and incurs a significant add-on cost.


=head2 FramerateDenominator => Int

When you use the API for transcode jobs that use frame rate conversion,
specify the frame rate as a fraction. For example, 24000 / 1001 =
23.976 fps. Use FramerateDenominator to specify the denominator of this
fraction. In this example, use 1001 for the value of
FramerateDenominator. When you use the console for transcode jobs that
use frame rate conversion, provide the value as a decimal number for
Frame rate. In this example, specify 23.976.


=head2 FramerateNumerator => Int

When you use the API for transcode jobs that use frame rate conversion,
specify the frame rate as a fraction. For example, 24000 / 1001 =
23.976 fps. Use FramerateNumerator to specify the numerator of this
fraction. In this example, use 24000 for the value of
FramerateNumerator. When you use the console for transcode jobs that
use frame rate conversion, provide the value as a decimal number for
Framerate. In this example, specify 23.976.


=head2 Profile => Str

Specify the XAVC profile for this output. For more information, see the
Sony documentation at https://www.xavc-info.org/. Note that
MediaConvert doesn't support the interlaced video XAVC operating points
for XAVC_HD_INTRA_CBG. To create an interlaced XAVC output, choose the
profile XAVC_HD.


=head2 SlowPal => Str

Ignore this setting unless your input frame rate is 23.976 or 24 frames
per second (fps). Enable slow PAL to create a 25 fps output by
relabeling the video frames and resampling your audio. Note that
enabling this setting will slightly reduce the duration of your video.
Related settings: You must also set Frame rate to 25. In your JSON job
specification, set (framerateControl) to (SPECIFIED),
(framerateNumerator) to 25 and (framerateDenominator) to 1.


=head2 Softness => Int

Ignore this setting unless your downstream workflow requires that you
specify it explicitly. Otherwise, we recommend that you adjust the
softness of your output by using a lower value for the setting
Sharpness (sharpness) or by enabling a noise reducer filter
(noiseReducerFilter). The Softness (softness) setting specifies the
quantization matrices that the encoder uses. Keep the default value, 0,
for flat quantization. Choose the value 1 or 16 to use the default JVT
softening quantization matricies from the H.264 specification. Choose a
value from 17 to 128 to use planar interpolation. Increasing values
from 17 to 128 result in increasing reduction of high-frequency data.
The value 128 results in the softest video.


=head2 SpatialAdaptiveQuantization => Str

The best way to set up adaptive quantization is to keep the default
value, Auto (AUTO), for the setting Adaptive quantization
(adaptiveQuantization). When you do so, MediaConvert automatically
applies the best types of quantization for your video content. Include
this setting in your JSON job specification only when you choose to
change the default value for Adaptive quantization. For this setting,
keep the default value, Enabled (ENABLED), to adjust quantization
within each frame based on spatial variation of content complexity.
When you enable this feature, the encoder uses fewer bits on areas that
can sustain more distortion with no noticeable visual degradation and
uses more bits on areas where any small distortion will be noticeable.
For example, complex textured blocks are encoded with fewer bits and
smooth textured blocks are encoded with more bits. Enabling this
feature will almost always improve your video quality. Note, though,
that this feature doesn't take into account where the viewer's
attention is likely to be. If viewers are likely to be focusing their
attention on a part of the screen with a lot of complex texture, you
might choose to disable this feature. Related setting: When you enable
spatial adaptive quantization, set the value for Adaptive quantization
(adaptiveQuantization) depending on your content. For homogeneous
content, such as cartoons and video games, set it to Low. For content
with a wider variety of textures, set it to High or Higher.


=head2 TemporalAdaptiveQuantization => Str

The best way to set up adaptive quantization is to keep the default
value, Auto (AUTO), for the setting Adaptive quantization
(adaptiveQuantization). When you do so, MediaConvert automatically
applies the best types of quantization for your video content. Include
this setting in your JSON job specification only when you choose to
change the default value for Adaptive quantization. For this setting,
keep the default value, Enabled (ENABLED), to adjust quantization
within each frame based on temporal variation of content complexity.
When you enable this feature, the encoder uses fewer bits on areas of
the frame that aren't moving and uses more bits on complex objects with
sharp edges that move a lot. For example, this feature improves the
readability of text tickers on newscasts and scoreboards on sports
matches. Enabling this feature will almost always improve your video
quality. Note, though, that this feature doesn't take into account
where the viewer's attention is likely to be. If viewers are likely to
be focusing their attention on a part of the screen that doesn't have
moving objects with sharp edges, such as sports athletes' faces, you
might choose to disable this feature. Related setting: When you enable
temporal adaptive quantization, adjust the strength of the filter with
the setting Adaptive quantization (adaptiveQuantization).


=head2 Xavc4kIntraCbgProfileSettings => L<Paws::MediaConvert::Xavc4kIntraCbgProfileSettings>

Required when you set (Profile) under
(VideoDescription)E<gt>(CodecSettings)E<gt>(XavcSettings) to the value
XAVC_4K_INTRA_CBG.


=head2 Xavc4kIntraVbrProfileSettings => L<Paws::MediaConvert::Xavc4kIntraVbrProfileSettings>

Required when you set (Profile) under
(VideoDescription)E<gt>(CodecSettings)E<gt>(XavcSettings) to the value
XAVC_4K_INTRA_VBR.


=head2 Xavc4kProfileSettings => L<Paws::MediaConvert::Xavc4kProfileSettings>

Required when you set (Profile) under
(VideoDescription)E<gt>(CodecSettings)E<gt>(XavcSettings) to the value
XAVC_4K.


=head2 XavcHdIntraCbgProfileSettings => L<Paws::MediaConvert::XavcHdIntraCbgProfileSettings>

Required when you set (Profile) under
(VideoDescription)E<gt>(CodecSettings)E<gt>(XavcSettings) to the value
XAVC_HD_INTRA_CBG.


=head2 XavcHdProfileSettings => L<Paws::MediaConvert::XavcHdProfileSettings>

Required when you set (Profile) under
(VideoDescription)E<gt>(CodecSettings)E<gt>(XavcSettings) to the value
XAVC_HD.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConvert>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

