/*
This file is part of Ext JS 3.4

Copyright (c) 2011-2013 Sencha Inc

Contact:  http://www.sencha.com/contact

GNU General Public License Usage
This file may be used under the terms of the GNU General Public License version 3.0 as
published by the Free Software Foundation and appearing in the file LICENSE included in the
packaging of this file.

Please review the following information to ensure the GNU General Public License version 3.0
requirements will be met: http://www.gnu.org/copyleft/gpl.html.

If you are unsure which license is appropriate for your use, please contact the sales department
at http://www.sencha.com/contact.

Build date: 2013-04-03 15:07:25
*/
Ext.data.JsonP.Ext_form_TwinTriggerField({"alternateClassNames":[],"aliases":{},"enum":null,"parentMixins":[],"tagname":"class","subclasses":[],"extends":"Ext.form.TriggerField","uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='docClass'>Ext.util.Observable</a><div class='subclass '><a href='#!/api/Ext.Component' rel='Ext.Component' class='docClass'>Ext.Component</a><div class='subclass '><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='docClass'>Ext.BoxComponent</a><div class='subclass '><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='docClass'>Ext.form.Field</a><div class='subclass '><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='docClass'>Ext.form.TextField</a><div class='subclass '><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='docClass'>Ext.form.TriggerField</a><div class='subclass '><strong>Ext.form.TwinTriggerField</strong></div></div></div></div></div></div></div><h4>Files</h4><div class='dependency'><a href='source/TriggerField.html#Ext-form-TwinTriggerField' target='_blank'>TriggerField.js</a></div></pre><div class='doc-contents'><p>TwinTriggerField is not a public class to be used directly.  It is meant as an abstract base class\nto be extended by an implementing class.  For an example of implementing this class, see the custom\nSearchField implementation here:\n<a href=\"http://extjs.com/deploy/ext/examples/form/custom.html\">http://extjs.com/deploy/ext/examples/form/custom.html</a></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-allowBlank' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-cfg-allowBlank' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-cfg-allowBlank' class='name expandable'>allowBlank</a><span> : Boolean</span></div><div class='description'><div class='short'>Specify false to validate that the value's length is > 0 (defaults to\ntrue) ...</div><div class='long'><p>Specify <tt>false</tt> to validate that the value's length is > 0 (defaults to\n<tt>true</tt>)</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-allowDomMove' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-allowDomMove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-allowDomMove' class='name expandable'>allowDomMove</a><span> : Boolean</span></div><div class='description'><div class='short'>Whether the component can move the Dom node when rendering (defaults to true). ...</div><div class='long'><p>Whether the component can move the Dom node when rendering (defaults to true).</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-anchor' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-anchor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-anchor' class='name expandable'>anchor</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Note: this config is only used when this Component is rendered\nby a Container which has been configured to use an Anc...</div><div class='long'><p><b>Note</b>: this config is only used when this Component is rendered\nby a Container which has been configured to use an <b><a href=\"#!/api/Ext.layout.AnchorLayout\" rel=\"Ext.layout.AnchorLayout\" class=\"docClass\">AnchorLayout</a> (or subclass thereof).</b>\nbased layout manager, for example:<div class=\"mdetail-params\"><ul>\n<li><a href=\"#!/api/Ext.form.FormPanel\" rel=\"Ext.form.FormPanel\" class=\"docClass\">Ext.form.FormPanel</a></li>\n<li>specifying <code>layout: 'anchor' // or 'form', or 'absolute'</code></li>\n</ul></div></p>\n\n\n<p>See <a href=\"#!/api/Ext.layout.AnchorLayout\" rel=\"Ext.layout.AnchorLayout\" class=\"docClass\">Ext.layout.AnchorLayout</a>.<a href=\"#!/api/Ext.layout.AnchorLayout-cfg-anchor\" rel=\"Ext.layout.AnchorLayout-cfg-anchor\" class=\"docClass\">anchor</a> also.</p>\n\n</div></div></div><div id='cfg-applyTo' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-applyTo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-applyTo' class='name expandable'>applyTo</a><span> : Mixed</span></div><div class='description'><div class='short'>Specify the id of the element, a DOM element or an existing Element corresponding to a DIV\nthat is already present in...</div><div class='long'><p>Specify the id of the element, a DOM element or an existing Element corresponding to a DIV\nthat is already present in the document that specifies some structural markup for this\ncomponent.</p>\n\n\n<div><ul>\n<li><b>Description</b> : <ul>\n<div class=\"sub-desc\">When <tt>applyTo</tt> is used, constituent parts of the component can also be specified\nby id or CSS class name within the main element, and the component being created may attempt\nto create its subcomponents from that markup if applicable.</div>\n</ul></li>\n<li><b>Notes</b> : <ul>\n<div class=\"sub-desc\">When using this config, a call to render() is not required.</div>\n<div class=\"sub-desc\">If applyTo is specified, any value passed for <a href=\"#!/api/Ext.Component-cfg-renderTo\" rel=\"Ext.Component-cfg-renderTo\" class=\"docClass\">renderTo</a> will be ignored and the target\nelement's parent node will automatically be used as the component's container.</div>\n</ul></li>\n</ul></div>\n\n</div></div></div><div id='cfg-autoCreate' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-cfg-autoCreate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-cfg-autoCreate' class='name expandable'>autoCreate</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object</span></div><div class='description'><div class='short'>A DomHelper element spec, or true for a default\nelement spec. ...</div><div class='long'><p>A <a href=\"#!/api/Ext.DomHelper\" rel=\"Ext.DomHelper\" class=\"docClass\">DomHelper</a> element spec, or true for a default\nelement spec. Used to create the <a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">Element</a> which will encapsulate this Component.\nSee <tt><a href=\"#!/api/Ext.Component-cfg-autoEl\" rel=\"Ext.Component-cfg-autoEl\" class=\"docClass\">autoEl</a></tt> for details.  Defaults to:</p>\n\n\n<pre><code>{tag: \"input\", type: \"text\", size: \"16\", autocomplete: \"off\"}</code></pre>\n\n<p>Overrides: <a href='#!/api/Ext.form.Field-cfg-autoCreate' rel='Ext.form.Field-cfg-autoCreate' class='docClass'>Ext.form.Field.autoCreate</a></p></div></div></div><div id='cfg-autoScroll' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-autoScroll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-autoScroll' class='name expandable'>autoScroll</a><span> : Boolean</span></div><div class='description'><div class='short'>true to use overflow:'auto' on the components layout element and show scroll bars automatically when\nnecessary, false...</div><div class='long'><p><code>true</code> to use overflow:'auto' on the components layout element and show scroll bars automatically when\nnecessary, <code>false</code> to clip any overflowing content (defaults to <code>false</code>).</p>\n</div></div></div><div id='cfg-autoShow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-autoShow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-autoShow' class='name expandable'>autoShow</a><span> : Boolean</span></div><div class='description'><div class='short'>True if the component should check for hidden classes (e.g. ...</div><div class='long'><p>True if the component should check for hidden classes (e.g. 'x-hidden' or 'x-hide-display') and remove\nthem on render (defaults to false).</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-blankText' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-cfg-blankText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-cfg-blankText' class='name expandable'>blankText</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The error text to display if the allowBlank validation\nfails (defaults to 'This field is required') ...</div><div class='long'><p>The error text to display if the <b><tt><a href=\"#!/api/Ext.form.TextField-cfg-allowBlank\" rel=\"Ext.form.TextField-cfg-allowBlank\" class=\"docClass\">allowBlank</a></tt></b> validation\nfails (defaults to <tt>'This field is required'</tt>)</p>\n<p>Defaults to: <code>'This field is required'</code></p></div></div></div><div id='cfg-boxMaxHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-boxMaxHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-boxMaxHeight' class='name expandable'>boxMaxHeight</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The maximum value in pixels which this BoxComponent will set its height to. ...</div><div class='long'><p>The maximum value in pixels which this BoxComponent will set its height to.</p>\n\n\n<p><b>Warning:</b> This will override any size management applied by layout managers.</p>\n\n</div></div></div><div id='cfg-boxMaxWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-boxMaxWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-boxMaxWidth' class='name expandable'>boxMaxWidth</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The maximum value in pixels which this BoxComponent will set its width to. ...</div><div class='long'><p>The maximum value in pixels which this BoxComponent will set its width to.</p>\n\n\n<p><b>Warning:</b> This will override any size management applied by layout managers.</p>\n\n</div></div></div><div id='cfg-boxMinHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-boxMinHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-boxMinHeight' class='name expandable'>boxMinHeight</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The minimum value in pixels which this BoxComponent will set its height to. ...</div><div class='long'><p>The minimum value in pixels which this BoxComponent will set its height to.</p>\n\n\n<p><b>Warning:</b> This will override any size management applied by layout managers.</p>\n\n</div></div></div><div id='cfg-boxMinWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-boxMinWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-boxMinWidth' class='name expandable'>boxMinWidth</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The minimum value in pixels which this BoxComponent will set its width to. ...</div><div class='long'><p>The minimum value in pixels which this BoxComponent will set its width to.</p>\n\n\n<p><b>Warning:</b> This will override any size management applied by layout managers.</p>\n\n</div></div></div><div id='cfg-bubbleEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-bubbleEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-bubbleEvents' class='name expandable'>bubbleEvents</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>An array of events that, when fired, should be bubbled to any parent container. ...</div><div class='long'><p>An array of events that, when fired, should be bubbled to any parent container.\nSee <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">Ext.util.Observable.enableBubble</a>.\nDefaults to <tt>[]</tt>.\n\n</p><p>Defaults to: <code>[]</code></p></div></div></div><div id='cfg-clearCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-clearCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-clearCls' class='name expandable'>clearCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The CSS class used to to apply to the special clearing div rendered\ndirectly after each form field wrapper to provide...</div><div class='long'><p>The CSS class used to to apply to the special clearing div rendered\ndirectly after each form field wrapper to provide field clearing (defaults to\n<tt>'x-form-clear-left'</tt>).</p>\n\n\n<br><p><b>Note</b>: this config is only used when this Component is rendered by a Container\n\n\n<p>which has been configured to use the <b><a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">FormLayout</a></b> layout\nmanager (e.g. <a href=\"#!/api/Ext.form.FormPanel\" rel=\"Ext.form.FormPanel\" class=\"docClass\">Ext.form.FormPanel</a> or specifying <tt>layout:'form'</tt>) and either a\n<tt><a href=\"#!/api/Ext.Component-cfg-fieldLabel\" rel=\"Ext.Component-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a></tt> is specified or <tt>isFormField=true</tt> is specified.</p><br></p>\n\n<p>See <a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>.<a href=\"#!/api/Ext.layout.FormLayout-property-fieldTpl\" rel=\"Ext.layout.FormLayout-property-fieldTpl\" class=\"docClass\">fieldTpl</a> also.</p>\n\n</div></div></div><div id='cfg-cls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-cfg-cls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-cfg-cls' class='name not-expandable'>cls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'><p>A custom CSS class to apply to the field's underlying element (defaults to '').</p>\n</div><div class='long'><p>A custom CSS class to apply to the field's underlying element (defaults to '').</p>\n<p>Overrides: <a href='#!/api/Ext.Component-cfg-cls' rel='Ext.Component-cfg-cls' class='docClass'>Ext.Component.cls</a></p></div></div></div><div id='cfg-contentEl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-contentEl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-contentEl' class='name expandable'>contentEl</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Optional. ...</div><div class='long'><p>Optional. Specify an existing HTML element, or the <code>id</code> of an existing HTML element to use as the content\nfor this component.</p>\n\n\n<ul>\n<li><b>Description</b> :\n<div class=\"sub-desc\">This config option is used to take an existing HTML element and place it in the layout element\nof a new component (it simply moves the specified DOM element <i>after the Component is rendered</i> to use as the content.</div></li>\n<li><b>Notes</b> :\n<div class=\"sub-desc\">The specified HTML element is appended to the layout element of the component <i>after any configured\n<a href=\"#!/api/Ext.Component-cfg-html\" rel=\"Ext.Component-cfg-html\" class=\"docClass\">HTML</a> has been inserted</i>, and so the document will not contain this element at the time the <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">render</a> event is fired.</div>\n<div class=\"sub-desc\">The specified HTML element used will not participate in any <code><b><a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a></b></code>\nscheme that the Component may use. It is just HTML. Layouts operate on child <code><b><a href=\"#!/api/Ext.Container-property-items\" rel=\"Ext.Container-property-items\" class=\"docClass\">items</a></b></code>.</div>\n<div class=\"sub-desc\">Add either the <code>x-hidden</code> or the <code>x-hide-display</code> CSS class to\nprevent a brief flicker of the content before it is rendered to the panel.</div></li>\n</ul>\n\n</div></div></div><div id='cfg-ctCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-ctCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-ctCls' class='name expandable'>ctCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>An optional extra CSS class that will be added to this component's container. ...</div><div class='long'><p>An optional extra CSS class that will be added to this component's container. This can be useful for\nadding customized styles to the container or any of its children using standard CSS rules.  See\n<a href=\"#!/api/Ext.layout.ContainerLayout\" rel=\"Ext.layout.ContainerLayout\" class=\"docClass\">Ext.layout.ContainerLayout</a>.<a href=\"#!/api/Ext.layout.ContainerLayout-cfg-extraCls\" rel=\"Ext.layout.ContainerLayout-cfg-extraCls\" class=\"docClass\">extraCls</a> also.</p>\n\n\n<p><b>Note</b>: <tt>ctCls</tt> defaults to <tt>''</tt> except for the following class\nwhich assigns a value by default:\n<div class=\"mdetail-params\"><ul>\n<li>Box Layout : <tt>'x-box-layout-ct'</tt></li>\n</ul></div>\nTo configure the above Class with an extra CSS class append to the default.  For example,\nfor BoxLayout (Hbox and Vbox):\n<pre><code>ctCls: 'x-box-layout-ct custom-class'\n</code></pre>\n</p>\n\n</div></div></div><div id='cfg-data' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-data' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-data' class='name not-expandable'>data</a><span> : Mixed</span></div><div class='description'><div class='short'><p>The initial set of data to apply to the <code><a href=\"#!/api/Ext.Component-cfg-tpl\" rel=\"Ext.Component-cfg-tpl\" class=\"docClass\">tpl</a></code> to\nupdate the content area of the Component.</p>\n</div><div class='long'><p>The initial set of data to apply to the <code><a href=\"#!/api/Ext.Component-cfg-tpl\" rel=\"Ext.Component-cfg-tpl\" class=\"docClass\">tpl</a></code> to\nupdate the content area of the Component.</p>\n</div></div></div><div id='cfg-disableKeyFilter' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-cfg-disableKeyFilter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-cfg-disableKeyFilter' class='name expandable'>disableKeyFilter</a><span> : Boolean</span></div><div class='description'><div class='short'>Specify true to disable input keystroke filtering (defaults\nto false) ...</div><div class='long'><p>Specify <tt>true</tt> to disable input keystroke filtering (defaults\nto <tt>false</tt>)</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-disabled' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-cfg-disabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-cfg-disabled' class='name expandable'>disabled</a><span> : Boolean</span></div><div class='description'><div class='short'>True to disable the field (defaults to false). ...</div><div class='long'><p>True to disable the field (defaults to false).</p>\n\n<p>Be aware that conformant with the <a href=\"http://www.w3.org/TR/html401/interact/forms.html#h-17.12.1\">HTML specification</a>,\ndisabled Fields will not be <a href=\"#!/api/Ext.form.BasicForm-method-submit\" rel=\"Ext.form.BasicForm-method-submit\" class=\"docClass\">submitted</a>.</p>\n\n<p>Defaults to: <code>false</code></p><p>Overrides: <a href='#!/api/Ext.Component-cfg-disabled' rel='Ext.Component-cfg-disabled' class='docClass'>Ext.Component.disabled</a></p></div></div></div><div id='cfg-disabledClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-disabledClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-disabledClass' class='name expandable'>disabledClass</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>CSS class added to the component when it is disabled (defaults to 'x-item-disabled'). ...</div><div class='long'><p>CSS class added to the component when it is disabled (defaults to 'x-item-disabled').</p>\n<p>Defaults to: <code>'x-item-disabled'</code></p></div></div></div><div id='cfg-editable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-cfg-editable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-cfg-editable' class='name expandable'>editable</a><span> : Boolean</span></div><div class='description'><div class='short'>false to prevent the user from typing text directly into the field,\nthe field will only respond to a click on the tri...</div><div class='long'><p><tt>false</tt> to prevent the user from typing text directly into the field,\nthe field will only respond to a click on the trigger to set the value. (defaults to <tt>true</tt>).</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-emptyClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-cfg-emptyClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-cfg-emptyClass' class='name expandable'>emptyClass</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The CSS class to apply to an empty field to style the emptyText\n(defaults to 'x-form-empty-field'). ...</div><div class='long'><p>The CSS class to apply to an empty field to style the <b><tt><a href=\"#!/api/Ext.form.TextField-cfg-emptyText\" rel=\"Ext.form.TextField-cfg-emptyText\" class=\"docClass\">emptyText</a></tt></b>\n(defaults to <tt>'x-form-empty-field'</tt>).  This class is automatically added and removed as needed\ndepending on the current field value.</p>\n<p>Defaults to: <code>'x-form-empty-field'</code></p></div></div></div><div id='cfg-emptyText' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-cfg-emptyText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-cfg-emptyText' class='name expandable'>emptyText</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The default text to place into an empty field (defaults to null). ...</div><div class='long'><p>The default text to place into an empty field (defaults to <tt>null</tt>).\n<b>Note</b>: that this value will be submitted to the server if this field is enabled and configured\nwith a <a href=\"#!/api/Ext.form.TextField-cfg-name\" rel=\"Ext.form.TextField-cfg-name\" class=\"docClass\">name</a>.</p>\n</div></div></div><div id='cfg-enableKeyEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-cfg-enableKeyEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-cfg-enableKeyEvents' class='name not-expandable'>enableKeyEvents</a><span> : Boolean</span></div><div class='description'><div class='short'><p><tt>true</tt> to enable the proxying of key events for the HTML input\nfield (defaults to <tt>false</tt>)</p>\n</div><div class='long'><p><tt>true</tt> to enable the proxying of key events for the HTML input\nfield (defaults to <tt>false</tt>)</p>\n</div></div></div><div id='cfg-fieldClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-cfg-fieldClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-cfg-fieldClass' class='name expandable'>fieldClass</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The default CSS class for the field (defaults to 'x-form-field') ...</div><div class='long'><p>The default CSS class for the field (defaults to 'x-form-field')</p>\n<p>Defaults to: <code>'x-form-field'</code></p></div></div></div><div id='cfg-fieldLabel' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-fieldLabel' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-fieldLabel' class='name expandable'>fieldLabel</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The label text to display next to this Component (defaults to ''). ...</div><div class='long'><p>The label text to display next to this Component (defaults to '').</p>\n\n\n<br><p><b>Note</b>: this config is only used when this Component is rendered by a Container which\n\n\n<p>has been configured to use the <b><a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">FormLayout</a></b> layout manager (e.g.\n<a href=\"#!/api/Ext.form.FormPanel\" rel=\"Ext.form.FormPanel\" class=\"docClass\">Ext.form.FormPanel</a> or specifying <tt>layout:'form'</tt>).</p><br></p>\n\n<p>Also see <tt><a href=\"#!/api/Ext.Component-cfg-hideLabel\" rel=\"Ext.Component-cfg-hideLabel\" class=\"docClass\">hideLabel</a></tt> and\n<a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>.<a href=\"#!/api/Ext.layout.FormLayout-property-fieldTpl\" rel=\"Ext.layout.FormLayout-property-fieldTpl\" class=\"docClass\">fieldTpl</a>.</p>\n\n\n<p>Example use:</p>\n\n<pre><code>new Ext.FormPanel({\n    height: 100,\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    items: [{\n        xtype: 'textfield',\n        fieldLabel: 'Name'\n    }]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-flex' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-flex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-flex' class='name expandable'>flex</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>Note: this config is only used when this Component is rendered\nby a Container which has been configured to use a BoxL...</div><div class='long'><p><b>Note</b>: this config is only used when this Component is rendered\nby a Container which has been configured to use a <b><a href=\"#!/api/Ext.layout.BoxLayout\" rel=\"Ext.layout.BoxLayout\" class=\"docClass\">BoxLayout</a>.</b>\nEach child Component with a <code>flex</code> property will be flexed either vertically (by a VBoxLayout)\nor horizontally (by an HBoxLayout) according to the item's <b>relative</b> <code>flex</code> value\ncompared to the sum of all Components with <code>flex</code> value specified. Any child items that have\neither a <code>flex = 0</code> or <code>flex = undefined</code> will not be 'flexed' (the initial size will not be changed).\n\n</p></div></div></div><div id='cfg-focusClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-cfg-focusClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-cfg-focusClass' class='name expandable'>focusClass</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The CSS class to use when the field receives focus (defaults to 'x-form-focus') ...</div><div class='long'><p>The CSS class to use when the field receives focus (defaults to 'x-form-focus')</p>\n<p>Defaults to: <code>'x-form-focus'</code></p></div></div></div><div id='cfg-height' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-height' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-height' class='name expandable'>height</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The height of this component in pixels (defaults to auto). ...</div><div class='long'><p>The height of this component in pixels (defaults to auto).\n<b>Note</b> to express this dimension as a percentage or offset see Ext.Component.anchor.</p>\n</div></div></div><div id='cfg-hidden' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-hidden' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-hidden' class='name expandable'>hidden</a><span> : Boolean</span></div><div class='description'><div class='short'>Render this component hidden (default is false). ...</div><div class='long'><p>Render this component hidden (default is false). If <tt>true</tt>, the\n<a href=\"#!/api/Ext.Component-method-hide\" rel=\"Ext.Component-method-hide\" class=\"docClass\">hide</a> method will be called internally.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-hideLabel' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-hideLabel' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-hideLabel' class='name expandable'>hideLabel</a><span> : Boolean</span></div><div class='description'><div class='short'>true to completely hide the label element\n(label and separator). ...</div><div class='long'><p><tt>true</tt> to completely hide the label element\n(<a href=\"#!/api/Ext.Component-cfg-fieldLabel\" rel=\"Ext.Component-cfg-fieldLabel\" class=\"docClass\">label</a> and <a href=\"#!/api/Ext.Component-cfg-labelSeparator\" rel=\"Ext.Component-cfg-labelSeparator\" class=\"docClass\">separator</a>). Defaults to <tt>false</tt>.\nBy default, even if you do not specify a <tt><a href=\"#!/api/Ext.Component-cfg-fieldLabel\" rel=\"Ext.Component-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a></tt> the space will still be\nreserved so that the field will line up with other fields that do have labels.\nSetting this to <tt>true</tt> will cause the field to not reserve that space.</p>\n\n\n<br><p><b>Note</b>: see the note for <tt><a href=\"#!/api/Ext.Component-cfg-clearCls\" rel=\"Ext.Component-cfg-clearCls\" class=\"docClass\">clearCls</a></tt>.</p><br>\n\n\n<p>Example use:</p>\n\n<pre><code>new Ext.FormPanel({\n    height: 100,\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    items: [{\n        xtype: 'textfield'\n        hideLabel: true\n    }]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-hideMode' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-hideMode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-hideMode' class='name expandable'>hideMode</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>How this component should be hidden. ...</div><div class='long'><p>How this component should be hidden. Supported values are <tt>'visibility'</tt>\n(css visibility), <tt>'offsets'</tt> (negative offset position) and <tt>'display'</tt>\n(css display).</p>\n\n\n<br><p><b>Note</b>: the default of <tt>'display'</tt> is generally preferred\n\n\n<p>since items are automatically laid out when they are first shown (no sizing\nis done while hidden).</p></p>\n<p>Defaults to: <code>'display'</code></p></div></div></div><div id='cfg-hideParent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-hideParent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-hideParent' class='name expandable'>hideParent</a><span> : Boolean</span></div><div class='description'><div class='short'>True to hide and show the component's container when hide/show is called on the component, false to hide\nand show the...</div><div class='long'><p>True to hide and show the component's container when hide/show is called on the component, false to hide\nand show the component itself (defaults to false).  For example, this can be used as a shortcut for a hide\nbutton on a window by setting hide:true on the button when adding it to its parent container.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-hideTrigger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-cfg-hideTrigger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-cfg-hideTrigger' class='name expandable'>hideTrigger</a><span> : Boolean</span></div><div class='description'><div class='short'>true to hide the trigger element and display only the base\ntext field (defaults to false) ...</div><div class='long'><p><tt>true</tt> to hide the trigger element and display only the base\ntext field (defaults to <tt>false</tt>)</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-html' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-html' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-html' class='name expandable'>html</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object</span></div><div class='description'><div class='short'>An HTML fragment, or a DomHelper specification to use as the layout element\ncontent (defaults to ''). ...</div><div class='long'><p>An HTML fragment, or a <a href=\"#!/api/Ext.DomHelper\" rel=\"Ext.DomHelper\" class=\"docClass\">DomHelper</a> specification to use as the layout element\ncontent (defaults to ''). The HTML content is added after the component is rendered,\nso the document will not contain this HTML at the time the <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">render</a> event is fired.\nThis content is inserted into the body <i>before</i> any configured <a href=\"#!/api/Ext.Component-cfg-contentEl\" rel=\"Ext.Component-cfg-contentEl\" class=\"docClass\">contentEl</a> is appended.</p>\n</div></div></div><div id='cfg-id' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-id' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-id' class='name expandable'>id</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The unique id of this component (defaults to an auto-assigned id). ...</div><div class='long'><p>The <b>unique</b> id of this component (defaults to an <a href=\"#!/api/Ext.Component-method-getId\" rel=\"Ext.Component-method-getId\" class=\"docClass\">auto-assigned id</a>).\nYou should assign an id if you need to be able to access the component later and you do\nnot have an object reference available (e.g., using <a href=\"#!/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a>.<a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">getCmp</a>).</p>\n\n\n<p>Note that this id will also be used as the element id for the containing HTML element\nthat is rendered to the page for this component. This allows you to write id-based CSS\nrules to style the specific instance of this component uniquely, and also to select\nsub-elements using this component's id as the parent.</p>\n\n\n<p><b>Note</b>: to avoid complications imposed by a unique <tt>id</tt> also see\n<code><a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a></code> and <code><a href=\"#!/api/Ext.Component-cfg-ref\" rel=\"Ext.Component-cfg-ref\" class=\"docClass\">ref</a></code>.</p>\n\n\n<p><b>Note</b>: to access the container of an item see <code><a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a></code>.</p>\n\n</div></div></div><div id='cfg-inputType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-cfg-inputType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-cfg-inputType' class='name expandable'>inputType</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The type attribute for input fields -- e.g. ...</div><div class='long'><p>The type attribute for input fields -- e.g. radio, text, password, file (defaults\nto 'text'). The types 'file' and 'password' must be used to render those field types currently -- there are\nno separate Ext components for those. Note that if you use <tt>inputType:'file'</tt>, emptyText\nis not supported and should be avoided.</p>\n</div></div></div><div id='cfg-invalidClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-cfg-invalidClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-cfg-invalidClass' class='name expandable'>invalidClass</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The CSS class to use when marking a field invalid (defaults to 'x-form-invalid') ...</div><div class='long'><p>The CSS class to use when marking a field invalid (defaults to 'x-form-invalid')</p>\n<p>Defaults to: <code>'x-form-invalid'</code></p></div></div></div><div id='cfg-invalidText' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-cfg-invalidText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-cfg-invalidText' class='name expandable'>invalidText</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The error text to use when marking a field invalid and no message is provided\n(defaults to 'The value in this field i...</div><div class='long'><p>The error text to use when marking a field invalid and no message is provided\n(defaults to 'The value in this field is invalid')</p>\n<p>Defaults to: <code>'The value in this field is invalid'</code></p></div></div></div><div id='cfg-itemCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-itemCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-itemCls' class='name expandable'>itemCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Note: this config is only used when this Component is rendered by a Container which\nhas been configured to use the Fo...</div><div class='long'><p><b>Note</b>: this config is only used when this Component is rendered by a Container which\nhas been configured to use the <b><a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">FormLayout</a></b> layout manager (e.g.\n<a href=\"#!/api/Ext.form.FormPanel\" rel=\"Ext.form.FormPanel\" class=\"docClass\">Ext.form.FormPanel</a> or specifying <tt>layout:'form'</tt>).</p>\n\n\n<br>\n\n\n<p>An additional CSS class to apply to the div wrapping the form item\nelement of this field.  If supplied, <tt>itemCls</tt> at the <b>field</b> level will override\nthe default <tt>itemCls</tt> supplied at the <b>container</b> level. The value specified for\n<tt>itemCls</tt> will be added to the default class (<tt>'x-form-item'</tt>).</p>\n\n\n<p>Since it is applied to the item wrapper (see\n<a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>.<a href=\"#!/api/Ext.layout.FormLayout-property-fieldTpl\" rel=\"Ext.layout.FormLayout-property-fieldTpl\" class=\"docClass\">fieldTpl</a>), it allows\nyou to write standard CSS rules that can apply to the field, the label (if specified), or\nany other element within the markup for the field.</p>\n\n\n<br><p><b>Note</b>: see the note for <tt><a href=\"#!/api/Ext.Component-cfg-fieldLabel\" rel=\"Ext.Component-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a></tt>.</p><br>\n\n\n<p>Example use:</p>\n\n<pre><code>// Apply a style to the field&#39;s label:\n&lt;style>\n    .required .x-form-item-label {font-weight:bold;color:red;}\n&lt;/style>\n\nnew Ext.FormPanel({\n    height: 100,\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    items: [{\n        xtype: 'textfield',\n        fieldLabel: 'Name',\n        itemCls: 'required' //this label will be styled\n    },{\n        xtype: 'textfield',\n        fieldLabel: 'Favorite Color'\n    }]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-itemId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-itemId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-itemId' class='name expandable'>itemId</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>An itemId can be used as an alternative way to get a reference to a component\nwhen no object reference is available. ...</div><div class='long'><p>An <tt>itemId</tt> can be used as an alternative way to get a reference to a component\nwhen no object reference is available.  Instead of using an <code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code> with\n<a href=\"#!/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a>.<a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">getCmp</a>, use <code>itemId</code> with\n<a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a>.<a href=\"#!/api/Ext.Container-method-getComponent\" rel=\"Ext.Container-method-getComponent\" class=\"docClass\">getComponent</a> which will retrieve\n<code>itemId</code>'s or <tt><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></tt>'s. Since <code>itemId</code>'s are an index to the\ncontainer's internal MixedCollection, the <code>itemId</code> is scoped locally to the container --\navoiding potential conflicts with <a href=\"#!/api/Ext.ComponentMgr\" rel=\"Ext.ComponentMgr\" class=\"docClass\">Ext.ComponentMgr</a> which requires a <b>unique</b>\n<code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code>.</p>\n\n\n<pre><code>var c = new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({ //\n    <a href=\"#!/api/Ext.BoxComponent-cfg-height\" rel=\"Ext.BoxComponent-cfg-height\" class=\"docClass\">height</a>: 300,\n    <a href=\"#!/api/Ext.Component-cfg-renderTo\" rel=\"Ext.Component-cfg-renderTo\" class=\"docClass\">renderTo</a>: document.body,\n    <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a>: 'auto',\n    <a href=\"#!/api/Ext.Container-property-items\" rel=\"Ext.Container-property-items\" class=\"docClass\">items</a>: [\n        {\n            itemId: 'p1',\n            <a href=\"#!/api/Ext.Panel-cfg-title\" rel=\"Ext.Panel-cfg-title\" class=\"docClass\">title</a>: 'Panel 1',\n            <a href=\"#!/api/Ext.BoxComponent-cfg-height\" rel=\"Ext.BoxComponent-cfg-height\" class=\"docClass\">height</a>: 150\n        },\n        {\n            itemId: 'p2',\n            <a href=\"#!/api/Ext.Panel-cfg-title\" rel=\"Ext.Panel-cfg-title\" class=\"docClass\">title</a>: 'Panel 2',\n            <a href=\"#!/api/Ext.BoxComponent-cfg-height\" rel=\"Ext.BoxComponent-cfg-height\" class=\"docClass\">height</a>: 150\n        }\n    ]\n})\np1 = c.<a href=\"#!/api/Ext.Container-method-getComponent\" rel=\"Ext.Container-method-getComponent\" class=\"docClass\">getComponent</a>('p1'); // not the same as <a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">Ext.getCmp()</a>\np2 = p1.<a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a>.<a href=\"#!/api/Ext.Container-method-getComponent\" rel=\"Ext.Container-method-getComponent\" class=\"docClass\">getComponent</a>('p2'); // reference via a sibling\n</code></pre>\n\n\n<p>Also see <tt><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></tt> and <code><a href=\"#!/api/Ext.Component-cfg-ref\" rel=\"Ext.Component-cfg-ref\" class=\"docClass\">ref</a></code>.</p>\n\n\n<p><b>Note</b>: to access the container of an item see <tt><a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a></tt>.</p>\n\n</div></div></div><div id='cfg-labelSeparator' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-labelSeparator' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-labelSeparator' class='name expandable'>labelSeparator</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The separator to display after the text of each\nfieldLabel. ...</div><div class='long'><p>The separator to display after the text of each\n<tt><a href=\"#!/api/Ext.Component-cfg-fieldLabel\" rel=\"Ext.Component-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a></tt>.  This property may be configured at various levels.\nThe order of precedence is:\n<div class=\"mdetail-params\"><ul>\n<li>field / component level</li>\n<li>container level</li>\n<li><a href=\"#!/api/Ext.layout.FormLayout-cfg-labelSeparator\" rel=\"Ext.layout.FormLayout-cfg-labelSeparator\" class=\"docClass\">layout level</a> (defaults to colon <tt>':'</tt>)</li>\n</ul></div>\nTo display no separator for this field's label specify empty string ''.</p>\n\n\n<br><p><b>Note</b>: see the note for <tt><a href=\"#!/api/Ext.Component-cfg-clearCls\" rel=\"Ext.Component-cfg-clearCls\" class=\"docClass\">clearCls</a></tt>.</p><br>\n\n\n<p>Also see <tt><a href=\"#!/api/Ext.Component-cfg-hideLabel\" rel=\"Ext.Component-cfg-hideLabel\" class=\"docClass\">hideLabel</a></tt> and\n<a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>.<a href=\"#!/api/Ext.layout.FormLayout-property-fieldTpl\" rel=\"Ext.layout.FormLayout-property-fieldTpl\" class=\"docClass\">fieldTpl</a>.</p>\n\n\n<p>Example use:</p>\n\n<pre><code>new Ext.FormPanel({\n    height: 100,\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    layoutConfig: {\n        labelSeparator: '~'   // layout config has lowest priority (defaults to ':')\n    },\n    <a href=\"#!/api/Ext.layout.FormLayout-cfg-labelSeparator\" rel=\"Ext.layout.FormLayout-cfg-labelSeparator\" class=\"docClass\">labelSeparator</a>: '>>',     // config at container level\n    items: [{\n        xtype: 'textfield',\n        fieldLabel: 'Field 1',\n        labelSeparator: '...' // field/component level config supersedes others\n    },{\n        xtype: 'textfield',\n        fieldLabel: 'Field 2' // labelSeparator will be '='\n    }]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-labelStyle' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-labelStyle' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-labelStyle' class='name expandable'>labelStyle</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A CSS style specification string to apply directly to this field's\nlabel. ...</div><div class='long'><p>A CSS style specification string to apply directly to this field's\nlabel.  Defaults to the container's labelStyle value if set (e.g.,\n<tt><a href=\"#!/api/Ext.layout.FormLayout-property-labelStyle\" rel=\"Ext.layout.FormLayout-property-labelStyle\" class=\"docClass\">Ext.layout.FormLayout.labelStyle</a></tt> , or '').</p>\n\n\n<br><p><b>Note</b>: see the note for <code><a href=\"#!/api/Ext.Component-cfg-clearCls\" rel=\"Ext.Component-cfg-clearCls\" class=\"docClass\">clearCls</a></code>.</p><br>\n\n\n<p>Also see <code><a href=\"#!/api/Ext.Component-cfg-hideLabel\" rel=\"Ext.Component-cfg-hideLabel\" class=\"docClass\">hideLabel</a></code> and\n<code><a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>.<a href=\"#!/api/Ext.layout.FormLayout-property-fieldTpl\" rel=\"Ext.layout.FormLayout-property-fieldTpl\" class=\"docClass\">fieldTpl</a>.</code></p>\n\n\n<p>Example use:</p>\n\n<pre><code>new Ext.FormPanel({\n    height: 100,\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    items: [{\n        xtype: 'textfield',\n        fieldLabel: 'Name',\n        labelStyle: 'font-weight:bold;'\n    }]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-listeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-cfg-listeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-cfg-listeners' class='name expandable'>listeners</a><span> : Object</span></div><div class='description'><div class='short'>(optional) A config object containing one or more event handlers to be added to this\nobject during initialization. ...</div><div class='long'><p>(optional) <p>A config object containing one or more event handlers to be added to this\nobject during initialization.  This should be a valid listeners config object as specified in the\n<a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> example for attaching multiple handlers at once.</p></p>\n\n<br><p><b><u>DOM events from ExtJs <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a></u></b></p>\n\n\n<br><p>While <i>some</i> ExtJs Component classes export selected DOM events (e.g. \"click\", \"mouseover\" etc), this\n\n\n<p>is usually only done when extra value can be added. For example the <a href=\"#!/api/Ext.DataView\" rel=\"Ext.DataView\" class=\"docClass\">DataView</a>'s\n<b><code><a href=\"#!/api/Ext.DataView-event-click\" rel=\"Ext.DataView-event-click\" class=\"docClass\">click</a></code></b> event passing the node clicked on. To access DOM\nevents directly from a Component's HTMLElement, listeners must be added to the <i><a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">Element</a></i> after the Component\nhas been rendered. A plugin can simplify this step:</p>\n\n<pre><code>// Plugin is configured with a listeners config object.\n// The Component is appended to the argument list of all handler functions.\nExt.DomObserver = <a href=\"#!/api/Ext-method-extend\" rel=\"Ext-method-extend\" class=\"docClass\">Ext.extend</a>(Object, {\n    constructor: function(config) {\n        this.listeners = config.listeners ? config.listeners : config;\n    },\n\n    // Component passes itself into plugin&#39;s init method\n    init: function(c) {\n        var p, l = this.listeners;\n        for (p in l) {\n            if (<a href=\"#!/api/Ext-method-isFunction\" rel=\"Ext-method-isFunction\" class=\"docClass\">Ext.isFunction</a>(l[p])) {\n                l[p] = this.createHandler(l[p], c);\n            } else {\n                l[p].fn = this.createHandler(l[p].fn, c);\n            }\n        }\n\n        // Add the listeners to the Element immediately following the render call\n        c.render = c.render.<a href=\"#!/api/Function-method-createSequence\" rel=\"Function-method-createSequence\" class=\"docClass\">createSequence</a>(function() {\n            var e = c.getEl();\n            if (e) {\n                e.on(l);\n            }\n        });\n    },\n\n    createHandler: function(fn, c) {\n        return function(e) {\n            fn.call(this, e, c);\n        };\n    }\n});\n\nvar combo = new <a href=\"#!/api/Ext.form.ComboBox\" rel=\"Ext.form.ComboBox\" class=\"docClass\">Ext.form.ComboBox</a>({\n\n    // Collapse combo when its element is clicked on\n    plugins: [ new Ext.DomObserver({\n        click: function(evt, comp) {\n            comp.collapse();\n        }\n    })],\n    store: myStore,\n    typeAhead: true,\n    mode: 'local',\n    triggerAction: 'all'\n});\n</code></pre>\n\n\n<p></p></p>\n</div></div></div><div id='cfg-margins' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-margins' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-margins' class='name expandable'>margins</a><span> : Object</span></div><div class='description'><div class='short'>Note: this config is only used when this BoxComponent is rendered\nby a Container which has been configured to use the...</div><div class='long'><p><b>Note</b>: this config is only used when this BoxComponent is rendered\nby a Container which has been configured to use the <b><a href=\"#!/api/Ext.layout.BorderLayout\" rel=\"Ext.layout.BorderLayout\" class=\"docClass\">BorderLayout</a></b>\nor one of the two <b><a href=\"#!/api/Ext.layout.BoxLayout\" rel=\"Ext.layout.BoxLayout\" class=\"docClass\">BoxLayout</a> subclasses.</b></p>\n\n\n<p>An object containing margins to apply to this BoxComponent in the\nformat:</p>\n\n\n<pre><code>{\n    top: (top margin),\n    right: (right margin),\n    bottom: (bottom margin),\n    left: (left margin)\n}</code></pre>\n\n\n<p>May also be a string containing space-separated, numeric margin values. The order of the\nsides associated with each value matches the way CSS processes margin values:</p>\n\n\n<p><div class=\"mdetail-params\"><ul>\n<li>If there is only one value, it applies to all sides.</li>\n<li>If there are two values, the top and bottom borders are set to the first value and the\nright and left are set to the second.</li>\n<li>If there are three values, the top is set to the first value, the left and right are set\nto the second, and the bottom is set to the third.</li>\n<li>If there are four values, they apply to the top, right, bottom, and left, respectively.</li>\n</ul></div></p>\n\n\n<p>Defaults to:</p>\n\n\n<pre><code>{top:0, right:0, bottom:0, left:0}\n</code></pre>\n\n</div></div></div><div id='cfg-maskRe' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-cfg-maskRe' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-cfg-maskRe' class='name expandable'>maskRe</a><span> : RegExp</span></div><div class='description'><div class='short'>An input mask regular expression that will be used to filter keystrokes that do\nnot match (defaults to null). ...</div><div class='long'><p>An input mask regular expression that will be used to filter keystrokes that do\nnot match (defaults to <tt>null</tt>). The maskRe will not operate on any paste events.</p>\n</div></div></div><div id='cfg-maxLength' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-cfg-maxLength' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-cfg-maxLength' class='name expandable'>maxLength</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>Maximum input field length allowed by validation (defaults to Number.MAX_VALUE). ...</div><div class='long'><p>Maximum input field length allowed by validation (defaults to Number.MAX_VALUE).\nThis behavior is intended to provide instant feedback to the user by improving usability to allow pasting\nand editing or overtyping and back tracking. To restrict the maximum number of characters that can be\nentered into the field use <tt><b><a href=\"#!/api/Ext.form.Field-cfg-autoCreate\" rel=\"Ext.form.Field-cfg-autoCreate\" class=\"docClass\">autoCreate</a></b></tt> to add\nany attributes you want to a field, for example:</p>\n\n<pre><code>var myField = new <a href=\"#!/api/Ext.form.NumberField\" rel=\"Ext.form.NumberField\" class=\"docClass\">Ext.form.NumberField</a>({\n    id: 'mobile',\n    anchor:'90%',\n    fieldLabel: 'Mobile',\n    maxLength: 16, // for validation\n    autoCreate: {tag: 'input', type: 'text', size: '20', autocomplete: 'off', maxlength: '10'}\n});\n</code></pre>\n\n</div></div></div><div id='cfg-maxLengthText' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-cfg-maxLengthText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-cfg-maxLengthText' class='name expandable'>maxLengthText</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Error text to display if the maximum length\nvalidation fails (defaults to 'The maximum length for this field is {maxL...</div><div class='long'><p>Error text to display if the <b><tt><a href=\"#!/api/Ext.form.TextField-cfg-maxLength\" rel=\"Ext.form.TextField-cfg-maxLength\" class=\"docClass\">maximum length</a></tt></b>\nvalidation fails (defaults to <tt>'The maximum length for this field is {maxLength}'</tt>)</p>\n<p>Defaults to: <code>'The maximum length for this field is {0}'</code></p></div></div></div><div id='cfg-minLength' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-cfg-minLength' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-cfg-minLength' class='name expandable'>minLength</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>Minimum input field length required (defaults to 0) ...</div><div class='long'><p>Minimum input field length required (defaults to <tt>0</tt>)</p>\n<p>Defaults to: <code>0</code></p></div></div></div><div id='cfg-minLengthText' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-cfg-minLengthText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-cfg-minLengthText' class='name expandable'>minLengthText</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Error text to display if the minimum length\nvalidation fails (defaults to 'The minimum length for this field is {minL...</div><div class='long'><p>Error text to display if the <b><tt><a href=\"#!/api/Ext.form.TextField-cfg-minLength\" rel=\"Ext.form.TextField-cfg-minLength\" class=\"docClass\">minimum length</a></tt></b>\nvalidation fails (defaults to <tt>'The minimum length for this field is {minLength}'</tt>)</p>\n<p>Defaults to: <code>'The minimum length for this field is {0}'</code></p></div></div></div><div id='cfg-msgFx' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-cfg-msgFx' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-cfg-msgFx' class='name expandable'>msgFx</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Experimental The effect used when displaying a validation message under the field\n(defaults to 'normal'). ...</div><div class='long'><p><b>Experimental</b> The effect used when displaying a validation message under the field\n(defaults to 'normal').</p>\n<p>Defaults to: <code>'normal'</code></p></div></div></div><div id='cfg-msgTarget' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-cfg-msgTarget' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-cfg-msgTarget' class='name expandable'>msgTarget</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The location where the message text set through markInvalid should display. ...</div><div class='long'><p>The location where the message text set through <a href=\"#!/api/Ext.form.Field-method-markInvalid\" rel=\"Ext.form.Field-method-markInvalid\" class=\"docClass\">markInvalid</a> should display.\nMust be one of the following values:</p>\n\n\n<div class=\"mdetail-params\"><ul>\n<li><code>qtip</code> Display a quick tip containing the message when the user hovers over the field. This is the default.\n<div class=\"subdesc\"><b><a href=\"#!/api/Ext.QuickTips-method-init\" rel=\"Ext.QuickTips-method-init\" class=\"docClass\">Ext.QuickTips.init</a> must have been called for this setting to work.</b></div</li>\n<li><code>title</code> Display the message in a default browser title attribute popup.</li>\n<li><code>under</code> Add a block div beneath the field containing the error message.</li>\n<li><code>side</code> Add an error icon to the right of the field, displaying the message in a popup on hover.</li>\n<li><code>[element id]</code> Add the error message directly to the innerHTML of the specified element.</li>\n</ul></div>\n\n</div><p>Defaults to: <code>'qtip'</code></p></div></div></div><div id='cfg-name' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-cfg-name' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-cfg-name' class='name expandable'>name</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The field's HTML name attribute (defaults to ''). ...</div><div class='long'><p>The field's HTML name attribute (defaults to '').\n<b>Note</b>: this property must be set if this field is to be automatically included with\n<a href=\"#!/api/Ext.form.BasicForm-method-submit\" rel=\"Ext.form.BasicForm-method-submit\" class=\"docClass\">form submit()</a>.</p>\n</div></div></div><div id='cfg-overCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-overCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-overCls' class='name expandable'>overCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>An optional extra CSS class that will be added to this component's Element when the mouse moves\nover the Element, and...</div><div class='long'><p>An optional extra CSS class that will be added to this component's Element when the mouse moves\nover the Element, and removed when the mouse moves out. (defaults to '').  This can be\nuseful for adding customized 'active' or 'hover' styles to the component or any of its children using standard CSS rules.</p>\n</div></div></div><div id='cfg-pageX' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-pageX' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-pageX' class='name not-expandable'>pageX</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The page level x coordinate for this component if contained within a positioning container.</p>\n</div><div class='long'><p>The page level x coordinate for this component if contained within a positioning container.</p>\n</div></div></div><div id='cfg-pageY' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-pageY' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-pageY' class='name not-expandable'>pageY</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The page level y coordinate for this component if contained within a positioning container.</p>\n</div><div class='long'><p>The page level y coordinate for this component if contained within a positioning container.</p>\n</div></div></div><div id='cfg-plugins' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-plugins' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-plugins' class='name expandable'>plugins</a><span> : Object/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>An object or array of objects that will provide custom functionality for this component. ...</div><div class='long'><p>An object or array of objects that will provide custom functionality for this component.  The only\nrequirement for a valid plugin is that it contain an init method that accepts a reference of type <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.\nWhen a component is created, if any plugins are available, the component will call the init method on each\nplugin, passing a reference to itself.  Each plugin can then call methods or respond to events on the\ncomponent as needed to provide its functionality.</p>\n</div></div></div><div id='cfg-preventMark' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-cfg-preventMark' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-cfg-preventMark' class='name expandable'>preventMark</a><span> : Boolean</span></div><div class='description'><div class='short'>true to disable marking the field invalid. ...</div><div class='long'><p><tt>true</tt> to disable <a href=\"#!/api/Ext.form.Field-method-markInvalid\" rel=\"Ext.form.Field-method-markInvalid\" class=\"docClass\">marking the field invalid</a>.\nDefaults to <tt>false</tt>.</p>\n</div></div></div><div id='cfg-ptype' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-ptype' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-ptype' class='name expandable'>ptype</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The registered ptype to create. ...</div><div class='long'><p>The registered <tt>ptype</tt> to create. This config option is not used when passing\na config object into a constructor. This config option is used only when\nlazy instantiation is being used, and a Plugin is being\nspecified not as a fully instantiated Component, but as a <i>Component config\nobject</i>. The <tt>ptype</tt> will be looked up at render time up to determine what\ntype of Plugin to create.<br><br>\nIf you create your own Plugins, you may register them using\n<a href=\"#!/api/Ext.ComponentMgr-method-registerPlugin\" rel=\"Ext.ComponentMgr-method-registerPlugin\" class=\"docClass\">Ext.ComponentMgr.registerPlugin</a> in order to be able to\ntake advantage of lazy instantiation and rendering.</p>\n</div></div></div><div id='cfg-readOnly' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-cfg-readOnly' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-cfg-readOnly' class='name expandable'>readOnly</a><span> : Boolean</span></div><div class='description'><div class='short'>true to prevent the user from changing the field, and\nhides the trigger. ...</div><div class='long'><p><tt>true</tt> to prevent the user from changing the field, and\nhides the trigger.  Superceeds the editable and hideTrigger options if the value is true.\n(defaults to <tt>false</tt>)</p>\n<p>Defaults to: <code>false</code></p><p>Overrides: <a href='#!/api/Ext.form.Field-cfg-readOnly' rel='Ext.form.Field-cfg-readOnly' class='docClass'>Ext.form.Field.readOnly</a></p></div></div></div><div id='cfg-ref' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-ref' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-ref' class='name expandable'>ref</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A path specification, relative to the Component's ownerCt\nspecifying into which ancestor Container to place a named r...</div><div class='long'><p>A path specification, relative to the Component's <code><a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a></code>\nspecifying into which ancestor Container to place a named reference to this Component.</p>\n\n\n<p>The ancestor axis can be traversed by using '/' characters in the path.\nFor example, to put a reference to a Toolbar Button into <i>the Panel which owns the Toolbar</i>:</p>\n\n\n<pre><code>var myGrid = new <a href=\"#!/api/Ext.grid.EditorGridPanel\" rel=\"Ext.grid.EditorGridPanel\" class=\"docClass\">Ext.grid.EditorGridPanel</a>({\n    title: 'My EditorGridPanel',\n    store: myStore,\n    colModel: myColModel,\n    tbar: [{\n        text: 'Save',\n        handler: saveChanges,\n        disabled: true,\n        ref: '../saveButton'\n    }],\n    listeners: {\n        afteredit: function() {\n//          The button reference is in the GridPanel\n            myGrid.saveButton.enable();\n        }\n    }\n});\n</code></pre>\n\n\n<p>In the code above, if the <code>ref</code> had been <code>'saveButton'</code>\nthe reference would have been placed into the Toolbar. Each '/' in the <code>ref</code>\nmoves up one level from the Component's <code><a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a></code>.</p>\n\n\n<p>Also see the <code><a href=\"#!/api/Ext.Component-event-added\" rel=\"Ext.Component-event-added\" class=\"docClass\">added</a></code> and <code><a href=\"#!/api/Ext.Component-event-removed\" rel=\"Ext.Component-event-removed\" class=\"docClass\">removed</a></code> events.</p>\n\n</div></div></div><div id='cfg-regex' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-cfg-regex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-cfg-regex' class='name expandable'>regex</a><span> : RegExp</span></div><div class='description'><div class='short'>A JavaScript RegExp object to be tested against the field value during validation\n(defaults to null). ...</div><div class='long'><p>A JavaScript RegExp object to be tested against the field value during validation\n(defaults to <tt>null</tt>). If the test fails, the field will be marked invalid using\n<b><tt><a href=\"#!/api/Ext.form.TextField-cfg-regexText\" rel=\"Ext.form.TextField-cfg-regexText\" class=\"docClass\">regexText</a></tt></b>.</p>\n</div></div></div><div id='cfg-regexText' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-cfg-regexText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-cfg-regexText' class='name expandable'>regexText</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The error text to display if regex is used and the\ntest fails during validation (defaults to '') ...</div><div class='long'><p>The error text to display if <b><tt><a href=\"#!/api/Ext.form.TextField-cfg-regex\" rel=\"Ext.form.TextField-cfg-regex\" class=\"docClass\">regex</a></tt></b> is used and the\ntest fails during validation (defaults to <tt>''</tt>)</p>\n<p>Defaults to: <code>''</code></p></div></div></div><div id='cfg-region' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-region' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-region' class='name expandable'>region</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Note: this config is only used when this BoxComponent is rendered\nby a Container which has been configured to use the...</div><div class='long'><p><b>Note</b>: this config is only used when this BoxComponent is rendered\nby a Container which has been configured to use the <b><a href=\"#!/api/Ext.layout.BorderLayout\" rel=\"Ext.layout.BorderLayout\" class=\"docClass\">BorderLayout</a></b>\nlayout manager (e.g. specifying <tt>layout:'border'</tt>).</p>\n\n\n<br>\n\n\n<p>See <a href=\"#!/api/Ext.layout.BorderLayout\" rel=\"Ext.layout.BorderLayout\" class=\"docClass\">Ext.layout.BorderLayout</a> also.</p>\n\n</div></div></div><div id='cfg-renderTo' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-renderTo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-renderTo' class='name expandable'>renderTo</a><span> : Mixed</span></div><div class='description'><div class='short'>Specify the id of the element, a DOM element or an existing Element that this component\nwill be rendered into. ...</div><div class='long'><p>Specify the id of the element, a DOM element or an existing Element that this component\nwill be rendered into.</p>\n\n\n<div><ul>\n<li><b>Notes</b> : <ul>\n<div class=\"sub-desc\">Do <u>not</u> use this option if the Component is to be a child item of\na <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Container</a>. It is the responsibility of the\n<a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Container</a>'s <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout manager</a>\nto render and manage its child items.</div>\n<div class=\"sub-desc\">When using this config, a call to render() is not required.</div>\n</ul></li>\n</ul></div>\n\n\n<p>See <tt><a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">render</a></tt> also.</p>\n\n</div></div></div><div id='cfg-selectOnFocus' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-cfg-selectOnFocus' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-cfg-selectOnFocus' class='name expandable'>selectOnFocus</a><span> : Boolean</span></div><div class='description'><div class='short'>true to automatically select any existing field text when the field\nreceives input focus (defaults to false) ...</div><div class='long'><p><tt>true</tt> to automatically select any existing field text when the field\nreceives input focus (defaults to <tt>false</tt>)</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-stateEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-stateEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-stateEvents' class='name expandable'>stateEvents</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>An array of events that, when fired, should trigger this component to\nsave its state (defaults to none). ...</div><div class='long'><p>An array of events that, when fired, should trigger this component to\nsave its state (defaults to none). <code>stateEvents</code> may be any type\nof event supported by this component, including browser or custom events\n(e.g., <tt>['click', 'customerchange']</tt>).</p>\n\n\n<p>See <code><a href=\"#!/api/Ext.Component-cfg-stateful\" rel=\"Ext.Component-cfg-stateful\" class=\"docClass\">stateful</a></code> for an explanation of saving and\nrestoring Component state.</p>\n\n</div></div></div><div id='cfg-stateId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-stateId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-stateId' class='name expandable'>stateId</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The unique id for this component to use for state management purposes\n(defaults to the component id if one was set, o...</div><div class='long'><p>The unique id for this component to use for state management purposes\n(defaults to the component id if one was set, otherwise null if the\ncomponent is using a generated id).</p>\n\n<p>See <code><a href=\"#!/api/Ext.Component-cfg-stateful\" rel=\"Ext.Component-cfg-stateful\" class=\"docClass\">stateful</a></code> for an explanation of saving and\nrestoring Component state.</p>\n\n</div></div></div><div id='cfg-stateful' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-stateful' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-stateful' class='name expandable'>stateful</a><span> : Boolean</span></div><div class='description'><div class='short'>A flag which causes the Component to attempt to restore the state of\ninternal properties from a saved state on startup. ...</div><div class='long'><p>A flag which causes the Component to attempt to restore the state of\ninternal properties from a saved state on startup. The component must have\neither a <code><a href=\"#!/api/Ext.Component-cfg-stateId\" rel=\"Ext.Component-cfg-stateId\" class=\"docClass\">stateId</a></code> or <code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code> assigned\nfor state to be managed. Auto-generated ids are not guaranteed to be stable\nacross page loads and cannot be relied upon to save and restore the same\nstate for a component.<p>\n<p>For state saving to work, the state manager's provider must have been\nset to an implementation of <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> which overrides the\n<a href=\"#!/api/Ext.state.Provider-method-set\" rel=\"Ext.state.Provider-method-set\" class=\"docClass\">set</a> and <a href=\"#!/api/Ext.state.Provider-method-get\" rel=\"Ext.state.Provider-method-get\" class=\"docClass\">get</a>\nmethods to save and recall name/value pairs. A built-in implementation,\n<a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a> is available.</p>\n<p>To set the state provider for the current page:</p>\n<pre><code><a href=\"#!/api/Ext.state.Manager-method-setProvider\" rel=\"Ext.state.Manager-method-setProvider\" class=\"docClass\">Ext.state.Manager.setProvider</a>(new <a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a>({\n    expires: new Date(new Date().getTime()+(1000*60*60*24*7)), //7 days from now\n}));\n</code></pre>\n<p>A stateful Component attempts to save state when one of the events\nlisted in the <code><a href=\"#!/api/Ext.Component-cfg-stateEvents\" rel=\"Ext.Component-cfg-stateEvents\" class=\"docClass\">stateEvents</a></code> configuration fires.</p>\n<p>To save state, a stateful Component first serializes its state by\ncalling <b><code>getState</code></b>. By default, this function does\nnothing. The developer must provide an implementation which returns an\nobject hash which represents the Component's restorable state.</p>\n<p>The value yielded by getState is passed to <a href=\"#!/api/Ext.state.Manager-method-set\" rel=\"Ext.state.Manager-method-set\" class=\"docClass\">Ext.state.Manager.set</a>\nwhich uses the configured <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> to save the object\nkeyed by the Component's <code>stateId</code>, or, if that is not\nspecified, its <code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code>.</p>\n<p>During construction, a stateful Component attempts to <i>restore</i>\nits state by calling <a href=\"#!/api/Ext.state.Manager-method-get\" rel=\"Ext.state.Manager-method-get\" class=\"docClass\">Ext.state.Manager.get</a> passing the\n<code><a href=\"#!/api/Ext.Component-cfg-stateId\" rel=\"Ext.Component-cfg-stateId\" class=\"docClass\">stateId</a></code>, or, if that is not specified, the\n<code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code>.</p>\n<p>The resulting object is passed to <b><code>applyState</code></b>.\nThe default implementation of <code>applyState</code> simply copies\nproperties into the object, but a developer may override this to support\nmore behaviour.</p>\n<p>You can perform extra processing on state save and restore by attaching\nhandlers to the <a href=\"#!/api/Ext.Component-event-beforestaterestore\" rel=\"Ext.Component-event-beforestaterestore\" class=\"docClass\">beforestaterestore</a>, <a href=\"#!/api/Ext.Component-event-staterestore\" rel=\"Ext.Component-event-staterestore\" class=\"docClass\">staterestore</a>,\n<a href=\"#!/api/Ext.Component-event-beforestatesave\" rel=\"Ext.Component-event-beforestatesave\" class=\"docClass\">beforestatesave</a> and <a href=\"#!/api/Ext.Component-event-statesave\" rel=\"Ext.Component-event-statesave\" class=\"docClass\">statesave</a> events.</p>\n\n</p></p></div></div></div><div id='cfg-stripCharsRe' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-cfg-stripCharsRe' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-cfg-stripCharsRe' class='name not-expandable'>stripCharsRe</a><span> : RegExp</span></div><div class='description'><div class='short'><p>A JavaScript RegExp object used to strip unwanted content from the value\nbefore validation (defaults to <tt>null</tt>).</p>\n</div><div class='long'><p>A JavaScript RegExp object used to strip unwanted content from the value\nbefore validation (defaults to <tt>null</tt>).</p>\n</div></div></div><div id='cfg-style' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-style' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-style' class='name expandable'>style</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A custom style specification to be applied to this component's Element. ...</div><div class='long'><p>A custom style specification to be applied to this component's Element.  Should be a valid argument to\n<a href=\"#!/api/Ext.Element-method-applyStyles\" rel=\"Ext.Element-method-applyStyles\" class=\"docClass\">Ext.Element.applyStyles</a>.</p>\n\n<pre><code>new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({\n    title: 'Some Title',\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    width: 400, height: 300,\n    layout: 'form',\n    items: [{\n        xtype: 'textarea',\n        style: {\n            width: '95%',\n            marginBottom: '10px'\n        }\n    },\n        new <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a>({\n            text: 'Send',\n            minWidth: '100',\n            style: {\n                marginBottom: '10px'\n            }\n        })\n    ]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-submitValue' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-cfg-submitValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-cfg-submitValue' class='name expandable'>submitValue</a><span> : Boolean</span></div><div class='description'><div class='short'>False to clear the name attribute on the field so that it is not submitted during a form post. ...</div><div class='long'><p>False to clear the name attribute on the field so that it is not submitted during a form post.\nDefaults to <tt>true</tt>.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-tabIndex' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-cfg-tabIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-cfg-tabIndex' class='name expandable'>tabIndex</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The tabIndex for this field. ...</div><div class='long'><p>The tabIndex for this field. Note this only applies to fields that are rendered,\nnot those which are built via applyTo (defaults to undefined).</p>\n</div></div></div><div id='cfg-tabTip' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-tabTip' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-tabTip' class='name expandable'>tabTip</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Note: this config is only used when this BoxComponent is a child item of a TabPanel. ...</div><div class='long'><p><b>Note</b>: this config is only used when this BoxComponent is a child item of a TabPanel.</p>\n\n\n<p>A string to be used as innerHTML (html tags are accepted) to show in a tooltip when mousing over\nthe associated tab selector element. <a href=\"#!/api/Ext.QuickTips\" rel=\"Ext.QuickTips\" class=\"docClass\">Ext.QuickTips</a>.init()\nmust be called in order for the tips to render.</p>\n</div></div></div><div id='cfg-tpl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-tpl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-tpl' class='name expandable'>tpl</a><span> : Mixed</span></div><div class='description'><div class='short'>An Ext.Template, Ext.XTemplate\nor an array of strings to form an Ext.XTemplate. ...</div><div class='long'><p>An <bold><a href=\"#!/api/Ext.Template\" rel=\"Ext.Template\" class=\"docClass\">Ext.Template</a></bold>, <bold><a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a></bold>\nor an array of strings to form an <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a>.\nUsed in conjunction with the <code><a href=\"#!/api/Ext.Component-cfg-data\" rel=\"Ext.Component-cfg-data\" class=\"docClass\">data</a></code> and\n<code><a href=\"#!/api/Ext.Component-cfg-tplWriteMode\" rel=\"Ext.Component-cfg-tplWriteMode\" class=\"docClass\">tplWriteMode</a></code> configurations.</p>\n</div></div></div><div id='cfg-tplWriteMode' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-tplWriteMode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-tplWriteMode' class='name expandable'>tplWriteMode</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The Ext.(X)Template method to use when\nupdating the content area of the Component. ...</div><div class='long'><p>The Ext.(X)Template method to use when\nupdating the content area of the Component. Defaults to <tt>'overwrite'</tt>\n(see <code><a href=\"#!/api/Ext.XTemplate-method-overwrite\" rel=\"Ext.XTemplate-method-overwrite\" class=\"docClass\">Ext.XTemplate.overwrite</a></code>).</p>\n<p>Defaults to: <code>'overwrite'</code></p></div></div></div><div id='cfg-trigger1Class' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.TwinTriggerField'>Ext.form.TwinTriggerField</span><br/><a href='source/TriggerField.html#Ext-form-TwinTriggerField-cfg-trigger1Class' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TwinTriggerField-cfg-trigger1Class' class='name expandable'>trigger1Class</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>An additional CSS class used to style the trigger button. ...</div><div class='long'><p>An additional CSS class used to style the trigger button.  The trigger will always get the\nclass <tt>'x-form-trigger'</tt> by default and <tt>triggerClass</tt> will be <b>appended</b> if specified.</p>\n</div></div></div><div id='cfg-trigger2Class' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.TwinTriggerField'>Ext.form.TwinTriggerField</span><br/><a href='source/TriggerField.html#Ext-form-TwinTriggerField-cfg-trigger2Class' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TwinTriggerField-cfg-trigger2Class' class='name expandable'>trigger2Class</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>An additional CSS class used to style the trigger button. ...</div><div class='long'><p>An additional CSS class used to style the trigger button.  The trigger will always get the\nclass <tt>'x-form-trigger'</tt> by default and <tt>triggerClass</tt> will be <b>appended</b> if specified.</p>\n</div></div></div><div id='cfg-triggerClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-cfg-triggerClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-cfg-triggerClass' class='name expandable'>triggerClass</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>An additional CSS class used to style the trigger button. ...</div><div class='long'><p>An additional CSS class used to style the trigger button.  The trigger will always get the\nclass <tt>'x-form-trigger'</tt> by default and <tt>triggerClass</tt> will be <b>appended</b> if specified.</p>\n</div></div></div><div id='cfg-triggerConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.TwinTriggerField'>Ext.form.TwinTriggerField</span><br/><a href='source/TriggerField.html#Ext-form-TwinTriggerField-cfg-triggerConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TwinTriggerField-cfg-triggerConfig' class='name expandable'>triggerConfig</a><span> : Mixed</span></div><div class='description'><div class='short'>A DomHelper config object specifying the structure of the trigger elements\nfor this Field. ...</div><div class='long'><p>A <a href=\"#!/api/Ext.DomHelper\" rel=\"Ext.DomHelper\" class=\"docClass\">DomHelper</a> config object specifying the structure of the trigger elements\nfor this Field. (Optional).</p>\n\n\n<p>Specify this when you need a customized element to contain the two trigger elements for this Field.\nEach trigger element must be marked by the CSS class <tt>x-form-trigger</tt> (also see\n<tt><a href=\"#!/api/Ext.form.TwinTriggerField-cfg-trigger1Class\" rel=\"Ext.form.TwinTriggerField-cfg-trigger1Class\" class=\"docClass\">trigger1Class</a></tt> and <tt><a href=\"#!/api/Ext.form.TwinTriggerField-cfg-trigger2Class\" rel=\"Ext.form.TwinTriggerField-cfg-trigger2Class\" class=\"docClass\">trigger2Class</a></tt>).</p>\n\n\n<p>Note that when using this option, it is the developer's responsibility to ensure correct sizing,\npositioning and appearance of the triggers.</p>\n\n<p>Overrides: <a href='#!/api/Ext.form.TriggerField-cfg-triggerConfig' rel='Ext.form.TriggerField-cfg-triggerConfig' class='docClass'>Ext.form.TriggerField.triggerConfig</a></p></div></div></div><div id='cfg-validateOnBlur' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-cfg-validateOnBlur' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-cfg-validateOnBlur' class='name expandable'>validateOnBlur</a><span> : Boolean</span></div><div class='description'><div class='short'>Whether the field should validate when it loses focus (defaults to true). ...</div><div class='long'><p>Whether the field should validate when it loses focus (defaults to true).</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-validationDelay' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-cfg-validationDelay' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-cfg-validationDelay' class='name expandable'>validationDelay</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The length of time in milliseconds after user input begins until validation\nis initiated (defaults to 250) ...</div><div class='long'><p>The length of time in milliseconds after user input begins until validation\nis initiated (defaults to 250)</p>\n<p>Defaults to: <code>250</code></p></div></div></div><div id='cfg-validationEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-cfg-validationEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-cfg-validationEvent' class='name expandable'>validationEvent</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Boolean</span></div><div class='description'><div class='short'>The event that should initiate field validation. ...</div><div class='long'><p>The event that should initiate field validation. Set to false to disable</p>\n\n<pre><code>  automatic validation (defaults to 'keyup').\n</code></pre>\n<p>Defaults to: <code>'keyup'</code></p></div></div></div><div id='cfg-validator' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-cfg-validator' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-cfg-validator' class='name expandable'>validator</a><span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span></div><div class='description'><div class='short'>A custom validation function to be called during field validation (validateValue)\n(defaults to null). ...</div><div class='long'><p>A custom validation function to be called during field validation (<a href=\"#!/api/Ext.form.TextField-method-validateValue\" rel=\"Ext.form.TextField-method-validateValue\" class=\"docClass\">validateValue</a>)\n(defaults to <tt>null</tt>). If specified, this function will be called first, allowing the\ndeveloper to override the default validation process.</p>\n\n\n<br><p>This function will be passed the following Parameters:</p>\n\n\n<div class=\"mdetail-params\"><ul>\n<li><code>value</code>: <i>Mixed</i>\n<div class=\"sub-desc\">The current field value</div></li>\n</ul></div>\n\n\n<br><p>This function is to Return:</p>\n\n\n<div class=\"mdetail-params\"><ul>\n<li><code>true</code>: <i>Boolean</i>\n<div class=\"sub-desc\"><code>true</code> if the value is valid</div></li>\n<li><code>msg</code>: <i>String</i>\n<div class=\"sub-desc\">An error message if the value is invalid</div></li>\n</ul></div>\n\n</div></div></div><div id='cfg-value' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-cfg-value' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-cfg-value' class='name not-expandable'>value</a><span> : Mixed</span></div><div class='description'><div class='short'><p>A value to initialize this field with (defaults to undefined).</p>\n</div><div class='long'><p>A value to initialize this field with (defaults to undefined).</p>\n</div></div></div><div id='cfg-vtype' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-cfg-vtype' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-cfg-vtype' class='name not-expandable'>vtype</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'><p>A validation type name as defined in <a href=\"#!/api/Ext.form.VTypes\" rel=\"Ext.form.VTypes\" class=\"docClass\">Ext.form.VTypes</a> (defaults to <tt>null</tt>)</p>\n</div><div class='long'><p>A validation type name as defined in <a href=\"#!/api/Ext.form.VTypes\" rel=\"Ext.form.VTypes\" class=\"docClass\">Ext.form.VTypes</a> (defaults to <tt>null</tt>)</p>\n</div></div></div><div id='cfg-vtypeText' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-cfg-vtypeText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-cfg-vtypeText' class='name expandable'>vtypeText</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A custom error message to display in place of the default message provided\nfor the vtype currently set for this field...</div><div class='long'><p>A custom error message to display in place of the default message provided\nfor the <b><code><a href=\"#!/api/Ext.form.TextField-cfg-vtype\" rel=\"Ext.form.TextField-cfg-vtype\" class=\"docClass\">vtype</a></code></b> currently set for this field (defaults to <tt>''</tt>).  <b>Note</b>:\nonly applies if <b><code><a href=\"#!/api/Ext.form.TextField-cfg-vtype\" rel=\"Ext.form.TextField-cfg-vtype\" class=\"docClass\">vtype</a></code></b> is set, else ignored.</p>\n</div></div></div><div id='cfg-width' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-width' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-width' class='name expandable'>width</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The width of this component in pixels (defaults to auto). ...</div><div class='long'><p>The width of this component in pixels (defaults to auto).\n<b>Note</b> to express this dimension as a percentage or offset see Ext.Component.anchor.</p>\n</div></div></div><div id='cfg-wrapFocusClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-cfg-wrapFocusClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-cfg-wrapFocusClass' class='name expandable'>wrapFocusClass</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The class added to the to the wrap of the trigger element. ...</div><div class='long'><p>The class added to the to the wrap of the trigger element. Defaults to\n<tt>x-trigger-wrap-focus</tt>.</p>\n<p>Defaults to: <code>'x-trigger-wrap-focus'</code></p></div></div></div><div id='cfg-x' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-x' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-x' class='name not-expandable'>x</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The local x (left) coordinate for this component if contained within a positioning container.</p>\n</div><div class='long'><p>The local x (left) coordinate for this component if contained within a positioning container.</p>\n</div></div></div><div id='cfg-xtype' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-xtype' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-xtype' class='name expandable'>xtype</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The registered xtype to create. ...</div><div class='long'><p>The registered <tt>xtype</tt> to create. This config option is not used when passing\na config object into a constructor. This config option is used only when\nlazy instantiation is being used, and a child item of a Container is being\nspecified not as a fully instantiated Component, but as a <i>Component config\nobject</i>. The <tt>xtype</tt> will be looked up at render time up to determine what\ntype of child Component to create.<br><br>\nThe predefined xtypes are listed <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">here</a>.</p>\n\n<br><br>\n\n\n<p>If you subclass Components to create your own Components, you may register\nthem using <a href=\"#!/api/Ext.ComponentMgr-method-registerType\" rel=\"Ext.ComponentMgr-method-registerType\" class=\"docClass\">Ext.ComponentMgr.registerType</a> in order to be able to\ntake advantage of lazy instantiation and rendering.</p>\n</div></div></div><div id='cfg-y' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-y' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-y' class='name not-expandable'>y</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The local y (top) coordinate for this component if contained within a positioning container.</p>\n</div><div class='long'><p>The local y (top) coordinate for this component if contained within a positioning container.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-actionMode' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-property-actionMode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-property-actionMode' class='name expandable'>actionMode</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>'wrap'</code></p></div></div></div><div id='property-boxReady' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-property-boxReady' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-property-boxReady' class='name expandable'>boxReady</a><span> : Boolean</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>private, set in afterRender to signify that the component has been rendered ...</div><div class='long'><p>private, set in afterRender to signify that the component has been rendered</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-defaultTriggerWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-property-defaultTriggerWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-property-defaultTriggerWidth' class='name expandable'>defaultTriggerWidth</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>17</code></p></div></div></div><div id='property-deferHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-property-deferHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-property-deferHeight' class='name expandable'>deferHeight</a><span> : Boolean</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Defaults to: <code>true</code></p><p>Overrides: <a href='#!/api/Ext.BoxComponent-property-deferHeight' rel='Ext.BoxComponent-property-deferHeight' class='docClass'>Ext.BoxComponent.deferHeight</a></p></div></div></div><div id='property-disabled' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-disabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-disabled' class='name expandable'>disabled</a><span> : Boolean</span></div><div class='description'><div class='short'>True if this component is disabled. ...</div><div class='long'><p>True if this component is disabled. Read-only.</p>\n</div></div></div><div id='property-el' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-el' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-el' class='name expandable'>el</a><span> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span></div><div class='description'><div class='short'>The Ext.Element which encapsulates this Component. ...</div><div class='long'><p>The <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> which encapsulates this Component. Read-only.</p>\n\n\n<p>This will <i>usually</i> be a &lt;DIV> element created by the class's onRender method, but\nthat may be overridden using the <code><a href=\"#!/api/Ext.Component-cfg-autoEl\" rel=\"Ext.Component-cfg-autoEl\" class=\"docClass\">autoEl</a></code> config.</p>\n\n\n<br><p><b>Note</b>: this element will not be available until this Component has been rendered.</p><br>\n\n\n<p>To add listeners for <b>DOM events</b> to this Component (as opposed to listeners\nfor this Component's own Observable events), see the <a href=\"#!/api/Ext.util.Observable-cfg-listeners\" rel=\"Ext.util.Observable-cfg-listeners\" class=\"docClass\">listeners</a>\nconfig for a suggestion, or use a render listener directly:</p>\n\n\n<pre><code>new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({\n    title: 'The Clickable Panel',\n    listeners: {\n        render: function(p) {\n            // Append the Panel to the click handler&#39;s argument list.\n            p.getEl().on('click', handlePanelClick.createDelegate(null, [p], true));\n        },\n        single: true  // Remove the listener after first invocation\n    }\n});\n</code></pre>\n\n\n<p>See also <tt><a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">getEl</a></tt></p>\n\n</div></div></div><div id='property-hasFocus' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-property-hasFocus' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-property-hasFocus' class='name expandable'>hasFocus</a><span> : Boolean</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-hidden' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-hidden' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-hidden' class='name expandable'>hidden</a><span> : Boolean</span></div><div class='description'><div class='short'>True if this component is hidden. ...</div><div class='long'><p>True if this component is hidden. Read-only.</p>\n</div></div></div><div id='property-initialConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-initialConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-initialConfig' class='name expandable'>initialConfig</a><span> : Object</span></div><div class='description'><div class='short'>This Component's initial configuration specification. ...</div><div class='long'><p>This Component's initial configuration specification. Read-only.</p>\n</div></div></div><div id='property-isFormField' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-property-isFormField' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-property-isFormField' class='name expandable'>isFormField</a><span> : Boolean</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='property-label' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-property-label' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-property-label' class='name expandable'>label</a><span> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span></div><div class='description'><div class='short'>The label Element associated with this Field. ...</div><div class='long'><p>The label Element associated with this Field. <b>Only available after this Field has been rendered by a\nExt.layout.FormLayout layout manager.</b></p>\n\n</div></div></div><div id='property-mimicing' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-property-mimicing' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-property-mimicing' class='name expandable'>mimicing</a><span> : Boolean</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-monitorTab' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-property-monitorTab' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-property-monitorTab' class='name expandable'>monitorTab</a><span> : Boolean</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='property-msgDisplay' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-property-msgDisplay' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-property-msgDisplay' class='name expandable'>msgDisplay</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Defaults to: <code>''</code></p></div></div></div><div id='property-originalValue' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-property-originalValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-property-originalValue' class='name expandable'>originalValue</a><span> : mixed</span></div><div class='description'><div class='short'>The original value of the field as configured in the value configuration, or\nas loaded by the last form load operatio...</div><div class='long'><p>The original value of the field as configured in the <a href=\"#!/api/Ext.form.Field-cfg-value\" rel=\"Ext.form.Field-cfg-value\" class=\"docClass\">value</a> configuration, or\nas loaded by the last form load operation if the form's <a href=\"#!/api/Ext.form.BasicForm-cfg-trackResetOnLoad\" rel=\"Ext.form.BasicForm-cfg-trackResetOnLoad\" class=\"docClass\">trackResetOnLoad</a>\nsetting is <code>true</code>.</p>\n</div></div></div><div id='property-ownerCt' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-ownerCt' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-ownerCt' class='name expandable'>ownerCt</a><span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span></div><div class='description'><div class='short'>This Component's owner Container (defaults to undefined, and is set automatically when\nthis Component is added to a C...</div><div class='long'><p>This Component's owner <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Container</a> (defaults to undefined, and is set automatically when\nthis Component is added to a Container).  Read-only.</p>\n\n<p><b>Note</b>: to access items within the Container see <tt><a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a></tt>.</p>\n\n</div></div></div><div id='property-refOwner' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-refOwner' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-refOwner' class='name expandable'>refOwner</a><span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span></div><div class='description'><div class='short'>The ancestor Container into which the ref reference was inserted if this Component\nis a child of a Container, and has...</div><div class='long'><p>The ancestor Container into which the <a href=\"#!/api/Ext.Component-cfg-ref\" rel=\"Ext.Component-cfg-ref\" class=\"docClass\">ref</a> reference was inserted if this Component\nis a child of a Container, and has been configured with a <code>ref</code>.</p>\n</div></div></div><div id='property-rendered' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-rendered' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-rendered' class='name expandable'>rendered</a><span> : Boolean</span></div><div class='description'><div class='short'>True if this component has been rendered. ...</div><div class='long'><p>True if this component has been rendered. Read-only.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-startValue' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-property-startValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-property-startValue' class='name expandable'>startValue</a><span> : mixed</span></div><div class='description'><div class='short'>The value that the Field had at the time it was last focused. ...</div><div class='long'><p>The value that the Field had at the time it was last focused. This is the value that is passed\nto the <a href=\"#!/api/Ext.form.Field-event-change\" rel=\"Ext.form.Field-event-change\" class=\"docClass\">change</a> event which is fired if the value has been changed when the Field is blurred.</p>\n\n\n<p><b>This will be undefined until the Field has been visited.</b> Compare <a href=\"#!/api/Ext.form.Field-property-originalValue\" rel=\"Ext.form.Field-property-originalValue\" class=\"docClass\">originalValue</a>.</p>\n\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.form.TriggerField-method-constructor' class='name expandable'>Ext.form.TwinTriggerField</a>( <span class='pre'>config</span> ) : <a href=\"#!/api/Ext.form.TriggerField\" rel=\"Ext.form.TriggerField\" class=\"docClass\">Ext.form.TriggerField</a></div><div class='description'><div class='short'>Create a new TriggerField. ...</div><div class='long'><p>Create a new TriggerField.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration options (valid {@<a href=\"#!/api/Ext.form.TextField\" rel=\"Ext.form.TextField\" class=\"docClass\">Ext.form.TextField</a>} config options will also be applied\nto the base TextField)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.form.TriggerField\" rel=\"Ext.form.TriggerField\" class=\"docClass\">Ext.form.TriggerField</a></span><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.form.TextField-method-constructor' rel='Ext.form.TextField-method-constructor' class='docClass'>Ext.form.TextField.constructor</a></p></div></div></div><div id='method-addClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-addClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-addClass' class='name expandable'>addClass</a>( <span class='pre'>cls</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Adds a CSS class to the component's underlying element. ...</div><div class='long'><p>Adds a CSS class to the component's underlying element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cls</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>The CSS class name to add</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-addEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addEvents' class='name expandable'>addEvents</a>( <span class='pre'>o, Optional</span> )</div><div class='description'><div class='short'>Adds the specified events to the list of events which this Observable may fire. ...</div><div class='long'><p>Adds the specified events to the list of events which this Observable may fire.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Either an object with event names as properties with a value of <code>true</code>\nor the first event name string if multiple event names are being passed as separate parameters.</p>\n</div></li><li><span class='pre'>Optional</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>. Event name if multiple event names are being passed as separate parameters.\nUsage:</p>\n\n<pre><code>this.addEvents('storeloaded', 'storecleared');\n</code></pre>\n\n</div></li></ul></div></div></div><div id='method-addListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addListener' class='name expandable'>addListener</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object. ...</div><div class='long'><p>Appends an event handler to this object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to listen for.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.\nproperties. This may contain any of the following properties:<ul>\n<li><b>scope</b> : Object<div class=\"sub-desc\">The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></div></li>\n<li><b>delay</b> : Number<div class=\"sub-desc\">The number of milliseconds to delay the invocation of the handler after the event fires.</div></li>\n<li><b>single</b> : Boolean<div class=\"sub-desc\">True to add a handler to handle just the next firing of the event, and then remove itself.</div></li>\n<li><b>buffer</b> : Number<div class=\"sub-desc\">Causes the handler to be scheduled to run in an <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a> delayed\nby the specified number of milliseconds. If the event fires again within that time, the original\nhandler is <em>not</em> invoked, but the new handler is scheduled in its place.</div></li>\n<li><b>target</b> : Observable<div class=\"sub-desc\">Only call the handler if the event was fired on the target Observable, <i>not</i>\nif the event was bubbled up from a child Observable.</div></li>\n</ul><br></p>\n\n<p>\n<b>Combining Options</b><br>\nUsing the options argument, it is possible to combine different types of listeners:<br>\n<br>\nA delayed, one-time listener.\n<pre><code>myDataView.on('click', this.onClick, this, {\nsingle: true,\ndelay: 100\n});</code></pre>\n<p>\n<b>Attaching multiple handlers in 1 call</b><br>\nThe method also allows for a single argument to be passed which is a config object containing properties\nwhich specify multiple handlers.\n<p>\n<pre><code>myGridPanel.on({\n'click' : {\n    fn: this.onClick,\n    scope: this,\n    delay: 100\n},\n'mouseover' : {\n    fn: this.onMouseOver,\n    scope: this\n},\n'mouseout' : {\n    fn: this.onMouseOut,\n    scope: this\n}\n});</code></pre>\n<p>\nOr a shorthand syntax:<br>\n<pre><code>myGridPanel.on({\n'click' : this.onClick,\n'mouseover' : this.onMouseOver,\n'mouseout' : this.onMouseOut,\n scope: this\n});</code></pre>\n\n</p></p></p></p></div></li></ul></div></div></div><div id='method-adjustPosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-adjustPosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-adjustPosition' class='name expandable'>adjustPosition</a>( <span class='pre'>x, y</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>y</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-adjustSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-adjustSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-adjustSize' class='name expandable'>adjustSize</a>( <span class='pre'>w, h</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>w</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>h</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-afterRender' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.TwinTriggerField'>Ext.form.TwinTriggerField</span><br/><a href='source/TriggerField.html#Ext-form-TwinTriggerField-method-afterRender' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TwinTriggerField-method-afterRender' class='name expandable'>afterRender</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Overrides: <a href='#!/api/Ext.form.TriggerField-method-afterRender' rel='Ext.form.TriggerField-method-afterRender' class='docClass'>Ext.form.TriggerField.afterRender</a></p></div></div></div><div id='method-alignErrorEl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-method-alignErrorEl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-method-alignErrorEl' class='name expandable'>alignErrorEl</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Alignment for 'under' target ...</div><div class='long'><p>Alignment for 'under' target</p>\n</div></div></div><div id='method-alignErrorIcon' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-method-alignErrorIcon' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-method-alignErrorIcon' class='name expandable'>alignErrorIcon</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Overrides: <a href='#!/api/Ext.form.Field-method-alignErrorIcon' rel='Ext.form.Field-method-alignErrorIcon' class='docClass'>Ext.form.Field.alignErrorIcon</a></p></div></div></div><div id='method-append' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-method-append' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-method-append' class='name expandable'>append</a>( <span class='pre'>v</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private, does not work for all fields ...</div><div class='long'><p>private, does not work for all fields</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>v</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-applyEmptyText' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-method-applyEmptyText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-method-applyEmptyText' class='name expandable'>applyEmptyText</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-applyToMarkup' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-applyToMarkup' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-applyToMarkup' class='name expandable'>applyToMarkup</a>( <span class='pre'>el</span> )</div><div class='description'><div class='short'>Apply this component to existing markup that is valid. ...</div><div class='long'><p>Apply this component to existing markup that is valid. With this function, no call to render() is required.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-beforeBlur' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-method-beforeBlur' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-method-beforeBlur' class='name expandable'>beforeBlur</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Overrides: <a href='#!/api/Ext.form.Field-method-beforeBlur' rel='Ext.form.Field-method-beforeBlur' class='docClass'>Ext.form.Field.beforeBlur</a></p></div></div></div><div id='method-bubble' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-bubble' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-bubble' class='name expandable'>bubble</a>( <span class='pre'>fn, [scope], [args]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Bubbles up the component/container heirarchy, calling the specified function with each component. ...</div><div class='long'><p>Bubbles up the component/container heirarchy, calling the specified function with each component. The scope (<i>this</i>) of\nfunction call will be the scope provided or the current component. The arguments to the function\nwill be the args provided or the current component. If the function returns false at any point,\nthe bubble is stopped.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to call</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope of the function (defaults to current node)</p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> (optional)<div class='sub-desc'><p>The args to call the function with (default to passing the current component)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-checkTab' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-method-checkTab' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-method-checkTab' class='name expandable'>checkTab</a>( <span class='pre'>me, e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>me</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-clearInvalid' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-method-clearInvalid' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-method-clearInvalid' class='name expandable'>clearInvalid</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Clear any invalid styles/messages for this field ...</div><div class='long'><p>Clear any invalid styles/messages for this field</p>\n</div></div></div><div id='method-cloneConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-cloneConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-cloneConfig' class='name expandable'>cloneConfig</a>( <span class='pre'>overrides</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Clone the current component using the original config values passed into this instance by default. ...</div><div class='long'><p>Clone the current component using the original config values passed into this instance by default.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>overrides</span> : Object<div class='sub-desc'><p>A new config containing any properties to override in the cloned version.\nAn id property can be passed on this object, otherwise one will be generated to avoid duplicates.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>clone The cloned copy of this component</p>\n</div></li></ul></div></div></div><div id='method-destroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-destroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-destroy' class='name expandable'>destroy</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Destroys this component by purging any event listeners, removing the component's element from the DOM,\nremoving the c...</div><div class='long'><p>Destroys this component by purging any event listeners, removing the component's element from the DOM,\nremoving the component from its <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a> (if applicable) and unregistering it from\n<a href=\"#!/api/Ext.ComponentMgr\" rel=\"Ext.ComponentMgr\" class=\"docClass\">Ext.ComponentMgr</a>.  Destruction is generally handled automatically by the framework and this method\nshould usually not need to be called directly.</p>\n</div></div></div><div id='method-disable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-disable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-disable' class='name expandable'>disable</a>( <span class='pre'>silent</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Disable this component and fire the 'disable' event. ...</div><div class='long'><p>Disable this component and fire the 'disable' event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>silent</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-doAutoSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-method-doAutoSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-method-doAutoSize' class='name expandable'>doAutoSize</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-enable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-enable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-enable' class='name expandable'>enable</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Enable this component and fire the 'enable' event. ...</div><div class='long'><p>Enable this component and fire the 'enable' event.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-enableBubble' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-enableBubble' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-enableBubble' class='name expandable'>enableBubble</a>( <span class='pre'>events</span> )</div><div class='description'><div class='short'>Enables events fired by this Observable to bubble up an owner hierarchy by calling\nthis.getBubbleTarget() if present. ...</div><div class='long'><p>Enables events fired by this Observable to bubble up an owner hierarchy by calling\n<code>this.getBubbleTarget()</code> if present. There is no implementation in the Observable base class.</p>\n\n\n<p>This is commonly used by Ext.Components to bubble events to owner Containers. See Ext.Component.getBubbleTarget. The default\nimplementation in <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> returns the Component's immediate owner. But if a known target is required, this can be overridden to\naccess the required target more quickly.</p>\n\n\n<p>Example:</p>\n\n\n<pre><code><a href=\"#!/api/Ext-method-override\" rel=\"Ext-method-override\" class=\"docClass\">Ext.override</a>(<a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a>, {\n    //  Add functionality to Field&#39;s initComponent to enable the change event to bubble\n    initComponent : Ext.form.Field.prototype.initComponent.createSequence(function() {\n        this.enableBubble('change');\n    }),\n\n    //  We know that we want Field&#39;s events to bubble directly to the FormPanel.\n    getBubbleTarget : function() {\n        if (!this.formPanel) {\n            this.formPanel = this.findParentByType('form');\n        }\n        return this.formPanel;\n    }\n});\n\nvar myForm = new Ext.formPanel({\n    title: 'User Details',\n    items: [{\n        ...\n    }],\n    listeners: {\n        change: function() {\n            // Title goes red if form has been modified.\n            myForm.header.setStyle('color', 'red');\n        }\n    }\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>events</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The event name to bubble, or an Array of event names.</p>\n</div></li></ul></div></div></div><div id='method-filterKeys' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-method-filterKeys' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-method-filterKeys' class='name expandable'>filterKeys</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-filterValidation' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-method-filterValidation' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-method-filterValidation' class='name expandable'>filterValidation</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-findParentBy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-findParentBy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-findParentBy' class='name expandable'>findParentBy</a>( <span class='pre'>fn</span> ) : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></div><div class='description'><div class='short'>Find a container above this component at any level by a custom function. ...</div><div class='long'><p>Find a container above this component at any level by a custom function. If the passed function returns\ntrue, the container will be returned.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The custom function to call with the arguments (container, this component).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span><div class='sub-desc'><p>The first Container for which the custom function returns true</p>\n</div></li></ul></div></div></div><div id='method-findParentByType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-findParentByType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-findParentByType' class='name expandable'>findParentByType</a>( <span class='pre'>xtype, [shallow]</span> ) : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></div><div class='description'><div class='short'>Find a container above this component at any level by xtype or class ...</div><div class='long'><p>Find a container above this component at any level by xtype or class</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>xtype</span> : String/Ext.Component/Class<div class='sub-desc'><p>The xtype to check for this Component. Note that the the component can either be an instance\nor a component class:</p>\n</div></li><li><span class='pre'>shallow</span> : Boolean (optional)<div class='sub-desc'><p>False to check whether this Component is descended from the xtype (this is\nthe default), or true to check whether this Component is directly of the specified xtype.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span><div class='sub-desc'><p>The first Container which matches the given xtype or class</p>\n</div></li></ul></div></div></div><div id='method-fireEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-fireEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-fireEvent' class='name expandable'>fireEvent</a>( <span class='pre'>eventName, args</span> ) : Boolean</div><div class='description'><div class='short'>Fires the specified event with the passed parameters (minus the event name). ...</div><div class='long'><p>Fires the specified event with the passed parameters (minus the event name).</p>\n\n\n<p>An event may be set to bubble up an Observable parent hierarchy (See <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>)\nby calling <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to fire.</p>\n</div></li><li><span class='pre'>args</span> : Object...<div class='sub-desc'><p>Variable number of parameters are passed to handlers.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>returns false if any of the handlers return false otherwise it returns true.</p>\n</div></li></ul></div></div></div><div id='method-fireKey' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-method-fireKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-method-fireKey' class='name expandable'>fireKey</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-focus' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-focus' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-focus' class='name expandable'>focus</a>( <span class='pre'>[selectText], [delay]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Try to focus this component. ...</div><div class='long'><p>Try to focus this component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selectText</span> : Boolean (optional)<div class='sub-desc'><p>If applicable, true to also select the text in this component</p>\n</div></li><li><span class='pre'>delay</span> : Boolean/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>Delay the focus this number of milliseconds (true for 10 milliseconds)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-getActiveError' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-method-getActiveError' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-method-getActiveError' class='name expandable'>getActiveError</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Gets the active error message for this field. ...</div><div class='long'><p>Gets the active error message for this field.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>Returns the active error message on the field, if there is no error, an empty string is returned.</p>\n</div></li></ul></div></div></div><div id='method-getBox' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getBox' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getBox' class='name expandable'>getBox</a>( <span class='pre'>[local]</span> ) : Object</div><div class='description'><div class='short'>Gets the current box measurements of the component's underlying element. ...</div><div class='long'><p>Gets the current box measurements of the component's underlying element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>local</span> : Boolean (optional)<div class='sub-desc'><p>If true the element's left and top are returned instead of page XY (defaults to false)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>box An object in the format {x, y, width, height}</p>\n</div></li></ul></div></div></div><div id='method-getBubbleTarget' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getBubbleTarget' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getBubbleTarget' class='name expandable'>getBubbleTarget</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></div><div class='description'><div class='short'>Provides the link for Observable's fireEvent method to bubble up the ownership hierarchy. ...</div><div class='long'><p>Provides the link for Observable's fireEvent method to bubble up the ownership hierarchy.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span><div class='sub-desc'><p>the Container which owns this Component.</p>\n</div></li></ul></div></div></div><div id='method-getEl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getEl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getEl' class='name expandable'>getEl</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Returns the Ext.Element which encapsulates this Component. ...</div><div class='long'><p>Returns the <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> which encapsulates this Component.</p>\n\n\n<p>This will <i>usually</i> be a &lt;DIV> element created by the class's onRender method, but\nthat may be overridden using the <a href=\"#!/api/Ext.Component-cfg-autoEl\" rel=\"Ext.Component-cfg-autoEl\" class=\"docClass\">autoEl</a> config.</p>\n\n\n<br><p><b>Note</b>: this element will not be available until this Component has been rendered.</p><br>\n\n\n<p>To add listeners for <b>DOM events</b> to this Component (as opposed to listeners\nfor this Component's own Observable events), see the <a href=\"#!/api/Ext.Component-cfg-listeners\" rel=\"Ext.Component-cfg-listeners\" class=\"docClass\">listeners</a> config for a suggestion,\nor use a render listener directly:</p>\n\n\n<pre><code>new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({\n    title: 'The Clickable Panel',\n    listeners: {\n        render: function(p) {\n            // Append the Panel to the click handler&#39;s argument list.\n            p.getEl().on('click', handlePanelClick.createDelegate(null, [p], true));\n        },\n        single: true  // Remove the listener after first invocation\n    }\n});\n</code></pre>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element which encapsulates this Component.</p>\n</div></li></ul></div></div></div><div id='method-getErrorCt' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-method-getErrorCt' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-method-getErrorCt' class='name expandable'>getErrorCt</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-getErrors' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-method-getErrors' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-method-getErrors' class='name expandable'>getErrors</a>( <span class='pre'>value</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Validates a value according to the field's validation rules and returns an array of errors\nfor any failing validations. ...</div><div class='long'><p>Validates a value according to the field's validation rules and returns an array of errors\nfor any failing validations. Validation rules are processed in the following order:</p>\n\n\n<div class=\"mdetail-params\"><ul>\n\n<li><b>1. Field specific validator</b>\n<div class=\"sub-desc\">\n<p>A validator offers a way to customize and reuse a validation specification.\nIf a field is configured with a <code><a href=\"#!/api/Ext.form.TextField-cfg-validator\" rel=\"Ext.form.TextField-cfg-validator\" class=\"docClass\">validator</a></code>\nfunction, it will be passed the current field value.  The <code><a href=\"#!/api/Ext.form.TextField-cfg-validator\" rel=\"Ext.form.TextField-cfg-validator\" class=\"docClass\">validator</a></code>\nfunction is expected to return either:\n<div class=\"mdetail-params\"><ul>\n<li>Boolean <tt>true</tt> if the value is valid (validation continues).</li>\n<li>a String to represent the invalid message if invalid (validation halts).</li>\n</ul></div>\n</div></li>\n\n<li><b>2. Basic Validation</b>\n<div class=\"sub-desc\">\n<p>If the <code><a href=\"#!/api/Ext.form.TextField-cfg-validator\" rel=\"Ext.form.TextField-cfg-validator\" class=\"docClass\">validator</a></code> has not halted validation,\nbasic validation proceeds as follows:</p>\n\n<div class=\"mdetail-params\"><ul>\n\n<li><code><a href=\"#!/api/Ext.form.TextField-cfg-allowBlank\" rel=\"Ext.form.TextField-cfg-allowBlank\" class=\"docClass\">allowBlank</a></code> : (Invalid message =\n<code><a href=\"#!/api/Ext.form.TextField-cfg-emptyText\" rel=\"Ext.form.TextField-cfg-emptyText\" class=\"docClass\">emptyText</a></code>)<div class=\"sub-desc\">\nDepending on the configuration of <code><a href=\"#!/api/Ext.form.TextField-cfg-allowBlank\" rel=\"Ext.form.TextField-cfg-allowBlank\" class=\"docClass\">allowBlank</a></code>, a\nblank field will cause validation to halt at this step and return\nBoolean true or false accordingly.  \n</div></li>\n\n<li><code><a href=\"#!/api/Ext.form.TextField-cfg-minLength\" rel=\"Ext.form.TextField-cfg-minLength\" class=\"docClass\">minLength</a></code> : (Invalid message =\n<code><a href=\"#!/api/Ext.form.TextField-cfg-minLengthText\" rel=\"Ext.form.TextField-cfg-minLengthText\" class=\"docClass\">minLengthText</a></code>)<div class=\"sub-desc\">\nIf the passed value does not satisfy the <code><a href=\"#!/api/Ext.form.TextField-cfg-minLength\" rel=\"Ext.form.TextField-cfg-minLength\" class=\"docClass\">minLength</a></code>\nspecified, validation halts.\n</div></li>\n\n<li><code><a href=\"#!/api/Ext.form.TextField-cfg-maxLength\" rel=\"Ext.form.TextField-cfg-maxLength\" class=\"docClass\">maxLength</a></code> : (Invalid message =\n<code><a href=\"#!/api/Ext.form.TextField-cfg-maxLengthText\" rel=\"Ext.form.TextField-cfg-maxLengthText\" class=\"docClass\">maxLengthText</a></code>)<div class=\"sub-desc\">\nIf the passed value does not satisfy the <code><a href=\"#!/api/Ext.form.TextField-cfg-maxLength\" rel=\"Ext.form.TextField-cfg-maxLength\" class=\"docClass\">maxLength</a></code>\nspecified, validation halts.\n</div></li>\n\n</ul></div>\n</div></li>\n\n<li><b>3. Preconfigured Validation Types (VTypes)</b>\n<div class=\"sub-desc\">\n<p>If none of the prior validation steps halts validation, a field\nconfigured with a <code><a href=\"#!/api/Ext.form.TextField-cfg-vtype\" rel=\"Ext.form.TextField-cfg-vtype\" class=\"docClass\">vtype</a></code> will utilize the\ncorresponding <a href=\"#!/api/Ext.form.VTypes\" rel=\"Ext.form.VTypes\" class=\"docClass\">VTypes</a> validation function.\nIf invalid, either the field's <code><a href=\"#!/api/Ext.form.TextField-cfg-vtypeText\" rel=\"Ext.form.TextField-cfg-vtypeText\" class=\"docClass\">vtypeText</a></code> or\nthe VTypes vtype Text property will be used for the invalid message.\nKeystrokes on the field will be filtered according to the VTypes\nvtype Mask property.</p>\n</div></li>\n\n<li><b>4. Field specific regex test</b>\n<div class=\"sub-desc\">\n<p>If none of the prior validation steps halts validation, a field's\nconfigured <code><a href=\"#!/api/Ext.form.TextField-cfg-regex\" rel=\"Ext.form.TextField-cfg-regex\" class=\"docClass\">regex</a></code> test will be processed.\nThe invalid message for this test is configured with\n<code><a href=\"#!/api/Ext.form.TextField-cfg-regexText\" rel=\"Ext.form.TextField-cfg-regexText\" class=\"docClass\">regexText</a></code>.</p>\n</div></li>\n\n</p></ul></div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : Mixed<div class='sub-desc'><p>The value to validate. The processed raw value will be used if nothing is passed</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>Array of any validation errors</p>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.form.Field-method-getErrors' rel='Ext.form.Field-method-getErrors' class='docClass'>Ext.form.Field.getErrors</a></p></div></div></div><div id='method-getHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getHeight' class='name expandable'>getHeight</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the current height of the component's underlying element. ...</div><div class='long'><p>Gets the current height of the component's underlying element.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getId' class='name expandable'>getId</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the id of this component or automatically generates and\nreturns an id if an id is not defined yet:\n\n'ext-comp...</div><div class='long'><p>Returns the <code>id</code> of this component or automatically generates and\nreturns an <code>id</code> if an <code>id</code> is not defined yet:</p>\n\n<pre><code>'ext-comp-' + (++<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.AUTO_ID)\n</code></pre>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>id</p>\n</div></li></ul></div></div></div><div id='method-getItemCt' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-method-getItemCt' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-method-getItemCt' class='name expandable'>getItemCt</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-getItemId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getItemId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getItemId' class='name expandable'>getItemId</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the itemId of this component. ...</div><div class='long'><p>Returns the <code><a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a></code> of this component.  If an\n<code><a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a></code> was not assigned through configuration the\n<code>id</code> is returned using <code><a href=\"#!/api/Ext.Component-method-getId\" rel=\"Ext.Component-method-getId\" class=\"docClass\">getId</a></code>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getMessageHandler' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-method-getMessageHandler' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-method-getMessageHandler' class='name expandable'>getMessageHandler</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-getName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-method-getName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-method-getName' class='name expandable'>getName</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the name or hiddenName\nattribute of the field if available. ...</div><div class='long'><p>Returns the <a href=\"#!/api/Ext.form.Field-cfg-name\" rel=\"Ext.form.Field-cfg-name\" class=\"docClass\">name</a> or <a href=\"#!/api/Ext.form.ComboBox-cfg-hiddenName\" rel=\"Ext.form.ComboBox-cfg-hiddenName\" class=\"docClass\">hiddenName</a>\nattribute of the field if available.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>name The field <a href=\"#!/api/Ext.form.Field-cfg-name\" rel=\"Ext.form.Field-cfg-name\" class=\"docClass\">name</a> or <a href=\"#!/api/Ext.form.ComboBox-cfg-hiddenName\" rel=\"Ext.form.ComboBox-cfg-hiddenName\" class=\"docClass\">hiddenName</a></p>\n\n</div></li></ul></div></div></div><div id='method-getOuterSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getOuterSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getOuterSize' class='name expandable'>getOuterSize</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Gets the current size of the component's underlying element, including space taken by its margins. ...</div><div class='long'><p>Gets the current size of the component's underlying element, including space taken by its margins.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>An object containing the element's size {width: (element width + left/right margins), height: (element height + top/bottom margins)}</p>\n</div></li></ul></div></div></div><div id='method-getPosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getPosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getPosition' class='name expandable'>getPosition</a>( <span class='pre'>[local]</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Gets the current XY position of the component's underlying element. ...</div><div class='long'><p>Gets the current XY position of the component's underlying element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>local</span> : Boolean (optional)<div class='sub-desc'><p>If true the element's left and top are returned instead of page XY (defaults to false)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>The XY position of the element (e.g., [100, 200])</p>\n</div></li></ul></div></div></div><div id='method-getRawValue' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-method-getRawValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-method-getRawValue' class='name expandable'>getRawValue</a>( <span class='pre'></span> ) : Mixed</div><div class='description'><div class='short'>Returns the raw data value which may or may not be a valid, defined value. ...</div><div class='long'><p>Returns the raw data value which may or may not be a valid, defined value.  To return a normalized value see <a href=\"#!/api/Ext.form.Field-method-getValue\" rel=\"Ext.form.Field-method-getValue\" class=\"docClass\">getValue</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Mixed</span><div class='sub-desc'><p>value The field value</p>\n</div></li></ul></div></div></div><div id='method-getResizeEl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getResizeEl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getResizeEl' class='name expandable'>getResizeEl</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Returns the outermost Element of this Component which defines the Components overall size. ...</div><div class='long'><p>Returns the outermost Element of this Component which defines the Components overall size.</p>\n\n\n<p><i>Usually</i> this will return the same Element as <code><a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">getEl</a></code>,\nbut in some cases, a Component may have some more wrapping Elements around its main\nactive Element.</p>\n\n\n<p>An example is a ComboBox. It is encased in a <i>wrapping</i> Element which\ncontains both the <code>&lt;input></code> Element (which is what would be returned\nby its <code><a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">getEl</a></code> method, <i>and</i> the trigger button Element.\nThis Element is returned as the <code>resizeEl</code>.\n\n</p><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element which is to be resized by size managing layouts.</p>\n</div></li></ul></div></div></div><div id='method-getSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getSize' class='name expandable'>getSize</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Gets the current size of the component's underlying element. ...</div><div class='long'><p>Gets the current size of the component's underlying element.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>An object containing the element's size {width: (element width), height: (element height)}</p>\n</div></li></ul></div></div></div><div id='method-getTrigger' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.TwinTriggerField'>Ext.form.TwinTriggerField</span><br/><a href='source/TriggerField.html#Ext-form-TwinTriggerField-method-getTrigger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TwinTriggerField-method-getTrigger' class='name expandable'>getTrigger</a>( <span class='pre'>index</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>index</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTriggerWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.TwinTriggerField'>Ext.form.TwinTriggerField</span><br/><a href='source/TriggerField.html#Ext-form-TwinTriggerField-method-getTriggerWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TwinTriggerField-method-getTriggerWidth' class='name expandable'>getTriggerWidth</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Overrides: <a href='#!/api/Ext.form.TriggerField-method-getTriggerWidth' rel='Ext.form.TriggerField-method-getTriggerWidth' class='docClass'>Ext.form.TriggerField.getTriggerWidth</a></p></div></div></div><div id='method-getValue' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-method-getValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-method-getValue' class='name expandable'>getValue</a>( <span class='pre'></span> ) : Mixed</div><div class='description'><div class='short'>Returns the normalized data value (undefined or emptyText will be returned as ''). ...</div><div class='long'><p>Returns the normalized data value (undefined or emptyText will be returned as '').  To return the raw value see <a href=\"#!/api/Ext.form.Field-method-getRawValue\" rel=\"Ext.form.Field-method-getRawValue\" class=\"docClass\">getRawValue</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Mixed</span><div class='sub-desc'><p>value The field value</p>\n</div></li></ul></div></div></div><div id='method-getWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-method-getWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-method-getWidth' class='name expandable'>getWidth</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the current width of the component's underlying element. ...</div><div class='long'><p>Gets the current width of the component's underlying element.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.BoxComponent-method-getWidth' rel='Ext.BoxComponent-method-getWidth' class='docClass'>Ext.BoxComponent.getWidth</a></p></div></div></div><div id='method-getXType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getXType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getXType' class='name expandable'>getXType</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Gets the xtype for this component as registered with Ext.ComponentMgr. ...</div><div class='long'><p>Gets the xtype for this component as registered with <a href=\"#!/api/Ext.ComponentMgr\" rel=\"Ext.ComponentMgr\" class=\"docClass\">Ext.ComponentMgr</a>. For a list of all\navailable xtypes, see the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header. Example usage:</p>\n\n<pre><code>var t = new <a href=\"#!/api/Ext.form.TextField\" rel=\"Ext.form.TextField\" class=\"docClass\">Ext.form.TextField</a>();\nalert(t.getXType());  // alerts 'textfield'\n</code></pre>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The xtype</p>\n</div></li></ul></div></div></div><div id='method-getXTypes' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getXTypes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getXTypes' class='name expandable'>getXTypes</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns this Component's xtype hierarchy as a slash-delimited string. ...</div><div class='long'><p>Returns this Component's xtype hierarchy as a slash-delimited string. For a list of all\navailable xtypes, see the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header.</p>\n\n\n<p><b>If using your own subclasses, be aware that a Component must register its own xtype\nto participate in determination of inherited xtypes.</b></p>\n\n\n<p>Example usage:</p>\n\n\n<pre><code>var t = new <a href=\"#!/api/Ext.form.TextField\" rel=\"Ext.form.TextField\" class=\"docClass\">Ext.form.TextField</a>();\nalert(t.getXTypes());  // alerts 'component/box/field/textfield'\n</code></pre>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The xtype hierarchy string</p>\n</div></li></ul></div></div></div><div id='method-hasListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-hasListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-hasListener' class='name expandable'>hasListener</a>( <span class='pre'>eventName</span> ) : Boolean</div><div class='description'><div class='short'>Checks to see if this object has any listeners for a specified event ...</div><div class='long'><p>Checks to see if this object has any listeners for a specified event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to check for</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the event is being listened for, else false</p>\n</div></li></ul></div></div></div><div id='method-hide' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-hide' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-hide' class='name expandable'>hide</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Hide this component. ...</div><div class='long'><p>Hide this component.  Listen to the '<a href=\"#!/api/Ext.Component-event-beforehide\" rel=\"Ext.Component-event-beforehide\" class=\"docClass\">beforehide</a>' event and return\n<tt>false</tt> to cancel hiding the component.  Fires the '<a href=\"#!/api/Ext.Component-method-hide\" rel=\"Ext.Component-method-hide\" class=\"docClass\">hide</a>'\nevent after hiding the component. Note this method is called internally if\nthe component is configured to be <code><a href=\"#!/api/Ext.Component-cfg-hidden\" rel=\"Ext.Component-cfg-hidden\" class=\"docClass\">hidden</a></code>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-initComponent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-method-initComponent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-method-initComponent' class='name expandable'>initComponent</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Overrides: <a href='#!/api/Ext.BoxComponent-method-initComponent' rel='Ext.BoxComponent-method-initComponent' class='docClass'>Ext.BoxComponent.initComponent</a></p></div></div></div><div id='method-initEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-method-initEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-method-initEvents' class='name expandable'>initEvents</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Overrides: <a href='#!/api/Ext.form.Field-method-initEvents' rel='Ext.form.Field-method-initEvents' class='docClass'>Ext.form.Field.initEvents</a></p></div></div></div><div id='method-initRef' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-initRef' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-initRef' class='name expandable'>initRef</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Method to establish a reference to a component. ...</div><div class='long'><p>Method to establish a reference to a component.</p>\n</div></div></div><div id='method-initTrigger' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.TwinTriggerField'>Ext.form.TwinTriggerField</span><br/><a href='source/TriggerField.html#Ext-form-TwinTriggerField-method-initTrigger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TwinTriggerField-method-initTrigger' class='name expandable'>initTrigger</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Overrides: <a href='#!/api/Ext.form.TriggerField-method-initTrigger' rel='Ext.form.TriggerField-method-initTrigger' class='docClass'>Ext.form.TriggerField.initTrigger</a></p></div></div></div><div id='method-initValue' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-method-initValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-method-initValue' class='name expandable'>initValue</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-isDirty' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-method-isDirty' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-method-isDirty' class='name expandable'>isDirty</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the value of this Field has been changed from its original value. ...</div><div class='long'><p>Returns true if the value of this Field has been changed from its original value.\nWill return false if the field is disabled or has not been rendered yet.</p>\n\n\n<p>Note that if the owning <a href=\"#!/api/Ext.form.BasicForm\" rel=\"Ext.form.BasicForm\" class=\"docClass\">form</a> was configured with\n<a href=\"#!/api/Ext.form.BasicForm\" rel=\"Ext.form.BasicForm\" class=\"docClass\">Ext.form.BasicForm</a>.<a href=\"#!/api/Ext.form.BasicForm-cfg-trackResetOnLoad\" rel=\"Ext.form.BasicForm-cfg-trackResetOnLoad\" class=\"docClass\">trackResetOnLoad</a>\nthen the <i>original value</i> is updated when the values are loaded by\n<a href=\"#!/api/Ext.form.BasicForm\" rel=\"Ext.form.BasicForm\" class=\"docClass\">Ext.form.BasicForm</a>.<a href=\"#!/api/Ext.form.BasicForm-method-setValues\" rel=\"Ext.form.BasicForm-method-setValues\" class=\"docClass\">setValues</a>.</p>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if this field has been changed from its original value (and\nis not disabled), false otherwise.</p>\n</div></li></ul></div></div></div><div id='method-isValid' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-method-isValid' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-method-isValid' class='name expandable'>isValid</a>( <span class='pre'>preventMark</span> ) : Boolean</div><div class='description'><div class='short'>Returns whether or not the field value is currently valid by\nvalidating the processed value\nof the field. ...</div><div class='long'><p>Returns whether or not the field value is currently valid by\n<a href=\"#!/api/Ext.form.Field-method-validateValue\" rel=\"Ext.form.Field-method-validateValue\" class=\"docClass\">validating</a> the <a href=\"#!/api/Ext.form.Field-method-processValue\" rel=\"Ext.form.Field-method-processValue\" class=\"docClass\">processed value</a>\nof the field. <b>Note</b>: <a href=\"#!/api/Ext.form.Field-property-disabled\" rel=\"Ext.form.Field-property-disabled\" class=\"docClass\">disabled</a> fields are ignored.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>preventMark</span> : Boolean<div class='sub-desc'><p>True to disable marking the field invalid</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the value is valid, else false</p>\n</div></li></ul></div></div></div><div id='method-isVisible' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-isVisible' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-isVisible' class='name expandable'>isVisible</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if this component is visible. ...</div><div class='long'><p>Returns true if this component is visible.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if this component is visible, false otherwise.</p>\n</div></li></ul></div></div></div><div id='method-isXType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-isXType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-isXType' class='name expandable'>isXType</a>( <span class='pre'>xtype, [shallow]</span> ) : Boolean</div><div class='description'><div class='short'>Tests whether or not this Component is of a specific xtype. ...</div><div class='long'><p>Tests whether or not this Component is of a specific xtype. This can test whether this Component is descended\nfrom the xtype (default) or whether it is directly of the xtype specified (shallow = true).</p>\n\n\n<p><b>If using your own subclasses, be aware that a Component must register its own xtype\nto participate in determination of inherited xtypes.</b></p>\n\n\n<p>For a list of all available xtypes, see the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header.</p>\n\n\n<p>Example usage:</p>\n\n\n<pre><code>var t = new <a href=\"#!/api/Ext.form.TextField\" rel=\"Ext.form.TextField\" class=\"docClass\">Ext.form.TextField</a>();\nvar isText = t.isXType('textfield');        // true\nvar isBoxSubclass = t.isXType('box');       // true, descended from BoxComponent\nvar isBoxInstance = t.isXType('box', true); // false, not a direct BoxComponent instance\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>xtype</span> : String/Ext.Component/Class<div class='sub-desc'><p>The xtype to check for this Component. Note that the the component can either be an instance\nor a component class:</p>\n\n<pre><code>var c = new <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>();\nconsole.log(c.isXType(c));\nconsole.log(c.isXType(<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>));\n</code></pre>\n\n</div></li><li><span class='pre'>shallow</span> : Boolean (optional)<div class='sub-desc'><p>False to check whether this Component is descended from the xtype (this is\nthe default), or true to check whether this Component is directly of the specified xtype.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if this component descends from the specified xtype, false otherwise.</p>\n</div></li></ul></div></div></div><div id='method-markInvalid' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-method-markInvalid' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-method-markInvalid' class='name expandable'>markInvalid</a>( <span class='pre'>[msg]</span> )</div><div class='description'><div class='short'>Display an error message associated with this field, using msgTarget to determine how to\ndisplay the message and appl...</div><div class='long'><p>Display an error message associated with this field, using <a href=\"#!/api/Ext.form.Field-cfg-msgTarget\" rel=\"Ext.form.Field-cfg-msgTarget\" class=\"docClass\">msgTarget</a> to determine how to\ndisplay the message and applying <a href=\"#!/api/Ext.form.Field-cfg-invalidClass\" rel=\"Ext.form.Field-cfg-invalidClass\" class=\"docClass\">invalidClass</a> to the field's UI element.</p>\n\n\n<p><b>Note</b>: this method does not cause the Field's <a href=\"#!/api/Ext.form.Field-method-validate\" rel=\"Ext.form.Field-method-validate\" class=\"docClass\">validate</a> method to return <code>false</code>\nif the value does <i>pass</i> validation. So simply marking a Field as invalid will not prevent\nsubmission of forms submitted with the <a href=\"#!/api/Ext.form.Action.Submit-cfg-clientValidation\" rel=\"Ext.form.Action.Submit-cfg-clientValidation\" class=\"docClass\">Ext.form.Action.Submit.clientValidation</a> option set.</p>\n\n\n<p><a href=\"#!/api/Ext.form.Field-method-isValid\" rel=\"Ext.form.Field-method-isValid\" class=\"docClass\">invalid</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>msg</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The validation message (defaults to <a href=\"#!/api/Ext.form.Field-cfg-invalidText\" rel=\"Ext.form.Field-cfg-invalidText\" class=\"docClass\">invalidText</a>)</p>\n</div></li></ul></div></div></div><div id='method-mimicBlur' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-method-mimicBlur' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-method-mimicBlur' class='name expandable'>mimicBlur</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-mon' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-mon' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-mon' class='name expandable'>mon</a>( <span class='pre'>item, ename, fn, scope, opt</span> )</div><div class='description'><div class='short'>Adds listeners to any Observable object (or Elements) which are automatically removed when this Component\nis destroyed. ...</div><div class='long'><p>Adds listeners to any Observable object (or Elements) which are automatically removed when this Component\nis destroyed. Usage:</p>\n\n\n<p><code></p>\n\n<pre>myGridPanel.mon(myGridPanel.getSelectionModel(), 'selectionchange', handleSelectionChange, null, {buffer: 50});\n</pre>\n\n\n<p></code></p>\n\n<p>or:</p>\n\n\n<p><code></p>\n\n<pre>myGridPanel.mon(myGridPanel.getSelectionModel(), {\n    selectionchange: handleSelectionChange,\n    buffer: 50\n});\n</pre>\n\n\n<p></code></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : Observable|Element<div class='sub-desc'><p>The item to which to add a listener/listeners.</p>\n</div></li><li><span class='pre'>ename</span> : Object|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The event name, or an object containing event name properties.</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>Optional. If the <code>ename</code> parameter was an event name, this\nis the handler function.</p>\n</div></li><li><span class='pre'>scope</span> : Object<div class='sub-desc'><p>Optional. If the <code>ename</code> parameter was an event name, this\nis the scope (<code>this</code> reference) in which the handler function is executed.</p>\n</div></li><li><span class='pre'>opt</span> : Object<div class='sub-desc'><p>Optional. If the <code>ename</code> parameter was an event name, this\nis the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> options.</p>\n</div></li></ul></div></div></div><div id='method-mun' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-mun' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-mun' class='name expandable'>mun</a>( <span class='pre'>item, ename, fn, scope</span> )</div><div class='description'><div class='short'>Removes listeners that were added by the mon method. ...</div><div class='long'><p>Removes listeners that were added by the <a href=\"#!/api/Ext.Component-method-mon\" rel=\"Ext.Component-method-mon\" class=\"docClass\">mon</a> method.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : Observable|Element<div class='sub-desc'><p>The item from which to remove a listener/listeners.</p>\n</div></li><li><span class='pre'>ename</span> : Object|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The event name, or an object containing event name properties.</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>Optional. If the <code>ename</code> parameter was an event name, this\nis the handler function.</p>\n</div></li><li><span class='pre'>scope</span> : Object<div class='sub-desc'><p>Optional. If the <code>ename</code> parameter was an event name, this\nis the scope (<code>this</code> reference) in which the handler function is executed.</p>\n</div></li></ul></div></div></div><div id='method-nextSibling' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-nextSibling' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-nextSibling' class='name expandable'>nextSibling</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Returns the next component in the owning container ...</div><div class='long'><p>Returns the next component in the owning container</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></p>\n</div></li></ul></div></div></div><div id='method-on' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-on' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-on' class='name expandable'>on</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object (shorthand for addListener.) ...</div><div class='long'><p>Appends an event handler to this object (shorthand for <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event to listen for</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.</p>\n</div></li></ul></div></div></div><div id='method-onAdded' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-onAdded' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-onAdded' class='name expandable'>onAdded</a>( <span class='pre'>container, pos</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Method to manage awareness of when components are added to their\nrespective Container, firing an added event. ...</div><div class='long'><p>Method to manage awareness of when components are added to their\nrespective Container, firing an added event.\nReferences are established at add time rather than at render time.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>container</span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><div class='sub-desc'><p>Container which holds the component</p>\n</div></li><li><span class='pre'>pos</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">number</a><div class='sub-desc'><p>Position at which the component was added</p>\n</div></li></ul></div></div></div><div id='method-onBlur' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-method-onBlur' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-method-onBlur' class='name expandable'>onBlur</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Overrides: <a href='#!/api/Ext.form.Field-method-onBlur' rel='Ext.form.Field-method-onBlur' class='docClass'>Ext.form.Field.onBlur</a></p></div></div></div><div id='method-onDestroy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.TwinTriggerField'>Ext.form.TwinTriggerField</span><br/><a href='source/TriggerField.html#Ext-form-TwinTriggerField-method-onDestroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TwinTriggerField-method-onDestroy' class='name expandable'>onDestroy</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Overrides: <a href='#!/api/Ext.form.TriggerField-method-onDestroy' rel='Ext.form.TriggerField-method-onDestroy' class='docClass'>Ext.form.TriggerField.onDestroy</a></p></div></div></div><div id='method-onDisable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-method-onDisable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-method-onDisable' class='name expandable'>onDisable</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-onEnable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-method-onEnable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-method-onEnable' class='name expandable'>onEnable</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-onFocus' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-method-onFocus' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-method-onFocus' class='name expandable'>onFocus</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Overrides: <a href='#!/api/Ext.form.Field-method-onFocus' rel='Ext.form.Field-method-onFocus' class='docClass'>Ext.form.Field.onFocus</a></p></div></div></div><div id='method-onKeyDown' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-method-onKeyDown' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-method-onKeyDown' class='name expandable'>onKeyDown</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onKeyPress' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-method-onKeyPress' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-method-onKeyPress' class='name expandable'>onKeyPress</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onKeyUp' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-method-onKeyUp' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-method-onKeyUp' class='name expandable'>onKeyUp</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onKeyUpBuffered' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-method-onKeyUpBuffered' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-method-onKeyUpBuffered' class='name expandable'>onKeyUpBuffered</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onMouseDown' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-method-onMouseDown' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-method-onMouseDown' class='name expandable'>onMouseDown</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onPosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-onPosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-onPosition' class='name expandable'>onPosition</a>( <span class='pre'>x, y</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>// protected\nCalled after the component is moved, this method is empty by default but can be implemented by any\nsubcl...</div><div class='long'><p>// protected\nCalled after the component is moved, this method is empty by default but can be implemented by any\nsubclass that needs to perform custom logic after a move occurs.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new x position</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new y position</p>\n</div></li></ul></div></div></div><div id='method-onRemoved' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-onRemoved' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-onRemoved' class='name expandable'>onRemoved</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Method to manage awareness of when components are removed from their\nrespective Container, firing an removed event. ...</div><div class='long'><p>Method to manage awareness of when components are removed from their\nrespective Container, firing an removed event. References are properly\ncleaned up after removing a component from its owning container.</p>\n</div></div></div><div id='method-onRender' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-method-onRender' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-method-onRender' class='name expandable'>onRender</a>( <span class='pre'>ct, position</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ct</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>position</span> : Object<div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.form.Field-method-onRender' rel='Ext.form.Field-method-onRender' class='docClass'>Ext.form.Field.onRender</a></p></div></div></div><div id='method-onResize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-method-onResize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-method-onResize' class='name expandable'>onResize</a>( <span class='pre'>w, h</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>w</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>h</span> : Object<div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.BoxComponent-method-onResize' rel='Ext.BoxComponent-method-onResize' class='docClass'>Ext.BoxComponent.onResize</a></p></div></div></div><div id='method-onTrigger1Click' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.TwinTriggerField'>Ext.form.TwinTriggerField</span><br/><a href='source/TriggerField.html#Ext-form-TwinTriggerField-method-onTrigger1Click' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TwinTriggerField-method-onTrigger1Click' class='name expandable'>onTrigger1Click</a>( <span class='pre'>e</span> )</div><div class='description'><div class='short'>The function that should handle the trigger's click event. ...</div><div class='long'><p>The function that should handle the trigger's click event.  This method does nothing by default\nuntil overridden by an implementing function. See <a href=\"#!/api/Ext.form.TriggerField-method-onTriggerClick\" rel=\"Ext.form.TriggerField-method-onTriggerClick\" class=\"docClass\">Ext.form.TriggerField.onTriggerClick</a>\nfor additional information.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : EventObject<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onTrigger2Click' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.form.TwinTriggerField'>Ext.form.TwinTriggerField</span><br/><a href='source/TriggerField.html#Ext-form-TwinTriggerField-method-onTrigger2Click' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TwinTriggerField-method-onTrigger2Click' class='name expandable'>onTrigger2Click</a>( <span class='pre'>e</span> )</div><div class='description'><div class='short'>The function that should handle the trigger's click event. ...</div><div class='long'><p>The function that should handle the trigger's click event.  This method does nothing by default\nuntil overridden by an implementing function. See <a href=\"#!/api/Ext.form.TriggerField-method-onTriggerClick\" rel=\"Ext.form.TriggerField-method-onTriggerClick\" class=\"docClass\">Ext.form.TriggerField.onTriggerClick</a>\nfor additional information.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : EventObject<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onTriggerClick' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-method-onTriggerClick' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-method-onTriggerClick' class='name expandable'>onTriggerClick</a>( <span class='pre'>e</span> )</div><div class='description'><div class='short'>The function that should handle the trigger's click event. ...</div><div class='long'><p>The function that should handle the trigger's click event.  This method does nothing by default\nuntil overridden by an implementing function.  See <a href=\"#!/api/Ext.form.ComboBox\" rel=\"Ext.form.ComboBox\" class=\"docClass\">Ext.form.ComboBox</a> and <a href=\"#!/api/Ext.form.DateField\" rel=\"Ext.form.DateField\" class=\"docClass\">Ext.form.DateField</a> for\nsample implementations.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : EventObject<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-postBlur' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-method-postBlur' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-method-postBlur' class='name expandable'>postBlur</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Overrides: <a href='#!/api/Ext.form.Field-method-postBlur' rel='Ext.form.Field-method-postBlur' class='docClass'>Ext.form.Field.postBlur</a></p></div></div></div><div id='method-preFocus' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-method-preFocus' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-method-preFocus' class='name expandable'>preFocus</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Overrides: <a href='#!/api/Ext.form.Field-method-preFocus' rel='Ext.form.Field-method-preFocus' class='docClass'>Ext.form.Field.preFocus</a></p></div></div></div><div id='method-previousSibling' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-previousSibling' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-previousSibling' class='name expandable'>previousSibling</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Returns the previous component in the owning container ...</div><div class='long'><p>Returns the previous component in the owning container</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></p>\n</div></li></ul></div></div></div><div id='method-processValue' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-method-processValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-method-processValue' class='name expandable'>processValue</a>( <span class='pre'>value</span> )</div><div class='description'><div class='short'>This method should only be overridden if necessary to prepare raw values\nfor validation (see validate and isValid). ...</div><div class='long'><p>This method should only be overridden if necessary to prepare raw values\nfor validation (see <a href=\"#!/api/Ext.form.TextField-method-validate\" rel=\"Ext.form.TextField-method-validate\" class=\"docClass\">validate</a> and <a href=\"#!/api/Ext.form.TextField-method-isValid\" rel=\"Ext.form.TextField-method-isValid\" class=\"docClass\">isValid</a>).  This method\nis expected to return the processed value for the field which will\nbe used for validation (see validateValue method).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : Mixed<div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.form.Field-method-processValue' rel='Ext.form.Field-method-processValue' class='docClass'>Ext.form.Field.processValue</a></p></div></div></div><div id='method-purgeListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-purgeListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-purgeListeners' class='name expandable'>purgeListeners</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all listeners for this object ...</div><div class='long'><p>Removes all listeners for this object</p>\n</div></div></div><div id='method-relayEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-relayEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-relayEvents' class='name expandable'>relayEvents</a>( <span class='pre'>o, events</span> )</div><div class='description'><div class='short'>Relays selected events from the specified Observable as if the events were fired by this. ...</div><div class='long'><p>Relays selected events from the specified Observable as if the events were fired by <tt><b>this</b></tt>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The Observable whose events this object is to relay.</p>\n</div></li><li><span class='pre'>events</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>Array of event names to relay.</p>\n</div></li></ul></div></div></div><div id='method-removeClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-removeClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-removeClass' class='name expandable'>removeClass</a>( <span class='pre'>cls</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Removes a CSS class from the component's underlying element. ...</div><div class='long'><p>Removes a CSS class from the component's underlying element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cls</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>The CSS class name to remove</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-removeListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-removeListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-removeListener' class='name expandable'>removeListener</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler. ...</div><div class='long'><p>Removes an event handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div><div id='method-render' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-render' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-render' class='name expandable'>render</a>( <span class='pre'>[container], [position]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Render this Component into the passed HTML element. ...</div><div class='long'><p>Render this Component into the passed HTML element.</p>\n\n\n<p><b>If you are using a <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Container</a> object to house this Component, then\ndo not use the render method.</b></p>\n\n\n<p>A Container's child Components are rendered by that Container's\n<a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a> manager when the Container is first rendered.</p>\n\n\n<p>Certain layout managers allow dynamic addition of child components. Those that do\ninclude <a href=\"#!/api/Ext.layout.CardLayout\" rel=\"Ext.layout.CardLayout\" class=\"docClass\">Ext.layout.CardLayout</a>, <a href=\"#!/api/Ext.layout.AnchorLayout\" rel=\"Ext.layout.AnchorLayout\" class=\"docClass\">Ext.layout.AnchorLayout</a>,\n<a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>, <a href=\"#!/api/Ext.layout.TableLayout\" rel=\"Ext.layout.TableLayout\" class=\"docClass\">Ext.layout.TableLayout</a>.</p>\n\n\n<p>If the Container is already rendered when a new child Component is added, you may need to call\nthe Container's <a href=\"#!/api/Ext.Container-method-doLayout\" rel=\"Ext.Container-method-doLayout\" class=\"docClass\">doLayout</a> to refresh the view which causes any\nunrendered child Components to be rendered. This is required so that you can add multiple\nchild components if needed while only refreshing the layout once.</p>\n\n\n<p>When creating complex UIs, it is important to remember that sizing and positioning\nof child items is the responsibility of the Container's <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a> manager.\nIf you expect child items to be sized in response to user interactions, you must\nconfigure the Container with a layout manager which creates and manages the type of layout you\nhave in mind.</p>\n\n\n<p><b>Omitting the Container's <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a> config means that a basic\nlayout manager is used which does nothing but render child components sequentially into the\nContainer. No sizing or positioning will be performed in this situation.</b></p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>container</span> : Element/HTMLElement/String (optional)<div class='sub-desc'><p>The element this Component should be\nrendered into. If it is being created from existing markup, this should be omitted.</p>\n</div></li><li><span class='pre'>position</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The element ID or DOM node index within the container <b>before</b>\nwhich this component will be inserted (defaults to appending to the end of the container)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-reset' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-method-reset' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-method-reset' class='name expandable'>reset</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Resets the current field value to the originally-loaded value and clears any validation messages. ...</div><div class='long'><p>Resets the current field value to the originally-loaded value and clears any validation messages.\nAlso adds <tt><b><a href=\"#!/api/Ext.form.TextField-cfg-emptyText\" rel=\"Ext.form.TextField-cfg-emptyText\" class=\"docClass\">emptyText</a></b></tt> and <tt><b><a href=\"#!/api/Ext.form.TextField-cfg-emptyClass\" rel=\"Ext.form.TextField-cfg-emptyClass\" class=\"docClass\">emptyClass</a></b></tt> if the\noriginal value was blank.</p>\n<p>Overrides: <a href='#!/api/Ext.form.Field-method-reset' rel='Ext.form.Field-method-reset' class='docClass'>Ext.form.Field.reset</a></p></div></div></div><div id='method-resumeEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-resumeEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-resumeEvents' class='name expandable'>resumeEvents</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Resume firing events. ...</div><div class='long'><p>Resume firing events. (see <a href=\"#!/api/Ext.util.Observable-method-suspendEvents\" rel=\"Ext.util.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a>)\nIf events were suspended using the <tt><b>queueSuspended</b></tt> parameter, then all\nevents fired during event suspension will be sent to any listeners now.</p>\n</div></div></div><div id='method-selectText' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-method-selectText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-method-selectText' class='name expandable'>selectText</a>( <span class='pre'>[start], [end]</span> )</div><div class='description'><div class='short'>Selects text in this field ...</div><div class='long'><p>Selects text in this field</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>start</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The index where the selection should start (defaults to 0)</p>\n</div></li><li><span class='pre'>end</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The index where the selection should end (defaults to the text length)</p>\n</div></li></ul></div></div></div><div id='method-setActiveError' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-method-setActiveError' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-method-setActiveError' class='name expandable'>setActiveError</a>( <span class='pre'>msg, suppressEvent</span> )</div><div class='description'><div class='short'>Sets the current activeError to the given string. ...</div><div class='long'><p>Sets the current activeError to the given string. Fires the 'invalid' event.\nThis does not set up the error icon, only sets the message and fires the event. To show the error icon,\nuse markInvalid instead, which calls this method internally</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>msg</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The error message</p>\n</div></li><li><span class='pre'>suppressEvent</span> : Boolean<div class='sub-desc'><p>True to suppress the 'invalid' event from being fired</p>\n</div></li></ul></div></div></div><div id='method-setAutoScroll' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-setAutoScroll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-setAutoScroll' class='name expandable'>setAutoScroll</a>( <span class='pre'>scroll</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the overflow on the content element of the component. ...</div><div class='long'><p>Sets the overflow on the content element of the component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>scroll</span> : Boolean<div class='sub-desc'><p>True to allow the Component to auto scroll.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setDisabled' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-setDisabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-setDisabled' class='name expandable'>setDisabled</a>( <span class='pre'>disabled</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Convenience function for setting disabled/enabled by boolean. ...</div><div class='long'><p>Convenience function for setting disabled/enabled by boolean.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>disabled</span> : Boolean<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setEditable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-method-setEditable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-method-setEditable' class='name expandable'>setEditable</a>( <span class='pre'>value</span> )</div><div class='description'><div class='short'>Allow or prevent the user from directly editing the field text. ...</div><div class='long'><p>Allow or prevent the user from directly editing the field text.  If false is passed,\nthe user will only be able to modify the field using the trigger.  Will also add\na click event to the text field which will call the trigger. This method\nis the runtime equivalent of setting the <a href=\"#!/api/Ext.form.TriggerField-cfg-editable\" rel=\"Ext.form.TriggerField-cfg-editable\" class=\"docClass\">editable</a> config option at config time.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : Boolean<div class='sub-desc'><p>True to allow the user to directly edit the field text.</p>\n</div></li></ul></div></div></div><div id='method-setHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-setHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-setHeight' class='name expandable'>setHeight</a>( <span class='pre'>height</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the height of the component. ...</div><div class='long'><p>Sets the height of the component.  This method fires the <a href=\"#!/api/Ext.BoxComponent-event-resize\" rel=\"Ext.BoxComponent-event-resize\" class=\"docClass\">resize</a> event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>height</span> : Mixed<div class='sub-desc'><p>The new height to set. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new height in the <a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">Element</a>'s <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS height style.</li>\n<li><i>undefined</i> to leave the height unchanged.</li>\n</ul></div></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setHideTrigger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-method-setHideTrigger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-method-setHideTrigger' class='name expandable'>setHideTrigger</a>( <span class='pre'>hideTrigger</span> )</div><div class='description'><div class='short'>Changes the hidden status of the trigger. ...</div><div class='long'><p>Changes the hidden status of the trigger.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>hideTrigger</span> : Boolean<div class='sub-desc'><p>True to hide the trigger, false to show it.</p>\n</div></li></ul></div></div></div><div id='method-setPagePosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-setPagePosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-setPagePosition' class='name expandable'>setPagePosition</a>( <span class='pre'>x, y</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the page XY position of the component. ...</div><div class='long'><p>Sets the page XY position of the component.  To set the left and top instead, use <a href=\"#!/api/Ext.BoxComponent-method-setPosition\" rel=\"Ext.BoxComponent-method-setPosition\" class=\"docClass\">setPosition</a>.\nThis method fires the <a href=\"#!/api/Ext.BoxComponent-event-move\" rel=\"Ext.BoxComponent-event-move\" class=\"docClass\">move</a> event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new x position</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new y position</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setPosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-setPosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-setPosition' class='name expandable'>setPosition</a>( <span class='pre'>left, top</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the left and top of the component. ...</div><div class='long'><p>Sets the left and top of the component.  To set the page XY position instead, use <a href=\"#!/api/Ext.BoxComponent-method-setPagePosition\" rel=\"Ext.BoxComponent-method-setPagePosition\" class=\"docClass\">setPagePosition</a>.\nThis method fires the <a href=\"#!/api/Ext.BoxComponent-event-move\" rel=\"Ext.BoxComponent-event-move\" class=\"docClass\">move</a> event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>left</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new left</p>\n</div></li><li><span class='pre'>top</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new top</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setRawValue' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-method-setRawValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-method-setRawValue' class='name expandable'>setRawValue</a>( <span class='pre'>value</span> ) : Mixed</div><div class='description'><div class='short'>Sets the underlying DOM field's value directly, bypassing validation. ...</div><div class='long'><p>Sets the underlying DOM field's value directly, bypassing validation.  To set the value with validation see <a href=\"#!/api/Ext.form.Field-method-setValue\" rel=\"Ext.form.Field-method-setValue\" class=\"docClass\">setValue</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : Mixed<div class='sub-desc'><p>The value to set</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Mixed</span><div class='sub-desc'><p>value The field value that is set</p>\n</div></li></ul></div></div></div><div id='method-setReadOnly' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-method-setReadOnly' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-method-setReadOnly' class='name expandable'>setReadOnly</a>( <span class='pre'>value</span> )</div><div class='description'><div class='short'>Setting this to true will supersede settings editable and hideTrigger. ...</div><div class='long'><p>Setting this to true will supersede settings <a href=\"#!/api/Ext.form.TriggerField-cfg-editable\" rel=\"Ext.form.TriggerField-cfg-editable\" class=\"docClass\">editable</a> and <a href=\"#!/api/Ext.form.TriggerField-cfg-hideTrigger\" rel=\"Ext.form.TriggerField-cfg-hideTrigger\" class=\"docClass\">hideTrigger</a>.\nSetting this to false will defer back to <a href=\"#!/api/Ext.form.TriggerField-cfg-editable\" rel=\"Ext.form.TriggerField-cfg-editable\" class=\"docClass\">editable</a> and <a href=\"#!/api/Ext.form.TriggerField-cfg-hideTrigger\" rel=\"Ext.form.TriggerField-cfg-hideTrigger\" class=\"docClass\">hideTrigger</a>. This method\nis the runtime equivalent of setting the <a href=\"#!/api/Ext.form.TriggerField-cfg-readOnly\" rel=\"Ext.form.TriggerField-cfg-readOnly\" class=\"docClass\">readOnly</a> config option at config time.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : Boolean<div class='sub-desc'><p>True to prevent the user changing the field and explicitly\nhide the trigger.</p>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.form.Field-method-setReadOnly' rel='Ext.form.Field-method-setReadOnly' class='docClass'>Ext.form.Field.setReadOnly</a></p></div></div></div><div id='method-setSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-setSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-setSize' class='name expandable'>setSize</a>( <span class='pre'>width, height</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the width and height of this BoxComponent. ...</div><div class='long'><p>Sets the width and height of this BoxComponent. This method fires the <a href=\"#!/api/Ext.BoxComponent-event-resize\" rel=\"Ext.BoxComponent-event-resize\" class=\"docClass\">resize</a> event. This method can accept\neither width and height as separate arguments, or you can pass a size object like <code>{width:10, height:20}</code>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>width</span> : Mixed<div class='sub-desc'><p>The new width to set. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new width in the <a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">Element</a>'s <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">Ext.Element.defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS width style.</li>\n<li>A size object in the format <code>{width: widthValue, height: heightValue}</code>.</li>\n<li><code>undefined</code> to leave the width unchanged.</li>\n</ul></div></p>\n</div></li><li><span class='pre'>height</span> : Mixed<div class='sub-desc'><p>The new height to set (not required if a size object is passed as the first arg).\nThis may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new height in the <a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">Element</a>'s <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">Ext.Element.defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS height style. Animation may <b>not</b> be used.</li>\n<li><code>undefined</code> to leave the height unchanged.</li>\n</ul></div></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setValue' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-method-setValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-method-setValue' class='name expandable'>setValue</a>( <span class='pre'>value</span> ) : <a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets a data value into the field and validates it. ...</div><div class='long'><p>Sets a data value into the field and validates it.  To set the value directly without validation see <a href=\"#!/api/Ext.form.TextField-method-setRawValue\" rel=\"Ext.form.TextField-method-setRawValue\" class=\"docClass\">setRawValue</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : Mixed<div class='sub-desc'><p>The value to set</p>\n\n\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a></span><div class='sub-desc'><p>this</p>\n\n\n\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.form.Field-method-setValue' rel='Ext.form.Field-method-setValue' class='docClass'>Ext.form.Field.setValue</a></p></div></div></div><div id='method-setVisible' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-setVisible' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-setVisible' class='name expandable'>setVisible</a>( <span class='pre'>visible</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Convenience function to hide or show this component by boolean. ...</div><div class='long'><p>Convenience function to hide or show this component by boolean.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>visible</span> : Boolean<div class='sub-desc'><p>True to show, false to hide</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-setWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-setWidth' class='name expandable'>setWidth</a>( <span class='pre'>width</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the width of the component. ...</div><div class='long'><p>Sets the width of the component.  This method fires the <a href=\"#!/api/Ext.BoxComponent-event-resize\" rel=\"Ext.BoxComponent-event-resize\" class=\"docClass\">resize</a> event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>width</span> : Mixed<div class='sub-desc'><p>The new width to set. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new width in the <a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">Element</a>'s <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS width style.</li>\n</ul></div></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-show' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-show' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-show' class='name expandable'>show</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Show this component. ...</div><div class='long'><p>Show this component.  Listen to the '<a href=\"#!/api/Ext.Component-event-beforeshow\" rel=\"Ext.Component-event-beforeshow\" class=\"docClass\">beforeshow</a>' event and return\n<tt>false</tt> to cancel showing the component.  Fires the '<a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a>'\nevent after showing the component.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-suspendEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-suspendEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-suspendEvents' class='name expandable'>suspendEvents</a>( <span class='pre'>queueSuspended</span> )</div><div class='description'><div class='short'>Suspend the firing of all events. ...</div><div class='long'><p>Suspend the firing of all events. (see <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a>)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>queueSuspended</span> : Boolean<div class='sub-desc'><p>Pass as true to queue up suspended events to be fired\nafter the <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a> call instead of discarding all suspended events;</p>\n</div></li></ul></div></div></div><div id='method-syncSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-syncSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-syncSize' class='name expandable'>syncSize</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Force the component's size to recalculate based on the underlying element's current height and width. ...</div><div class='long'><p>Force the component's size to recalculate based on the underlying element's current height and width.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-triggerBlur' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-method-triggerBlur' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-method-triggerBlur' class='name expandable'>triggerBlur</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-un' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-un' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-un' class='name expandable'>un</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler (shorthand for removeListener.) ...</div><div class='long'><p>Removes an event handler (shorthand for <a href=\"#!/api/Ext.util.Observable-method-removeListener\" rel=\"Ext.util.Observable-method-removeListener\" class=\"docClass\">removeListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div><div id='method-unsetActiveError' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-method-unsetActiveError' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-method-unsetActiveError' class='name expandable'>unsetActiveError</a>( <span class='pre'>suppressEvent</span> )</div><div class='description'><div class='short'>Clears the activeError and fires the 'valid' event. ...</div><div class='long'><p>Clears the activeError and fires the 'valid' event. This is called internally by clearInvalid and would not\nusually need to be called manually</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>suppressEvent</span> : Boolean<div class='sub-desc'><p>True to suppress the 'invalid' event from being fired</p>\n</div></li></ul></div></div></div><div id='method-update' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-update' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-update' class='name expandable'>update</a>( <span class='pre'>htmlOrData, loadScripts, callback</span> )</div><div class='description'><div class='short'>Update the content area of a component. ...</div><div class='long'><p>Update the content area of a component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>htmlOrData</span> : Mixed<div class='sub-desc'><p>If this component has been configured with a template via the tpl config\nthen it will use this argument as data to populate the template.\nIf this component was not configured with a template, the components\ncontent area will be updated via <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> update</p>\n</div></li><li><span class='pre'>loadScripts</span> : Boolean<div class='sub-desc'><p>(optional) Only legitimate when using the html configuration. Defaults to false</p>\n</div></li><li><span class='pre'>callback</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>(optional) Only legitimate when using the html configuration. Callback to execute when scripts have finished loading</p>\n</div></li></ul></div></div></div><div id='method-updateBox' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-updateBox' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-updateBox' class='name expandable'>updateBox</a>( <span class='pre'>box</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the current box measurements of the component's underlying element. ...</div><div class='long'><p>Sets the current box measurements of the component's underlying element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>box</span> : Object<div class='sub-desc'><p>An object in the format {x, y, width, height}</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-updateEditState' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-method-updateEditState' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-method-updateEditState' class='name expandable'>updateEditState</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-validate' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-method-validate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-method-validate' class='name expandable'>validate</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Validates the field value ...</div><div class='long'><p>Validates the field value</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the value is valid, else false</p>\n</div></li></ul></div></div></div><div id='method-validateBlur' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TriggerField' rel='Ext.form.TriggerField' class='defined-in docClass'>Ext.form.TriggerField</a><br/><a href='source/TriggerField.html#Ext-form-TriggerField-method-validateBlur' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TriggerField-method-validateBlur' class='name expandable'>validateBlur</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private\nThis should be overriden by any subclass that needs to check whether or not the field can be blurred. ...</div><div class='long'><p>private\nThis should be overriden by any subclass that needs to check whether or not the field can be blurred.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-validateValue' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-method-validateValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-method-validateValue' class='name expandable'>validateValue</a>( <span class='pre'>The</span> ) : Boolean</div><div class='description'><div class='short'>Uses getErrors to build an array of validation errors. ...</div><div class='long'><p>Uses getErrors to build an array of validation errors. If any errors are found, markInvalid is called\nwith the first and false is returned, otherwise true is returned. Previously, subclasses were invited\nto provide an implementation of this to process validations - from 3.2 onwards getErrors should be\noverridden instead.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>The</span> : Mixed<div class='sub-desc'><p>current value of the field</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if all validations passed, false if one or more failed</p>\n</div></li></ul></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-event'>Events</h3><div class='subsection'><div id='event-added' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-added' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-added' class='name expandable'>added</a>( <span class='pre'>this, ownerCt, index</span> )</div><div class='description'><div class='short'>Fires when a component is added to an Ext.Container ...</div><div class='long'><p>Fires when a component is added to an <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>ownerCt</span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><div class='sub-desc'><p>Container which holds the component</p>\n</div></li><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">number</a><div class='sub-desc'><p>Position at which the component was added</p>\n</div></li></ul></div></div></div><div id='event-afterrender' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-afterrender' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-afterrender' class='name expandable'>afterrender</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component rendering is finished. ...</div><div class='long'><p>Fires after the component rendering is finished.</p>\n\n\n<p>The afterrender event is fired after this Component has been <a href=\"#!/api/Ext.Component-property-rendered\" rel=\"Ext.Component-property-rendered\" class=\"docClass\">rendered</a>, been postprocesed\nby any afterRender method defined for the Component, and, if <a href=\"#!/api/Ext.Component-cfg-stateful\" rel=\"Ext.Component-cfg-stateful\" class=\"docClass\">stateful</a>, after state\nhas been restored.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-autosize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-event-autosize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-event-autosize' class='name expandable'>autosize</a>( <span class='pre'>this, width</span> )</div><div class='description'><div class='short'>Fires when the autoSize function is triggered. ...</div><div class='long'><p>Fires when the <tt><b><a href=\"#!/api/Ext.form.TextField-method-autoSize\" rel=\"Ext.form.TextField-method-autoSize\" class=\"docClass\">autoSize</a></b></tt> function is triggered. The field may or\nmay not have actually changed size according to the default logic, but this event provides\na hook for the developer to apply additional logic at runtime to resize the field if needed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a><div class='sub-desc'><p>This text field</p>\n</div></li><li><span class='pre'>width</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new field width</p>\n</div></li></ul></div></div></div><div id='event-beforedestroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforedestroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforedestroy' class='name expandable'>beforedestroy</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires before the component is destroyed. ...</div><div class='long'><p>Fires before the component is <a href=\"#!/api/Ext.Component-event-destroy\" rel=\"Ext.Component-event-destroy\" class=\"docClass\">destroy</a>ed. Return false from an event handler to stop the <a href=\"#!/api/Ext.Component-event-destroy\" rel=\"Ext.Component-event-destroy\" class=\"docClass\">destroy</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-beforehide' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforehide' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforehide' class='name expandable'>beforehide</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires before the component is hidden by calling the hide method. ...</div><div class='long'><p>Fires before the component is hidden by calling the <a href=\"#!/api/Ext.Component-method-hide\" rel=\"Ext.Component-method-hide\" class=\"docClass\">hide</a> method.\nReturn false from an event handler to stop the hide.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-beforerender' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforerender' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforerender' class='name expandable'>beforerender</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires before the component is rendered. ...</div><div class='long'><p>Fires before the component is <a href=\"#!/api/Ext.Component-property-rendered\" rel=\"Ext.Component-property-rendered\" class=\"docClass\">rendered</a>. Return false from an\nevent handler to stop the <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">render</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-beforeshow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforeshow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforeshow' class='name expandable'>beforeshow</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires before the component is shown by calling the show method. ...</div><div class='long'><p>Fires before the component is shown by calling the <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> method.\nReturn false from an event handler to stop the show.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-beforestaterestore' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforestaterestore' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforestaterestore' class='name expandable'>beforestaterestore</a>( <span class='pre'>this, state</span> )</div><div class='description'><div class='short'>Fires before the state of the component is restored. ...</div><div class='long'><p>Fires before the state of the component is restored. Return false from an event handler to stop the restore.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>state</span> : Object<div class='sub-desc'><p>The hash of state values returned from the StateProvider. If this\nevent is not vetoed, then the state object is passed to <b><tt>applyState</tt></b>. By default,\nthat simply copies property values into this Component. The method maybe overriden to\nprovide custom state restoration.</p>\n</div></li></ul></div></div></div><div id='event-beforestatesave' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforestatesave' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforestatesave' class='name expandable'>beforestatesave</a>( <span class='pre'>this, state</span> )</div><div class='description'><div class='short'>Fires before the state of the component is saved to the configured state provider. ...</div><div class='long'><p>Fires before the state of the component is saved to the configured state provider. Return false to stop the save.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>state</span> : Object<div class='sub-desc'><p>The hash of state values. This is determined by calling\n<b><tt>getState()</tt></b> on the Component. This method must be provided by the\ndeveloper to return whetever representation of state is required, by default, <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>\nhas a null implementation.</p>\n</div></li></ul></div></div></div><div id='event-blur' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-event-blur' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-event-blur' class='name expandable'>blur</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires when this field loses input focus. ...</div><div class='long'><p>Fires when this field loses input focus.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-change' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-event-change' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-event-change' class='name expandable'>change</a>( <span class='pre'>this, newValue, oldValue</span> )</div><div class='description'><div class='short'>Fires just before the field blurs if the field value has changed. ...</div><div class='long'><p>Fires just before the field blurs if the field value has changed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a><div class='sub-desc'>\n</div></li><li><span class='pre'>newValue</span> : Mixed<div class='sub-desc'><p>The new value</p>\n</div></li><li><span class='pre'>oldValue</span> : Mixed<div class='sub-desc'><p>The original value</p>\n</div></li></ul></div></div></div><div id='event-destroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-destroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-destroy' class='name expandable'>destroy</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component is destroyed. ...</div><div class='long'><p>Fires after the component is <a href=\"#!/api/Ext.Component-event-destroy\" rel=\"Ext.Component-event-destroy\" class=\"docClass\">destroy</a>ed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-disable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-disable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-disable' class='name expandable'>disable</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component is disabled. ...</div><div class='long'><p>Fires after the component is disabled.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-enable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-enable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-enable' class='name expandable'>enable</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component is enabled. ...</div><div class='long'><p>Fires after the component is enabled.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-focus' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-event-focus' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-event-focus' class='name expandable'>focus</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires when this field receives input focus. ...</div><div class='long'><p>Fires when this field receives input focus.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-hide' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-hide' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-hide' class='name expandable'>hide</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component is hidden. ...</div><div class='long'><p>Fires after the component is hidden.\nFires after the component is hidden when calling the <a href=\"#!/api/Ext.Component-method-hide\" rel=\"Ext.Component-method-hide\" class=\"docClass\">hide</a> method.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-invalid' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-event-invalid' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-event-invalid' class='name expandable'>invalid</a>( <span class='pre'>this, msg</span> )</div><div class='description'><div class='short'>Fires after the field has been marked as invalid. ...</div><div class='long'><p>Fires after the field has been marked as invalid.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a><div class='sub-desc'>\n</div></li><li><span class='pre'>msg</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The validation message</p>\n</div></li></ul></div></div></div><div id='event-keydown' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-event-keydown' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-event-keydown' class='name expandable'>keydown</a>( <span class='pre'>this, e</span> )</div><div class='description'><div class='short'>Keydown input field event. ...</div><div class='long'><p>Keydown input field event. This event only fires if <tt><b><a href=\"#!/api/Ext.form.TextField-cfg-enableKeyEvents\" rel=\"Ext.form.TextField-cfg-enableKeyEvents\" class=\"docClass\">enableKeyEvents</a></b></tt>\nis set to true.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.form.TextField\" rel=\"Ext.form.TextField\" class=\"docClass\">Ext.form.TextField</a><div class='sub-desc'><p>This text field</p>\n</div></li><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-keypress' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-event-keypress' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-event-keypress' class='name expandable'>keypress</a>( <span class='pre'>this, e</span> )</div><div class='description'><div class='short'>Keypress input field event. ...</div><div class='long'><p>Keypress input field event. This event only fires if <tt><b><a href=\"#!/api/Ext.form.TextField-cfg-enableKeyEvents\" rel=\"Ext.form.TextField-cfg-enableKeyEvents\" class=\"docClass\">enableKeyEvents</a></b></tt>\nis set to true.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.form.TextField\" rel=\"Ext.form.TextField\" class=\"docClass\">Ext.form.TextField</a><div class='sub-desc'><p>This text field</p>\n</div></li><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-keyup' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.TextField' rel='Ext.form.TextField' class='defined-in docClass'>Ext.form.TextField</a><br/><a href='source/TextField.html#Ext-form-TextField-event-keyup' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.TextField-event-keyup' class='name expandable'>keyup</a>( <span class='pre'>this, e</span> )</div><div class='description'><div class='short'>Keyup input field event. ...</div><div class='long'><p>Keyup input field event. This event only fires if <tt><b><a href=\"#!/api/Ext.form.TextField-cfg-enableKeyEvents\" rel=\"Ext.form.TextField-cfg-enableKeyEvents\" class=\"docClass\">enableKeyEvents</a></b></tt>\nis set to true.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.form.TextField\" rel=\"Ext.form.TextField\" class=\"docClass\">Ext.form.TextField</a><div class='sub-desc'><p>This text field</p>\n</div></li><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-move' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-event-move' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-event-move' class='name expandable'>move</a>( <span class='pre'>this, x, y</span> )</div><div class='description'><div class='short'>Fires after the component is moved. ...</div><div class='long'><p>Fires after the component is moved.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new x position</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new y position</p>\n</div></li></ul></div></div></div><div id='event-removed' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-removed' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-removed' class='name expandable'>removed</a>( <span class='pre'>this, ownerCt</span> )</div><div class='description'><div class='short'>Fires when a component is removed from an Ext.Container ...</div><div class='long'><p>Fires when a component is removed from an <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>ownerCt</span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><div class='sub-desc'><p>Container which holds the component</p>\n</div></li></ul></div></div></div><div id='event-render' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-render' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-render' class='name expandable'>render</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component markup is rendered. ...</div><div class='long'><p>Fires after the component markup is <a href=\"#!/api/Ext.Component-property-rendered\" rel=\"Ext.Component-property-rendered\" class=\"docClass\">rendered</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-resize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-event-resize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-event-resize' class='name expandable'>resize</a>( <span class='pre'>this, adjWidth, adjHeight, rawWidth, rawHeight</span> )</div><div class='description'><div class='short'>Fires after the component is resized. ...</div><div class='long'><p>Fires after the component is resized.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>adjWidth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The box-adjusted width that was set</p>\n</div></li><li><span class='pre'>adjHeight</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The box-adjusted height that was set</p>\n</div></li><li><span class='pre'>rawWidth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The width that was originally specified</p>\n</div></li><li><span class='pre'>rawHeight</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The height that was originally specified</p>\n</div></li></ul></div></div></div><div id='event-show' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-show' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-show' class='name expandable'>show</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component is shown when calling the show method. ...</div><div class='long'><p>Fires after the component is shown when calling the <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> method.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-specialkey' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-event-specialkey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-event-specialkey' class='name expandable'>specialkey</a>( <span class='pre'>this, e</span> )</div><div class='description'><div class='short'>Fires when any key related to navigation (arrows, tab, enter, esc, etc.) is pressed. ...</div><div class='long'><p>Fires when any key related to navigation (arrows, tab, enter, esc, etc.) is pressed.\nTo handle other keys see <a href=\"#!/api/Ext.Panel-cfg-keys\" rel=\"Ext.Panel-cfg-keys\" class=\"docClass\">Ext.Panel.keys</a> or <a href=\"#!/api/Ext.KeyMap\" rel=\"Ext.KeyMap\" class=\"docClass\">Ext.KeyMap</a>.\nYou can check <a href=\"#!/api/Ext.EventObject-method-getKey\" rel=\"Ext.EventObject-method-getKey\" class=\"docClass\">Ext.EventObject.getKey</a> to determine which key was pressed.\nFor example:</p>\n\n<pre><code>var form = new <a href=\"#!/api/Ext.form.FormPanel\" rel=\"Ext.form.FormPanel\" class=\"docClass\">Ext.form.FormPanel</a>({\n    ...\n    items: [{\n            fieldLabel: 'Field 1',\n            name: 'field1',\n            allowBlank: false\n        },{\n            fieldLabel: 'Field 2',\n            name: 'field2',\n            listeners: {\n                specialkey: function(field, e){\n                    // e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN,\n                    // e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN\n                    if (e.<a href=\"#!/api/Ext.EventObject-method-getKey\" rel=\"Ext.EventObject-method-getKey\" class=\"docClass\">getKey()</a> == e.ENTER) {\n                        var form = field.ownerCt.getForm();\n                        form.submit();\n                    }\n                }\n            }\n        }\n    ],\n    ...\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a><div class='sub-desc'>\n</div></li><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The event object</p>\n</div></li></ul></div></div></div><div id='event-staterestore' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-staterestore' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-staterestore' class='name expandable'>staterestore</a>( <span class='pre'>this, state</span> )</div><div class='description'><div class='short'>Fires after the state of the component is restored. ...</div><div class='long'><p>Fires after the state of the component is restored.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>state</span> : Object<div class='sub-desc'><p>The hash of state values returned from the StateProvider. This is passed\nto <b><tt>applyState</tt></b>. By default, that simply copies property values into this\nComponent. The method maybe overriden to provide custom state restoration.</p>\n</div></li></ul></div></div></div><div id='event-statesave' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-statesave' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-statesave' class='name expandable'>statesave</a>( <span class='pre'>this, state</span> )</div><div class='description'><div class='short'>Fires after the state of the component is saved to the configured state provider. ...</div><div class='long'><p>Fires after the state of the component is saved to the configured state provider.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>state</span> : Object<div class='sub-desc'><p>The hash of state values. This is determined by calling\n<b><tt>getState()</tt></b> on the Component. This method must be provided by the\ndeveloper to return whetever representation of state is required, by default, <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>\nhas a null implementation.</p>\n</div></li></ul></div></div></div><div id='event-valid' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Field' rel='Ext.form.Field' class='defined-in docClass'>Ext.form.Field</a><br/><a href='source/Field.html#Ext-form-Field-event-valid' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.form.Field-event-valid' class='name expandable'>valid</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the field has been validated with no errors. ...</div><div class='long'><p>Fires after the field has been validated with no errors.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a><div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","superclasses":["Ext.util.Observable","Ext.Component","Ext.BoxComponent","Ext.form.Field","Ext.form.TextField","Ext.form.TriggerField"],"meta":{},"requires":[],"html_meta":{},"statics":{"property":[],"cfg":[],"css_var":[],"method":[],"event":[],"css_mixin":[]},"files":[{"href":"TriggerField.html#Ext-form-TwinTriggerField","filename":"TriggerField.js"}],"linenr":281,"members":{"property":[{"tagname":"property","owner":"Ext.form.TriggerField","meta":{"private":true},"name":"actionMode","id":"property-actionMode"},{"tagname":"property","owner":"Ext.BoxComponent","meta":{"private":true},"name":"boxReady","id":"property-boxReady"},{"tagname":"property","owner":"Ext.form.TriggerField","meta":{"private":true},"name":"defaultTriggerWidth","id":"property-defaultTriggerWidth"},{"tagname":"property","owner":"Ext.form.TriggerField","meta":{"private":true},"name":"deferHeight","id":"property-deferHeight"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"disabled","id":"property-disabled"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"el","id":"property-el"},{"tagname":"property","owner":"Ext.form.Field","meta":{"private":true},"name":"hasFocus","id":"property-hasFocus"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"hidden","id":"property-hidden"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"initialConfig","id":"property-initialConfig"},{"tagname":"property","owner":"Ext.form.Field","meta":{"private":true},"name":"isFormField","id":"property-isFormField"},{"tagname":"property","owner":"Ext.form.Field","meta":{},"name":"label","id":"property-label"},{"tagname":"property","owner":"Ext.form.TriggerField","meta":{"private":true},"name":"mimicing","id":"property-mimicing"},{"tagname":"property","owner":"Ext.form.TriggerField","meta":{"private":true},"name":"monitorTab","id":"property-monitorTab"},{"tagname":"property","owner":"Ext.form.Field","meta":{"private":true},"name":"msgDisplay","id":"property-msgDisplay"},{"tagname":"property","owner":"Ext.form.Field","meta":{},"name":"originalValue","id":"property-originalValue"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"ownerCt","id":"property-ownerCt"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"refOwner","id":"property-refOwner"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"rendered","id":"property-rendered"},{"tagname":"property","owner":"Ext.form.Field","meta":{},"name":"startValue","id":"property-startValue"}],"cfg":[{"tagname":"cfg","owner":"Ext.form.TextField","meta":{},"name":"allowBlank","id":"cfg-allowBlank"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"allowDomMove","id":"cfg-allowDomMove"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"anchor","id":"cfg-anchor"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"applyTo","id":"cfg-applyTo"},{"tagname":"cfg","owner":"Ext.form.TriggerField","meta":{},"name":"autoCreate","id":"cfg-autoCreate"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"autoScroll","id":"cfg-autoScroll"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"autoShow","id":"cfg-autoShow"},{"tagname":"cfg","owner":"Ext.form.TextField","meta":{},"name":"blankText","id":"cfg-blankText"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"boxMaxHeight","id":"cfg-boxMaxHeight"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"boxMaxWidth","id":"cfg-boxMaxWidth"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"boxMinHeight","id":"cfg-boxMinHeight"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"boxMinWidth","id":"cfg-boxMinWidth"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"bubbleEvents","id":"cfg-bubbleEvents"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"clearCls","id":"cfg-clearCls"},{"tagname":"cfg","owner":"Ext.form.Field","meta":{},"name":"cls","id":"cfg-cls"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"contentEl","id":"cfg-contentEl"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"ctCls","id":"cfg-ctCls"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"data","id":"cfg-data"},{"tagname":"cfg","owner":"Ext.form.TextField","meta":{},"name":"disableKeyFilter","id":"cfg-disableKeyFilter"},{"tagname":"cfg","owner":"Ext.form.Field","meta":{},"name":"disabled","id":"cfg-disabled"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"disabledClass","id":"cfg-disabledClass"},{"tagname":"cfg","owner":"Ext.form.TriggerField","meta":{},"name":"editable","id":"cfg-editable"},{"tagname":"cfg","owner":"Ext.form.TextField","meta":{},"name":"emptyClass","id":"cfg-emptyClass"},{"tagname":"cfg","owner":"Ext.form.TextField","meta":{},"name":"emptyText","id":"cfg-emptyText"},{"tagname":"cfg","owner":"Ext.form.TextField","meta":{},"name":"enableKeyEvents","id":"cfg-enableKeyEvents"},{"tagname":"cfg","owner":"Ext.form.Field","meta":{},"name":"fieldClass","id":"cfg-fieldClass"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"fieldLabel","id":"cfg-fieldLabel"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"flex","id":"cfg-flex"},{"tagname":"cfg","owner":"Ext.form.Field","meta":{},"name":"focusClass","id":"cfg-focusClass"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"height","id":"cfg-height"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"hidden","id":"cfg-hidden"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"hideLabel","id":"cfg-hideLabel"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"hideMode","id":"cfg-hideMode"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"hideParent","id":"cfg-hideParent"},{"tagname":"cfg","owner":"Ext.form.TriggerField","meta":{},"name":"hideTrigger","id":"cfg-hideTrigger"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"html","id":"cfg-html"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"id","id":"cfg-id"},{"tagname":"cfg","owner":"Ext.form.Field","meta":{},"name":"inputType","id":"cfg-inputType"},{"tagname":"cfg","owner":"Ext.form.Field","meta":{},"name":"invalidClass","id":"cfg-invalidClass"},{"tagname":"cfg","owner":"Ext.form.Field","meta":{},"name":"invalidText","id":"cfg-invalidText"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"itemCls","id":"cfg-itemCls"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"itemId","id":"cfg-itemId"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"labelSeparator","id":"cfg-labelSeparator"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"labelStyle","id":"cfg-labelStyle"},{"tagname":"cfg","owner":"Ext.util.Observable","meta":{},"name":"listeners","id":"cfg-listeners"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"margins","id":"cfg-margins"},{"tagname":"cfg","owner":"Ext.form.TextField","meta":{},"name":"maskRe","id":"cfg-maskRe"},{"tagname":"cfg","owner":"Ext.form.TextField","meta":{},"name":"maxLength","id":"cfg-maxLength"},{"tagname":"cfg","owner":"Ext.form.TextField","meta":{},"name":"maxLengthText","id":"cfg-maxLengthText"},{"tagname":"cfg","owner":"Ext.form.TextField","meta":{},"name":"minLength","id":"cfg-minLength"},{"tagname":"cfg","owner":"Ext.form.TextField","meta":{},"name":"minLengthText","id":"cfg-minLengthText"},{"tagname":"cfg","owner":"Ext.form.Field","meta":{},"name":"msgFx","id":"cfg-msgFx"},{"tagname":"cfg","owner":"Ext.form.Field","meta":{},"name":"msgTarget","id":"cfg-msgTarget"},{"tagname":"cfg","owner":"Ext.form.Field","meta":{},"name":"name","id":"cfg-name"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"overCls","id":"cfg-overCls"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"pageX","id":"cfg-pageX"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"pageY","id":"cfg-pageY"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"plugins","id":"cfg-plugins"},{"tagname":"cfg","owner":"Ext.form.Field","meta":{},"name":"preventMark","id":"cfg-preventMark"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"ptype","id":"cfg-ptype"},{"tagname":"cfg","owner":"Ext.form.TriggerField","meta":{},"name":"readOnly","id":"cfg-readOnly"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"ref","id":"cfg-ref"},{"tagname":"cfg","owner":"Ext.form.TextField","meta":{},"name":"regex","id":"cfg-regex"},{"tagname":"cfg","owner":"Ext.form.TextField","meta":{},"name":"regexText","id":"cfg-regexText"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"region","id":"cfg-region"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"renderTo","id":"cfg-renderTo"},{"tagname":"cfg","owner":"Ext.form.TextField","meta":{},"name":"selectOnFocus","id":"cfg-selectOnFocus"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"stateEvents","id":"cfg-stateEvents"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"stateId","id":"cfg-stateId"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"stateful","id":"cfg-stateful"},{"tagname":"cfg","owner":"Ext.form.TextField","meta":{},"name":"stripCharsRe","id":"cfg-stripCharsRe"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"style","id":"cfg-style"},{"tagname":"cfg","owner":"Ext.form.Field","meta":{},"name":"submitValue","id":"cfg-submitValue"},{"tagname":"cfg","owner":"Ext.form.Field","meta":{},"name":"tabIndex","id":"cfg-tabIndex"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"tabTip","id":"cfg-tabTip"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"tpl","id":"cfg-tpl"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"tplWriteMode","id":"cfg-tplWriteMode"},{"tagname":"cfg","owner":"Ext.form.TwinTriggerField","meta":{},"name":"trigger1Class","id":"cfg-trigger1Class"},{"tagname":"cfg","owner":"Ext.form.TwinTriggerField","meta":{},"name":"trigger2Class","id":"cfg-trigger2Class"},{"tagname":"cfg","owner":"Ext.form.TriggerField","meta":{},"name":"triggerClass","id":"cfg-triggerClass"},{"tagname":"cfg","owner":"Ext.form.TwinTriggerField","meta":{},"name":"triggerConfig","id":"cfg-triggerConfig"},{"tagname":"cfg","owner":"Ext.form.Field","meta":{},"name":"validateOnBlur","id":"cfg-validateOnBlur"},{"tagname":"cfg","owner":"Ext.form.Field","meta":{},"name":"validationDelay","id":"cfg-validationDelay"},{"tagname":"cfg","owner":"Ext.form.Field","meta":{},"name":"validationEvent","id":"cfg-validationEvent"},{"tagname":"cfg","owner":"Ext.form.TextField","meta":{},"name":"validator","id":"cfg-validator"},{"tagname":"cfg","owner":"Ext.form.Field","meta":{},"name":"value","id":"cfg-value"},{"tagname":"cfg","owner":"Ext.form.TextField","meta":{},"name":"vtype","id":"cfg-vtype"},{"tagname":"cfg","owner":"Ext.form.TextField","meta":{},"name":"vtypeText","id":"cfg-vtypeText"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"width","id":"cfg-width"},{"tagname":"cfg","owner":"Ext.form.TriggerField","meta":{},"name":"wrapFocusClass","id":"cfg-wrapFocusClass"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"x","id":"cfg-x"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"xtype","id":"cfg-xtype"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"y","id":"cfg-y"}],"css_var":[],"method":[{"tagname":"method","owner":"Ext.form.TriggerField","meta":{},"name":"constructor","id":"method-constructor"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"addClass","id":"method-addClass"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addEvents","id":"method-addEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addListener","id":"method-addListener"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"private":true},"name":"adjustPosition","id":"method-adjustPosition"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"private":true},"name":"adjustSize","id":"method-adjustSize"},{"tagname":"method","owner":"Ext.form.TwinTriggerField","meta":{"private":true},"name":"afterRender","id":"method-afterRender"},{"tagname":"method","owner":"Ext.form.Field","meta":{"private":true},"name":"alignErrorEl","id":"method-alignErrorEl"},{"tagname":"method","owner":"Ext.form.TriggerField","meta":{"private":true},"name":"alignErrorIcon","id":"method-alignErrorIcon"},{"tagname":"method","owner":"Ext.form.Field","meta":{"private":true},"name":"append","id":"method-append"},{"tagname":"method","owner":"Ext.form.TextField","meta":{"private":true},"name":"applyEmptyText","id":"method-applyEmptyText"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"applyToMarkup","id":"method-applyToMarkup"},{"tagname":"method","owner":"Ext.form.TriggerField","meta":{"private":true},"name":"beforeBlur","id":"method-beforeBlur"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"bubble","id":"method-bubble"},{"tagname":"method","owner":"Ext.form.TriggerField","meta":{"private":true},"name":"checkTab","id":"method-checkTab"},{"tagname":"method","owner":"Ext.form.Field","meta":{},"name":"clearInvalid","id":"method-clearInvalid"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"cloneConfig","id":"method-cloneConfig"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"destroy","id":"method-destroy"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"disable","id":"method-disable"},{"tagname":"method","owner":"Ext.form.TextField","meta":{"private":true},"name":"doAutoSize","id":"method-doAutoSize"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"enable","id":"method-enable"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"enableBubble","id":"method-enableBubble"},{"tagname":"method","owner":"Ext.form.TextField","meta":{"private":true},"name":"filterKeys","id":"method-filterKeys"},{"tagname":"method","owner":"Ext.form.TextField","meta":{"private":true},"name":"filterValidation","id":"method-filterValidation"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"findParentBy","id":"method-findParentBy"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"findParentByType","id":"method-findParentByType"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"fireEvent","id":"method-fireEvent"},{"tagname":"method","owner":"Ext.form.Field","meta":{"private":true},"name":"fireKey","id":"method-fireKey"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"focus","id":"method-focus"},{"tagname":"method","owner":"Ext.form.Field","meta":{},"name":"getActiveError","id":"method-getActiveError"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getBox","id":"method-getBox"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getBubbleTarget","id":"method-getBubbleTarget"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getEl","id":"method-getEl"},{"tagname":"method","owner":"Ext.form.Field","meta":{"private":true},"name":"getErrorCt","id":"method-getErrorCt"},{"tagname":"method","owner":"Ext.form.TextField","meta":{},"name":"getErrors","id":"method-getErrors"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getHeight","id":"method-getHeight"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getId","id":"method-getId"},{"tagname":"method","owner":"Ext.form.Field","meta":{"private":true},"name":"getItemCt","id":"method-getItemCt"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getItemId","id":"method-getItemId"},{"tagname":"method","owner":"Ext.form.Field","meta":{"private":true},"name":"getMessageHandler","id":"method-getMessageHandler"},{"tagname":"method","owner":"Ext.form.Field","meta":{},"name":"getName","id":"method-getName"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getOuterSize","id":"method-getOuterSize"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getPosition","id":"method-getPosition"},{"tagname":"method","owner":"Ext.form.Field","meta":{},"name":"getRawValue","id":"method-getRawValue"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getResizeEl","id":"method-getResizeEl"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getSize","id":"method-getSize"},{"tagname":"method","owner":"Ext.form.TwinTriggerField","meta":{"private":true},"name":"getTrigger","id":"method-getTrigger"},{"tagname":"method","owner":"Ext.form.TwinTriggerField","meta":{"private":true},"name":"getTriggerWidth","id":"method-getTriggerWidth"},{"tagname":"method","owner":"Ext.form.Field","meta":{},"name":"getValue","id":"method-getValue"},{"tagname":"method","owner":"Ext.form.TriggerField","meta":{},"name":"getWidth","id":"method-getWidth"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getXType","id":"method-getXType"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getXTypes","id":"method-getXTypes"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"hasListener","id":"method-hasListener"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"hide","id":"method-hide"},{"tagname":"method","owner":"Ext.form.Field","meta":{"private":true},"name":"initComponent","id":"method-initComponent"},{"tagname":"method","owner":"Ext.form.TextField","meta":{"private":true},"name":"initEvents","id":"method-initEvents"},{"tagname":"method","owner":"Ext.Component","meta":{"private":true},"name":"initRef","id":"method-initRef"},{"tagname":"method","owner":"Ext.form.TwinTriggerField","meta":{"private":true},"name":"initTrigger","id":"method-initTrigger"},{"tagname":"method","owner":"Ext.form.Field","meta":{"private":true},"name":"initValue","id":"method-initValue"},{"tagname":"method","owner":"Ext.form.Field","meta":{},"name":"isDirty","id":"method-isDirty"},{"tagname":"method","owner":"Ext.form.Field","meta":{},"name":"isValid","id":"method-isValid"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"isVisible","id":"method-isVisible"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"isXType","id":"method-isXType"},{"tagname":"method","owner":"Ext.form.Field","meta":{},"name":"markInvalid","id":"method-markInvalid"},{"tagname":"method","owner":"Ext.form.TriggerField","meta":{"private":true},"name":"mimicBlur","id":"method-mimicBlur"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"mon","id":"method-mon"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"mun","id":"method-mun"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"nextSibling","id":"method-nextSibling"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"on","id":"method-on"},{"tagname":"method","owner":"Ext.Component","meta":{"private":true},"name":"onAdded","id":"method-onAdded"},{"tagname":"method","owner":"Ext.form.TriggerField","meta":{"private":true},"name":"onBlur","id":"method-onBlur"},{"tagname":"method","owner":"Ext.form.TwinTriggerField","meta":{"private":true},"name":"onDestroy","id":"method-onDestroy"},{"tagname":"method","owner":"Ext.form.TextField","meta":{"private":true},"name":"onDisable","id":"method-onDisable"},{"tagname":"method","owner":"Ext.form.TextField","meta":{"private":true},"name":"onEnable","id":"method-onEnable"},{"tagname":"method","owner":"Ext.form.TriggerField","meta":{"private":true},"name":"onFocus","id":"method-onFocus"},{"tagname":"method","owner":"Ext.form.TextField","meta":{"private":true},"name":"onKeyDown","id":"method-onKeyDown"},{"tagname":"method","owner":"Ext.form.TextField","meta":{"private":true},"name":"onKeyPress","id":"method-onKeyPress"},{"tagname":"method","owner":"Ext.form.TextField","meta":{"private":true},"name":"onKeyUp","id":"method-onKeyUp"},{"tagname":"method","owner":"Ext.form.TextField","meta":{"private":true},"name":"onKeyUpBuffered","id":"method-onKeyUpBuffered"},{"tagname":"method","owner":"Ext.form.TextField","meta":{"private":true},"name":"onMouseDown","id":"method-onMouseDown"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"private":true},"name":"onPosition","id":"method-onPosition"},{"tagname":"method","owner":"Ext.Component","meta":{"private":true},"name":"onRemoved","id":"method-onRemoved"},{"tagname":"method","owner":"Ext.form.TriggerField","meta":{"private":true},"name":"onRender","id":"method-onRender"},{"tagname":"method","owner":"Ext.form.TriggerField","meta":{"private":true},"name":"onResize","id":"method-onResize"},{"tagname":"method","owner":"Ext.form.TwinTriggerField","meta":{},"name":"onTrigger1Click","id":"method-onTrigger1Click"},{"tagname":"method","owner":"Ext.form.TwinTriggerField","meta":{},"name":"onTrigger2Click","id":"method-onTrigger2Click"},{"tagname":"method","owner":"Ext.form.TriggerField","meta":{},"name":"onTriggerClick","id":"method-onTriggerClick"},{"tagname":"method","owner":"Ext.form.TextField","meta":{"private":true},"name":"postBlur","id":"method-postBlur"},{"tagname":"method","owner":"Ext.form.TextField","meta":{"private":true},"name":"preFocus","id":"method-preFocus"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"previousSibling","id":"method-previousSibling"},{"tagname":"method","owner":"Ext.form.TextField","meta":{},"name":"processValue","id":"method-processValue"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"purgeListeners","id":"method-purgeListeners"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"relayEvents","id":"method-relayEvents"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"removeClass","id":"method-removeClass"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"removeListener","id":"method-removeListener"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"render","id":"method-render"},{"tagname":"method","owner":"Ext.form.TextField","meta":{},"name":"reset","id":"method-reset"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"resumeEvents","id":"method-resumeEvents"},{"tagname":"method","owner":"Ext.form.TextField","meta":{},"name":"selectText","id":"method-selectText"},{"tagname":"method","owner":"Ext.form.Field","meta":{},"name":"setActiveError","id":"method-setActiveError"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"setAutoScroll","id":"method-setAutoScroll"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"setDisabled","id":"method-setDisabled"},{"tagname":"method","owner":"Ext.form.TriggerField","meta":{},"name":"setEditable","id":"method-setEditable"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"setHeight","id":"method-setHeight"},{"tagname":"method","owner":"Ext.form.TriggerField","meta":{},"name":"setHideTrigger","id":"method-setHideTrigger"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"setPagePosition","id":"method-setPagePosition"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"setPosition","id":"method-setPosition"},{"tagname":"method","owner":"Ext.form.Field","meta":{},"name":"setRawValue","id":"method-setRawValue"},{"tagname":"method","owner":"Ext.form.TriggerField","meta":{},"name":"setReadOnly","id":"method-setReadOnly"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"setSize","id":"method-setSize"},{"tagname":"method","owner":"Ext.form.TextField","meta":{"chainable":true},"name":"setValue","id":"method-setValue"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"setVisible","id":"method-setVisible"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"setWidth","id":"method-setWidth"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"show","id":"method-show"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"suspendEvents","id":"method-suspendEvents"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"syncSize","id":"method-syncSize"},{"tagname":"method","owner":"Ext.form.TriggerField","meta":{"private":true},"name":"triggerBlur","id":"method-triggerBlur"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"un","id":"method-un"},{"tagname":"method","owner":"Ext.form.Field","meta":{},"name":"unsetActiveError","id":"method-unsetActiveError"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"update","id":"method-update"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"updateBox","id":"method-updateBox"},{"tagname":"method","owner":"Ext.form.TriggerField","meta":{"private":true},"name":"updateEditState","id":"method-updateEditState"},{"tagname":"method","owner":"Ext.form.Field","meta":{},"name":"validate","id":"method-validate"},{"tagname":"method","owner":"Ext.form.TriggerField","meta":{"private":true},"name":"validateBlur","id":"method-validateBlur"},{"tagname":"method","owner":"Ext.form.Field","meta":{},"name":"validateValue","id":"method-validateValue"}],"event":[{"tagname":"event","owner":"Ext.Component","meta":{},"name":"added","id":"event-added"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"afterrender","id":"event-afterrender"},{"tagname":"event","owner":"Ext.form.TextField","meta":{},"name":"autosize","id":"event-autosize"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforedestroy","id":"event-beforedestroy"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforehide","id":"event-beforehide"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforerender","id":"event-beforerender"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforeshow","id":"event-beforeshow"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforestaterestore","id":"event-beforestaterestore"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforestatesave","id":"event-beforestatesave"},{"tagname":"event","owner":"Ext.form.Field","meta":{},"name":"blur","id":"event-blur"},{"tagname":"event","owner":"Ext.form.Field","meta":{},"name":"change","id":"event-change"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"destroy","id":"event-destroy"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"disable","id":"event-disable"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"enable","id":"event-enable"},{"tagname":"event","owner":"Ext.form.Field","meta":{},"name":"focus","id":"event-focus"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"hide","id":"event-hide"},{"tagname":"event","owner":"Ext.form.Field","meta":{},"name":"invalid","id":"event-invalid"},{"tagname":"event","owner":"Ext.form.TextField","meta":{},"name":"keydown","id":"event-keydown"},{"tagname":"event","owner":"Ext.form.TextField","meta":{},"name":"keypress","id":"event-keypress"},{"tagname":"event","owner":"Ext.form.TextField","meta":{},"name":"keyup","id":"event-keyup"},{"tagname":"event","owner":"Ext.BoxComponent","meta":{},"name":"move","id":"event-move"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"removed","id":"event-removed"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"render","id":"event-render"},{"tagname":"event","owner":"Ext.BoxComponent","meta":{},"name":"resize","id":"event-resize"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"show","id":"event-show"},{"tagname":"event","owner":"Ext.form.Field","meta":{},"name":"specialkey","id":"event-specialkey"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"staterestore","id":"event-staterestore"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"statesave","id":"event-statesave"},{"tagname":"event","owner":"Ext.form.Field","meta":{},"name":"valid","id":"event-valid"}],"css_mixin":[]},"inheritable":null,"private":null,"component":true,"name":"Ext.form.TwinTriggerField","singleton":false,"override":null,"inheritdoc":null,"id":"class-Ext.form.TwinTriggerField","mixins":[],"mixedInto":[]});