#!perl -T

use strict; use warnings;
use Test::More;

use OpenSSL::Versions qw( parse_openssl_version_number );

# These are OPENSSL_VERSION_NUMBER values and corresponding version strings
# from all distributions available as of 2012/03/12 at
# http://www.openssl.org/source/

my @cases = (
    [ '0x0913' => '0.9.1c' ],
    [ '0x0922' => '0.9.2b' ],
    [ '0x00903100' => '0.9.3' ],
    [ '0x00903101' => '0.9.3a' ],
    [ '0x00904100' => '0.9.4' ],
    [ '0x00905100' => '0.9.5' ],
    [ '0x0090581f' => '0.9.5a' ],
    [ '0x0090600f' => '0.9.6' ],
    [ '0x0090601f' => '0.9.6a' ],
    [ '0x0090602f' => '0.9.6b' ],
    [ '0x0090603f' => '0.9.6c' ],
    [ '0x0090604f' => '0.9.6d' ],
    [ '0x0090605f' => '0.9.6e' ],
    [ '0x0090606f' => '0.9.6f' ],
    [ '0x0090607f' => '0.9.6g' ],
    [ '0x0090608f' => '0.9.6h' ],
    [ '0x0090609f' => '0.9.6i' ],
    [ '0x009060af' => '0.9.6j' ],
    [ '0x009060bf' => '0.9.6k' ],
    [ '0x009060cf' => '0.9.6l' ],
    [ '0x009060df' => '0.9.6m' ],
    [ '0x0090700f' => '0.9.7' ],
    [ '0x0090701f' => '0.9.7a' ],
    [ '0x0090702f' => '0.9.7b' ],
    [ '0x0090703f' => '0.9.7c' ],
    [ '0x0090704f' => '0.9.7d' ],
    [ '0x0090705F' => '0.9.7e' ],
    [ '0x0090706F' => '0.9.7f' ],
    [ '0x0090707f' => '0.9.7g' ],
    [ '0x0090708f' => '0.9.7h' ],
    [ '0x0090709f' => '0.9.7i' ],
    [ '0x009070af' => '0.9.7j' ],
    [ '0x009070bf' => '0.9.7k' ],
    [ '0x009070cf' => '0.9.7l' ],
    [ '0x009070df' => '0.9.7m' ],
    [ '0x0090800f' => '0.9.8' ],
    [ '0x0090801f' => '0.9.8a' ],
    [ '0x0090802f' => '0.9.8b' ],
    [ '0x0090803f' => '0.9.8c' ],
    [ '0x0090804f' => '0.9.8d' ],
    [ '0x0090805f' => '0.9.8e' ],
    [ '0x00908070' => '0.9.8f' ],
    [ '0x0090807f' => '0.9.8g' ],
    [ '0x0090808f' => '0.9.8h' ],
    [ '0x0090809f' => '0.9.8i' ],
    [ '0x009080af' => '0.9.8j' ],
    [ '0x009080bf' => '0.9.8k' ],
    [ '0x009080cf' => '0.9.8l' ],
    [ '0x009080df' => '0.9.8m' ],
    [ '0x009080d1' => '0.9.8m-beta1' ],
    [ '0x009080ef' => '0.9.8n' ],
    [ '0x009080ff' => '0.9.8o' ],
    [ '0x0090810f' => '0.9.8p' ],
    [ '0x0090811f' => '0.9.8q' ],
    [ '0x0090812f' => '0.9.8r' ],
    [ '0x0090813f' => '0.9.8s' ],
    [ '0x0090814f' => '0.9.8t' ],
    [ '0x0090815f' => '0.9.8u' ],
    [ '0x1000000f' => '1.0.0' ],
    [ '0x10000001' => '1.0.0-beta1' ],
    [ '0x10000002' => '1.0.0-beta2' ],
    [ '0x10000003' => '1.0.0-beta3' ],
    [ '0x10000004' => '1.0.0-beta4' ],
    [ '0x10000005' => '1.0.0-beta5' ],
    [ '0x1000001f' => '1.0.0a' ],
    [ '0x1000002f' => '1.0.0b' ],
    [ '0x1000003f' => '1.0.0c' ],
    [ '0x1000004f' => '1.0.0d' ],
    [ '0x1000005f' => '1.0.0e' ],
    [ '0x1000006f' => '1.0.0f' ],
    [ '0x1000007f' => '1.0.0g' ],
    [ '0x1000008f' => '1.0.0h' ],
    [ '0x10001001' => '1.0.1-beta1' ],
    [ '0x10001002' => '1.0.1-beta2' ],
    [ '0x10001003' => '1.0.1-beta3' ],
);

for my $case ( @cases ) {
    my ($input, $expected) = @$case;
    is(
        parse_openssl_version_number($input),
        $expected,
        "$input => $expected",
    );
}

done_testing(scalar @cases);

