package Shipment::FedEx::WSDL::TrackTypes::TrackNotificationPackage;
$Shipment::FedEx::WSDL::TrackTypes::TrackNotificationPackage::VERSION = '3.08';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns {'http://fedex.com/ws/track/v9'}

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{    # BLOCK to scope variables

    my %TrackingNumber_of : ATTR(:get<TrackingNumber>);
    my %TrackingNumberUniqueIdentifiers_of :
      ATTR(:get<TrackingNumberUniqueIdentifiers>);
    my %CarrierCode_of : ATTR(:get<CarrierCode>);
    my %ShipDate_of : ATTR(:get<ShipDate>);
    my %Destination_of : ATTR(:get<Destination>);
    my %RecipientDetails_of : ATTR(:get<RecipientDetails>);

    __PACKAGE__->_factory(
        [   qw(        TrackingNumber
              TrackingNumberUniqueIdentifiers
              CarrierCode
              ShipDate
              Destination
              RecipientDetails

            )
        ],
        {   'TrackingNumber'                  => \%TrackingNumber_of,
            'TrackingNumberUniqueIdentifiers' =>
              \%TrackingNumberUniqueIdentifiers_of,
            'CarrierCode'      => \%CarrierCode_of,
            'ShipDate'         => \%ShipDate_of,
            'Destination'      => \%Destination_of,
            'RecipientDetails' => \%RecipientDetails_of,
        },
        {   'TrackingNumber' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'TrackingNumberUniqueIdentifiers' =>
              'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'CarrierCode' =>
              'Shipment::FedEx::WSDL::TrackTypes::CarrierCodeType',
            'ShipDate'         => 'SOAP::WSDL::XSD::Typelib::Builtin::date',
            'Destination'      => 'Shipment::FedEx::WSDL::TrackTypes::Address',
            'RecipientDetails' =>
              'Shipment::FedEx::WSDL::TrackTypes::TrackNotificationRecipientDetail',
        },
        {

            'TrackingNumber'                  => 'TrackingNumber',
            'TrackingNumberUniqueIdentifiers' =>
              'TrackingNumberUniqueIdentifiers',
            'CarrierCode'      => 'CarrierCode',
            'ShipDate'         => 'ShipDate',
            'Destination'      => 'Destination',
            'RecipientDetails' => 'RecipientDetails',
        }
    );

}    # end BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::FedEx::WSDL::TrackTypes::TrackNotificationPackage

=head1 VERSION

version 3.08

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
TrackNotificationPackage from the namespace http://fedex.com/ws/track/v9.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * TrackingNumber

=item * TrackingNumberUniqueIdentifiers

=item * CarrierCode

=item * ShipDate

=item * Destination

=item * RecipientDetails

=back

=head1 NAME

Shipment::FedEx::WSDL::TrackTypes::TrackNotificationPackage

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::FedEx::WSDL::TrackTypes::TrackNotificationPackage
   TrackingNumber =>  $some_value, # string
   TrackingNumberUniqueIdentifiers =>  $some_value, # string
   CarrierCode => $some_value, # CarrierCodeType
   ShipDate =>  $some_value, # date
   Destination =>  { # Shipment::FedEx::WSDL::TrackTypes::Address
     StreetLines =>  $some_value, # string
     City =>  $some_value, # string
     StateOrProvinceCode =>  $some_value, # string
     PostalCode =>  $some_value, # string
     UrbanizationCode =>  $some_value, # string
     CountryCode =>  $some_value, # string
     CountryName =>  $some_value, # string
     Residential =>  $some_value, # boolean
   },
   RecipientDetails =>  { # Shipment::FedEx::WSDL::TrackTypes::TrackNotificationRecipientDetail
     NotificationEventsAvailable => $some_value, # EMailNotificationEventType
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
