/*
 * Decompiled with CFR 0.152.
 */
package opera;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import netscape.javascript.JSObject;
import netscape.plugin.Plugin;
import opera.InvocationThread;
import opera.LC3Resolver;
import opera.LiveConnectPrivilegedActions;
import opera.MethodLookupThread;

class MethodResolver {
    static Class jsobjectClass;
    static Class objectClass;
    static Class stringClass;
    static Class classClass;
    static Class doubleClass;
    static Class booleanClass;
    static final int JSTYPE_NOTFOUND = 0;
    static final int JSTYPE_NUMBER = 1;
    static final int JSTYPE_BOOLEAN = 2;
    static final int JSTYPE_OBJECT = 3;
    static final int JSTYPE_JAVAARRAY = 4;
    static final int JSTYPE_JAVAOBJECT = 5;
    static final int JSTYPE_STATIC = 8;
    static final int JSTYPE_FINAL = 16;
    static final int JM_NOTFOUND = 0;
    static final int JM_NONSTATIC = 1;
    static final int JM_STATIC = 2;

    MethodResolver() {
    }

    static String findMethod(Class clazz, String string, String string2, Object[] objectArray, boolean bl) {
        if (string.equals("<init>")) {
            Constructor constructor = LC3Resolver.resolveConstructor(clazz, string2, objectArray, bl);
            if (constructor != null) {
                return MethodResolver.makeSignature(null, constructor.getParameterTypes());
            }
        } else {
            Method method = LC3Resolver.resolveMethod(clazz, string, string2, objectArray, bl);
            if (method != null) {
                return MethodResolver.makeSignature(method.getReturnType(), method.getParameterTypes());
            }
        }
        return null;
    }

    static String makeSignature(Class clazz, Class[] classArray) {
        String string = new String("(");
        int n = 0;
        while (n < classArray.length) {
            if (classArray[n] != null) {
                string = string + MethodResolver.getTypeSignature(classArray[n]);
            }
            ++n;
        }
        string = string + ")";
        string = clazz != null ? string + MethodResolver.getTypeSignature(clazz) : string + "V";
        return string;
    }

    static boolean hasMethod(Class clazz, String string, boolean bl, JSObject jSObject) {
        try {
            MethodLookupThread methodLookupThread = new MethodLookupThread(clazz, string, bl, jSObject);
            methodLookupThread.start();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return false;
        }
    }

    static int hasMethod(Class clazz, String string, boolean bl) {
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        int n2 = 0;
        while (n2 < methodArray.length) {
            if (string.equals(methodArray[n2].getName()) && (!bl || Modifier.isStatic(methodArray[n2].getModifiers()))) {
                n |= Modifier.isStatic(methodArray[n2].getModifiers()) ? 2 : 1;
            }
            ++n2;
        }
        return n;
    }

    static int hasField(Class clazz, String string, boolean bl) {
        try {
            Field field = clazz.getField(string);
            if (!bl || Modifier.isStatic(field.getModifiers())) {
                Class<?> clazz2 = field.getType();
                return MethodResolver.classToJSType(clazz2) | (Modifier.isStatic(field.getModifiers()) ? 8 : 0) | (Modifier.isFinal(field.getModifiers()) ? 16 : 0);
            }
            return 0;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return 0;
        }
    }

    static int classToJSType(Class clazz) {
        if (clazz.equals(Byte.TYPE) || clazz.equals(Character.TYPE) || clazz.equals(Short.TYPE) || clazz.equals(Integer.TYPE) || clazz.equals(Long.TYPE) || clazz.equals(Float.TYPE) || clazz.equals(Double.TYPE)) {
            return 1;
        }
        if (clazz.equals(Boolean.TYPE)) {
            return 2;
        }
        if (clazz.equals(jsobjectClass)) {
            return 3;
        }
        if (clazz.isArray()) {
            return 4;
        }
        return 5;
    }

    static String getFieldTypeName(Class clazz, String string, boolean bl) {
        try {
            Field field = clazz.getField(string);
            if (!bl || Modifier.isStatic(field.getModifiers())) {
                return MethodResolver.getTypeSignature(field.getType());
            }
            return null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    static double getFieldDouble(Class clazz, String string, Object object, String string2) {
        try {
            Field field = clazz.getField(string);
            Object object2 = LiveConnectPrivilegedActions.getField(field, object, string2);
            if (object2 instanceof Character) {
                return ((Character)object2).charValue();
            }
            return ((Number)object2).doubleValue();
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    static boolean getFieldBoolean(Class clazz, String string, Object object, String string2) {
        try {
            Field field = clazz.getField(string);
            Object object2 = LiveConnectPrivilegedActions.getField(field, object, string2);
            return (Boolean)object2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static Object getFieldObject(Class clazz, String string, Object object, String string2) {
        try {
            Field field = clazz.getField(string);
            return LiveConnectPrivilegedActions.getField(field, object, string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static boolean isAssignableFrom(String string, Object object) {
        try {
            Class clazz = MethodResolver.getTypeFromSignature(string);
            return clazz.isAssignableFrom(object.getClass());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static Class getTypeFromSignature(String string) {
        try {
            switch (string.charAt(0)) {
                case 'L': {
                    String string2 = string.replace('/', '.');
                    return Class.forName(string2.substring(1, string2.indexOf(59)));
                }
                case '[': {
                    return Class.forName(string);
                }
                case 'B': {
                    return Byte.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'I': {
                    return Integer.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'V': {
                    return Void.TYPE;
                }
                case 'Z': {
                    return Boolean.TYPE;
                }
            }
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static String getTypeSignature(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz.equals(Boolean.TYPE)) {
                return new String("Z");
            }
            if (clazz.equals(Byte.TYPE)) {
                return new String("B");
            }
            if (clazz.equals(Character.TYPE)) {
                return new String("C");
            }
            if (clazz.equals(Double.TYPE)) {
                return new String("D");
            }
            if (clazz.equals(Float.TYPE)) {
                return new String("F");
            }
            if (clazz.equals(Integer.TYPE)) {
                return new String("I");
            }
            if (clazz.equals(Long.TYPE)) {
                return new String("J");
            }
            if (clazz.equals(Short.TYPE)) {
                return new String("S");
            }
            if (clazz.equals(Void.TYPE)) {
                return new String("V");
            }
            return null;
        }
        if (clazz.isArray()) {
            return clazz.getName().replace('.', '/');
        }
        return "L" + clazz.getName().replace('.', '/') + ";";
    }

    private static String getJRIStubName(Class clazz, Method method) {
        return "native_" + clazz.getName().replace('.', '_') + "_" + method.getName();
    }

    private static int nativeMethodCount(Method[] methodArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < methodArray.length) {
            if (Modifier.isNative(methodArray[n2].getModifiers())) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private static String[] getNativeMethods(Class clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = MethodResolver.nativeMethodCount(methodArray);
        if (n > 0) {
            String[] stringArray = new String[n * 2];
            int n2 = 0;
            int n3 = 0;
            while (n3 < methodArray.length) {
                if (Modifier.isNative(methodArray[n3].getModifiers())) {
                    String string = methodArray[n3].getName() + "(";
                    Class<?>[] classArray = methodArray[n3].getParameterTypes();
                    int n4 = 0;
                    while (n4 < classArray.length) {
                        string = string + MethodResolver.getTypeSignature(classArray[n4]);
                        ++n4;
                    }
                    string = string + ")";
                    string = string + MethodResolver.getTypeSignature(methodArray[n3].getReturnType());
                    String string2 = MethodResolver.getJRIStubName(clazz, methodArray[n3]);
                    stringArray[n2++] = string;
                    stringArray[n2++] = string2;
                }
                ++n3;
            }
            return stringArray;
        }
        return null;
    }

    private static Object newObject(Constructor constructor, Object[] objectArray, String string) {
        try {
            return LiveConnectPrivilegedActions.newObject(constructor, objectArray, string);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    private static boolean invoke(Object object, Method method, Object[] objectArray, JSObject jSObject, String string) {
        try {
            InvocationThread invocationThread = new InvocationThread(object, method, objectArray, jSObject, string);
            if (object instanceof Plugin) {
                invocationThread.run();
            } else {
                invocationThread.start();
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return false;
        }
    }

    static {
        try {
            jsobjectClass = Class.forName("netscape.javascript.JSObject");
            objectClass = Class.forName("java.lang.Object");
            stringClass = Class.forName("java.lang.String");
            classClass = Class.forName("java.lang.Class");
            doubleClass = Class.forName("java.lang.Double");
            booleanClass = Class.forName("java.lang.Boolean");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

