/*
 * Decompiled with CFR 0.152.
 */
package opera;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import opera.OperaURLConnection;

class OperaOutputStream
extends OutputStream {
    private static final int BUFFER_SIZE = 16384;
    private static Hashtable stream_map = new Hashtable();
    private static int next_stream_id = 0;
    private byte[] buffer = new byte[16384];
    private int next_write_byte = 0;
    private int stream_id = -1;
    protected int istream_id = -1;
    private OperaURLConnection connection = null;
    private boolean is_closed = false;

    protected OperaOutputStream(OperaURLConnection operaURLConnection) {
        this.connection = operaURLConnection;
    }

    public void write(int n) throws IOException {
        if (this.buffer == null) {
            throw new IOException();
        }
        this.buffer[this.next_write_byte++] = (byte)n;
        if (this.next_write_byte == 16384) {
            this.flushBuffer();
        }
    }

    public void flush() throws IOException {
        if (this.buffer == null) {
            throw new IOException();
        }
        this.flushBuffer();
    }

    public void close() throws IOException {
        if (this.buffer == null) {
            throw new IOException();
        }
        this.flushBuffer();
        this.postData(this.istream_id, this.connection.makeExtraHeaders());
        this.connection = null;
        this.buffer = null;
        this.is_closed = true;
    }

    boolean isClosed() {
        return this.is_closed;
    }

    private void flushBuffer() {
        if (this.next_write_byte > 0) {
            this.addData(this.buffer, this.next_write_byte);
            this.next_write_byte = 0;
        }
    }

    private native void postData(int var1, String var2);

    private native void addData(byte[] var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int addStream(OperaOutputStream operaOutputStream) {
        Hashtable hashtable = stream_map;
        synchronized (hashtable) {
            stream_map.put(new Integer(next_stream_id), operaOutputStream);
            operaOutputStream.stream_id = next_stream_id++;
        }
        return operaOutputStream.stream_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeStream(int n) {
        Hashtable hashtable = stream_map;
        synchronized (hashtable) {
            stream_map.remove(new Integer(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static OperaOutputStream getStream(int n) {
        Hashtable hashtable = stream_map;
        synchronized (hashtable) {
            OperaOutputStream operaOutputStream = (OperaOutputStream)stream_map.get(new Integer(n));
            return operaOutputStream;
        }
    }
}

