/*
 * Decompiled with CFR 0.152.
 */
package netscape.javascript;

import java.applet.Applet;
import netscape.javascript.JSException;
import opera.EcmaScriptObject;
import opera.PluginContext;

public final class JSObject {
    private EcmaScriptObject ecma_object;
    private Object result;
    private Object result_mutex = new Object();

    private JSObject(int n, int n2) {
        this.ecma_object = EcmaScriptObject.getObject(n, n2);
        if (this.ecma_object != null) {
            this.ecma_object.ref();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object call(String string, Object[] objectArray) throws JSException {
        try {
            JSObject jSObject = (JSObject)this.getMember(string);
            Object object = this.result_mutex;
            synchronized (object) {
                JSObject jSObject2 = this;
                synchronized (jSObject2) {
                    if (jSObject == null) {
                        throw new JSException("Method " + string + " not found.");
                    }
                    if (this.startCall(jSObject, objectArray)) {
                        this.wait();
                        if (!(this.result instanceof JSException)) return this.result;
                        throw (JSException)this.result;
                    }
                    this.result = null;
                    return this.result;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    private native boolean startCall(JSObject var1, Object[] var2);

    public boolean equals(Object object) {
        return object instanceof JSObject && ((JSObject)object).ecma_object.equals(this.ecma_object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String string) throws JSException {
        try {
            Object object = this.result_mutex;
            synchronized (object) {
                JSObject jSObject = this;
                synchronized (jSObject) {
                    if (this.startEval(string)) {
                        this.wait();
                        if (this.result instanceof JSException) {
                            throw (JSException)this.result;
                        }
                    } else {
                        this.result = null;
                    }
                    Object object2 = this.result;
                    return object2;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    private native boolean startEval(String var1);

    public static JSObject getWindow(Applet applet) throws JSException {
        if (applet.getParameter("mayscript") == null) {
            throw new JSException("Applet not allowed to access javascript.");
        }
        PluginContext pluginContext = (PluginContext)applet.getAppletContext();
        if (pluginContext != null) {
            int n = pluginContext.getJSWindow();
            int n2 = pluginContext.getESRuntime();
            if (n != 0 && n2 != 0) {
                return new JSObject(n, n2);
            }
        }
        return null;
    }

    public Object getMember(String string) {
        try {
            return this.eval("this." + string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private native boolean getMemberN(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMember(String string, Object object) {
        try {
            Object object2 = this.result_mutex;
            synchronized (object2) {
                JSObject jSObject = this;
                synchronized (jSObject) {
                    if (this.setMemberN(string, object)) {
                        this.wait();
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private native boolean setMemberN(String var1, Object var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMember(String string) {
        try {
            Object object = this.result_mutex;
            synchronized (object) {
                JSObject jSObject = this;
                synchronized (jSObject) {
                    if (this.removeMemberN(string)) {
                        this.wait();
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private native boolean removeMemberN(String var1);

    public Object getSlot(int n) {
        try {
            return this.eval("this[" + n + "];");
        }
        catch (Exception exception) {
            return null;
        }
    }

    private native boolean getSlotN(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSlot(int n, Object object) {
        try {
            Object object2 = this.result_mutex;
            synchronized (object2) {
                JSObject jSObject = this;
                synchronized (jSObject) {
                    if (this.setSlotN(n, object)) {
                        this.wait();
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private native boolean setSlotN(int var1, Object var2);

    public String toString() {
        try {
            Object object = this.eval("this.toString()");
            if (object != null && object instanceof String) {
                return (String)object;
            }
            return null;
        }
        catch (JSException jSException) {
            return null;
        }
    }

    protected void finalize() {
        try {
            if (this.ecma_object != null) {
                this.ecma_object.unref();
            }
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResult(Object object) {
        JSObject jSObject = this;
        synchronized (jSObject) {
            this.result = object;
            this.notify();
        }
    }

    private void setExceptionResult() {
        this.result = new JSException("JavaScript exception");
    }

    private int getESObjectPtr() {
        if (this.ecma_object != null) {
            return this.ecma_object.getESObjectPtr();
        }
        return 0;
    }

    private int getESRuntimePtr() {
        if (this.ecma_object != null) {
            return this.ecma_object.getESRuntimePtr();
        }
        return 0;
    }
}

