/*
 * Decompiled with CFR 0.152.
 */
package opera;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import opera.OperaInputStream;
import opera.OperaOutputStream;
import opera.PluginContext;

public class OperaURLConnection
extends HttpURLConnection {
    private OperaInputStream is = null;
    private int istream_id = -1;
    private OperaOutputStream os = null;
    private int ostream_id = -1;
    private Hashtable req_props = new Hashtable();
    private Hashtable header_fields = new Hashtable();

    protected OperaURLConnection(URL uRL) {
        super(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        if (!this.connected) {
            block23: {
                SecurityManager securityManager;
                Object object;
                int n;
                String string = this.url.toString();
                if (this.url.getPort() == -1 && (n = string.indexOf(":-1")) != -1) {
                    object = new StringBuffer(string);
                    ((StringBuffer)object).delete(n, n + 3);
                    string = ((StringBuffer)object).toString();
                }
                if ((securityManager = System.getSecurityManager()) != null) {
                    securityManager.checkConnect(this.url.getHost(), this.url.getPort());
                }
                try {
                    this.is = new OperaInputStream(this);
                    this.os = new OperaOutputStream(this);
                    this.istream_id = OperaInputStream.addStream(this.is);
                    this.ostream_id = OperaOutputStream.addStream(this.os);
                    this.os.istream_id = this.istream_id;
                    if (this.method.compareTo("POST") == 0) {
                        object = PluginContext.opera_mutex;
                        synchronized (object) {
                            this.nativeConnect(string, this.method, this.ostream_id);
                        }
                        this.connected = true;
                        break block23;
                    }
                    if (this.method.compareTo("GET") == 0) {
                        object = PluginContext.opera_mutex;
                        synchronized (object) {
                            this.nativeConnect(string, this.method, this.istream_id);
                        }
                        try {
                            OperaInputStream operaInputStream = this.is;
                            synchronized (operaInputStream) {
                                if (!this.is.isHeaderLoaded()) {
                                    this.is.wait();
                                }
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        this.connected = this.is.getResponse() == 200;
                        break block23;
                    }
                    object = this.is;
                    synchronized (object) {
                        this.is.headerLoaded(0, 200);
                        this.is.setEOF();
                    }
                    this.connected = true;
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
            if (!this.connected) {
                throw new IOException("Connection failed.");
            }
        }
    }

    private native void nativeConnect(String var1, String var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.method.compareTo("POST") == 0) {
            if (!this.os.isClosed()) {
                this.os.close();
            }
            if (this.is.getResponse() == -1) {
                try {
                    OperaInputStream operaInputStream = this.is;
                    synchronized (operaInputStream) {
                        this.is.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.is.getResponse() != 200) {
                this.connected = false;
                throw new FileNotFoundException(this.url.toString());
            }
            this.connected = true;
        }
        return this.is;
    }

    public String getContentType() {
        return this.getHeaderField("content-type");
    }

    public int getContentLength() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.is != null) {
            return this.is.getContentLength();
        }
        return 0;
    }

    public String getContentEncoding() {
        return this.getHeaderField("content-encoding");
    }

    public OutputStream getOutputStream() throws IOException {
        this.method = "POST";
        if (!this.connected) {
            this.connect();
        }
        return this.os;
    }

    public int getHeaderFieldInt(String string, int n) {
        String string2 = this.getHeaderField(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public String getHeaderField(int n) {
        if (n == 0) {
            // empty if block
        }
        Enumeration enumeration = this.header_fields.elements();
        while (n > 0 && enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (n == 1) {
                return (String)v;
            }
            --n;
        }
        return null;
    }

    public String getHeaderKey(int n) {
        if (n == 0) {
            // empty if block
        }
        Enumeration enumeration = this.header_fields.keys();
        while (n > 0 && enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (n == 1) {
                return (String)k;
            }
            --n;
        }
        return null;
    }

    public String getHeaderField(String string) {
        return (String)this.header_fields.get(string.toLowerCase());
    }

    public String getRequestProperty(String string) {
        return (String)this.req_props.get(string);
    }

    public void setRequestProperty(String string, String string2) {
        if (string.compareToIgnoreCase("Content-length") != 0) {
            this.req_props.put(string, string2);
        }
    }

    public void disconnect() {
    }

    public boolean usingProxy() {
        return false;
    }

    protected void finalize() throws Throwable {
        if (this.is != null) {
            this.is = null;
            OperaInputStream.removeStream(this.istream_id);
        }
        if (this.os != null) {
            this.os = null;
            OperaOutputStream.removeStream(this.ostream_id);
        }
        super.finalize();
    }

    protected String makeExtraHeaders() {
        String string = "";
        Enumeration enumeration = this.req_props.keys();
        Enumeration enumeration2 = this.req_props.elements();
        while (enumeration.hasMoreElements()) {
            string = string.concat((String)enumeration.nextElement());
            String string2 = (String)enumeration2.nextElement();
            string = string2 != null ? string.concat(": " + string2 + "\r\n") : string.concat("\r\n");
        }
        return string;
    }

    protected void addHeader(String string, String string2) {
        this.header_fields.put(string.toLowerCase(), string2);
    }
}

