/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.clearcase;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.clearcase.ClearCase;
import org.apache.tools.ant.types.Commandline;

public class CCCheckin
extends ClearCase {
    private String m_Comment = null;
    private String m_Cfile = null;
    private boolean m_Nwarn = false;
    private boolean m_Ptime = false;
    private boolean m_Keep = false;
    private boolean m_Identical = true;
    public static final String FLAG_COMMENT = "-c";
    public static final String FLAG_COMMENTFILE = "-cfile";
    public static final String FLAG_NOCOMMENT = "-nc";
    public static final String FLAG_NOWARN = "-nwarn";
    public static final String FLAG_PRESERVETIME = "-ptime";
    public static final String FLAG_KEEPCOPY = "-keep";
    public static final String FLAG_IDENTICAL = "-identical";

    public void execute() throws BuildException {
        Commandline commandLine = new Commandline();
        Project aProj = this.getProject();
        int result = 0;
        if (this.getViewPath() == null) {
            this.setViewPath(aProj.getBaseDir().getPath());
        }
        commandLine.setExecutable(this.getClearToolCommand());
        commandLine.createArgument().setValue("checkin");
        this.checkOptions(commandLine);
        result = this.run(commandLine);
        if (result != 0) {
            String msg = "Failed executing: " + commandLine.toString();
            throw new BuildException(msg, this.location);
        }
    }

    private void checkOptions(Commandline cmd) {
        if (this.getComment() != null) {
            this.getCommentCommand(cmd);
        } else if (this.getCommentFile() != null) {
            this.getCommentFileCommand(cmd);
        } else {
            cmd.createArgument().setValue(FLAG_NOCOMMENT);
        }
        if (this.getNoWarn()) {
            cmd.createArgument().setValue(FLAG_NOWARN);
        }
        if (this.getPreserveTime()) {
            cmd.createArgument().setValue(FLAG_PRESERVETIME);
        }
        if (this.getKeepCopy()) {
            cmd.createArgument().setValue(FLAG_KEEPCOPY);
        }
        if (this.getIdentical()) {
            cmd.createArgument().setValue(FLAG_IDENTICAL);
        }
        cmd.createArgument().setValue(this.getViewPath());
    }

    public void setComment(String comment) {
        this.m_Comment = comment;
    }

    public String getComment() {
        return this.m_Comment;
    }

    public void setCommentFile(String cfile) {
        this.m_Cfile = cfile;
    }

    public String getCommentFile() {
        return this.m_Cfile;
    }

    public void setNoWarn(boolean nwarn) {
        this.m_Nwarn = nwarn;
    }

    public boolean getNoWarn() {
        return this.m_Nwarn;
    }

    public void setPreserveTime(boolean ptime) {
        this.m_Ptime = ptime;
    }

    public boolean getPreserveTime() {
        return this.m_Ptime;
    }

    public void setKeepCopy(boolean keep) {
        this.m_Keep = keep;
    }

    public boolean getKeepCopy() {
        return this.m_Keep;
    }

    public void setIdentical(boolean identical) {
        this.m_Identical = identical;
    }

    public boolean getIdentical() {
        return this.m_Identical;
    }

    private void getCommentCommand(Commandline cmd) {
        if (this.getComment() != null) {
            cmd.createArgument().setValue(FLAG_COMMENT);
            cmd.createArgument().setValue(this.getComment());
        }
    }

    private void getCommentFileCommand(Commandline cmd) {
        if (this.getCommentFile() != null) {
            cmd.createArgument().setValue(FLAG_COMMENTFILE);
            cmd.createArgument().setValue(this.getCommentFile());
        }
    }
}

