/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.tr;

import com.jclark.xsl.expr.BooleanExpr;
import com.jclark.xsl.expr.EmptyVariableSet;
import com.jclark.xsl.expr.ExprParser;
import com.jclark.xsl.expr.ExtensionContext;
import com.jclark.xsl.expr.NodeSetExpr;
import com.jclark.xsl.expr.NumberVariant;
import com.jclark.xsl.expr.StringExpr;
import com.jclark.xsl.expr.StringVariant;
import com.jclark.xsl.expr.TopLevelPattern;
import com.jclark.xsl.expr.VariableSet;
import com.jclark.xsl.expr.Variant;
import com.jclark.xsl.expr.VariantExpr;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NameTable;
import com.jclark.xsl.om.NamespaceConstants;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.SafeNodeIterator;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.SaxFilterMaker;
import com.jclark.xsl.tr.Action;
import com.jclark.xsl.tr.ActionDebugTarget;
import com.jclark.xsl.tr.AddVariableSet;
import com.jclark.xsl.tr.AnyLevelNumberAction;
import com.jclark.xsl.tr.AnyLevelNumberActionDebug;
import com.jclark.xsl.tr.AppendAction;
import com.jclark.xsl.tr.AppendActionDebug;
import com.jclark.xsl.tr.ApplyImportsAction;
import com.jclark.xsl.tr.ApplyImportsActionDebug;
import com.jclark.xsl.tr.AttributeAction;
import com.jclark.xsl.tr.AttributeActionDebug;
import com.jclark.xsl.tr.BilevelComparatorTemplate;
import com.jclark.xsl.tr.BindLocalParamAction;
import com.jclark.xsl.tr.BindLocalParamActionDebug;
import com.jclark.xsl.tr.BindLocalVariableAction;
import com.jclark.xsl.tr.BindLocalVariableActionDebug;
import com.jclark.xsl.tr.BuiltinAction;
import com.jclark.xsl.tr.CharsAction;
import com.jclark.xsl.tr.CharsActionDebug;
import com.jclark.xsl.tr.CommentAction;
import com.jclark.xsl.tr.CommentActionDebug;
import com.jclark.xsl.tr.ComparatorTemplate;
import com.jclark.xsl.tr.CopyAction;
import com.jclark.xsl.tr.CopyActionDebug;
import com.jclark.xsl.tr.CopyOfAction;
import com.jclark.xsl.tr.CopyOfActionDebug;
import com.jclark.xsl.tr.DocumentAction;
import com.jclark.xsl.tr.ElementAction;
import com.jclark.xsl.tr.ElementActionDebug;
import com.jclark.xsl.tr.EmptyAction;
import com.jclark.xsl.tr.ExprNumberAction;
import com.jclark.xsl.tr.ExtensionHandler;
import com.jclark.xsl.tr.ForEachAction;
import com.jclark.xsl.tr.ForEachActionDebug;
import com.jclark.xsl.tr.IfAction;
import com.jclark.xsl.tr.IfActionDebug;
import com.jclark.xsl.tr.Importance;
import com.jclark.xsl.tr.ImportantBoolean;
import com.jclark.xsl.tr.InvokeAction;
import com.jclark.xsl.tr.InvokeActionDebug;
import com.jclark.xsl.tr.KeyDefinition;
import com.jclark.xsl.tr.Lang;
import com.jclark.xsl.tr.LiteralAttributeAction;
import com.jclark.xsl.tr.LiteralElementAction;
import com.jclark.xsl.tr.LiteralElementActionDebug;
import com.jclark.xsl.tr.LoadContext;
import com.jclark.xsl.tr.MessageAction;
import com.jclark.xsl.tr.MessageActionDebug;
import com.jclark.xsl.tr.MultiLevelNumberAction;
import com.jclark.xsl.tr.MultiLevelNumberActionDebug;
import com.jclark.xsl.tr.NodeComparatorTemplate;
import com.jclark.xsl.tr.NumberListFormatTemplate;
import com.jclark.xsl.tr.OutputMethod;
import com.jclark.xsl.tr.ParamAction;
import com.jclark.xsl.tr.ParameterSet;
import com.jclark.xsl.tr.Priority;
import com.jclark.xsl.tr.ProcessAction;
import com.jclark.xsl.tr.ProcessActionDebug;
import com.jclark.xsl.tr.ProcessContextImpl;
import com.jclark.xsl.tr.ProcessingInstructionAction;
import com.jclark.xsl.tr.ProcessingInstructionActionDebug;
import com.jclark.xsl.tr.RawCharsAction;
import com.jclark.xsl.tr.RawCharsActionDebug;
import com.jclark.xsl.tr.RawValueOfAction;
import com.jclark.xsl.tr.RawValueOfActionDebug;
import com.jclark.xsl.tr.Result;
import com.jclark.xsl.tr.ResultFragmentExpr;
import com.jclark.xsl.tr.SheetDetails;
import com.jclark.xsl.tr.SingleLevelNumberAction;
import com.jclark.xsl.tr.SingleLevelNumberActionDebug;
import com.jclark.xsl.tr.SortNodeSetExpr;
import com.jclark.xsl.tr.TemplateAttributeAction;
import com.jclark.xsl.tr.TemplateRuleSet;
import com.jclark.xsl.tr.TerminateMessageAction;
import com.jclark.xsl.tr.TerminateMessageActionDebug;
import com.jclark.xsl.tr.UnbindLocalVariablesAction;
import com.jclark.xsl.tr.UseAttributeSetAction;
import com.jclark.xsl.tr.ValueOfAction;
import com.jclark.xsl.tr.ValueOfActionDebug;
import com.jclark.xsl.tr.VariableInfo;
import com.jclark.xsl.tr.XMLProcessor;
import com.jclark.xsl.tr.XRAPAction;
import com.jclark.xsl.tr.XRAPActionDebug;
import com.jclark.xsl.util.Comparator;
import com.jclark.xsl.util.NumberComparator;
import com.jclark.xsl.util.ReverseComparator;
import com.jclark.xsl.util.TextComparator;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

class SheetImpl
implements SheetDetails,
LoadContext,
NamespaceConstants {
    private SaxFilterMaker _xrap = null;
    private ActionDebugTarget _debugger = null;
    private ImportantBoolean stripSource = null;
    private Hashtable stripSourceElementTable = null;
    private Hashtable stripSourceNamespaceTable = null;
    private TemplateRuleSet templateRules = new TemplateRuleSet(new BuiltinAction());
    private Hashtable modeTable = new Hashtable();
    private Hashtable namedTemplateTable = new Hashtable();
    private Hashtable variableInfoTable = new Hashtable();
    private Hashtable userFunctionTable = new Hashtable();
    private Hashtable attributeSetTable = new Hashtable();
    private Hashtable namespaceAliasTable = new Hashtable();
    private Hashtable keysDefinitionsTable = new Hashtable();
    private Vector idAttributes = new Vector();
    private static final Action emptyAction = new EmptyAction();
    private Hashtable topLevelTable = new Hashtable();
    private Hashtable actionTable = new Hashtable();
    Importance currentImportance = Importance.create();
    int importCount = 0;
    static NodeSetExpr childrenExpr = ExprParser.getChildrenExpr();
    VariableSet currentLocalVariables = new EmptyVariableSet();
    int nCurrentLocalVariables = 0;
    Vector excludedNamespaces;
    XMLProcessor _omBuilder;
    static StringVariant emptyStringVariant = new StringVariant("");
    Name XSL_WHEN;
    Name XSL_OTHERWISE;
    Name XSL_STYLESHEET;
    Name XSL_TRANSFORM;
    Name XSL_WITH_PARAM;
    Name XSL_SORT;
    Name XSL_FOR_EACH;
    Name XSL_FALLBACK;
    Name XSL_VERSION;
    Name XSL_VENDOR;
    Name XSL_VENDOR_URL;
    Name XSL_USE_ATTRIBUTE_SETS;
    Name XSL_ATTRIBUTE;
    Name ATTRIBUTE;
    Name CASE_ORDER;
    Name CDATA_SECTION_ELEMENTS;
    Name COUNT;
    Name DATA_TYPE;
    Name DEFAULT;
    Name DISABLE_OUTPUT_ESCAPING;
    Name DOCTYPE_PUBLIC;
    Name DOCTYPE_SYSTEM;
    Name ELEMENTS;
    Name ENCODING;
    Name EXCLUDE_RESULT_PREFIXES;
    Name FORMAT;
    Name FROM;
    Name GROUPING_SEPARATOR;
    Name GROUPING_SIZE;
    Name HREF;
    Name INDENT;
    Name LANG;
    Name LETTER_VALUE;
    Name LEVEL;
    Name MATCH;
    Name MEDIA_TYPE;
    Name METHOD;
    Name MODE;
    Name NAME;
    Name NAMESPACE;
    Name OMIT_XML_DECLARATION;
    Name ORDER;
    Name PRIORITY;
    Name RESULT_PREFIX;
    Name SELECT;
    Name STANDALONE;
    Name STYLESHEET_PREFIX;
    Name TERMINATE;
    Name TEST;
    Name USE;
    Name USE_ATTRIBUTE_SETS;
    Name VALUE;
    Name VERSION;
    OutputMethodImpl _outputMethod;
    OutputMethodImpl _runtimeOutputMethod = null;
    LoadContext sheetLoadContext;
    NameTable nameTable;
    ExtensionHandler extensionHandler;

    SheetImpl(Node node, XMLProcessor omBuilder, ExtensionHandler extensionHandler, LoadContext sheetLoadContext, NameTable nameTable) throws IOException, XSLException {
        this.sheetLoadContext = sheetLoadContext;
        this.nameTable = nameTable;
        this._omBuilder = omBuilder;
        this.extensionHandler = extensionHandler;
        this._debugger = sheetLoadContext.getDebugger();
        this.XSL_WHEN = this.xsl("when");
        this.XSL_OTHERWISE = this.xsl("otherwise");
        this.XSL_STYLESHEET = this.xsl("stylesheet");
        this.XSL_TRANSFORM = this.xsl("transform");
        this.XSL_WITH_PARAM = this.xsl("with-param");
        this.XSL_SORT = this.xsl("sort");
        this.XSL_FOR_EACH = this.xsl("for-each");
        this.XSL_FALLBACK = this.xsl("fallback");
        this.XSL_VERSION = this.xsl("version");
        this.XSL_VENDOR = this.xsl("vendor");
        this.XSL_VENDOR_URL = this.xsl("vendor-url");
        this.XSL_USE_ATTRIBUTE_SETS = this.xsl("use-attribute-sets");
        this.XSL_ATTRIBUTE = this.xsl("attribute");
        this.ATTRIBUTE = nameTable.createName("attribute");
        this.CASE_ORDER = nameTable.createName("case-order");
        this.CDATA_SECTION_ELEMENTS = nameTable.createName("cdata-section-elements");
        this.COUNT = nameTable.createName("count");
        this.DATA_TYPE = nameTable.createName("data-type");
        this.DEFAULT = nameTable.createName("default");
        this.DISABLE_OUTPUT_ESCAPING = nameTable.createName("disable-output-escaping");
        this.DOCTYPE_PUBLIC = nameTable.createName("doctype-public");
        this.DOCTYPE_SYSTEM = nameTable.createName("doctype-system");
        this.ELEMENTS = nameTable.createName("elements");
        this.ENCODING = nameTable.createName("encoding");
        this.EXCLUDE_RESULT_PREFIXES = nameTable.createName("exclude-result-prefixes");
        this.FORMAT = nameTable.createName("format");
        this.FROM = nameTable.createName("from");
        this.GROUPING_SEPARATOR = nameTable.createName("grouping-separator");
        this.GROUPING_SIZE = nameTable.createName("grouping-size");
        this.HREF = nameTable.createName("href");
        this.INDENT = nameTable.createName("indent");
        this.LANG = nameTable.createName("lang");
        this.LETTER_VALUE = nameTable.createName("letter-value");
        this.LEVEL = nameTable.createName("level");
        this.MATCH = nameTable.createName("match");
        this.MEDIA_TYPE = nameTable.createName("media-type");
        this.METHOD = nameTable.createName("method");
        this.MODE = nameTable.createName("mode");
        this.NAME = nameTable.createName("name");
        this.NAMESPACE = nameTable.createName("namespace");
        this.OMIT_XML_DECLARATION = nameTable.createName("omit-xml-declaration");
        this.ORDER = nameTable.createName("order");
        this.PRIORITY = nameTable.createName("priority");
        this.RESULT_PREFIX = nameTable.createName("result-prefix");
        this.SELECT = nameTable.createName("select");
        this.STANDALONE = nameTable.createName("standalone");
        this.STYLESHEET_PREFIX = nameTable.createName("stylesheet-prefix");
        this.TERMINATE = nameTable.createName("terminate");
        this.TEST = nameTable.createName("test");
        this.USE = nameTable.createName("use");
        this.USE_ATTRIBUTE_SETS = nameTable.createName("use-attribute-sets");
        this.VALUE = nameTable.createName("value");
        this.VERSION = nameTable.createName("version");
        this.topLevelTable.put(this.xsl("include"), new IncludeParser());
        this.topLevelTable.put(this.xsl("import"), new ImportParser());
        this.topLevelTable.put(this.xsl("template"), new TemplateParser());
        this.topLevelTable.put(this.xsl("attribute-set"), new AttributeSetParser());
        this.topLevelTable.put(this.xsl("decimal-format"), new DecimalFormatParser());
        this.topLevelTable.put(this.xsl("key"), new KeyParser());
        this.topLevelTable.put(this.xsl("variable"), new VariableTopLevelParser());
        this.topLevelTable.put(this.xsl("param"), new ParamTopLevelParser());
        this.topLevelTable.put(this.xsl("strip-space"), new StripSpaceParser());
        this.topLevelTable.put(this.xsl("preserve-space"), new PreserveSpaceParser());
        this.topLevelTable.put(this.xsl("output"), new OutputParser());
        this.topLevelTable.put(this.xsl("namespace-alias"), new NamespaceAliasParser());
        this.topLevelTable.put(this.func("function"), new EXSLFunctionTopLevelParser());
        this.actionTable.put(this.xsl("text"), new TextParser());
        this.actionTable.put(this.xsl("apply-templates"), new ApplyTemplatesParser());
        this.actionTable.put(this.xsl("call-template"), new CallTemplateParser());
        this.actionTable.put(this.xsl("for-each"), new ForEachParser());
        this.actionTable.put(this.xsl("value-of"), new ValueOfParser());
        this.actionTable.put(this.xsl("number"), new NumberParser());
        this.actionTable.put(this.xsl("if"), new IfParser());
        this.actionTable.put(this.xsl("choose"), new ChooseParser());
        this.actionTable.put(this.xsl("copy"), new CopyParser());
        this.actionTable.put(this.xsl("copy-of"), new CopyOfParser());
        this.actionTable.put(this.xsl("comment"), new CommentParser());
        this.actionTable.put(this.xsl("processing-instruction"), new ProcessingInstructionParser());
        this.actionTable.put(this.xsl("element"), new ElementParser());
        this.actionTable.put(this.xsl("attribute"), new AttributeParser());
        this.actionTable.put(this.xsl("apply-imports"), new ApplyImportsParser());
        this.actionTable.put(this.xsl("variable"), new VariableActionParser());
        this.actionTable.put(this.xsl("param"), new ParamActionParser());
        this.actionTable.put(this.xsl("message"), new MessageParser());
        this.actionTable.put(this.xt("document"), new DocumentParser());
        this.actionTable.put(this.exsl("document"), new DocumentParser());
        this.actionTable.put(this.func("result"), new EXSLFunctionResultParser());
        this.actionTable.put(this.xfyxt("xrap"), new XRAPParser());
        this._outputMethod = new OutputMethodImpl();
        this.parseSheet(node);
    }

    public void setSaxExtensionFilter(SaxFilterMaker xrap) {
        this._xrap = xrap;
    }

    public SaxFilterMaker getSaxExtensionFilter() {
        return this._xrap;
    }

    public void setDebugger(ActionDebugTarget debugger) {
        this._debugger = debugger;
    }

    public ActionDebugTarget getDebugger() {
        return this._debugger;
    }

    public OutputMethod getOutputMethod() {
        return this._runtimeOutputMethod == null ? this._outputMethod : this._runtimeOutputMethod;
    }

    public Properties getOutputMethodProperties() {
        return null;
    }

    public void clearOutputMethodProperties() {
        this._runtimeOutputMethod = null;
    }

    public void setOutputMethodProperty(String encodedPropertyNamespace, String encodedPropertyName, String value) throws XSLException {
        if (this._runtimeOutputMethod == null) {
            this._runtimeOutputMethod = (OutputMethodImpl)this._outputMethod.clone();
        }
        Name name = encodedPropertyNamespace == null ? this.nameTable.createName(encodedPropertyName) : this.nameTable.createName("omp:" + encodedPropertyName, encodedPropertyNamespace);
        this._runtimeOutputMethod.setSpecifiedValue(name, value, null);
    }

    public String getOutputMethodProperty(String encodedPropertyNamespace, String encodedPropertyName) {
        OutputMethodImpl om = this._runtimeOutputMethod == null ? this._outputMethod : this._runtimeOutputMethod;
        Name name = encodedPropertyNamespace == null ? this.nameTable.createName(encodedPropertyName) : this.nameTable.createName("omp:" + encodedPropertyName, encodedPropertyNamespace);
        return om.getSpecifiedValue(name);
    }

    public Result process(Node node, XMLProcessor omBuilder, ParameterSet params, Result root) throws XSLException {
        root.start(this._runtimeOutputMethod == null ? this._outputMethod : this._runtimeOutputMethod);
        ProcessContextImpl pci = new ProcessContextImpl(this, node, omBuilder, params);
        pci.processSafe(node, null, root);
        root.end();
        return root;
    }

    private void parseSheet(Node rootNode) throws XSLException, IOException {
        if (rootNode == null) {
            throw new XSLException("null document rootNode");
        }
        Node sheetNode = rootNode.getChildren().next();
        if (sheetNode == null) {
            throw new XSLException("no root element");
        }
        if ("http://www.w3.org/1999/XSL/Transform".equals(sheetNode.getName().getNamespace())) {
            if (!this.XSL_STYLESHEET.equals(sheetNode.getName()) && !this.XSL_TRANSFORM.equals(sheetNode.getName())) {
                throw new XSLException("bad document element for stylesheet", sheetNode);
            }
            this.parseTopLevel(sheetNode);
        } else {
            this.parseRootTemplate(rootNode);
        }
        this.currentImportance.set(this.importCount);
        this.templateRules.compile();
        Enumeration iter = this.modeTable.elements();
        while (iter.hasMoreElements()) {
            ((TemplateRuleSet)iter.nextElement()).compile();
        }
    }

    private Vector getExcludedNamespaces(Node node) throws XSLException {
        String prefix;
        String prefixList = node.getAttributeValue(this.EXCLUDE_RESULT_PREFIXES);
        if (prefixList == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        StringTokenizer iter = new StringTokenizer(prefixList);
        while (iter.hasMoreElements() && (prefix = (String)iter.nextElement()) != null) {
            v.addElement(this.getPrefixNamespace(node, prefix));
        }
        if (v.size() == 0) {
            return null;
        }
        return v;
    }

    String getPrefixNamespace(Node node, String prefix) throws XSLException {
        NamespacePrefixMap map = node.getNamespacePrefixMap();
        String ns = map.getNamespace(prefix);
        if (ns == null) {
            if (prefix.equals("#default")) {
                ns = map.getDefaultNamespace();
            }
            if (ns == null) {
                throw new XSLException("undefined prefix", node);
            }
        }
        return ns;
    }

    void parseTopLevel(Node sheetNode) throws XSLException, IOException {
        Node node;
        Vector saveExcludedNamespaces = this.excludedNamespaces;
        this.excludedNamespaces = this.getExcludedNamespaces(sheetNode);
        SafeNodeIterator iter = sheetNode.getChildren();
        while ((node = iter.next()) != null) {
            TopLevelParser parser = null;
            try {
                Name name = node.getName();
                if (name == null) {
                    throw new XSLException("illegal data characters inside xsl:stylesheet", node);
                }
                parser = (TopLevelParser)this.topLevelTable.get(name);
                if (parser == null && name.getNamespace() == null) {
                    throw new XSLException("illegal top-level element", node);
                }
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            if (parser == null) continue;
            parser.parse(node);
        }
        this.excludedNamespaces = saveExcludedNamespaces;
    }

    private void parseRootTemplate(Node defNode) throws XSLException {
        this.templateRules.add(ExprParser.parsePattern(defNode, "/"), this.currentImportance, null, this.parseActions(defNode, emptyAction));
    }

    Action parseAttributesAndActions(Node node) throws XSLException {
        Node att;
        AppendAction sequence = this.parseUseAttributeSets(node, true, null);
        SafeNodeIterator iter = node.getAttributes();
        while ((att = iter.next()) != null) {
            if (sequence == null) {
                sequence = this._debugger != null ? new AppendActionDebug(this._debugger, node, "") : new AppendAction();
            }
            String value = att.getData();
            Name name = att.getName();
            if ("http://www.w3.org/1999/XSL/Transform".equals(name.getNamespace())) continue;
            if (value.indexOf(123) >= 0 || value.indexOf(125) >= 0) {
                sequence.add(new TemplateAttributeAction(name, ExprParser.parseValueExpr(node, value, this.currentLocalVariables)));
                continue;
            }
            sequence.add(new LiteralAttributeAction(name, value));
        }
        return this.parseActions(node, null, sequence);
    }

    Action parseUseAttributeSetsAndActions(Node node) throws XSLException {
        return this.parseActions(node, emptyAction, this.parseUseAttributeSets(node, false, null));
    }

    AppendAction parseUseAttributeSets(Node node, boolean literal, AppendAction sequence) throws XSLException {
        String value = node.getAttributeValue(literal ? this.XSL_USE_ATTRIBUTE_SETS : this.USE_ATTRIBUTE_SETS);
        if (value != null) {
            StringTokenizer iter = new StringTokenizer(value);
            while (iter.hasMoreElements()) {
                if (sequence == null) {
                    sequence = new AppendAction();
                }
                sequence.add(new UseAttributeSetAction(SheetImpl.expandSourceElementTypeName((String)iter.nextElement(), node)));
            }
        }
        return sequence;
    }

    Action parseActions(Node node, Action ifEmpty) throws XSLException {
        return this.parseActions(node, ifEmpty, null);
    }

    Action parseActions(Node node, Action ifEmpty, AppendAction sequence) throws XSLException {
        VariableSet startLocalVariables = this.currentLocalVariables;
        int nStartLocalVariables = this.nCurrentLocalVariables;
        SafeNodeIterator iter = node.getChildren();
        if ((node = iter.next()) == null) {
            if (sequence == null) {
                return ifEmpty;
            }
            return sequence;
        }
        if (sequence == null) {
            sequence = this._debugger != null ? new AppendActionDebug(this._debugger, node, "") : new AppendAction();
        }
        block6: do {
            switch (node.getType()) {
                case 1: {
                    if (this._debugger != null) {
                        sequence.add(new CharsActionDebug(this._debugger, node, "", node.getData()));
                        break;
                    }
                    sequence.add(new CharsAction(node.getData()));
                    break;
                }
                case 0: {
                    Name name = node.getName();
                    String ns = name.getNamespace();
                    if (!("http://www.w3.org/1999/XSL/Transform".equals(ns) || "http://www.jclark.com/xt".equals(ns) || "http://www.blnz.com/namespaces/xx".equals(ns))) {
                        if (this._debugger != null) {
                            sequence.add(new LiteralElementActionDebug(this._debugger, node, "", node.getName(), this.literalNamespacePrefixMap(node), this.parseAttributesAndActions(node)));
                            break;
                        }
                        sequence.add(new LiteralElementAction(node.getName(), this.literalNamespacePrefixMap(node), this.parseAttributesAndActions(node)));
                        break;
                    }
                    ActionParser actionParser = null;
                    try {
                        actionParser = (ActionParser)this.actionTable.get(name);
                    }
                    catch (ClassCastException e) {
                        // empty catch block
                    }
                    if (actionParser == null) {
                        if (name.equals(this.XSL_SORT) && this.XSL_FOR_EACH.equals(node.getParent().getName()) || name.equals(this.XSL_FALLBACK)) continue block6;
                        throw new XSLException("expected action not " + name, node);
                    }
                    sequence.add(actionParser.parse(node));
                }
            }
        } while ((node = iter.next()) != null);
        if (nStartLocalVariables != this.nCurrentLocalVariables) {
            sequence.add(new UnbindLocalVariablesAction(this.nCurrentLocalVariables - nStartLocalVariables));
            this.nCurrentLocalVariables = nStartLocalVariables;
            this.currentLocalVariables = startLocalVariables;
        }
        return sequence;
    }

    String getRequiredAttribute(Node node, Name name) throws XSLException {
        String value = node.getAttributeValue(name);
        if (value == null) {
            throw new XSLException("missing attribute \"" + name + "\"", node);
        }
        return value;
    }

    String getOptionalAttribute(Node node, Name name, String dflt) {
        String value = node.getAttributeValue(name);
        return value == null ? dflt : value;
    }

    String getData(Node node) throws XSLException {
        if ((node = node.getChildren().next()) == null) {
            return "";
        }
        String data = node.getData();
        if (data == null) {
            throw new XSLException("only character data allowed", node);
        }
        return data;
    }

    NumberListFormatTemplate getNumberListFormatTemplate(Node node) throws XSLException {
        NumberListFormatTemplate t = new NumberListFormatTemplate();
        String value = node.getAttributeValue(this.FORMAT);
        if (value != null) {
            StringExpr expr = ExprParser.parseValueExpr(node, value, this.currentLocalVariables);
            String format = expr.constantValue();
            if (format != null) {
                t.setFormat(format);
            } else {
                t.setFormat(expr);
            }
        }
        if ((value = node.getAttributeValue(this.LANG)) != null) {
            t.setLang(value);
        }
        if ((value = node.getAttributeValue(this.LETTER_VALUE)) != null) {
            t.setLetterValue(value);
        }
        if ((value = node.getAttributeValue(this.GROUPING_SIZE)) != null) {
            try {
                t.setGroupingSize(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((value = node.getAttributeValue(this.GROUPING_SEPARATOR)) != null) {
            t.setGroupingSeparator(value);
        }
        return t;
    }

    Action addParams(ParamAction action, Node node) throws XSLException {
        SafeNodeIterator iter = node.getChildren();
        while ((node = iter.next()) != null) {
            if (!this.XSL_WITH_PARAM.equals(node.getName())) continue;
            action.addParam(SheetImpl.expandSourceElementTypeName(this.getRequiredAttribute(node, this.NAME), node), this.getVariantExpr(node));
        }
        return action;
    }

    NodeSetExpr getSortNodeSetExpr(Node node, NodeSetExpr expr) throws XSLException {
        ComparatorTemplate comparatorTemplate = null;
        SafeNodeIterator iter = node.getChildren();
        while ((node = iter.next()) != null) {
            Comparator cmp;
            if (!this.XSL_SORT.equals(node.getName())) continue;
            Locale locale = Lang.getLocale(node.getAttributeValue(this.LANG));
            String dataType = node.getAttributeValue(this.DATA_TYPE);
            if ("number".equals(dataType)) {
                cmp = new NumberComparator();
            } else {
                int caseOrder = 0;
                String caseOrderString = node.getAttributeValue(this.CASE_ORDER);
                if ("upper-first".equals(caseOrderString)) {
                    caseOrder = 1;
                } else if ("lower-first".equals(caseOrderString)) {
                    caseOrder = 2;
                }
                cmp = TextComparator.create(locale, caseOrder);
            }
            if ("descending".equals(node.getAttributeValue(this.ORDER))) {
                cmp = new ReverseComparator(cmp);
            }
            NodeComparatorTemplate templ = new NodeComparatorTemplate(cmp, ExprParser.parseStringExpr(node, this.getOptionalAttribute(node, this.SELECT, "."), this.currentLocalVariables));
            if (comparatorTemplate == null) {
                comparatorTemplate = templ;
                continue;
            }
            comparatorTemplate = new BilevelComparatorTemplate(comparatorTemplate, templ);
        }
        if (comparatorTemplate == null) {
            return expr;
        }
        return new SortNodeSetExpr(expr, comparatorTemplate);
    }

    VariantExpr getVariantExpr(Node defNode) throws XSLException {
        String expr = defNode.getAttributeValue(this.SELECT);
        if (defNode.getChildren().next() == null) {
            if (expr == null) {
                expr = "\"\"";
            }
        } else {
            if (expr != null) {
                throw new XSLException("non-empty content with select attribute", defNode);
            }
            return new ResultFragmentExpr(this.parseActions(defNode, emptyAction), defNode, this.extensionHandler);
        }
        return ExprParser.parseVariantExpr(defNode, expr, this.currentLocalVariables);
    }

    public TemplateRuleSet getModeTemplateRuleSet(Name modeName) {
        if (modeName == null) {
            return this.templateRules;
        }
        TemplateRuleSet ruleSet = (TemplateRuleSet)this.modeTable.get(modeName);
        if (ruleSet == null) {
            ruleSet = new TemplateRuleSet(new BuiltinAction(modeName));
            this.modeTable.put(modeName, ruleSet);
        }
        return ruleSet;
    }

    public KeyDefinition getKeyDefinition(Name keyName) {
        return (KeyDefinition)this.keysDefinitionsTable.get(keyName);
    }

    private Name xsl(String name) {
        return this.nameTable.createName("xsl:" + name, "http://www.w3.org/1999/XSL/Transform");
    }

    private Name exsl(String name) {
        return this.nameTable.createName("exsl:" + name, "http://exslt.org/common");
    }

    private Name func(String name) {
        return this.nameTable.createName("func:" + name, "http://exslt.org/functions");
    }

    private Name regexp(String name) {
        return this.nameTable.createName("regexp:" + name, "http://exslt.org/regular-expressions");
    }

    private Name xt(String name) {
        return this.nameTable.createName("xt:" + name, "http://www.jclark.com/xt");
    }

    private Name xfyxt(String name) {
        return this.nameTable.createName("xfyxt:" + name, "http://www.blnz.com/namespaces/xx");
    }

    private boolean namespaceExcluded(String ns) {
        if (ns == null) {
            return false;
        }
        if (ns.equals("http://www.w3.org/1999/XSL/Transform") || ns.equals("http://www.jclark.com/xt") || ns.equals("http://www.blnz.com/namespaces/xx")) {
            return true;
        }
        if (this.excludedNamespaces == null) {
            return false;
        }
        int len = this.excludedNamespaces.size();
        for (int i = 0; i < len; ++i) {
            if (!this.excludedNamespaces.elementAt(i).equals(ns)) continue;
            return true;
        }
        return false;
    }

    private NamespacePrefixMap literalNamespacePrefixMap(Node node) {
        NamespacePrefixMap map;
        NamespacePrefixMap newMap = map = node.getNamespacePrefixMap();
        String ns = map.getDefaultNamespace();
        if (this.namespaceExcluded(ns)) {
            newMap = newMap.unbindDefault();
        }
        int size = map.getSize();
        for (int i = 0; i < size; ++i) {
            ns = map.getNamespace(i);
            if (!this.namespaceExcluded(ns)) continue;
            newMap = newMap.unbind(map.getPrefix(i));
        }
        return newMap;
    }

    static Name expandSourceElementTypeName(String nameString, Node node) throws XSLException {
        if (node == null) {
            throw new XSLException("no node for prefix map");
        }
        NamespacePrefixMap pm = node.getNamespacePrefixMap();
        if (pm == null) {
            throw new XSLException("no prefix map");
        }
        Name n = pm.expandAttributeName(nameString, node);
        if (n == null) {
            throw new XSLException("no name for {" + nameString + "}");
        }
        return node.getNamespacePrefixMap().expandAttributeName(nameString, node);
    }

    public LoadContext getSourceLoadContext() {
        return this;
    }

    public boolean getStripSource(Name elementTypeName) {
        ImportantBoolean ib;
        ImportantBoolean ib2;
        String ns;
        ImportantBoolean match = this.stripSource;
        if (this.stripSourceNamespaceTable != null && (ns = elementTypeName.getNamespace()) != null && (ib2 = (ImportantBoolean)this.stripSourceNamespaceTable.get(ns)) != null && (match == null || ib2.getImportance().compareTo(match.getImportance()) >= 0)) {
            match = ib2;
        }
        if (this.stripSourceElementTable != null && (ib = (ImportantBoolean)this.stripSourceElementTable.get(elementTypeName)) != null && (match == null || ib.getImportance().compareTo(match.getImportance()) >= 0)) {
            match = ib;
        }
        return match != null ? match.getBoolean() : false;
    }

    public boolean getIncludeComments() {
        return true;
    }

    public boolean getIncludeProcessingInstructions() {
        return true;
    }

    public VariableInfo getGlobalVariableInfo(Name name) {
        return (VariableInfo)this.variableInfoTable.get(name);
    }

    public Variant getSystemProperty(Name name) {
        if (name.equals(this.XSL_VERSION)) {
            return new NumberVariant(1.0);
        }
        if (name.equals(this.XSL_VENDOR)) {
            return new StringVariant("James Clark");
        }
        if (name.equals(this.XSL_VENDOR_URL)) {
            return new StringVariant("http://www.jclark.com/");
        }
        return emptyStringVariant;
    }

    public ExtensionContext createExtensionContext(String namespace) throws XSLException {
        return this.extensionHandler.createContext(namespace);
    }

    public Action getAttributeSet(Name name) {
        return (Action)this.attributeSetTable.get(name);
    }

    public boolean haveNamespaceAliases() {
        return this.namespaceAliasTable.size() != 0;
    }

    public String getNamespaceAlias(String ns) {
        if (ns == null) {
            return null;
        }
        return (String)this.namespaceAliasTable.get(ns);
    }

    private class OutputMethodImpl
    implements OutputMethod,
    Cloneable {
        private Name _outputMethodName = null;
        private Name[] _outputMethodAttNames;
        private String[] _outputMethodAttValues;
        private Vector _outputCdataSectionElements;

        private OutputMethodImpl() {
            this._outputMethodAttNames = new Name[]{SheetImpl.this.DOCTYPE_PUBLIC, SheetImpl.this.DOCTYPE_SYSTEM, SheetImpl.this.ENCODING, SheetImpl.this.INDENT, SheetImpl.this.MEDIA_TYPE, SheetImpl.this.OMIT_XML_DECLARATION, SheetImpl.this.STANDALONE, SheetImpl.this.VERSION};
            this._outputMethodAttValues = new String[]{null, null, null, null, null, null, null, null};
            this._outputCdataSectionElements = new Vector();
        }

        OutputMethod mergeCopy(Node node) throws XSLException {
            SafeNodeIterator iter = node.getAttributes();
            if (iter.next() != null && iter.next() == null) {
                return this;
            }
            OutputMethodImpl om = (OutputMethodImpl)this.clone();
            om.merge(node);
            return om;
        }

        public Object clone() {
            try {
                OutputMethodImpl om = (OutputMethodImpl)super.clone();
                om._outputCdataSectionElements = (Vector)this._outputCdataSectionElements.clone();
                om._outputMethodAttValues = (String[])this._outputMethodAttValues.clone();
                return om;
            }
            catch (CloneNotSupportedException e) {
                throw new Error("unexpected CloneNotSupportedException");
            }
        }

        void merge(Node node) throws XSLException {
            Node att;
            SafeNodeIterator iter = node.getAttributes();
            while ((att = iter.next()) != null) {
                Name name = att.getName();
                String value = att.getData();
                this.setSpecifiedValue(name, value, node);
            }
        }

        public Name getName() {
            return this._outputMethodName;
        }

        public String getSpecifiedValue(Name name) {
            for (int i = 0; i < this._outputMethodAttNames.length; ++i) {
                if (!this._outputMethodAttNames[i].equals(name)) continue;
                return this._outputMethodAttValues[i];
            }
            return null;
        }

        public void setSpecifiedValue(Name name, String value, Node node) throws XSLException {
            if (!SheetImpl.this.HREF.equals(name)) {
                if (SheetImpl.this.METHOD.equals(name)) {
                    if (node != null) {
                        this._outputMethodName = node.getNamespacePrefixMap().expandAttributeName(value, node);
                    }
                } else if (SheetImpl.this.CDATA_SECTION_ELEMENTS.equals(name)) {
                    StringTokenizer t = new StringTokenizer(value);
                    if (node != null) {
                        NamespacePrefixMap nsm = node.getNamespacePrefixMap();
                        while (t.hasMoreElements()) {
                            String elQnm = (String)t.nextElement();
                            Name cdataElNm = nsm.expandAttributeName(elQnm, node);
                            this._outputCdataSectionElements.addElement(cdataElNm);
                        }
                    }
                } else {
                    for (int i = 0; i < this._outputMethodAttNames.length; ++i) {
                        if (!this._outputMethodAttNames[i].equals(name)) continue;
                        this._outputMethodAttValues[i] = value;
                        return;
                    }
                    int len = this._outputMethodAttNames.length;
                    Name[] newNames = new Name[len + 1];
                    String[] newVals = new String[len + 1];
                    System.arraycopy(this._outputMethodAttNames, 0, newNames, 0, len);
                    System.arraycopy(this._outputMethodAttValues, 0, newVals, 0, len);
                    newNames[len] = name;
                    newVals[len] = value;
                    this._outputMethodAttNames = newNames;
                    this._outputMethodAttValues = newVals;
                }
            }
        }

        public Name[] getAttributeNames() {
            return this._outputMethodAttNames;
        }

        private String getDefaultValue(Name name) {
            if (SheetImpl.this.METHOD.equals(name)) {
                return "xml";
            }
            if ("xml".equals(this.getPropertyValue(SheetImpl.this.METHOD))) {
                if (!(SheetImpl.this.DOCTYPE_PUBLIC.equals(name) || SheetImpl.this.DOCTYPE_SYSTEM.equals(name) || SheetImpl.this.ENCODING.equals(name) || SheetImpl.this.INDENT.equals(name) || SheetImpl.this.MEDIA_TYPE.equals(name))) {
                    if (SheetImpl.this.OMIT_XML_DECLARATION.equals(name)) {
                        return "no";
                    }
                    if (SheetImpl.this.STANDALONE.equals(name)) {
                        return "no";
                    }
                    if (SheetImpl.this.VERSION.equals(name)) {
                        return "1.0";
                    }
                    return null;
                }
            } else if ("html".equals(this.getPropertyValue(SheetImpl.this.METHOD))) {
                if (!(SheetImpl.this.DOCTYPE_PUBLIC.equals(name) || SheetImpl.this.DOCTYPE_SYSTEM.equals(name) || SheetImpl.this.ENCODING.equals(name) || SheetImpl.this.INDENT.equals(name) || SheetImpl.this.MEDIA_TYPE.equals(name))) {
                    if (SheetImpl.this.OMIT_XML_DECLARATION.equals(name)) {
                        return "no";
                    }
                    if (SheetImpl.this.STANDALONE.equals(name)) {
                        return "no";
                    }
                    if (SheetImpl.this.VERSION.equals(name)) {
                        return "1.0";
                    }
                    return null;
                }
            } else if ("text".equals(this.getPropertyValue(SheetImpl.this.METHOD))) {
                if (!(SheetImpl.this.DOCTYPE_PUBLIC.equals(name) || SheetImpl.this.DOCTYPE_SYSTEM.equals(name) || SheetImpl.this.ENCODING.equals(name) || SheetImpl.this.INDENT.equals(name) || SheetImpl.this.MEDIA_TYPE.equals(name))) {
                    if (SheetImpl.this.OMIT_XML_DECLARATION.equals(name)) {
                        return "no";
                    }
                    if (SheetImpl.this.STANDALONE.equals(name)) {
                        return "no";
                    }
                    if (SheetImpl.this.VERSION.equals(name)) {
                        return "1.0";
                    }
                    return null;
                }
            } else if ("java".equals(this.getPropertyValue(SheetImpl.this.METHOD))) {
                if (!(SheetImpl.this.DOCTYPE_PUBLIC.equals(name) || SheetImpl.this.DOCTYPE_SYSTEM.equals(name) || SheetImpl.this.ENCODING.equals(name) || SheetImpl.this.INDENT.equals(name) || SheetImpl.this.MEDIA_TYPE.equals(name))) {
                    if (SheetImpl.this.OMIT_XML_DECLARATION.equals(name)) {
                        return "no";
                    }
                    if (SheetImpl.this.STANDALONE.equals(name)) {
                        return "no";
                    }
                    if (SheetImpl.this.VERSION.equals(name)) {
                        return "1.0";
                    }
                    return null;
                }
            } else if (!(SheetImpl.this.DOCTYPE_PUBLIC.equals(name) || SheetImpl.this.DOCTYPE_SYSTEM.equals(name) || SheetImpl.this.ENCODING.equals(name) || SheetImpl.this.INDENT.equals(name) || SheetImpl.this.MEDIA_TYPE.equals(name))) {
                if (SheetImpl.this.OMIT_XML_DECLARATION.equals(name)) {
                    return "no";
                }
                if (SheetImpl.this.STANDALONE.equals(name)) {
                    return "no";
                }
                if (SheetImpl.this.VERSION.equals(name)) {
                    return "1.0";
                }
                return null;
            }
            return null;
        }

        public String getPropertyValue(Name name) {
            String val = this.getSpecifiedValue(name);
            return val == null ? this.getDefaultValue(name) : val;
        }

        public Name[] getCdataSectionElements() {
            Name[] names = new Name[this._outputCdataSectionElements.size()];
            for (int i = 0; i < names.length; ++i) {
                names[i] = (Name)this._outputCdataSectionElements.elementAt(i);
            }
            return names;
        }

        public NameTable getNameTable() {
            return SheetImpl.this.nameTable;
        }
    }

    private class MessageParser
    implements ActionParser {
        private MessageParser() {
        }

        public Action parse(Node node) throws XSLException {
            boolean terminate = "yes".equals(node.getAttributeValue(SheetImpl.this.TERMINATE));
            Action content = SheetImpl.this.parseActions(node, emptyAction);
            if (terminate) {
                if (SheetImpl.this._debugger != null) {
                    return new TerminateMessageActionDebug(SheetImpl.this._debugger, node, "", content);
                }
                return new TerminateMessageAction(content);
            }
            if (SheetImpl.this._debugger != null) {
                return new MessageActionDebug(SheetImpl.this._debugger, node, "", content);
            }
            return new MessageAction(content);
        }
    }

    private class ParamActionParser
    extends VariableActionParser {
        private ParamActionParser() {
        }

        Action makeAction(Node node, Name name, VariantExpr expr) {
            if (SheetImpl.this._debugger != null) {
                return new BindLocalParamActionDebug(SheetImpl.this._debugger, node, "", name, expr);
            }
            return new BindLocalParamAction(name, expr);
        }
    }

    private class VariableActionParser
    implements ActionParser {
        private VariableActionParser() {
        }

        public Action parse(Node node) throws XSLException {
            Name name = SheetImpl.expandSourceElementTypeName(SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.NAME), node);
            VariantExpr expr = SheetImpl.this.getVariantExpr(node);
            SheetImpl.this.currentLocalVariables = new AddVariableSet(name, SheetImpl.this.currentLocalVariables);
            ++SheetImpl.this.nCurrentLocalVariables;
            return this.makeAction(node, name, expr);
        }

        Action makeAction(Node node, Name name, VariantExpr expr) {
            if (SheetImpl.this._debugger != null) {
                return new BindLocalVariableActionDebug(SheetImpl.this._debugger, node, "", name, expr);
            }
            return new BindLocalVariableAction(name, expr);
        }
    }

    private class ApplyImportsParser
    implements ActionParser {
        private ApplyImportsParser() {
        }

        public Action parse(Node node) throws XSLException {
            if (SheetImpl.this._debugger != null) {
                return new ApplyImportsActionDebug(SheetImpl.this._debugger, node, "");
            }
            return new ApplyImportsAction();
        }
    }

    private class EXSLFunctionResultParser
    implements ActionParser {
        private EXSLFunctionResultParser() {
        }

        public Action parse(Node node) throws XSLException {
            VariantExpr expr = SheetImpl.this.getVariantExpr(node);
            return null;
        }
    }

    private class NumberParser
    implements ActionParser {
        private NumberParser() {
        }

        public Action parse(Node node) throws XSLException {
            NumberListFormatTemplate format = SheetImpl.this.getNumberListFormatTemplate(node);
            String value = node.getAttributeValue(SheetImpl.this.VALUE);
            if (value != null) {
                return new ExprNumberAction(ExprParser.parseNumberExpr(node, value, SheetImpl.this.currentLocalVariables), format);
            }
            String level = SheetImpl.this.getOptionalAttribute(node, SheetImpl.this.LEVEL, "single");
            String countString = node.getAttributeValue(SheetImpl.this.COUNT);
            TopLevelPattern count = countString == null ? null : ExprParser.parsePattern(node, countString, SheetImpl.this.currentLocalVariables);
            String fromString = node.getAttributeValue(SheetImpl.this.FROM);
            TopLevelPattern from = fromString == null ? null : ExprParser.parsePattern(node, fromString, SheetImpl.this.currentLocalVariables);
            if (level.equals("any")) {
                if (SheetImpl.this._debugger != null) {
                    return new AnyLevelNumberActionDebug(SheetImpl.this._debugger, node, "", count, from, format);
                }
                return new AnyLevelNumberAction(count, from, format);
            }
            if (level.equals("multiple")) {
                if (SheetImpl.this._debugger != null) {
                    return new MultiLevelNumberActionDebug(SheetImpl.this._debugger, node, "", count, from, format);
                }
                return new MultiLevelNumberAction(count, from, format);
            }
            if (level.equals("single")) {
                if (SheetImpl.this._debugger != null) {
                    return new SingleLevelNumberActionDebug(SheetImpl.this._debugger, node, "", count, from, format);
                }
                return new SingleLevelNumberAction(count, from, format);
            }
            throw new XSLException("bad level", node);
        }
    }

    private class ValueOfParser
    implements ActionParser {
        private ValueOfParser() {
        }

        public Action parse(Node node) throws XSLException {
            StringExpr expr = ExprParser.parseStringExpr(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.SELECT), SheetImpl.this.currentLocalVariables);
            if ("yes".equals(node.getAttributeValue(SheetImpl.this.DISABLE_OUTPUT_ESCAPING))) {
                if (SheetImpl.this._debugger != null) {
                    return new RawValueOfActionDebug(SheetImpl.this._debugger, node, "", expr);
                }
                return new RawValueOfAction(expr);
            }
            if (SheetImpl.this._debugger != null) {
                return new ValueOfActionDebug(SheetImpl.this._debugger, node, "", expr);
            }
            return new ValueOfAction(expr);
        }
    }

    private class TextParser
    implements ActionParser {
        private TextParser() {
        }

        public Action parse(Node node) throws XSLException {
            Node child = node.getChildren().next();
            if (child != null) {
                String data = child.getData();
                if (data == null || child.getFollowingSiblings().next() != null) {
                    throw new XSLException("xsl:text must not contain elements", node);
                }
                if ("yes".equals(node.getAttributeValue(SheetImpl.this.DISABLE_OUTPUT_ESCAPING))) {
                    if (SheetImpl.this._debugger != null) {
                        return new RawCharsActionDebug(SheetImpl.this._debugger, node, "", data);
                    }
                    return new RawCharsAction(data);
                }
                if (SheetImpl.this._debugger != null) {
                    return new CharsActionDebug(SheetImpl.this._debugger, node, "", data);
                }
                return new CharsAction(data);
            }
            return emptyAction;
        }
    }

    private class ChooseParser
    extends IfParser {
        private ChooseParser() {
        }

        public Action parse(Node node) throws XSLException {
            return this.parseChoices(node.getChildren());
        }

        public Action parseChoices(NodeIterator iter) throws XSLException {
            Node node = iter.next();
            if (node == null) {
                return emptyAction;
            }
            Name name = node.getName();
            if (SheetImpl.this.XSL_WHEN.equals(name)) {
                if (SheetImpl.this._debugger != null) {
                    return new IfActionDebug(SheetImpl.this._debugger, node, "", this.makeCondition(node), SheetImpl.this.parseActions(node, emptyAction), this.parseChoices(iter));
                }
                return new IfAction(this.makeCondition(node), SheetImpl.this.parseActions(node, emptyAction), this.parseChoices(iter));
            }
            if (SheetImpl.this.XSL_OTHERWISE.equals(name)) {
                Node next = iter.next();
                if (next != null) {
                    throw new XSLException("unexpected element after otherwise", next);
                }
                return SheetImpl.this.parseActions(node, emptyAction);
            }
            throw new XSLException("expected when or otherwise", node);
        }
    }

    private class CallTemplateParser
    implements ActionParser {
        private CallTemplateParser() {
        }

        public Action parse(Node node) throws XSLException {
            InvokeAction callAction = SheetImpl.this._debugger != null ? new InvokeActionDebug(SheetImpl.this._debugger, node, "", SheetImpl.expandSourceElementTypeName(SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.NAME), node), SheetImpl.this.namedTemplateTable) : new InvokeAction(SheetImpl.expandSourceElementTypeName(SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.NAME), node), SheetImpl.this.namedTemplateTable);
            return SheetImpl.this.addParams(callAction, node);
        }
    }

    private class XRAPParser
    implements ActionParser {
        private XRAPParser() {
        }

        public Action parse(Node node) throws XSLException {
            if (SheetImpl.this._debugger != null) {
                return new XRAPActionDebug(SheetImpl.this._debugger, node, "", node.getNamespacePrefixMap(), SheetImpl.this.parseActions(node, emptyAction));
            }
            return new XRAPAction(node.getNamespacePrefixMap(), SheetImpl.this.parseActions(node, emptyAction));
        }
    }

    private class DocumentParser
    implements ActionParser {
        private DocumentParser() {
        }

        public Action parse(Node node) throws XSLException {
            return new DocumentAction(ExprParser.parseValueExpr(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.HREF), SheetImpl.this.currentLocalVariables), SheetImpl.this._outputMethod.mergeCopy(node), SheetImpl.this.parseActions(node, emptyAction));
        }
    }

    private class AttributeParser
    extends ElementParser {
        private AttributeParser() {
        }

        public Action parse(Node node) throws XSLException {
            if (SheetImpl.this._debugger != null) {
                return new AttributeActionDebug(SheetImpl.this._debugger, node, "", ExprParser.parseValueExpr(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.NAME), SheetImpl.this.currentLocalVariables), this.getNamespaceExpr(node), node.getNamespacePrefixMap(), SheetImpl.this.parseActions(node, emptyAction));
            }
            return new AttributeAction(ExprParser.parseValueExpr(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.NAME), SheetImpl.this.currentLocalVariables), this.getNamespaceExpr(node), node.getNamespacePrefixMap(), SheetImpl.this.parseActions(node, emptyAction));
        }
    }

    private class ElementParser
    implements ActionParser {
        private ElementParser() {
        }

        public Action parse(Node node) throws XSLException {
            if (SheetImpl.this._debugger != null) {
                return new ElementActionDebug(SheetImpl.this._debugger, node, "", ExprParser.parseValueExpr(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.NAME), SheetImpl.this.currentLocalVariables), this.getNamespaceExpr(node), node.getNamespacePrefixMap(), SheetImpl.this.parseUseAttributeSetsAndActions(node));
            }
            return new ElementAction(ExprParser.parseValueExpr(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.NAME), SheetImpl.this.currentLocalVariables), this.getNamespaceExpr(node), node.getNamespacePrefixMap(), SheetImpl.this.parseUseAttributeSetsAndActions(node));
        }

        StringExpr getNamespaceExpr(Node node) throws XSLException {
            String namespace = node.getAttributeValue(SheetImpl.this.NAMESPACE);
            if (namespace == null) {
                return null;
            }
            return ExprParser.parseValueExpr(node, namespace, SheetImpl.this.currentLocalVariables);
        }
    }

    private class ProcessingInstructionParser
    implements ActionParser {
        private ProcessingInstructionParser() {
        }

        public Action parse(Node node) throws XSLException {
            if (SheetImpl.this._debugger != null) {
                return new ProcessingInstructionActionDebug(SheetImpl.this._debugger, node, "", ExprParser.parseValueExpr(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.NAME), SheetImpl.this.currentLocalVariables), SheetImpl.this.parseActions(node, emptyAction));
            }
            return new ProcessingInstructionAction(ExprParser.parseValueExpr(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.NAME), SheetImpl.this.currentLocalVariables), SheetImpl.this.parseActions(node, emptyAction));
        }
    }

    private class CommentParser
    implements ActionParser {
        private CommentParser() {
        }

        public Action parse(Node node) throws XSLException {
            if (SheetImpl.this._debugger != null) {
                return new CommentActionDebug(SheetImpl.this._debugger, node, "", SheetImpl.this.parseActions(node, emptyAction));
            }
            return new CommentAction(SheetImpl.this.parseActions(node, emptyAction));
        }
    }

    private class CopyOfParser
    implements ActionParser {
        private CopyOfParser() {
        }

        public Action parse(Node node) throws XSLException {
            if (SheetImpl.this._debugger != null) {
                return new CopyOfActionDebug(SheetImpl.this._debugger, node, "", ExprParser.parseVariantExpr(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.SELECT), SheetImpl.this.currentLocalVariables));
            }
            return new CopyOfAction(ExprParser.parseVariantExpr(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.SELECT), SheetImpl.this.currentLocalVariables));
        }
    }

    private class CopyParser
    implements ActionParser {
        private CopyParser() {
        }

        public Action parse(Node node) throws XSLException {
            if (SheetImpl.this._debugger != null) {
                return new CopyActionDebug(SheetImpl.this._debugger, node, "", SheetImpl.this.parseUseAttributeSetsAndActions(node));
            }
            return new CopyAction(SheetImpl.this.parseUseAttributeSetsAndActions(node));
        }
    }

    private class IfParser
    implements ActionParser {
        private IfParser() {
        }

        public Action parse(Node node) throws XSLException {
            if (SheetImpl.this._debugger != null) {
                return new IfActionDebug(SheetImpl.this._debugger, node, "", this.makeCondition(node), SheetImpl.this.parseActions(node, emptyAction), emptyAction);
            }
            return new IfAction(this.makeCondition(node), SheetImpl.this.parseActions(node, emptyAction), emptyAction);
        }

        BooleanExpr makeCondition(Node node) throws XSLException {
            return ExprParser.parseBooleanExpr(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.TEST), SheetImpl.this.currentLocalVariables);
        }
    }

    private class ForEachParser
    implements ActionParser {
        private ForEachParser() {
        }

        public Action parse(Node node) throws XSLException {
            if (SheetImpl.this._debugger != null) {
                return new ForEachActionDebug(SheetImpl.this._debugger, node, "", SheetImpl.this.getSortNodeSetExpr(node, ExprParser.parseNodeSetExpr(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.SELECT), SheetImpl.this.currentLocalVariables)), SheetImpl.this.parseActions(node, emptyAction));
            }
            return new ForEachAction(SheetImpl.this.getSortNodeSetExpr(node, ExprParser.parseNodeSetExpr(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.SELECT), SheetImpl.this.currentLocalVariables)), SheetImpl.this.parseActions(node, emptyAction));
        }
    }

    private class ApplyTemplatesParser
    implements ActionParser {
        private ApplyTemplatesParser() {
        }

        public Action parse(Node node) throws XSLException {
            NodeSetExpr expr = SheetImpl.this.getSortNodeSetExpr(node, this.getNodeSetExpr(node));
            String modeString = node.getAttributeValue(SheetImpl.this.MODE);
            Name modeName = null;
            if (modeString != null) {
                modeName = SheetImpl.expandSourceElementTypeName(modeString, node);
            }
            if (SheetImpl.this._debugger != null) {
                return SheetImpl.this.addParams(new ProcessActionDebug(SheetImpl.this._debugger, node, "", expr, modeName), node);
            }
            return SheetImpl.this.addParams(new ProcessAction(expr, modeName), node);
        }

        NodeSetExpr getNodeSetExpr(Node node) throws XSLException {
            String select = node.getAttributeValue(SheetImpl.this.SELECT);
            if (select == null) {
                return childrenExpr;
            }
            return ExprParser.parseNodeSetExpr(node, select, SheetImpl.this.currentLocalVariables);
        }
    }

    private static interface ActionParser {
        public Action parse(Node var1) throws XSLException;
    }

    private class NamespaceAliasParser
    implements TopLevelParser {
        private NamespaceAliasParser() {
        }

        public void parse(Node node) throws XSLException {
            SheetImpl.this.namespaceAliasTable.put(SheetImpl.this.getPrefixNamespace(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.STYLESHEET_PREFIX)), SheetImpl.this.getPrefixNamespace(node, SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.RESULT_PREFIX)));
        }
    }

    private class OutputParser
    implements TopLevelParser {
        private OutputParser() {
        }

        public void parse(Node node) throws XSLException {
            SheetImpl.this._outputMethod.merge(node);
        }
    }

    private class PreserveSpaceParser
    extends StripSpaceParser {
        private PreserveSpaceParser() {
        }

        public void parse(Node node) throws XSLException {
            this.parse(node, false);
        }
    }

    private class StripSpaceParser
    implements TopLevelParser {
        private StripSpaceParser() {
        }

        public void parse(Node node) throws XSLException {
            this.parse(node, true);
        }

        void parse(Node node, boolean strip) throws XSLException {
            StringTokenizer iter = new StringTokenizer(SheetImpl.this.getRequiredAttribute(node, SheetImpl.this.ELEMENTS));
            ImportantBoolean ib = new ImportantBoolean(strip, SheetImpl.this.currentImportance);
            while (iter.hasMoreElements()) {
                String str = (String)iter.nextElement();
                Name name = SheetImpl.expandSourceElementTypeName(str, node);
                if (name.getLocalPart().equals("*")) {
                    String ns = name.getNamespace();
                    if (ns == null) {
                        SheetImpl.this.stripSource = ib;
                        continue;
                    }
                    if (SheetImpl.this.stripSourceNamespaceTable == null) {
                        SheetImpl.this.stripSourceNamespaceTable = new Hashtable();
                    }
                    SheetImpl.this.stripSourceNamespaceTable.put(ns, ib);
                    continue;
                }
                if (SheetImpl.this.stripSourceElementTable == null) {
                    SheetImpl.this.stripSourceElementTable = new Hashtable();
                }
                SheetImpl.this.stripSourceElementTable.put(name, ib);
            }
        }
    }

    private class EXSLFunctionTopLevelParser
    implements TopLevelParser {
        private EXSLFunctionTopLevelParser() {
        }

        public void parse(Node defNode) throws XSLException {
            this.parse(defNode, false);
        }

        void parse(Node defNode, boolean isParam) throws XSLException {
            SheetImpl.this.userFunctionTable.put(SheetImpl.expandSourceElementTypeName(SheetImpl.this.getRequiredAttribute(defNode, SheetImpl.this.NAME), defNode), new VariableInfo(SheetImpl.this.getVariantExpr(defNode), isParam));
        }
    }

    private class ParamTopLevelParser
    extends VariableTopLevelParser {
        private ParamTopLevelParser() {
        }

        public void parse(Node defNode) throws XSLException {
            this.parse(defNode, true);
        }
    }

    private class VariableTopLevelParser
    implements TopLevelParser {
        private VariableTopLevelParser() {
        }

        public void parse(Node defNode) throws XSLException {
            this.parse(defNode, false);
        }

        void parse(Node defNode, boolean isParam) throws XSLException {
            SheetImpl.this.variableInfoTable.put(SheetImpl.expandSourceElementTypeName(SheetImpl.this.getRequiredAttribute(defNode, SheetImpl.this.NAME), defNode), new VariableInfo(SheetImpl.this.getVariantExpr(defNode), isParam));
        }
    }

    private class DecimalFormatParser
    implements TopLevelParser {
        private DecimalFormatParser() {
        }

        public void parse(Node defNode) throws XSLException {
        }
    }

    private class KeyParser
    implements TopLevelParser {
        private KeyParser() {
        }

        public void parse(Node defNode) throws XSLException {
            String pattern = SheetImpl.this.getRequiredAttribute(defNode, SheetImpl.this.MATCH);
            TopLevelPattern matchPattern = ExprParser.parsePattern(defNode, pattern);
            String name = SheetImpl.this.getRequiredAttribute(defNode, SheetImpl.this.NAME);
            Name expname = SheetImpl.expandSourceElementTypeName(name, defNode);
            String use = SheetImpl.this.getRequiredAttribute(defNode, SheetImpl.this.USE);
            StringExpr useExpr = ExprParser.parseStringExpr(defNode, use, SheetImpl.this.currentLocalVariables);
            KeyDefinition kd = new KeyDefinition(expname, matchPattern, useExpr);
            SheetImpl.this.keysDefinitionsTable.put(expname, kd);
        }
    }

    private class AttributeSetParser
    implements TopLevelParser {
        private AttributeSetParser() {
        }

        public void parse(Node defNode) throws XSLException {
            Node node;
            Name name = SheetImpl.expandSourceElementTypeName(SheetImpl.this.getRequiredAttribute(defNode, SheetImpl.this.NAME), defNode);
            AppendAction action = (AppendAction)SheetImpl.this.attributeSetTable.get(name);
            if (action == null) {
                action = new AppendAction();
                SheetImpl.this.attributeSetTable.put(name, action);
            }
            SheetImpl.this.parseUseAttributeSets(defNode, false, action);
            SafeNodeIterator iter = defNode.getChildren();
            while ((node = iter.next()) != null) {
                if (SheetImpl.this.XSL_ATTRIBUTE.equals(node.getName())) continue;
                throw new XSLException("only xsl:attribute allowed inside xsl:attribute-set", node);
            }
            SheetImpl.this.parseActions(defNode, null, action);
        }
    }

    private class TemplateParser
    implements TopLevelParser {
        private TemplateParser() {
        }

        public void parse(Node defNode) throws XSLException {
            String pattern;
            String name = defNode.getAttributeValue(SheetImpl.this.NAME);
            Action contents = SheetImpl.this.parseActions(defNode, emptyAction);
            if (name != null) {
                SheetImpl.this.namedTemplateTable.put(SheetImpl.expandSourceElementTypeName(name, defNode), contents);
            }
            if ((pattern = defNode.getAttributeValue(SheetImpl.this.MATCH)) == null) {
                return;
            }
            String modeString = defNode.getAttributeValue(SheetImpl.this.MODE);
            TemplateRuleSet ruleSet = modeString != null ? SheetImpl.this.getModeTemplateRuleSet(SheetImpl.expandSourceElementTypeName(modeString, defNode)) : SheetImpl.this.templateRules;
            try {
                ruleSet.add(ExprParser.parsePattern(defNode, pattern), SheetImpl.this.currentImportance, Priority.create(defNode.getAttributeValue(SheetImpl.this.PRIORITY)), contents);
            }
            catch (NumberFormatException e) {
                throw new XSLException("invalid priority", defNode);
            }
        }
    }

    private class ImportParser
    extends IncludeParser {
        private ImportParser() {
        }

        public void parse(Node ruleNode) throws XSLException, IOException {
            Importance oldCurrentImportance = SheetImpl.this.currentImportance;
            SheetImpl.this.currentImportance = Importance.create();
            super.parse(ruleNode);
            SheetImpl.this.currentImportance.set(SheetImpl.this.importCount);
            ++SheetImpl.this.importCount;
            SheetImpl.this.currentImportance = oldCurrentImportance;
        }
    }

    private class IncludeParser
    implements TopLevelParser {
        private IncludeParser() {
        }

        public void parse(Node ruleNode) throws XSLException, IOException {
            Node sheetNode = SheetImpl.this._omBuilder.load(new URL(ruleNode.getURL(), SheetImpl.this.getRequiredAttribute(ruleNode, SheetImpl.this.HREF)), 0, SheetImpl.this.sheetLoadContext, SheetImpl.this.nameTable).getChildren().next();
            if ("http://www.w3.org/1999/XSL/Transform".equals(sheetNode.getName().getNamespace())) {
                if (!SheetImpl.this.XSL_STYLESHEET.equals(sheetNode.getName()) && !SheetImpl.this.XSL_TRANSFORM.equals(sheetNode.getName())) {
                    throw new XSLException("bad document element for stylesheet", sheetNode);
                }
                SheetImpl.this.parseTopLevel(sheetNode);
            } else {
                SheetImpl.this.parseRootTemplate(sheetNode);
            }
        }
    }

    private static interface TopLevelParser {
        public void parse(Node var1) throws XSLException, IOException;
    }
}

