/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax2;

import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.CommentHandler;
import com.jclark.xsl.sax2.OutputMethodDefaulter;
import com.jclark.xsl.sax2.OutputMethodHandler;
import com.jclark.xsl.sax2.OutputMethodProperties;
import com.jclark.xsl.sax2.RawCharactersHandler;
import com.jclark.xsl.sax2.ResultTreeFragment;
import com.jclark.xsl.tr.OutputMethod;
import com.jclark.xsl.tr.Result;
import java.io.IOException;
import java.net.URL;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class ResultBase
implements Result,
Attributes {
    private ContentHandler _contentHandler;
    private CommentHandler _commentHandler;
    ErrorHandler _errorHandler;
    private RawCharactersHandler _rawCharactersHandler;
    OutputMethodHandler _outputMethodHandler;
    private static final int INITIAL_BUF_SIZE = 8192;
    private char[] buf = new char[8192];
    private int bufUsed = 0;
    private Name[] _attributeNames = new Name[10];
    private String[] _attributeValues = new String[10];
    private int _nAttributes = 0;
    private Name pendingElementType;
    private NamespacePrefixMap pendingNamespacePrefixMap;

    ResultBase(OutputMethodHandler outputMethodHandler, ErrorHandler errorHandler) {
        this._outputMethodHandler = outputMethodHandler;
        this._contentHandler = null;
        this._errorHandler = errorHandler;
    }

    ResultBase(ContentHandler contentHandler, ErrorHandler errorHandler) {
        this._outputMethodHandler = null;
        this._errorHandler = errorHandler;
        this.setContentHandler(contentHandler);
    }

    private void setContentHandler(ContentHandler handler) {
        this._contentHandler = handler;
        this._commentHandler = handler instanceof CommentHandler ? (CommentHandler)((Object)handler) : null;
        this._rawCharactersHandler = handler instanceof RawCharactersHandler ? (RawCharactersHandler)((Object)handler) : null;
    }

    public void flush() throws XSLException {
        if (this.pendingElementType != null) {
            this.startElementContent(this.pendingElementType, this.pendingNamespacePrefixMap);
            this.pendingElementType = null;
        } else if (this.bufUsed > 0) {
            try {
                this._contentHandler.characters(this.buf, 0, this.bufUsed);
                this.bufUsed = 0;
            }
            catch (SAXException e) {
                this.throwXSLException(e);
            }
        }
    }

    public void rawCharacters(String str) throws XSLException {
        if (this._rawCharactersHandler == null) {
            this.processingInstruction("javax.xml.transform.disable-output-escaping", "");
            this.characters(str);
            this.processingInstruction("javax.xml.transform.enable-output-escaping", "");
        } else {
            this.flush();
            try {
                this._rawCharactersHandler.rawCharacters(str);
            }
            catch (SAXException e) {
                this.throwXSLException(e);
            }
        }
    }

    public void characters(String str) throws XSLException {
        int strLength;
        if (this.pendingElementType != null) {
            this.flush();
        }
        if (this.bufUsed + (strLength = str.length()) > this.buf.length) {
            int newLen;
            char[] oldBuf = this.buf;
            for (newLen = oldBuf.length * 2; newLen < this.bufUsed + strLength; newLen *= 2) {
            }
            this.buf = new char[newLen];
            if (this.bufUsed > 0) {
                System.arraycopy(oldBuf, 0, this.buf, 0, this.bufUsed);
            }
        }
        str.getChars(0, strLength, this.buf, this.bufUsed);
        this.bufUsed += strLength;
    }

    public void comment(String str) throws XSLException {
        if (this._commentHandler != null) {
            this.flush();
            try {
                this._commentHandler.comment(ResultBase.fixComment(str));
            }
            catch (SAXException e) {
                this.throwXSLException(e);
            }
        }
    }

    public void processingInstruction(String target, String data) throws XSLException {
        try {
            this.flush();
            this._contentHandler.processingInstruction(target, ResultBase.fixProcessingInstruction(data));
        }
        catch (SAXException e) {
            this.throwXSLException(e);
        }
    }

    public void startElement(Name elementType, NamespacePrefixMap nsMap) throws XSLException {
        this.flush();
        this.pendingElementType = elementType;
        this.pendingNamespacePrefixMap = nsMap;
        this._nAttributes = 0;
    }

    public void endElement(Name elementType) throws XSLException {
        this.flush();
        this.endElementContent(elementType);
    }

    protected final ContentHandler getContentHandler() {
        return this._contentHandler;
    }

    public int getIndex(String qName) {
        int len = this._nAttributes;
        for (int i = 0; i < len; ++i) {
            if (!qName.equals(this.getQName(i))) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(String namespaceURI, String localName) {
        if (namespaceURI == null || localName == null) {
            return -1;
        }
        int len = this._nAttributes;
        for (int i = 0; i < len; ++i) {
            if (!localName.equals(this._attributeNames[i].getLocalPart()) || !namespaceURI.equals(this._attributeNames[i].getNamespace())) continue;
            return i;
        }
        return -1;
    }

    public int getLength() {
        return this._nAttributes;
    }

    public String getValue(String namespaceURI, String localName) {
        return this.getValue(this.getIndex(namespaceURI, localName));
    }

    public String getValue(int index) {
        if (index < 0 || index > this._nAttributes) {
            return null;
        }
        return this._attributeValues[index];
    }

    public String getValue(String qName) {
        return this.getValue(this.getIndex(qName));
    }

    public String getURI(int index) {
        if (index < 0 || index >= this._nAttributes) {
            return null;
        }
        String uri = this._attributeNames[index].getNamespace();
        return uri == null ? "" : uri;
    }

    public String getLocalName(int index) {
        if (index < 0 || index >= this._nAttributes) {
            return null;
        }
        String name = this._attributeNames[index].getLocalPart();
        return name == null ? "" : name;
    }

    public String getQName(int index) {
        if (index < 0 || index >= this._nAttributes) {
            return null;
        }
        String qName = this._attributeNames[index].toString();
        return qName == null ? "" : qName;
    }

    public String getType(int index) {
        if (index < 0 || index >= this._nAttributes) {
            return null;
        }
        return "CDATA";
    }

    public String getType(String qName) {
        return this.getType(this.getIndex(qName));
    }

    public String getType(String namespaceURI, String localName) {
        return this.getType(this.getIndex(namespaceURI, localName));
    }

    protected final Name getAttributeName(int index) {
        return this._attributeNames[index];
    }

    protected abstract void startElementContent(Name var1, NamespacePrefixMap var2) throws XSLException;

    protected abstract void endElementContent(Name var1) throws XSLException;

    public void attribute(Name name, String value) throws XSLException {
        if (this.pendingElementType == null) {
            return;
        }
        for (int i = 0; i < this._nAttributes; ++i) {
            if (!this._attributeNames[i].equals(name)) continue;
            this._attributeValues[i] = value;
            return;
        }
        if (this._nAttributes == this._attributeNames.length) {
            this._attributeNames = ResultBase.grow(this._attributeNames);
            this._attributeValues = ResultBase.grow(this._attributeValues);
        }
        this._attributeNames[this._nAttributes] = name;
        this._attributeValues[this._nAttributes] = value;
        ++this._nAttributes;
    }

    public void start(OutputMethod outputMethod) throws XSLException {
        try {
            if (this._contentHandler == null) {
                Name name = outputMethod.getName();
                if (name == null) {
                    this.setContentHandler(new OutputMethodDefaulter(this, outputMethod));
                } else {
                    this.setOutputMethod(name, outputMethod);
                }
            }
            this._contentHandler.startDocument();
        }
        catch (IOException e) {
            throw new XSLException(e);
        }
        catch (SAXException e) {
            this.throwXSLException(e);
        }
    }

    public abstract void resultTreeFragment(ResultTreeFragment var1) throws XSLException;

    ContentHandler setOutputMethod(Name name, OutputMethod method) throws IOException, SAXException {
        String nameString = name.getNamespace() != null ? name.getNamespace() + '^' + name.getLocalPart() : name.getLocalPart();
        this.setContentHandler(this._outputMethodHandler.createContentHandler(nameString, new OutputMethodProperties(method)));
        return this._contentHandler;
    }

    public void end() throws XSLException {
        try {
            this.flush();
            this._contentHandler.endDocument();
        }
        catch (SAXException e) {
            this.throwXSLException(e);
        }
    }

    protected void throwXSLException(SAXException e) throws XSLException {
        Exception wrapped = e.getException();
        if (wrapped != null) {
            throw new XSLException(wrapped);
        }
        throw new XSLException(e.getMessage());
    }

    public void message(Node node, String str) throws XSLException {
        if (this._errorHandler != null) {
            String systemId = null;
            int lineNumber = -1;
            if (node != null) {
                URL url = node.getURL();
                if (url != null) {
                    systemId = url.toString();
                }
                lineNumber = node.getLineNumber();
            }
            try {
                this._errorHandler.warning(new SAXParseException(str, null, systemId, lineNumber, -1, null));
            }
            catch (SAXException e) {
                this.throwXSLException(e);
            }
        }
    }

    static String[] grow(String[] v) {
        String[] old = v;
        v = new String[old.length * 2];
        System.arraycopy(old, 0, v, 0, old.length);
        return v;
    }

    static Name[] grow(Name[] v) {
        Name[] old = v;
        v = new Name[old.length * 2];
        System.arraycopy(old, 0, v, 0, old.length);
        return v;
    }

    private static final String fixComment(String str) {
        int i = str.indexOf(45);
        while (i++ >= 0) {
            int len = str.length();
            if (i == len) {
                return str + " ";
            }
            if (str.charAt(i) == '-') {
                str = str.substring(0, i) + " " + str.substring(i);
            }
            i = str.indexOf(45, i);
        }
        return str;
    }

    private static final String fixProcessingInstruction(String str) {
        int len;
        int i = str.indexOf(63);
        while (i++ >= 0 && i != (len = str.length())) {
            if (str.charAt(i) == '>') {
                str = str.substring(0, i) + " " + str.substring(i);
            }
            i = str.indexOf(63, i);
        }
        return str;
    }
}

