/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.om;

import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NameTable;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import java.util.Hashtable;

public class NameTableImpl
implements NameTable {
    private NamespacePrefixMap emptyMap = new NamespacePrefixMapImpl();
    private Hashtable prefixMaps = new Hashtable();
    private Hashtable namespaces = new Hashtable();
    private Hashtable docNamespace = new Hashtable();

    public NameTableImpl() {
        this.prefixMaps.put(this.emptyMap, this.emptyMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Name createName(String qName, String namespace) {
        Hashtable ns;
        Hashtable hashtable = this.namespaces;
        synchronized (hashtable) {
            ns = (Hashtable)this.namespaces.get(namespace);
            if (ns == null) {
                ns = new Hashtable();
                this.namespaces.put(namespace, ns);
            }
        }
        return this.createName(ns, qName, namespace);
    }

    public Name createName(String nonQName) {
        return this.createName(this.docNamespace, nonQName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NameImpl createName(Hashtable ns, String qName, String namespace) {
        Hashtable hashtable = ns;
        synchronized (hashtable) {
            NameImpl nm = (NameImpl)ns.get(qName);
            if (nm == null) {
                int i = qName.indexOf(58);
                nm = i == -1 ? new NameImpl(qName, namespace) : new NameImpl(qName, namespace, this.createName(ns, qName.substring(i + 1), namespace));
                ns.put(qName, nm);
            }
            return nm;
        }
    }

    public NamespacePrefixMap getEmptyNamespacePrefixMap() {
        return this.emptyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamespacePrefixMap intern(NamespacePrefixMap prefixMap) {
        Hashtable hashtable = this.prefixMaps;
        synchronized (hashtable) {
            Object obj = this.prefixMaps.get(prefixMap);
            if (obj != null) {
                return (NamespacePrefixMap)obj;
            }
            this.prefixMaps.put(prefixMap, prefixMap);
            return prefixMap;
        }
    }

    private class NameImpl
    implements Name {
        private String qName;
        private String namespace;
        private NameImpl canon;

        NameImpl(String qName, String namespace) {
            this.qName = qName;
            this.namespace = namespace;
            this.canon = this;
        }

        NameImpl(String qName, String namespace, NameImpl canon) {
            this.qName = qName;
            this.namespace = namespace;
            this.canon = canon;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getLocalPart() {
            return this.canon.qName;
        }

        public String getPrefix() {
            int i = this.qName.indexOf(58);
            if (i < 0) {
                return null;
            }
            return this.qName.substring(0, i);
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof NameImpl) {
                return ((NameImpl)obj).canon == this.canon;
            }
            return false;
        }

        public String toString() {
            return this.qName;
        }

        public int hashCode() {
            return System.identityHashCode(this.canon);
        }

        public Object getCreator() {
            return NameTableImpl.this;
        }
    }

    private final class NamespacePrefixMapImpl
    implements NamespacePrefixMap {
        private final String[] bindings;
        private final String defaultNS;

        NamespacePrefixMapImpl() {
            this.bindings = new String[0];
            this.defaultNS = null;
        }

        private NamespacePrefixMapImpl(String[] bindings, String defaultNS) {
            this.bindings = bindings;
            this.defaultNS = defaultNS;
        }

        public final int getSize() {
            return this.bindings.length >> 1;
        }

        public final String getPrefix(int i) {
            return this.bindings[i << 1];
        }

        public final String getNamespace(int i) {
            return this.bindings[i << 1 | 1];
        }

        public final String getPrefix(String namespace) {
            for (int i = 1; i < this.bindings.length; i += 2) {
                if (!namespace.equals(this.bindings[i])) continue;
                return this.bindings[i - 1];
            }
            return null;
        }

        public final String getNamespace(String prefix) {
            for (int i = 0; i < this.bindings.length; i += 2) {
                if (!prefix.equals(this.bindings[i])) continue;
                return this.bindings[i + 1];
            }
            return null;
        }

        public final String getDefaultNamespace() {
            return this.defaultNS;
        }

        public Name expandAttributeName(String name, Node node) throws XSLException {
            int i = name.indexOf(58);
            if (i == -1) {
                return NameTableImpl.this.createName(name);
            }
            if (i == 3 && name.regionMatches(0, "xml", 0, 3)) {
                return NameTableImpl.this.createName(name, "http://www.w3.org/XML/1998/namespace");
            }
            for (int j = 0; j < this.bindings.length; j += 2) {
                String prefix = this.bindings[j];
                if (prefix.length() != i || !name.regionMatches(0, prefix, 0, i)) continue;
                return NameTableImpl.this.createName(name, this.bindings[j + 1]);
            }
            throw new XSLException("no such prefix \"" + name.substring(0, i) + '\"', node);
        }

        public Name expandElementTypeName(String name, Node node) throws XSLException {
            int i = name.indexOf(58);
            if (i == -1) {
                if (this.defaultNS != null) {
                    return NameTableImpl.this.createName(name, this.defaultNS);
                }
                return NameTableImpl.this.createName(name);
            }
            if (i == 3 && name.regionMatches(0, "xml", 0, 3)) {
                return NameTableImpl.this.createName(name, "http://www.w3.org/XML/1998/namespace");
            }
            for (int j = 0; j < this.bindings.length; j += 2) {
                String prefix = this.bindings[j];
                if (prefix.length() != i || !name.regionMatches(0, prefix, 0, i)) continue;
                return NameTableImpl.this.createName(name, this.bindings[j + 1]);
            }
            throw new XSLException("no such prefix \"" + name.substring(0, i) + '\"', node);
        }

        public NamespacePrefixMap unbind(String prefix) {
            for (int i = 0; i < this.bindings.length; i += 2) {
                if (!prefix.equals(this.bindings[i])) continue;
                String[] newBindings = new String[this.bindings.length - 2];
                System.arraycopy(this.bindings, 0, newBindings, 0, i);
                System.arraycopy(this.bindings, i + 2, newBindings, i, this.bindings.length - i - 2);
                return NameTableImpl.this.intern(new NamespacePrefixMapImpl(newBindings, this.defaultNS));
            }
            return this;
        }

        public NamespacePrefixMap bind(String prefix, String namespace) {
            int cmp;
            int i;
            for (i = 0; i < this.bindings.length && (cmp = prefix.compareTo(this.bindings[i])) >= 0; i += 2) {
                if (cmp != 0) continue;
                if (namespace.equals(this.bindings[i + 1])) {
                    return this;
                }
                String[] newBindings = (String[])this.bindings.clone();
                newBindings[i + 1] = namespace;
                return NameTableImpl.this.intern(new NamespacePrefixMapImpl(newBindings, this.defaultNS));
            }
            String[] newBindings = new String[this.bindings.length + 2];
            System.arraycopy(this.bindings, 0, newBindings, 0, i);
            newBindings[i] = prefix;
            newBindings[i + 1] = namespace;
            System.arraycopy(this.bindings, i, newBindings, i + 2, this.bindings.length - i);
            return NameTableImpl.this.intern(new NamespacePrefixMapImpl(newBindings, this.defaultNS));
        }

        public NamespacePrefixMap bindDefault(String namespace) {
            if (namespace.equals(this.defaultNS)) {
                return this;
            }
            return NameTableImpl.this.intern(new NamespacePrefixMapImpl(this.bindings, namespace));
        }

        public NamespacePrefixMap unbindDefault() {
            if (this.defaultNS == null) {
                return this;
            }
            return NameTableImpl.this.intern(new NamespacePrefixMapImpl(this.bindings, null));
        }

        public NameTable getNameTable() {
            return NameTableImpl.this;
        }

        public int hashCode() {
            int h = this.defaultNS != null ? this.defaultNS.hashCode() : 0;
            for (int i = 0; i < this.bindings.length; ++i) {
                h ^= this.bindings[i].hashCode();
            }
            return h;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof NamespacePrefixMapImpl)) {
                return false;
            }
            NamespacePrefixMapImpl map = (NamespacePrefixMapImpl)obj;
            if (this.defaultNS == null ? map.defaultNS != null : !this.defaultNS.equals(map.defaultNS)) {
                return false;
            }
            if (this.bindings.length != map.bindings.length) {
                return false;
            }
            for (int i = 0; i < this.bindings.length; ++i) {
                if (this.bindings[i].equals(map.bindings[i])) continue;
                return false;
            }
            return true;
        }
    }
}

