/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.ConvertibleExpr;
import com.jclark.xsl.expr.ConvertibleNumberExpr;
import com.jclark.xsl.expr.ConvertibleStringExpr;
import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.FunctionOpt1;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;

class StringLengthFunction
extends FunctionOpt1 {
    StringLengthFunction() {
    }

    ConvertibleExpr makeCallExpr(ConvertibleExpr e) {
        final ConvertibleStringExpr se = e.makeStringExpr();
        return new ConvertibleNumberExpr(){

            public double eval(Node node, ExprContext context) throws XSLException {
                return StringLengthFunction.stringLength(se.eval(node, context));
            }
        };
    }

    private static final boolean isLowSurrogate(char c) {
        return (c & 0xFC00) == 55296;
    }

    private static final int stringLength(String s) {
        int n;
        int len = n = s.length();
        for (int i = 0; i < n; ++i) {
            if (!StringLengthFunction.isLowSurrogate(s.charAt(i))) continue;
            --len;
        }
        return len;
    }
}

