/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.PathPattern;
import com.jclark.xsl.expr.PathPatternBase;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PatternList {
    private Hashtable nameRules = new Hashtable();
    private Vector[] typeRules = new Vector[7];
    private Vector anyNameRules = new Vector();

    public PatternList() {
        for (int i = 0; i < 7; ++i) {
            this.typeRules[i] = new Vector();
        }
    }

    public Object get(Node node, ExprContext context) throws XSLException {
        Vector v = this.getVector(node);
        int len = v.size();
        for (int i = 0; i < len; i += 2) {
            if (!((PathPattern)v.elementAt(i)).matches(node, context)) continue;
            return v.elementAt(i + 1);
        }
        return null;
    }

    public Enumeration getAll(Node node, ExprContext context) {
        return new MatchEnumeration(this.getVector(node).elements(), node, context);
    }

    private Vector getVector(Node node) {
        Vector rules;
        Name nodeName = node.getName();
        if (nodeName != null && (rules = (Vector)this.nameRules.get(nodeName)) != null) {
            return rules;
        }
        return this.typeRules[node.getType()];
    }

    private static void append(Vector v, PathPattern pp, Object obj) {
        v.addElement(pp);
        v.addElement(obj);
    }

    public void add(PathPattern pp, Object obj) {
        PathPatternBase ppb = (PathPatternBase)pp;
        Name matchName = ppb.getMatchName();
        if (matchName == null) {
            byte matchNodeType = ppb.getMatchNodeType();
            if (matchNodeType == 7) {
                for (int i = 0; i < 7; ++i) {
                    PatternList.append(this.typeRules[i], ppb, obj);
                }
            } else {
                PatternList.append(this.typeRules[matchNodeType], ppb, obj);
            }
            switch (matchNodeType) {
                case 0: 
                case 2: 
                case 4: 
                case 7: {
                    Enumeration enumeration = this.nameRules.elements();
                    while (enumeration.hasMoreElements()) {
                        PatternList.append((Vector)enumeration.nextElement(), ppb, obj);
                    }
                    PatternList.append(this.anyNameRules, ppb, obj);
                }
            }
        } else {
            Vector v = (Vector)this.nameRules.get(matchName);
            if (v == null) {
                v = (Vector)this.anyNameRules.clone();
                this.nameRules.put(matchName, v);
            }
            PatternList.append(v, ppb, obj);
        }
    }

    private static class MatchEnumeration
    implements Enumeration {
        private Enumeration possibleMatches;
        private Node node;
        private Object nextMatch;
        private ExprContext context;

        MatchEnumeration(Enumeration possibleMatches, Node node, ExprContext context) {
            this.node = node;
            this.possibleMatches = possibleMatches;
            this.context = context;
            this.setNextMatch();
        }

        public boolean hasMoreElements() {
            return this.nextMatch != null;
        }

        public Object nextElement() {
            Object tem = this.nextMatch;
            this.setNextMatch();
            return tem;
        }

        void setNextMatch() {
            while (this.possibleMatches.hasMoreElements()) {
                PathPattern pp = (PathPattern)this.possibleMatches.nextElement();
                try {
                    if (pp.matches(this.node, this.context)) {
                        this.nextMatch = this.possibleMatches.nextElement();
                        return;
                    }
                }
                catch (XSLException xSLException) {
                    // empty catch block
                }
                this.possibleMatches.nextElement();
            }
            this.nextMatch = null;
        }
    }
}

