/*
 * Copyright (c) 2010-2012, 2014-2015 Todd C. Miller <Todd.Miller@courtesan.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <config.h>

#include <sys/types.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <termios.h>
#include <limits.h>

#include "sudo_compat.h"
#include "sudo_debug.h"
#include "sudo_util.h"

#ifdef TIOCGWINSZ
static int
get_ttysize_ioctl(int *rowp, int *colp)
{
    struct winsize wsize;
    debug_decl(get_ttysize_ioctl, SUDO_DEBUG_UTIL)

    if (ioctl(STDERR_FILENO, TIOCGWINSZ, &wsize) == 0 &&
	wsize.ws_row != 0 && wsize.ws_col  != 0) {
	*rowp = wsize.ws_row;
	*colp = wsize.ws_col;
	debug_return_int(0);
    }
    debug_return_int(-1);
}
#else
static int
get_ttysize_ioctl(int *rowp, int *colp)
{
    return -1;
}
#endif /* TIOCGWINSZ */

void
sudo_get_ttysize_v1(int *rowp, int *colp)
{
    debug_decl(sudo_get_ttysize, SUDO_DEBUG_UTIL)

    if (get_ttysize_ioctl(rowp, colp) == -1) {
	char *p;

	/* Fall back on $LINES and $COLUMNS. */
	if ((p = getenv("LINES")) == NULL ||
	    (*rowp = strtonum(p, 1, INT_MAX, NULL)) <= 0) {
	    *rowp = 24;
	}
	if ((p = getenv("COLUMNS")) == NULL ||
	    (*colp = strtonum(p, 1, INT_MAX, NULL)) <= 0) {
	    *colp = 80;
	}
    }

    debug_return;
}
