/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(XPATH)

#include "JSXPathNSResolver.h"

#include <wtf/GetPtr.h>

#include "JSCustomXPathNSResolver.h"
#include "JSXPathNSResolver.h"
#include "KURL.h"
#include "PlatformString.h"

#include <runtime/Error.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSXPathNSResolver)

/* Hash table for prototype */

static const HashTableValue JSXPathNSResolverPrototypeTableValues[2] =
{
    { "lookupNamespaceURI", DontDelete|Function, (intptr_t)jsXPathNSResolverPrototypeFunctionLookupNamespaceURI, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSXPathNSResolverPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSXPathNSResolverPrototypeTableValues, 0 };
#else
    { 2, 1, JSXPathNSResolverPrototypeTableValues, 0 };
#endif

const ClassInfo JSXPathNSResolverPrototype::s_info = { "XPathNSResolverPrototype", 0, &JSXPathNSResolverPrototypeTable, 0 };

JSObject* JSXPathNSResolverPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSXPathNSResolver>(exec);
}

bool JSXPathNSResolverPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSXPathNSResolverPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSXPathNSResolver::s_info = { "XPathNSResolver", 0, 0, 0 };

JSXPathNSResolver::JSXPathNSResolver(PassRefPtr<Structure> structure, PassRefPtr<XPathNSResolver> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSXPathNSResolver::~JSXPathNSResolver()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSXPathNSResolver::createPrototype(ExecState* exec)
{
    return new (exec) JSXPathNSResolverPrototype(JSXPathNSResolverPrototype::createStructure(exec->lexicalGlobalObject()->objectPrototype()));
}

JSValuePtr jsXPathNSResolverPrototypeFunctionLookupNamespaceURI(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSXPathNSResolver::s_info))
        return throwError(exec, TypeError);
    JSXPathNSResolver* castedThisObj = static_cast<JSXPathNSResolver*>(asObject(thisValue));
    XPathNSResolver* imp = static_cast<XPathNSResolver*>(castedThisObj->impl());
    const UString& prefix = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = jsStringOrNull(exec, imp->lookupNamespaceURI(prefix));
    return result;
}

JSC::JSValuePtr toJS(JSC::ExecState* exec, XPathNSResolver* object)
{
    return getDOMObjectWrapper<JSXPathNSResolver>(exec, object);
}
XPathNSResolver* toXPathNSResolver(JSC::JSValuePtr value)
{
    return value->isObject(&JSXPathNSResolver::s_info) ? static_cast<JSXPathNSResolver*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(XPATH)
