#!/bin/sh
# Finds all names of Plasma applets, adds new ones to
# a chosen property map, and lists outdated ones.

filename=skjermelement.pmap # Name of property map
eqchar='='                  # Property key–value separator
sepchar='|'                 # Property pair separator
template='pron=|bunden='    # Default template for properties

# Fetch all the names (English + translated) of Plasma applets
names=$(find ../../../messages -name 'desktop*.po' \
| xargs fgrep -hv 'dataengines/' | fgrep -v '/plasma-engine-' \
| fgrep -v '/plasma-dataengine' | fgrep -v '%{APPNAME' \
| sed -ne '/\(plasmoid\/\|applets\?\/\|runners\/\|\/plasma-\).*\.desktop:[1-4]$/,/^$/{/^msgctxt "Name"/,/^$/p}' \
| grep -A1 '^msgid' \
| egrep msg[is] \
| sed -r 's/[^"]+"([^"]*)"/\1/' \
| sed 'N;s/\n/'"$sepchar"'/' \
| sed 's/.*/'"$eqchar""$sepchar"'\0'"$sepchar"'/')

# For each name, check if already is included in the property map.
# If not, write to the end of the property map file.
echo "These entries are new"
echo "---------------------"
echo "$names" | sort | while read text
do
  noexistfilename=$(fgrep -L "$text" "$filename")
  if [ "$filename" = "$noexistfilename" ]
  then
    echo "$text"
    echo "$text$template${sepchar}${sepchar}" >> "$filename"
  fi
done

# See if there are any entries in the property map file that doesn’t 
# exist in PO file (and therefore should be removed).
echo -e '\n\n'
old=$(grep "^$eqchar$sepchar" "$filename" | cut -f1-3 -d"$sepchar")
echo "These entries are outdated"
echo "--------------------------"
echo "$old" | while read text
do
  tooold=$(echo "$names" | fgrep -c "$text")
  if [ "$tooold" == 0 ]
  then
    echo "$text"
  fi
done
