/*
 * Copyright (C) 1989-95 GROUPE BULL
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * GROUPE BULL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of GROUPE BULL shall not be
 * used in advertising or otherwise to promote the sale, use or other dealings
 * in this Software without prior written authorization from GROUPE BULL.
 */

/*****************************************************************************\
* XpmI.h:                                                                     *
*                                                                             *
*  XPM library                                                                *
*  Internal Include file                                                      *
*                                                                             *
*  ** Everything defined here is subject to changes any time. **              *
*                                                                             *
*  Developed by Arnaud Le Hors                                                *
\*****************************************************************************/

/*
 * The code related to FOR_MSW has been added by
 * HeDu (hedu@cul-ipn.uni-kiel.de) 4/94
 */

#ifndef _XPMI_h
#define _XPMI_h

#include <XmI/XmXpm.h>

/*
 * lets try to solve include files
 */

#include <stdio.h>
#include <stdlib.h>
/* stdio.h doesn't declare popen on a Sequent DYNIX OS */
#ifdef sequent
extern FILE *popen();
#endif

#include <string.h>

/* the following is defined in X11R6 but not in previous versions */
#ifdef __alpha
#ifndef LONG64
#define LONG64
#endif
#endif

#ifdef VMS
#include <unixio.h>
#include <file.h>
#endif

/* The following should help people wanting to use their own memory allocation
 * functions. To avoid the overhead of a function call when the standard
 * functions are used these are all macros, even the _LtXpmFree function which
 * needs to be a real function for the outside world though.
 * So if change these be sure to change the _LtXpmFree function in misc.c
 * accordingly.
 */
#define _LtXpmFree(ptr) free(ptr)

#ifndef FOR_MSW
#define _LtXpmMalloc(size) malloc((size))
#define _LtXpmRealloc(ptr, size) realloc((ptr), (size))
#define _LtXpmCalloc(nelem, elsize) calloc((nelem), (elsize))
#else
/* checks for mallocs bigger than 64K */
#define _LtXpmMalloc(size) boundCheckingMalloc((long)(size))/* in simx.[ch] */
#define _LtXpmRealloc(ptr, size) boundCheckingRealloc((ptr),(long)(size))
#define _LtXpmCalloc(nelem, elsize) \
		boundCheckingCalloc((long)(nelem),(long) (elsize))
#endif

#define XPMMAXCMTLEN BUFSIZ
typedef struct {
    unsigned int type;
    union {
	FILE *file;
	char **data;
    }     stream;
    char *cptr;
    unsigned int line;
    int CommentLength;
    char Comment[XPMMAXCMTLEN];
    char *Bcmt, *Ecmt, Bos, Eos;
    int format;			/* 1 if XPM1, 0 otherwise */
}      xpmData;

#define XPMARRAY 0
#define XPMFILE  1
#define XPMPIPE  2
#define XPMBUFFER 3

#define EOL '\n'
#define TAB '\t'
#define SPC ' '

typedef struct {
    char *type;			/* key word */
    char *Bcmt;			/* string beginning comments */
    char *Ecmt;			/* string ending comments */
    char Bos;			/* character beginning strings */
    char Eos;			/* character ending strings */
    char *Strs;			/* strings separator */
    char *Dec;			/* data declaration string */
    char *Boa;			/* string beginning assignment */
    char *Eoa;			/* string ending assignment */
}      xpmDataType;

extern xpmDataType _LtxpmDataTypes[];

/*
 * rgb values and ascii names (from rgb text file) rgb values,
 * range of 0 -> 65535 color mnemonic of rgb value
 */
typedef struct {
    int r, g, b;
    char *name;
}      xpmRgbName;

/* Maximum number of rgb mnemonics allowed in rgb text file. */
#define MAX_RGBNAMES 1024

extern char *_LtxpmColorKeys[];

#define TRANSPARENT_COLOR "None"	/* this must be a string! */

/* number of _LtxpmColorKeys */
#define NKEYS 5

/* XPM internal routines */

FUNC(_LtxpmParseData, int, (xpmData *data, _LtXpmImage *image, _LtXpmInfo *info));
FUNC(_Lt_LtxpmParseDataAndCreate, int, (Display *display, xpmData *data,
				  XImage **image_return,
				  XImage **shapeimage_return,
				  _LtXpmImage *image, _LtXpmInfo *info,
				  _LtXpmAttributes *attributes));

FUNC(_LtxpmFreeColorTable, void, (_LtXpmColor *colorTable, int ncolors));

FUNC(_LtxpmInitAttributes, void, (_LtXpmAttributes *attributes));

FUNC(_LtxpmInitXpmImage, void, (_LtXpmImage *image));

FUNC(_LtxpmInitXpmInfo, void, (_LtXpmInfo *info));

FUNC(_Lt_LtxpmSetInfoMask, void, (_LtXpmInfo *info, _LtXpmAttributes *attributes));
FUNC(_LtxpmSetInfo, void, (_LtXpmInfo *info, _LtXpmAttributes *attributes));
FUNC(_LtxpmSetAttributes, void, (_LtXpmAttributes *attributes, _LtXpmImage *image,
			      _LtXpmInfo *info));

#if !defined(FOR_MSW) && !defined(AMIGA)
FUNC(_LtxpmCreatePixmapFromImage, void, (Display *display, Drawable d,
				      XImage *ximage, Pixmap *pixmap_return));

FUNC(_LtxpmCreateImageFromPixmap, void, (Display *display, Pixmap pixmap,
				      XImage **ximage_return,
				      unsigned int *width,
				      unsigned int *height));
#endif

/* structures and functions related to hastable code */

typedef struct _xpmHashAtom {
    char *name;
    void *data;
}      *xpmHashAtom;

typedef struct {
    int size;
    int limit;
    int used;
    xpmHashAtom *atomTable;
}      xpmHashTable;

FUNC(_LtxpmHashTableInit, int, (xpmHashTable *table));
FUNC(_LtxpmHashTableFree, void, (xpmHashTable *table));
FUNC(_LtxpmHashSlot, xpmHashAtom *, (xpmHashTable *table, char *s));
FUNC(_LtxpmHashIntern, int, (xpmHashTable *table, char *tag, void *data));

#define HashAtomData(i) ((void *)i)
#define HashColorIndex(slot) ((unsigned int)((*slot)->data))
#define USE_HASHTABLE (cpp > 2 && ncolors > 4)

/* I/O utility */

FUNC(_LtxpmNextString, int, (xpmData *mdata));
FUNC(_LtxpmNextUI, int, (xpmData *mdata, unsigned int *ui_return));
FUNC(_LtxpmGetString, int, (xpmData *mdata, char **sptr, unsigned int *l));

#define xpmGetC(mdata) \
	((!mdata->type || mdata->type == XPMBUFFER) ? \
	 (*mdata->cptr++) : (getc(mdata->stream.file)))

FUNC(_LtxpmNextWord, unsigned int,
     (xpmData *mdata, char *buf, unsigned int buflen));
FUNC(_LtxpmGetCmt, int, (xpmData *mdata, char **cmt));
FUNC(_LtxpmParseHeader, int, (xpmData *mdata));
FUNC(_LtxpmParseValues, int, (xpmData *data, unsigned int *width,
			   unsigned int *height, unsigned int *ncolors,
			   unsigned int *cpp, unsigned int *x_hotspot,
			   unsigned int *y_hotspot, unsigned int *hotspot,
			   unsigned int *extensions));

FUNC(_LtxpmParseColors, int, (xpmData *data, unsigned int ncolors,
			   unsigned int cpp, _LtXpmColor **colorTablePtr,
			   xpmHashTable *hashtable));

FUNC(_LtxpmParseExtensions, int, (xpmData *data, _LtXpmExtension **extensions,
			       unsigned int *nextensions));

/* RGB utility */

FUNC(_LtxpmReadRgbNames, int, (char *rgb_fname, xpmRgbName *rgbn));
FUNC(_LtxpmGetRgbName, char *, (xpmRgbName *rgbn, int rgbn_max,
			     int red, int green, int blue));
FUNC(_LtxpmFreeRgbNames, void, (xpmRgbName *rgbn, int rgbn_max));
#ifdef FOR_MSW
FUNC(xpmGetRGBfromName,int, (char *name, int *r, int *g, int *b));
#endif

#ifndef AMIGA
FUNC(_Ltxpm_xynormalizeimagebits, void, (register unsigned char *bp,
				      register XImage *img));
FUNC(_Ltxpm_znormalizeimagebits, void, (register unsigned char *bp,
				     register XImage *img));

/*
 * Macros
 *
 * The XYNORMALIZE macro determines whether XY format data requires
 * normalization and calls a routine to do so if needed. The logic in
 * this module is designed for LSBFirst byte and bit order, so
 * normalization is done as required to present the data in this order.
 *
 * The ZNORMALIZE macro performs byte and nibble order normalization if
 * required for Z format data.
 *
 * The XYINDEX macro computes the index to the starting byte (char) boundary
 * for a bitmap_unit containing a pixel with coordinates x and y for image
 * data in XY format.
 *
 * The ZINDEX* macros compute the index to the starting byte (char) boundary
 * for a pixel with coordinates x and y for image data in ZPixmap format.
 *
 */

#define XYNORMALIZE(bp, img) \
    if ((img->byte_order == MSBFirst) || (img->bitmap_bit_order == MSBFirst)) \
	_Ltxpm_xynormalizeimagebits((unsigned char *)(bp), img)

#define ZNORMALIZE(bp, img) \
    if (img->byte_order == MSBFirst) \
	_Ltxpm_znormalizeimagebits((unsigned char *)(bp), img)

#define XYINDEX(x, y, img) \
    ((y) * img->bytes_per_line) + \
    (((x) + img->xoffset) / img->bitmap_unit) * (img->bitmap_unit >> 3)

#define ZINDEX(x, y, img) ((y) * img->bytes_per_line) + \
    (((x) * img->bits_per_pixel) >> 3)

#define ZINDEX32(x, y, img) ((y) * img->bytes_per_line) + ((x) << 2)

#define ZINDEX16(x, y, img) ((y) * img->bytes_per_line) + ((x) << 1)

#define ZINDEX8(x, y, img) ((y) * img->bytes_per_line) + (x)

#define ZINDEX1(x, y, img) ((y) * img->bytes_per_line) + ((x) >> 3)
#endif /* not AMIGA */


#ifndef HAVE_STRDUP
FUNC(xpmstrdup, char *, (char *s1));
#else
#undef xpmstrdup
#define xpmstrdup strdup
#endif

#ifndef HAVE_STRCASECMP                   
FUNC(xpmstrcasecmp, int, (char *s1, char *s2));
#else
#undef xpmstrcasecmp
#define xpmstrcasecmp strcasecmp
#endif

FUNC(_Ltxpmatoui, unsigned int,
     (char *p, unsigned int l, unsigned int *ui_return));

#endif /* _XPMI_H */
