/*
    packagelvi.h  -  Custom QListViewItem that holds a Package object
    
    copyright   : (c) 2001 by Martijn Klingens
    email       : mklingens@yahoo.com

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef KBBMAINWINDOW_PACKAGELVI_H
#define KBBMAINWINDOW_PACKAGELVI_H

#include <qlistview.h>

#include "package.h"

namespace KBugBusterMainWindow
{

/**
 * @author Martijn Klingens
 */
class PackageLVI : public QListViewItem
{
public:
    PackageLVI( QListView *parent , const Package &pkg );
    ~PackageLVI();

    Package& package() { return m_package; }
    void setPackage( Package &pkg ) { m_package = pkg; }
    
private:
    Package m_package;
};
 
}   // namespace

#endif // KBBMAINWINDOW_CENTRALWIGET_H

/* vim: set et ts=4 softtabstop=4 sw=4: */

