/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlineedit.h>
#include <qpushbutton.h>

#include <keditlistbox.h>

#include "page_startup.h"

PageStartup::PageStartup( QWidget *parent, const char *name ) : PageStartupBase( parent, name)
{
    notifyLB->upButton()->hide();
    notifyLB->downButton()->hide();
}

PageStartup::~PageStartup()
{
}

void PageStartup::saveConfig()
{
    ksopts->nick = nickLE->text();
	ksopts->altNick = altNickLE->text();
    ksopts->realName = rnLE->text();

    ksopts->notifyList.clear();
    for ( int i = 0; i < notifyLB->count(); ++i)
        ksopts->notifyList.append( notifyLB->text( i ) );
}

void PageStartup::readConfig( const KSOStartup *opts )
{
    nickLE->setText( opts->nick );
	altNickLE->setText( opts->altNick );
    rnLE->setText( opts->realName );
    notifyLB->insertStringList( opts->notifyList );
}

void PageStartup::defaultConfig()
{
    KSOStartup opts;
    readConfig( &opts );
}

void PageStartup::changed()
{
    emit modified();
}

#include "page_startup.moc"
