/*
    Copyright (C) 2000 - 2001 Kai Heitkamp, kai@kde.org
                              Holger Freyther, freyther@yahoo.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#include <qstring.h>

#include "tracklistviewitem.h"

TrackListViewItem::TrackListViewItem( KListView *parent, int track, QString src, QString cd_text, int size ) : KListViewItem( parent ) {
	t_track = track ;
	t_src   = src   ;
	t_cd_text = cd_text;
	t_size = size;
	setTrack( t_track );
	setText ( 1, t_src   );
	setText ( 2, t_cd_text );
	setText ( 3, QString::number( t_size ) + " MB" );
}

TrackListViewItem::~TrackListViewItem(){
}

/** Returns the tracknumber */
int TrackListViewItem::tracknumber( ){
	return t_track;
}

/** Returns the size in MB of the track */
int TrackListViewItem::size( ){
	return t_size;
}

/** Returns the URL of the track */
QString TrackListViewItem::source( ){
	return t_src;
}

/** Returns the cd text of the cd */
QString TrackListViewItem::cdtext( ){
	return t_cd_text;

}

/** Sets the CD-Text */
void TrackListViewItem::setCDText(QString cd_text ){
	t_cd_text = cd_text;
	setText( 2, t_cd_text );
}

/** Sets the CD track */
void TrackListViewItem::setTrack (int track ){
	t_track = track;
	if( track < 10 )
		setText( 0, "0" + QString::number ( t_track ) );
	else
		setText( 0, QString::number ( t_track ) );
}

/** Sets the source */
void TrackListViewItem::setSource(QString source ){
	t_src = source;
	setText( 1, t_src );
}

/** Sets the size */
void TrackListViewItem::setSize( int size ){
	t_size = size;
	setText( 3, QString::number( size ) + " MB" );
}
