#include "main.h"
#include "main.moc"

#include <klocale.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kapplication.h>

#include "common/highscores.h"
#include "board.h"
#include "piece.h"
#include "ai.h"
#include "field.h"


const MPGameInfo MP_GAME_INFO = {
        "003",
        4,
        500,
        TRUE,
        0, 0
};

const MainData MAIN_DATA = {
    "kfouleggs",
    I18N_NOOP("KFoulEggs"),
    I18N_NOOP("KFoulEggs is an adaptation of the well-known\n(at least in "
              "Japan) PuyoPuyo game."),
    "http://kfouleggs.sourceforge.net/",
    I18N_NOOP("Puyos")
};

const BoardInfo BOARD_INFO = {
    6, 15, // width - height
    true,

    21, 101, true, // block size (min, max, must be odd)

    1000, // base time
    10,   // drop down time
    10,   // before glue time
    10,   // after glue time
    150,  // before remove time
    10,   // after removed time
    10,   // after gift time
    3,    // nb bump stages
    3,    // nb toggles
    5,    // nb partial fall stages

    5, 6, 800, 2000 // nb leds, max to send, shower timeout, pool timeout
};

FEMainWindow::FEMainWindow()
{
    init(MP_GAME_INFO);
}

const MainData &FEMainWindow::mainData() const
{
    return MAIN_DATA;
}

const BoardInfo &FEMainWindow::boardInfo() const
{
    return BOARD_INFO;
}

BaseField *FEMainWindow::createField(QWidget *parent)
{
    Field *field = new FEField(parent);
    field->settingsChanged();
    QObject::connect(parent->parent(), SIGNAL(settingsChanged()),
                     field, SLOT(settingsChanged()));
    return field;
}

BaseBoard *FEMainWindow::createBoard(bool graphic, QWidget *parent)
{
	return new FEBoard(graphic, parent);
}

AI *FEMainWindow::createAI()
{
	return new FEAI(0, 200); // times needs tuning ?
}


//-----------------------------------------------------------------------------
int main(int argc, char **argv)
{
    KLocale::setMainCatalogue("ksirtet");
	KAboutData aboutData(MAIN_DATA.name, MAIN_DATA.trName, LONG_VERSION,
                         MAIN_DATA.description, KAboutData::License_GPL,
                         COPYLEFT, 0, MAIN_DATA.homepage);
    aboutData.addAuthor("Nicolas Hadacek", 0, "hadacek@kde.org");
	aboutData.addAuthor("Eirik Eng", I18N_NOOP("Core engine"));
	KCmdLineArgs::init(argc, argv, &aboutData);

	KApplication a;
    KGlobal::locale()->insertCatalogue("libkdegames");
    KGlobal::locale()->insertCatalogue("libkdehighscores");

    FEPieceInfo pieceInfo;
    KExtHighscores::ExtHighscores highscores(MAIN_DATA);

    if ( kapp->isRestored() ) RESTORE(FEMainWindow)
    else {
        FEMainWindow *mw = new FEMainWindow;
        kapp->setMainWidget(mw);
        mw->show();
    }
	return kapp->exec();
}
