/***************************************************************************
                            KConfigBase.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KCONFIGBASE_H
#define KCONFIGBASE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 Abstract base class for KDE configuration entries.

 This class forms the base for all KDE configuration. It is an
 abstract base class, meaning that you cannot directly instantiate
 objects of this class. Either use @ref KConfig (for usual KDE
 configuration) or @ref KSimpleConfig (for special needs as in ksamba), or
 even KSharedConfig (stores values in shared memory).

 All configuration entries are key, value pairs.  Each entry also
 belongs to a specific group of related entries.  All configuration
 entries that do not explicitly specify which group they are in are
 in a special group called the default group.

 If there is a $ character in an entry, KConfigBase tries to expand
 environment variable and uses its value instead of its name. You
 can avoid this feature by having two consecutive $ characters in
 your config file which get expanded to one.

 @author Kalle Dalheimer <kalle@kde.org>, Preston Brown <pbrown@kde.org>

 @version $Id: KConfigBase.h,v 1.3 2002/03/15 02:12:19 rdale Exp $

 @short KDE Configuration Management abstract base class.
*/
@class QFont; 

@interface KConfigBase : QObject 

/** 
 Destructs the KConfigBase object.
   
*/
- (void) dealloc;

/** 
 Specifies the group in which keys will be searched.

  Subsequent
 calls to @ref -readEntry will look only for keys in the currently
 activated group.

 Switch back to the default group by passing a null string.

*/
- setGroup: (NSString *)group;

/** 
 Sets the group to the "Desktop Entry" group used for
 desktop configuration files for applications, mime types, etc.
   
*/
- setDesktopGroup;

/** 
 Returns the name of the group in which we are
  searching for keys and from which we are retrieving entries.

*/
- (NSString *) group;

/** 
 Returns true if the specified group is known about.

*/
- (BOOL) hasGroup: (NSString *)group;

/** 
 Returns a list of groups that are known about.

*/
- (NSArray *) groupList;

/** 
 Returns a the current locale.

*/
- (NSString *) locale;

/** 
 Reads the value of an entry specified by @p pKey in the current group.

*/
- (NSString *) readEntry: (NSString *)pKey aDefault: (NSString *)aDefault;
- (NSString *) readEntry: (NSString *)pKey aDefault: (NSString *)aDefault;

/** 
 Reads the value of an entry specified by @p pKey in the current group.
 The value is treated as if it is of the given type.

 Note that only the following @ref -[QVariant Type]are allowed : String,
 StringList, List, Font, Point, Rect, Size, Color, Int, UInt, Bool,
 Double, DateTime and Date.
   
*/
- (QVariant*) readPropertyEntry: (NSString *)pKey int: (int)arg1;
- (QVariant*) readPropertyEntry: (NSString *)pKey int: (int)arg1;

/** 
 Reads the value of an entry specified by @p pKey in the current group.
 The value is treated as if it is of the type of the given default value.

 Note that only the following @ref -[QVariant Type]are allowed : String,
 StringList, List, Font, Point, Rect, Size, Color, Int, UInt, Bool,
 Double, DateTime and Date.
   
*/
- (QVariant*) readPropertyEntry: (NSString *)pKey adefault: (QVariant *)adefault;
- (QVariant*) readPropertyEntry: (NSString *)pKey aDefault: (QVariant *)aDefault;

/** 
 Reads a list of strings.

*/
//- (int) readListEntry: (NSString *)pKey list: (NSArray *)list char: (char sep ')arg1 : (' )arg2;
//- (int) readListEntry: (NSString *)pKey list: (NSArray *)list ;
//- (int) readListEntry: (NSString *)pKey list: (NSArray *)list char: (char sep ')arg1 : (' )arg2;
//- (int) readListEntry: (NSString *)pKey list: (NSArray *)list ;

/** 
 Reads a list of strings.

*/
//- (NSArray *) readListEntry: (NSString *)pKey char: (char sep ')arg1 : (' )arg2;
//- (NSArray *) readListEntry: (NSString *)pKey char: (char sep ')arg1 : (' )arg2;

/** 
 Reads a path.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it as a path. This means, dollar expansion is activated
 for this value, so that e.g. $HOME gets expanded.

*/
- (NSString *) readPathEntry: (NSString *)pKey aDefault: (NSString *)aDefault;
- (NSString *) readPathEntry: (NSString *)pKey aDefault: (NSString *)aDefault;

/** 
 Reads a numerical value.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it numerically.

*/
- (int) readNumEntry: (NSString *)pKey nDefault: (int)nDefault;
- (int) readNumEntry: (NSString *)pKey ;
- (int) readNumEntry: (NSString *)pKey nDefault: (int)nDefault;
- (int) readNumEntry: (NSString *)pKey ;

/** 
 Reads an unsigned numerical value.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it numerically.

*/
- (unsigned int) readUnsignedNumEntry: (NSString *)pKey nDefault: (unsigned int)nDefault;
- (unsigned int) readUnsignedNumEntry: (NSString *)pKey ;
- (unsigned int) readUnsignedNumEntry: (NSString *)pKey nDefault: (unsigned int)nDefault;
- (unsigned int) readUnsignedNumEntry: (NSString *)pKey ;

/** 
 Reads a numerical value.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it numerically.

*/
- (long) readLongNumEntry: (NSString *)pKey nDefault: (long)nDefault;
- (long) readLongNumEntry: (NSString *)pKey ;
- (long) readLongNumEntry: (NSString *)pKey nDefault: (long)nDefault;
- (long) readLongNumEntry: (NSString *)pKey ;

/** 
 Read an unsigned numerical value.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it numerically.

*/
- (unsigned long) readUnsignedLongNumEntry: (NSString *)pKey nDefault: (unsigned long)nDefault;
- (unsigned long) readUnsignedLongNumEntry: (NSString *)pKey ;
- (unsigned long) readUnsignedLongNumEntry: (NSString *)pKey nDefault: (unsigned long)nDefault;
- (unsigned long) readUnsignedLongNumEntry: (NSString *)pKey ;

/** 
 Reads a floating point value.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it numerically.

*/
- (double) readDoubleNumEntry: (NSString *)pKey nDefault: (double)nDefault;
- (double) readDoubleNumEntry: (NSString *)pKey ;
- (double) readDoubleNumEntry: (NSString *)pKey nDefault: (double)nDefault;
- (double) readDoubleNumEntry: (NSString *)pKey ;

/** 
 Reads a @ref QFont value.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it as a font object.

*/
- (QFont*) readFontEntry: (NSString *)pKey pDefault: (QFont *)pDefault;
- (QFont*) readFontEntry: (NSString *)pKey ;
- (QFont*) readFontEntry: (NSString *)pKey pDefault: (QFont *)pDefault;
- (QFont*) readFontEntry: (NSString *)pKey ;

/** 
 Reads a boolean entry.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it as a boolean value. Currently "on" and "true" are
 accepted as true, everything else if false.

*/
- (BOOL) readBoolEntry: (NSString *)pKey bDefault: (BOOL)bDefault;
- (BOOL) readBoolEntry: (NSString *)pKey ;
- (BOOL) readBoolEntry: (NSString *)pKey bDefault: (BOOL)bDefault;
- (BOOL) readBoolEntry: (NSString *)pKey ;

/** 
 Reads a @ref QRect entry.

 Read the value of an entry specified by pKey in the current group
 and interpret it as a @ref QRect object.

*/
- (QRect*) readRectEntry: (NSString *)pKey pDefault: (QRect*)pDefault;
- (QRect*) readRectEntry: (NSString *)pKey ;
- (QRect*) readRectEntry: (NSString *)pKey pDefault: (QRect*)pDefault;
- (QRect*) readRectEntry: (NSString *)pKey ;

/** 
 Reads a @ref QPoint entry.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it as a @ref QPoint object.

*/
- (QPoint*) readPointEntry: (NSString *)pKey pDefault: (QPoint*)pDefault;
- (QPoint*) readPointEntry: (NSString *)pKey ;
- (QPoint*) readPointEntry: (NSString *)pKey pDefault: (QPoint*)pDefault;
- (QPoint*) readPointEntry: (NSString *)pKey ;

/** 
 Reads a @ref QSize entry.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it as a @ref QSize object.

*/
- (QSize*) readSizeEntry: (NSString *)pKey pDefault: (QSize*)pDefault;
- (QSize*) readSizeEntry: (NSString *)pKey ;
- (QSize*) readSizeEntry: (NSString *)pKey pDefault: (QSize*)pDefault;
- (QSize*) readSizeEntry: (NSString *)pKey ;

/** 
 Reads a @ref QColor entry.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it as a color.

*/
- (QColor*) readColorEntry: (NSString *)pKey pDefault: (QColor*)pDefault;
- (QColor*) readColorEntry: (NSString *)pKey ;
- (QColor*) readColorEntry: (NSString *)pKey pDefault: (QColor*)pDefault;
- (QColor*) readColorEntry: (NSString *)pKey ;

/** 
 Reads a @ref QDateTime entry.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it as a date and time.

*/
- (NSDate *) readDateTimeEntry: (NSString *)pKey pDefault: (NSDate *)pDefault;
- (NSDate *) readDateTimeEntry: (NSString *)pKey pDefault: (NSDate *)pDefault;

/** 
 Writes a key/value pair.

 This is stored in the most specific config file when destroying the
 config object or when calling @ref -sync.

*/
- writeEntry: (NSString *)pKey pValue: (NSString *)pValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
- writeEntry: (NSString *)pKey pValue: (NSString *)pValue ;
- writeEntry: (NSString *)pKey pValue: (NSString *)pValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
- writeEntry: (NSString *)pKey pValue: (NSString *)pValue ;

/** 
 @ref -writeEntry Overridden to accept a property.

 Note: Unlike the other @ref -writeEntry functions, the old value is
 _not_ returned here!

*/
- writeEntry: (NSString *)pKey rValue: (QVariant *)rValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
- writeEntry: (NSString *)pKey rValue: (QVariant *)rValue ;
- writeEntry: (NSString *)pKey rValue: (QVariant *)rValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
- writeEntry: (NSString *)pKey rValue: (QVariant *)rValue ;

/** 
 @ref -writeEntry overridden to accept a list of strings.

 Note: Unlike the other @ref -writeEntry functions, the old value is
 _not_ returned here!

*/
//- writeEntry: (NSString *)pKey rValue: (NSArray *)rValue char: (char sep ')arg1 : (')arg2 bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
//- writeEntry: (NSString *)pKey rValue: (NSArray *)rValue ;
//- writeEntry: (NSString *)pKey rValue: (NSArray *)rValue char: (char sep ')arg1 : (')arg2 bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
//- writeEntry: (NSString *)pKey rValue: (NSArray *)rValue ;

/** 
 @ref -writeEntry overridden to accept a list of strings.

 Note: Unlike the other @ref -writeEntry functions, the old value is
 _not_ returned here!

*/
//- writeEntry: (NSString *)pKey rValue: (NSArray *)rValue char: (char sep ')arg1 : (')arg2 bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
//- writeEntry: (NSString *)pKey rValue: (NSArray *)rValue ;
//- writeEntry: (NSString *)pKey rValue: (NSArray *)rValue char: (char sep ')arg1 : (')arg2 bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
//- writeEntry: (NSString *)pKey rValue: (NSArray *)rValue ;

/** 
 Write a (key/value) pair.

 This is stored to the most specific config file when destroying the
 config object or when calling @ref -sync.

*/
- writeEntry: (NSString *)pKey pValue: (NSString *)pValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
- writeEntry: (NSString *)pKey pValue: (NSString *)pValue ;
- writeEntry: (NSString *)pKey pValue: (NSString *)pValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
- writeEntry: (NSString *)pKey pValue: (NSString *)pValue ;

/** 
 Write a (key/value) pair.
 Same as above, but writes a numerical value.

*/
- writeEntry: (NSString *)pKey nValue: (int)nValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
- writeEntry: (NSString *)pKey nValue: (int)nValue ;
- writeEntry: (NSString *)pKey nValue: (int)nValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
- writeEntry: (NSString *)pKey nValue: (int)nValue ;

/** 
 Writes a (key/value) pair.
 Same as above, but writes an unsigned numerical value.

*/
//- writeEntry: (NSString *)pKey nValue: (unsigned int)nValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
//- writeEntry: (NSString *)pKey nValue: (unsigned int)nValue ;
//- writeEntry: (NSString *)pKey nValue: (unsigned int)nValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
//- writeEntry: (NSString *)pKey nValue: (unsigned int)nValue ;

/** 
 Writes a (key/value) pair.
 Same as above, but write a long numerical value.

*/
//- writeEntry: (NSString *)pKey nValue: (long)nValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
//- writeEntry: (NSString *)pKey nValue: (long)nValue ;
//- writeEntry: (NSString *)pKey nValue: (long)nValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
//- writeEntry: (NSString *)pKey nValue: (long)nValue ;

/** 
 Writes a (key/value) pair.
 Same as above, but writes an unsigned long numerical value.

*/
//- writeEntry: (NSString *)pKey nValue: (unsigned long)nValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
//- writeEntry: (NSString *)pKey nValue: (unsigned long)nValue ;
//- writeEntry: (NSString *)pKey nValue: (unsigned long)nValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
//- writeEntry: (NSString *)pKey nValue: (unsigned long)nValue ;

/** 
 Writes a (key/value) pair.
 Same as above, but writes a floating-point value.

*/
- writeEntry: (NSString *)pKey nValue: (double)nValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal format: (char)format precision: (int)precision bNLS: (BOOL)bNLS;
//- writeEntry: (NSString *)pKey nValue: (double)nValue ;
- writeEntry: (NSString *)pKey nValue: (double)nValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal format: (char)format precision: (int)precision bNLS: (BOOL)bNLS;
//- writeEntry: (NSString *)pKey nValue: (double)nValue ;

/** 
 Writes a (key/value) pair.
 Same as above, but writes a boolean value.

*/
- writeEntry: (NSString *)pKey bValue: (BOOL)bValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
- writeEntry: (NSString *)pKey bValue: (BOOL)bValue ;
- writeEntry: (NSString *)pKey bValue: (BOOL)bValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
- writeEntry: (NSString *)pKey bValue: (BOOL)bValue ;

/** 
 Writes a (key/value) pair.
 Same as above, but writes a font value.

*/
- writeEntry: (NSString *)pKey rFont: (QFont *)rFont bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
- writeEntry: (NSString *)pKey rFont: (QFont *)rFont ;
- writeEntry: (NSString *)pKey rFont: (QFont *)rFont bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
- writeEntry: (NSString *)pKey rFont: (QFont *)rFont ;

/** 
 Writes a (key/value) pair.
 Same as above, but write a color entry.

 Note: Unlike the other @ref -writeEntry functions, the old value is
 _not_ returned here!

*/
- writeEntry: (NSString *)pKey rColor: (QColor *)rColor bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
- writeEntry: (NSString *)pKey rColor: (QColor *)rColor ;
- writeEntry: (NSString *)pKey rColor: (QColor *)rColor bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
- writeEntry: (NSString *)pKey rColor: (QColor *)rColor ;

/** 
 Writes a (key/value) pair.
 Same as above, but writes a date and time entry.

 Note: Unlike the other @ref -writeEntry functions, the old value is
 @em not returned here!

*/
- writeEntry: (NSString *)pKey rDateTime: (NSDate *)rDateTime bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
- writeEntry: (NSString *)pKey rDateTime: (NSDate *)rDateTime ;
- writeEntry: (NSString *)pKey rDateTime: (NSDate *)rDateTime bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
- writeEntry: (NSString *)pKey rDateTime: (NSDate *)rDateTime ;

/** 
 Writes a (key/value) pair.
 Same as above, but writes a rectangle.

 Note: Unlike the other @ref -writeEntry functions, the old value is
 _not_ returned here!

*/
//- writeEntry: (NSString *)pKey rValue: (QRect*)rValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
//- writeEntry: (NSString *)pKey rValue: (QRect*)rValue ;
//- writeEntry: (NSString *)pKey rValue: (QRect*)rValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
//- writeEntry: (NSString *)pKey rValue: (QRect*)rValue ;

/** 
 Writes a (key/value) pair.
 Same as above, but writes a point.

 Note: Unlike the other @ref -writeEntry functions, the old value is
 _not_ returned here!

*/
//- writeEntry: (NSString *)pKey rValue: (QPoint*)rValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
//- writeEntry: (NSString *)pKey rValue: (QPoint*)rValue ;
//- writeEntry: (NSString *)pKey rValue: (QPoint*)rValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
//- writeEntry: (NSString *)pKey rValue: (QPoint*)rValue ;

/** 
 Writes a (key/value) pair.
 Same as above, but writes a size.

 Note: Unlike the other @ref -writeEntry functions, the old value is
 _not_ returned here!

*/
//- writeEntry: (NSString *)pKey rValue: (QSize *)rValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
//- writeEntry: (NSString *)pKey rValue: (QSize *)rValue ;
//- writeEntry: (NSString *)pKey rValue: (QSize *)rValue bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
//- writeEntry: (NSString *)pKey rValue: (QSize *)rValue ;

/** 
 Writes a file path.

 It is checked whether the path is located under $HOME. If so the
 path is written out with the user's home-directory replaced with
 $HOME. The path should be read back with @ref -readPathEntry

*/
- writePathEntry: (NSString *)pKey path: (NSString *)path bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
- writePathEntry: (NSString *)pKey path: (NSString *)path ;
- writePathEntry: (NSString *)pKey path: (NSString *)path bPersistent: (BOOL)bPersistent bGlobal: (BOOL)bGlobal bNLS: (BOOL)bNLS;
- writePathEntry: (NSString *)pKey path: (NSString *)path ;

/** 
 Deletes the entry specified by @p pKey in the current group.

*/
- deleteEntry: (NSString *)pKey bNLS: (BOOL)bNLS bGlobal: (BOOL)bGlobal;
- deleteEntry: (NSString *)pKey ;
- deleteEntry: (NSString *)pKey bNLS: (BOOL)bNLS bGlobal: (BOOL)bGlobal;
- deleteEntry: (NSString *)pKey ;

/** 
 Deletes a configuration entry group

 If the group is not empty and bDeep is false, nothing gets
 deleted and false is returned.
 If this group is the current group and it is deleted, the
 current group is undefined and should be set with -setGroup
 before the next operation on the configuration object.

*/
- (BOOL) deleteGroup: (NSString *)group bDeep: (BOOL)bDeep bGlobal: (BOOL)bGlobal;
- (BOOL) deleteGroup: (NSString *)group ;

/** 
 Turns on or off "dollar  expansion" (see KConfigBase introduction)
  when reading config entries.
 Dollar sign expansion is initially OFF.

*/
- setDollarExpansion: (BOOL)_bExpand;
- setDollarExpansion;

/** 
 Returns whether dollar expansion is on or off.  It is initially OFF.

*/
- (BOOL) isDollarExpansion;

/** 
 Mark the config object as "clean," i.e. don't write dirty entries
 at destruction time. If @p bDeep is false, only the global dirty
 flag of the KConfig object gets cleared. If you then call
 @ref -writeEntry again, the global dirty flag is set again and all
 dirty entries will be written at a subsequent @ref -sync call.

 Classes that derive from KConfigBase should override this
 method and implement storage-specific behavior, as well as
 calling the @ref -[KConfigBase rollback] explicitly in the initializer.

*/
- rollback: (BOOL)bDeep;
- rollback;

/** 
 Flushes all changes that currently reside only in memory
 back to disk / permanent storage. Dirty configuration entries are
 written to the most specific file available.

 Asks the back end to flush out all pending writes, and then calls
 @ref -rollback.  No changes are made if the object has @p readOnly
 status.

 You should call this from your destructor in derivative classes.

*/
- sync;

/** 

*/
- (BOOL) isDirty;

/** 
 Sets the config object's read-only status.

   
*/
- setReadOnly: (BOOL)_ro;

/** 
 Returns the read-only status of the config object.

*/
- (BOOL) isReadOnly;

/** 
 Checks whether the key has an entry in the currently active group.
 Use this to determine whether a key is not specified for the current
 group (-hasKey returns false). Keys with null data are considered
 nonexistent.

*/
- (BOOL) hasKey: (NSString *)key;

/** 
 Reparses all configuration files. This is useful for programs
 that use stand alone graphical configuration tools. The base
 method implemented here only clears the group list and then
 appends the default group.

 Derivative classes should clear any internal data structures and
 then simply call @ref -parseConfigFiles when implementing this
 method.

*/
- reparseConfiguration;

/** 

*/
- (BOOL) isImmutable;

/** 

*/
- (BOOL) groupIsImmutable: (NSString *)group;

/** 

*/
- (BOOL) entryIsImmutable: (NSString *)key;

/** 
 Returns the state of the app-config object.

 Possible return values
 are NoAccess (the application-specific config file could not be
 opened neither read-write nor read-only), ReadOnly (the
 application-specific config file is opened read-only, but not
 read-write) and ReadWrite (the application-specific config
 file is opened read-write).

*/
- (int) getConfigState;

/** 
 Overloaded public methods:
   
*/
- setGroup: (NSString *)pGroup;
- setGroup: (NSString *)pGroup;
- (BOOL) hasGroup: (NSString *)_pGroup;
- (BOOL) hasGroup: (NSString *)_pGroup;
- (BOOL) hasKey: (NSString *)pKey;
+ (int) NoAccess;
+ (int) ReadOnly;
+ (int) ReadWrite;
@end

/** Override these methods in subclasses of KConfigBase to customise event handling behaviour */
@protocol KConfigBaseEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
