package org.kde.koala;
import org.kde.qt.*;


/** {@link KRestrictedLine} emits these signals */
public interface KRestrictedLineSignals {

/** 
 Emitted when the shortcut for substring completion is pressed.
     
*/
	void substringCompletion( String arg1 );

/** 
 Emitted when the user changed the completion mode by using the
 popupmenu.
     
*/
	void completionModeChanged( int arg1 );
	void destroyed( QObject obj );

/** 
 Emitted when the user presses the return key.

  The argument is the current text.  Note that this
 signal is <em>not</em> emitted if the widget's <code>EchoMode</code> is set to
 {@link QLineEdit#EchoMode}.
     
*/
	void returnPressed( String arg1 );

/** 
 Emitted when the text rotation key-bindings are pressed.

 The argument indicates which key-binding was pressed.
 In KLineEdit's case this can be either one of two values:
 {@link PrevCompletionMatch} or {@link NextCompletionMatch}. See
 {@link KCompletionBase#setKeyBinding} for details.

 Note that this signal is <em>not</em> emitted if the completion
 mode is set to <code>KGlobalSettings.CompletionNone</code> or <code>echoMode</code>() is <em>not</em>  normal.
     
*/
	void textRotation( int arg1 );

/** 
 Emitted when an invalid character was typed.
   
*/
	void invalidChar( int arg1 );

/** 
 Emitted before the context menu is displayed.

 The signal allows you to add your own entries into the
 the context menu that is created on demand.

 NOTE: Do not store the pointer to the QPopupMenu
 provided through since it is created and deleted
 on demand.

*/
	void aboutToShowContextMenu( QPopupMenu arg1 );

/** 
 Emitted when the completion key is pressed.

 Please note that this signal is <em>not</em> emitted if the
 completion mode is set to <code>CompletionNone</code> or <code>EchoMode</code> is
 <em>normal.</em>
     
*/
	void completion( String arg1 );
	void selectionChanged();
	void textChanged( String arg1 );
}

