/***************************************************************************
                            kde_SshProcess.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_SSHPROCESS
#define KDE_SSHPROCESS

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Executes a remote command, using ssh.
 
 @short 
 Executes a remote command, using ssh.
*/
#define SSHPROCESS_SshNotFound	1
#define SSHPROCESS_SshNeedsPassword	0
#define SSHPROCESS_SshIncorrectPassword	1
kde_SshProcess * kde_new_SshProcess(qt_QCString* host, qt_QCString* user, qt_QCString* command);
void kde_del_SshProcess( kde_SshProcess* p );

/**  Sets the target host. 
*/
void kde_SshProcess_setHost(kde_SshProcess* instPointer,qt_QCString* host);

/**  Sets the localtion of the remote stub. 
*/
void kde_SshProcess_setStub(kde_SshProcess* instPointer,qt_QCString* stub);

/**  
 Checks if the current user@host needs a password. 

*/
int kde_SshProcess_checkNeedPassword(kde_SshProcess* instPointer);

/** 
 Checks if the stub is installed and if the password is correct.

*/
int kde_SshProcess_checkInstall(kde_SshProcess* instPointer,char* password);

/**  Executes the command. 
*/
int kde_SshProcess_exec(kde_SshProcess* instPointer,char* password, int check);
qt_QCString* kde_SshProcess_prompt(kde_SshProcess* instPointer);
qt_QCString* kde_SshProcess_error(kde_SshProcess* instPointer);
qt_QCString* kde_SshProcess_display(kde_SshProcess* instPointer);
qt_QCString* kde_SshProcess_displayAuth(kde_SshProcess* instPointer);
qt_QCString* kde_SshProcess_dcopServer(kde_SshProcess* instPointer);

#endif
