/***************************************************************************
                            kde_KCursor.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KCURSOR
#define KDE_KCURSOR

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 A wrapper around @ref QCursor that allows for "themed" cursors.

 Currently, the only themed cursor is a hand shaped cursor.

 A typical usage would be
 <PRE>
 	setCursor(KCursor::handCursor());
 </PRE>

 @author Kurt Granroth <granroth@kde.org>
 
 @short A QCursor wrapper allowing "themed" cursors and auto-hiding cursors.

*/

/** 
 Constructor.

 Does not do anything so far.

*/
kde_KCursor * kde_new_KCursor();

/** 
 Returns the proper hand cursor according to
 the current GUI style (static function).
     
*/
qt_QCursor* kde_KCursor_handCursor( );

/** 
 Returns the proper arrow+hourglass cursor according to
 the current GUI style (static function).
     
*/
qt_QCursor* kde_KCursor_workingCursor( );

/** 
 Returns the proper arrow cursor according to
 the current GUI style (static function).
     
*/
qt_QCursor* kde_KCursor_arrowCursor( );

/** 
 Returns the proper up arrow cursor according to
 the current GUI style (static function).
     
*/
qt_QCursor* kde_KCursor_upArrowCursor( );

/** 
 Returns the proper cross-hair cursor according to
 the current GUI style (static function).
     
*/
qt_QCursor* kde_KCursor_crossCursor( );

/** 
 Returns the proper hourglass cursor according to
 the current GUI style (static function).
     
*/
qt_QCursor* kde_KCursor_waitCursor( );

/** 
 Returns the proper text cursor according to
 the current GUI style (static function).
     
*/
qt_QCursor* kde_KCursor_ibeamCursor( );

/** 
 Returns the proper vertical resize cursor
 according to the current GUI style (static function).
     
*/
qt_QCursor* kde_KCursor_sizeVerCursor( );

/** 
 Returns the proper horizontal resize cursor
 according to the current GUI style (static function).
     
*/
qt_QCursor* kde_KCursor_sizeHorCursor( );

/** 
 Returns the proper diagonal resize (/) cursor
 according to the current GUI style (static function).
     
*/
qt_QCursor* kde_KCursor_sizeBDiagCursor( );

/** 
 Returns the proper diagonal resize (\) cursor
 according to the current GUI style (static function).
     
*/
qt_QCursor* kde_KCursor_sizeFDiagCursor( );

/** 
 Returns the proper all-directions resize cursor
 according to the current GUI style (static function).
     
*/
qt_QCursor* kde_KCursor_sizeAllCursor( );

/** 
 Returns a blank or invisible cursor (static function).
     
*/
qt_QCursor* kde_KCursor_blankCursor( );

/** 
 Returns a WhatsThis cursor (static function).
     
*/
qt_QCursor* kde_KCursor_whatsThisCursor( );

/** 
 Sets auto-hiding the cursor for widget @p w. Enabling it will result in
 the cursor being hidden when

 The cursor will be shown again when the focus is lost or a mouse-event
 happens.

 Side effect: when enabling auto-hide, mouseTracking is enabled for the
 specified widget, because it's needed to get mouse-move-events. So
 don't disable mouseTracking for a widget while using auto-hide for it.

 When disabling auto-hide, mouseTracking will be disabled, so if you need
 mouseTracking after disabling auto-hide, you have to reenable
 mouseTracking.

 If you want to use auto-hiding for widgets that don't take focus, e.g.
 a QCanvasView, then you have to pass all key-events that should trigger
 auto-hiding to @ref autoHideEventFilter().
     
*/
void kde_KCursor_setAutoHideCursor( qt_QWidget * w, int enable);

/** 
 Overloaded method for the case where you have an event-filter installed
 on the widget you want to enable auto-cursor-hiding.

 In this case set @p customEventFilter to true and call
 @ref autoHideEventFilter() from the beginning of your eventFilter().

*/
void kde_KCursor_setAutoHideCursor1( qt_QWidget * w, int enable, int customEventFilter);

/** 
 Sets the delay time in milliseconds for auto-hiding. When no keyboard
 events arrive for that time-frame, the cursor will be hidden.

 Default is 5000, i.e. 5 seconds.
     
*/
void kde_KCursor_setHideCursorDelay( int ms);

/** 

 Default is 5000, i.e. 5 seconds.
     
*/
int kde_KCursor_hideCursorDelay( );

/** 
 KCursor has to install an eventFilter over the widget you want to
 auto-hide. If you have an own eventFilter() on that widget and stop
 some events by returning true, you might break auto-hiding, because
 KCursor doesn't get those events.

 In this case, you need to call setAutoHideCursor( widget, true, true );
 to tell KCursor not to install an eventFilter. Then you call this method
 from the beginning of your eventFilter, for example:
 <pre>
 edit = new KEdit( this, "some edit widget" );
 edit->installEventFilter( this );
 KCursor::setAutoHideCursor( edit, true, true );

 [...]

 bool YourClass::eventFilter( QObject *o, QEvent *e )
 {
     if ( o == edit ) // only that widget where you enabled auto-hide!
         KCursor::autoHideEventFilter( o, e );

     // now you can do your own event-processing
     [...]
 }
 </pre>

 Note that you must not call KCursor::autoHideEventFilter() when you
 didn't enable or after disabling auto-hiding.
     
*/
void kde_KCursor_autoHideEventFilter( qt_QObject * arg1, qt_QEvent * arg2);

#endif
