/***************************************************************************
                          kcmkuick.cpp - control module for kuick
                             -------------------
    copyright            : (C) 2001 by Holger Freyther <freyther@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.        *
 *                                                                         *
 ***************************************************************************/

#include "kcmkuick.h"

#include <kfontdialog.h>
#include <qlayout.h>
#include <kglobal.h>
#include <klocale.h>
#include <kconfig.h>
#include <kdebug.h>

#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qstring.h>

KCMKuick::KCMKuick(QWidget * parent, const char *name)
:KCModule(parent, name)
{
    QVBoxLayout *topLayout = new QVBoxLayout(this, 0, 0);
    dialog = new KCMKuickDialog(this);
    topLayout->add(dialog);
    connect( dialog->m_sbCopy, SIGNAL(valueChanged(int) ), this, SLOT(configChanged() ) );
    connect( dialog->m_sbMove, SIGNAL(valueChanged(int) ), this, SLOT(configChanged() ) );
    connect( dialog->pbCopyClear, SIGNAL(pressed() ), this, SLOT(slotClearCopyCache() ) );
    connect( dialog->pbMoveClear, SIGNAL(pressed() ), this, SLOT(slotClearMoveCache() ) );
    load();



}

void KCMKuick::load()
{

    KConfig config( "konquerorrc");
    config.setGroup("kuick-copy");
    dialog->m_sbCopy->setValue(config.readNumEntry("ShowRecent",5) );

    config.setGroup("kuick-write" );
    dialog->m_sbMove->setValue(config.readNumEntry("ShowRecent",5) );
    emit changed(false);
}

KCMKuick::~KCMKuick() {

}
void KCMKuick::load(const QString & /*s*/)
{

}


void KCMKuick::configChanged()
{
emit changed(true);
}

void KCMKuick::save()
{
    KConfig config("konquerorrc" );
    config.setGroup("kuick-copy");

    config.writeEntry("ShowRecent", dialog->m_sbCopy->value() );

    config.setGroup("kuick-write" );
    config.writeEntry("ShowRecent", dialog->m_sbMove->value() );

    config.sync();		//is it necessary ?

    emit changed(false);

}
void KCMKuick::slotClearCopyCache( ) {
     KConfig config("konquerorrc");
     config.setGroup("kuick-copy" );
     config.writeEntry("Paths", QStringList() );
}
void KCMKuick::slotClearMoveCache() {
     KConfig config("konquerorrc");
     config.setGroup("kuick-write" );
     config.writeEntry("Paths", QStringList() );
}
void KCMKuick::defaults()
{


    dialog->m_sbCopy->setValue(4);
    dialog->m_sbMove->setValue(4);


    configChanged();

}

QString KCMKuick::quickHelp() const
{
    return i18n("<h1>Kuick</h1> With this module you can configure kuick, the KDE quick"
		"copy and move plugin for Konqueror.");
}

const KAboutData * KCMKuick::aboutData() const
{

 KAboutData *ab=new KAboutData( "kcmkuick", I18N_NOOP("KCM Kuick"),
    "0.2",I18N_NOOP("KControl module for kuicks configuration"), KAboutData::License_GPL,
    "(c) 2001, Holger Freyther", 0, 0, "freyther@kde.org");

  ab->addAuthor("Holger Freyther",0, "freyther@kde.org");
 return ab;

}

extern "C" {
    KCModule *create_kuick(QWidget * parent, const char *) {
	return new KCMKuick(parent, "kcmkuick");
    };
}



#include "kcmkuick.moc"
