 /***************************************************************************
    plugin_katexmltools.h
    $Id: plugin_katexmltools.h,v 1.3 2002/01/24 00:59:12 dnaber Exp $
    copyright            : (C) 2001,2002 by Daniel Naber
    email                : daniel.naber@t-online.de
 ***************************************************************************/
 
/***************************************************************************
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ***************************************************************************/

#ifndef _PLUGIN_KANT_XMLTOOLS_H
#define _PLUGIN_KANT_XMLTOOLS_H

#include <qstring.h>
#include <qprogressdialog.h>
#include <qlistbox.h>

#include <kate/plugin.h>
#include <kate/application.h>
#include <kate/view.h>
#include <kate/document.h>
#include <kate/docmanager.h>
#include <kate/mainwindow.h>
#include <kate/viewmanager.h>
#include <ktexteditor/codecompletioninterface.h>

#include <klibloader.h>
#include <kdialog.h>

class KatePluginFactory : public KLibFactory
{

Q_OBJECT

public:
	KatePluginFactory();
	virtual ~KatePluginFactory();

	virtual QObject* createObject( QObject* parent = 0, const char* pname = 0, const char* name = "QObject", const QStringList &args = QStringList() );

private:
	static KInstance* s_instance;

};

class PluginKateXMLTools : public Kate::Plugin
{

Q_OBJECT

public:

	PluginKateXMLTools( QObject* parent = 0, const char* name = 0 );
	virtual ~PluginKateXMLTools();
	Kate::PluginView *createView (Kate::MainWindow *win);

private:

	QString KatePrompt (QString strTitle, QString strPrompt, QStringList list, 
		QWidget *widget, Kate::View *kv);

	QString insideTag(Kate::View &kv);
	QString insideAttribute(Kate::View &kv);

	void analyzeDTD();

	bool isOpeningTag(QString tag);
	bool isClosingTag(QString tag);
	bool isEmptyTag(QString tag);
	bool isQuote(QString ch);
	
	QString getParentElement(Kate::View &view);
	bool getAllowedElements(QDomDocument *doc, QProgressDialog *progress);
	QStringList getAllowedElementsFast(QString parent_element);
	bool getAllowedAttributes(QDomDocument *doc, QProgressDialog *progress);
	QStringList getAllowedAttributesFast(QString parent_element);
	bool getAllowedAttributeValues(QDomDocument *doc, QProgressDialog *progress);
	QStringList getAllowedAttributeValuesFast(QString element, QString attribute);
	bool getEntities(QDomDocument *doc, QProgressDialog *progress);
	QStringList getEntitiesFast(QString start);

	enum Mode {none, entities, attributevalues, attributes, elements};

	bool m_ready;
	bool m_sgml_support;
	uint m_max_check;
	uint m_max_check_elements;
	QString m_dtd_string;
	QString m_url_string;

	// Entities, e.g. <"nbsp", "160">
	QMap<QString,QString> m_entity_list;
	// Elements, e.g. <"a", ("b", "i", "em", "strong")>
	QMap<QString,QStringList> m_elements_list;
	// Attributes e.g. <"a", ("href", "lang", "title")>
	QMap<QString,QStringList> m_attributes_list;
	// Attribute values e.g. <"td", <"align", ("left", "right", "justify")>>
	QMap< QString,QMap<QString,QStringList> > m_attributevalues_list;

    // code completion stuff:
    KTextEditor::CodeCompletionInterface* m_codeInterface;

public slots:

	void getDTD();

	void slotCloseElement();
	void slotGetEntity();
	void slotGetInput(Mode mode);
	void slotGetInput();
	
	void slotFinished(KIO::Job *job);
	void slotData(KIO::Job *, const QByteArray &data);

protected:

	//bool eventFilter(QObject *object, QEvent *event);
	Kate::PluginView *m_pluginview;

};

class SelectDialog : public KDialog
{

Q_OBJECT

public:
	SelectDialog(QWidget *parent, QString caption, QString prompt, QStringList list);
	virtual ~SelectDialog();

	virtual QString selection();

protected slots:
	void slotSelect();
	void slotCancel();

protected:
	QListBox *m_ListBox;
	QString *m_Selection;

};

#endif // _PLUGIN_KANT_XMLTOOLS_H
