/*
 * GQview
 * (C) 2001 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#ifndef THUMB_H
#define THUMB_H


void thumb_loader_set_error_func(ThumbLoader *tl,
				 void (*func_error)(ThumbLoader *, gpointer),
				 gpointer data_error);
void thumb_loader_set_percent_func(ThumbLoader *tl,
				   void (*func_percent)(ThumbLoader *, gfloat, gpointer),
				   gpointer data_percent);

gint thumb_loader_start(ThumbLoader *tl, void (*func_done)(ThumbLoader *, gpointer), gpointer data_done);

gint thumb_loader_to_pixmap(ThumbLoader *tl, GdkPixmap **pixmap, GdkBitmap **mask);

gint thumb_loader_get_space(ThumbLoader *tl);

ThumbLoader *thumb_loader_new(gchar *path, gint width, gint height);
void thumb_loader_free(ThumbLoader *tl);

gint thumb_from_xpm_d(const char **data, gint max_w, gint max_h, GdkPixmap **pixmap, GdkBitmap **mask);


#endif
