/* vi:set ts=8 sts=0 sw=8:
 * $Id: msgbar.c,v 1.18 2000/03/13 23:03:50 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdarg.h>
#include <string.h>
#include "main.h"
#ifdef USE_GNOME
#include <gnome.h>
#endif
#include "win.h"
#include "msgbar.h"
#include "prefs.h"
#include "menu.h"


/*** global function definitions ***/
/*
 * PUBLIC: msgbar_clear
 *
 * clears the text by using a space (" ").  apparently, Gtk has no provision
 * for clearing a label widget.
 */
int
msgbar_clear(gpointer data)
{
	win_t *w = (win_t *)data;

	msgbar_printf(w, " ");
	return FALSE;
} /* msgbar_clear */


#ifndef USE_GNOME
/*
 * PUBLIC: msgbar_init
 *
 * initialize the message bar.  called from win_new().
 */
void
msgbar_init(win_t *w, GtkWidget *parent)
{
	w->msgbar = gtk_label_new(" ");
	gtk_box_pack_start(GTK_BOX(parent), w->msgbar, FALSE, FALSE, 0);
	gtk_misc_set_alignment(GTK_MISC(w->msgbar), 0.0, 0.5);

	/* set according to preferences */
	if (IS_SHOW_MSGBAR())
		gtk_widget_show(w->msgbar);
} /* msgbar_init */
#endif


/*
 * PUBLIC: msgbar_printf
 *
 * sets the message/status bar.  remembers the last message set so that a
 * duplicate one won't be set on top of the current one.
 */
void
msgbar_printf(win_t *w, const char *fmt, ...)
{
#ifdef GTK_HAVE_FEATURES_1_1_0
	va_list args;
#else
	va_list ap1, ap2;
#endif
	char *msg;

#ifdef GTK_HAVE_FEATURES_1_1_0
	va_start(args, fmt);
	msg = g_strdup_vprintf(fmt, args);
	va_end(args);
#else
	va_start(ap1, fmt);
	va_start(ap2, fmt);
	msg = g_vsprintf(fmt, &ap1, &ap2);
	va_end(ap1);
	va_end(ap2);
#endif
	if (w->lastmsg == NULL || (w->lastmsg && strcmp(w->lastmsg, msg))) {
		if (w->lastmsg && w->timeout_id > 0)
			gtk_timeout_remove(w->timeout_id);
#ifdef USE_GNOME
		gnome_appbar_set_status(GNOME_APPBAR(w->msgbar), msg);
#else
		gtk_label_set(GTK_LABEL(w->msgbar), msg);
#endif
		g_free(w->lastmsg);
		w->lastmsg = g_strdup(msg);
		w->timeout_id = gtk_timeout_add(
					5000, (GtkFunction)msgbar_clear, w);
	}
#ifdef GTK_HAVE_FEATURES_1_1_0
	g_free(msg);
#endif
} /* msgbar_printf */


/*
 * PUBLIC: msgbar_redraw
 *
 * redraws the msgbar for a specified window
 */
void
msgbar_redraw(void *data)
{
	win_t *w = (win_t *)data;

	if (IS_SHOW_MSGBAR()) {
#ifdef USE_GNOME
		gtk_widget_show_all(w->msgbar->parent);
#else
		gtk_widget_show_all(w->hbox_bot);
#endif
	} else {
#ifdef USE_GNOME
		gtk_widget_hide_all(w->msgbar->parent);
#else
		gtk_widget_hide_all(w->hbox_bot);
#endif
	}

	/* need to update the toggle items in the menu */
	menu_main_state_set(w);
} /* msgbar_redraw */


/*
 * PUBLIC: msgbar toggle
 *
 * toggles the msgbar on/off
 */
void
msgbar_toggle(GtkWidget *wgt, gpointer cbdata)
{
	if (IS_SHOW_MSGBAR())
		CLEAR_SHOW_MSGBAR();
	else
		SET_SHOW_MSGBAR();
	win_foreach(msgbar_redraw);
} /* msgbar_toggle */


/* the end */
