/*******************************
 General utility functions
 (c) 1999 Jeremy Wise
 GnomeICU
********************************/

#include "common.h"
#include "gnomecfg.h"
#include "gnomeicu.h"
#include "icons.h"
#include "showlist.h"
#include "util.h"
#include "v7send.h"

typedef struct 
{
  const char *name;
  WORD code;
} COUNTRY_CODE;

static COUNTRY_CODE Country_Codes[] = {
  { N_("Afghanistan"), 93 },
  { N_("Albania"), 355 },
  { N_("Algeria"), 213 },
  { N_("American Samoa"), 684 },
  { N_("Andorra"), 376 },
  { N_("Angola"), 244 },
  { N_("Anguilla"), 101 },
  { N_("Antigua"), 102 },
  { N_("Argentina"), 54 },
  { N_("Armenia"), 374 },
  { N_("Aruba"), 297 },
  { N_("Ascension Island"), 247 },
  { N_("Australia"), 61 },
  { N_("Australian Antarctic Territory"), 6721 },
  { N_("Austria"), 43 },
  { N_("Azerbaijan"), 994 },
  { N_("Bahamas"), 103 },
  { N_("Bahrain"), 973 },
  { N_("Bangladesh"), 880 },
  { N_("Barbados"), 104 },
  { N_("Barbuda"), 120 },
  { N_("Belarus"), 375 },
  { N_("Belgium"), 32 },
  { N_("Belize"), 501 },
  { N_("Benin"), 229 },
  { N_("Bermuda"), 105 },
  { N_("Bhutan"), 975 },
  { N_("Bolivia"), 591 },
  { N_("Bosnia and Herzegovina"), 387 },
  { N_("Botswana"), 267 },
  { N_("Brazil"), 55 },
  { N_("British Virgin Islands"), 106 },
  { N_("Brunei"), 673 },
  { N_("Bulgaria"), 359 },
  { N_("Burkina Faso"), 226 },
  { N_("Burundi"), 257 },
  { N_("Cambodia"), 855 },
  { N_("Cameroon"), 237 },
  { N_("Canada"), 107 },
  { N_("Cape Verde Islands"), 238 },
  { N_("Cayman Islands"), 108 },
  { N_("Central African Republic"), 236 },
  { N_("Chad"), 235 },
  { N_("Chile"), 56 },
  { N_("China"), 86 },
  { N_("Christmas Island"), 672 },
  { N_("Cocos-Keeling Islands"), 6101 },
  { N_("Colombia"), 57 },
  { N_("Comoros"), 2691 },
  { N_("Congo"), 242 },
  { N_("Cook Islands"), 682 },
  { N_("Costa Rica"), 506 },
  { N_("Croatia"), 385 },
  { N_("Cuba"), 53 },
  { N_("Cyprus"), 357 },
  { N_("Czech Republic"), 42 },
  { N_("Dem. Rep. of the Congo"), 243 },
  { N_("Denmark"), 45 },
  { N_("Diego Garcia"), 246 },
  { N_("Djibouti"), 253 },
  { N_("Dominica"), 109 },
  { N_("Dominican Republic"), 110 },
  { N_("Ecuador"), 593 },
  { N_("Egypt"), 20 },
  { N_("El Salvador"), 503 },
  { N_("Equatorial Guinea"), 240 },
  { N_("Eritrea"), 291 },
  { N_("Estonia"), 372 },
  { N_("Ethiopia"), 251 },
  { N_("F.Y.R.O.M. (Former Yugoslav Republic of Macedonia)"), 389 },
  { N_("Faeroe Islands"), 298 },
  { N_("Falkland Islands"), 500 },
  { N_("Fiji Islands"), 679 },
  { N_("Finland"), 358 },
  { N_("France"), 33 },
  { N_("French Antilles"), 5901 },
  { N_("French Guiana"), 594 },
  { N_("French Polynesia"), 689 },
  { N_("Gabon"), 241 },
  { N_("Gambia"), 220 },
  { N_("Georgia"), 995 },
  { N_("Germany"), 49 },
  { N_("Ghana"), 233 },
  { N_("Gibraltar"), 350 },
  { N_("Greece"), 30 },
  { N_("Greenland"), 299 },
  { N_("Grenada"), 111 },
  { N_("Guadeloupe"), 590 },
  { N_("Guam"), 671 },
  { N_("Guantanamo Bay"), 5399 },
  { N_("Guatemala"), 502 },
  { N_("Guinea"), 224 },
  { N_("Guinea-Bissau"), 245 },
  { N_("Guyana"), 592 },
  { N_("Haiti"), 509 },
  { N_("Honduras"), 504 },
  { N_("Hong Kong"), 852 },
  { N_("Hungary"), 36 },
  { N_("INMARSAT (Atlantic-East)"), 871 },
  { N_("INMARSAT (Atlantic-West)"), 874 },
  { N_("INMARSAT (Indian)"), 873 },
  { N_("INMARSAT (Pacific)"), 872 },
  { N_("INMARSAT"), 870 },
  { N_("Iceland"), 354 },
  { N_("India"), 91 },
  { N_("Indonesia"), 62 },
  { N_("International Freephone Service"), 800 },
  { N_("Iran"), 98 },
  { N_("Iraq"), 964 },
  { N_("Ireland"), 353 },
  { N_("Israel"), 972 },
  { N_("Italy"), 39 },
  { N_("Ivory Coast"), 225 },
  { N_("Jamaica"), 112 },
  { N_("Japan"), 81 },
  { N_("Jordan"), 962 },
  { N_("Kazakhstan"), 705 },
  { N_("Kenya"), 254 },
  { N_("Kiribati Republic"), 686 },
  { N_("Korea (North)"), 850 },
  { N_("Korea (Republic of)"), 82 },
  { N_("Kuwait"), 965 },
  { N_("Kyrgyz Republic"), 706 },
  { N_("Laos"), 856 },
  { N_("Latvia"), 371 },
  { N_("Lebanon"), 961 },
  { N_("Lesotho"), 266 },
  { N_("Liberia"), 231 },
  { N_("Libya"), 218 },
  { N_("Liechtenstein"), 4101 },
  { N_("Lithuania"), 370 },
  { N_("Luxembourg"), 352 },
  { N_("Macau"), 853 },
  { N_("Madagascar"), 261 },
  { N_("Malawi"), 265 },
  { N_("Malaysia"), 60 },
  { N_("Maldives"), 960 },
  { N_("Mali"), 223 },
  { N_("Malta"), 356 },
  { N_("Marshall Islands"), 692 },
  { N_("Martinique"), 596 },
  { N_("Mauritania"), 222 },
  { N_("Mauritius"), 230 },
  { N_("Mayotte Island"), 269 },
  { N_("Mexico"), 52 },
  { N_("Micronesia, Federated States of"), 691 },
  { N_("Moldova"), 373 },
  { N_("Monaco"), 377 },
  { N_("Mongolia"), 976 },
  { N_("Montserrat"), 113 },
  { N_("Morocco"), 212 },
  { N_("Mozambique"), 258 },
  { N_("Myanmar"), 95 },
  { N_("Namibia"), 264 },
  { N_("Nauru"), 674 },
  { N_("Nepal"), 977 },
  { N_("Netherlands Antilles"), 599 },
  { N_("Netherlands"), 31 },
  { N_("Nevis"), 114 },
  { N_("New Caledonia"), 687 },
  { N_("New Zealand"), 64 },
  { N_("Nicaragua"), 505 },
  { N_("Niger"), 227 },
  { N_("Nigeria"), 234 },
  { N_("Niue"), 683 },
  { N_("Norfolk Island"), 6722 },
  { N_("Norway"), 47 },
  { N_("Oman"), 968 },
  { N_("Pakistan"), 92 },
  { N_("Palau"), 680 },
  { N_("Panama"), 507 },
  { N_("Papua New Guinea"), 675 },
  { N_("Paraguay"), 595 },
  { N_("Peru"), 51 },
  { N_("Philippines"), 63 },
  { N_("Poland"), 48 },
  { N_("Portugal"), 351 },
  { N_("Puerto Rico"), 121 },
  { N_("Qatar"), 974 },
  { N_("Reunion Island"), 262 },
  { N_("Romania"), 40 },
  { N_("Rota Island"), 6701 },
  { N_("Russia"), 7 },
  { N_("Rwanda"), 250 },
  { N_("Saint Lucia"), 122 },
  { N_("Saipan Island"), 670 },
  { N_("San Marino"), 378 },
  { N_("Sao Tome and Principe"), 239 },
  { N_("Saudi Arabia"), 966 },
  { N_("Senegal Republic"), 221 },
  { N_("Seychelle Islands"), 248 },
  { N_("Sierra Leone"), 232 },
  { N_("Singapore"), 65 },
  { N_("Slovak Republic"), 4201 },
  { N_("Slovenia"), 386 },
  { N_("Solomon Islands"), 677 },
  { N_("Somalia"), 252 },
  { N_("South Africa"), 27 },
  { N_("Spain"), 34 },
  { N_("Sri Lanka"), 94 },
  { N_("St. Helena"), 290 },
  { N_("St. Kitts"), 115 },
  { N_("St. Pierre and Miquelon"), 508 },
  { N_("St. Vincent and the Grenadines"), 116 },
  { N_("Sudan"), 249 },
  { N_("Suriname"), 597 },
  { N_("Swaziland"), 268 },
  { N_("Sweden"), 46 },
  { N_("Switzerland"), 41 },
  { N_("Syria"), 963 },
  { N_("Taiwan, Republic of China"), 886 },
  { N_("Tajikistan"), 708 },
  { N_("Tanzania"), 255 },
  { N_("Thailand"), 66 },
  { N_("Tinian Island"), 6702 },
  { N_("Togo"), 228 },
  { N_("Tokelau"), 690 },
  { N_("Tonga"), 676 },
  { N_("Trinidad and Tobago"), 117 },
  { N_("Tunisia"), 216 },
  { N_("Turkey"), 90 },
  { N_("Turkmenistan"), 709 },
  { N_("Turks and Caicos Islands"), 118 },
  { N_("Tuvalu"), 688 },
  { N_("USA"), 1 },
  { N_("Uganda"), 256 },
  { N_("Ukraine"), 380 },
  { N_("United Arab Emirates"), 971 },
  { N_("United Kingdom"), 44 },
  { N_("United States Virgin Islands"), 123 },
  { N_("Uruguay"), 598 },
  { N_("Uzbekistan"), 711 },
  { N_("Vanuatu"), 678 },
  { N_("Vatican City"), 379 },
  { N_("Venezuela"), 58 },
  { N_("Vietnam"), 84 },
  { N_("Wallis and Futuna Islands"), 681 },
  { N_("Western Samoa"), 685 },
  { N_("Yemen"), 967 },
  { N_("Yugoslavia"), 381 },
  { N_("Zambia"), 260 },
  { N_("Zimbabwe"), 263 },
  { N_("Not entered"), 0 },
  { N_("Not entered"), 0xffff } 
};

typedef struct
{
	const char *str;
	int gmt_offset;
} TIME_ZONE;

TIME_ZONE time_zones[] =
{
  /* { N_("UTC+1300 (Tonga)"), 1300 }, Unused */
{ N_("UTC+1200 (Fiji)"), -24 },
{ N_("UTC+1130"), -23 },
{ N_("UTC+1100 (Solomon Islands)"), -22 },
{ N_("UTC+1030"), -21 },
{ N_("UTC+1000 (Guam)"), -20 },
{ N_("UTC+0930"), -19 },
{ N_("UTC+0900 (Japan)"), -18 },
{ N_("UTC+0830"), -17 },
{ N_("UTC+0800 (China/Taiwan)"), -16 },
{ N_("UTC+0730"), -15 },
{ N_("UTC+0700 (Cambodia)"), -14 },
{ N_("UTC+0630"), -13 },
{ N_("UTC+0600 (Bangladesh)"), -12 },
{ N_("UTC+0530"), -11 },
{ N_("UTC+0500 (Turkmenistan)"), -10 },
{ N_("UTC+0430"), -9 },
{ N_("UTC+0400 (Yemen/Oman/Armenia)"), -8 },
{ N_("UTC+0330"), -7 },
{ N_("UTC+0300 (Eastern African)"), -6 },
{ N_("UTC+0230"), -5 },
{ N_("UTC+0200 (Eastern European)"), -4 },
{ N_("UTC+0130"), -3 },
{ N_("UTC+0100 (Middle European)"), -2 },
{ N_("UTC+0030"), -1 },
{ N_("UTC"), 0 },
{ N_("UTC-0030"), 1 },
{ N_("UTC-0100"), 2 },
{ N_("UTC-0130"), 3 },
{ N_("UTC-0200 (Central African)"), 4 },
{ N_("UTC-0230"), 5 },
{ N_("UTC-0300 (Brazil)"), 6 },
{ N_("UTC-0330"), 7 },
{ N_("UTC-0400 (Atlantic)"), 8 },
{ N_("UTC-0430"), 9 },
{ N_("UTC-0500 (Eastern)"), 10 },
{ N_("UTC-0530"), 11 },
{ N_("UTC-0600 (Central)"), 12 },
{ N_("UTC-0630"), 13 },
{ N_("UTC-0700 (Mountain)"), 14 },
{ N_("UTC-0730"), 15 },
{ N_("UTC-0800 (Pacific)"), 16 },
{ N_("UTC-0830"), 17 },
{ N_("UTC-0900 (Alaska)"), 18 },
{ N_("UTC-0930"), 19 },
{ N_("UTC-1000 (Hawaii/Aleutian Islands)"), 20 },
{ N_("UTC-1030"), 21 },
{ N_("UTC-1100 (American Samoa)"), 22 },
{ N_("UTC-1130"), 23 },
{ N_("UTC-1200"), 24 },
{ N_("UTC-1230"), 25 },
{ N_("Unknown"), 100 }
};

/* Conversion tables for PC characters */

#define SP ' '

unsigned char iso1_to_pc[256]={
/*   0 */ SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,
/*  10 */ SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,
/*  20 */ SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,
/*  30 */ SP ,SP ,SP ,'!','\"','#','$','%','&','\'',
/*  40 */ '(',')','*','+',',','-','.','/','0','1',
/*  50 */ '2','3','4','5','6','7','8','9',':',';',
/*  60 */ '<','=','>','?','@','A','B','C','D','E',
/*  70 */ 'F','G','H','I','J','K','L','M','N','O',
/*  80 */ 'P','Q','R','S','T','U','V','W','X','Y',
/*  90 */ 'Z','[','\\',']','^','_','`','a','b','c',
/* 100 */ 'd','e','f','g','h','i','j','k','l','m',
/* 110 */ 'n','o','p','q','r','s','t','u','v','w',
/* 120 */ 'x','y','z','{','|','}','~',SP ,SP ,SP ,
/* 130 */ SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,
/* 140 */ SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,
/* 150 */ SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,
/* 160 */ SP ,173,189,156,207,190,221,245,249,184,
/* 170 */ 166,174,170,240,169,238,248,241,253,252,
/* 180 */ 239,230,244,250,247,251,167,175,172,171,
/* 190 */ 243,168,183,181,182,199,142,143,146,128,
/* 200 */ 212,144,210,211,222,214,215,216,209,165,
/* 210 */ 227,224,226,229,153,158,157,235,233,234,
/* 220 */ 154,237,232,225,133,160,131,198,132,134,
/* 230 */ 145,135,138,130,136,137,141,161,140,139,
/* 240 */ 208,164,149,162,147,228,148,246,155,151,
/* 250 */ 163,150,129,236,231,152 };

unsigned char pc_to_iso1[256]={
/*  00 */ SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,
/*  10 */ SP ,SP ,SP , 0 ,SP ,SP ,SP ,SP ,SP ,SP ,
/*  20 */ SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,SP ,
/*  30 */ SP ,SP ,SP ,'!','\"','#','$','%','&','\'',
/*  40 */ '(',')','*','+',',','-','.','/','0','1',
/*  50 */ '2','3','4','5','6','7','8','9',':',';',
/*  60 */ '<','=','>','?','@','A','B','C','D','E',
/*  70 */ 'F','G','H','I','J','K','L','M','N','O',
/*  80 */ 'P','Q','R','S','T','U','V','W','X','Y',
/*  90 */ 'Z','[','\\',']','^','_','`','a','b','c',
/* 100 */ 'd','e','f','g','h','i','j','k','l','m',
/* 110 */ 'n','o','p','q','r','s','t','u','v','w',
/* 120 */ 'x','y','z','{','|','}','~',SP ,199,252,
/* 130 */ 233,226,228,224,229,231,234,235,232,239,
/* 140 */ 238,236,196,197,201,230,198,244,246,242,
/* 150 */ 251,249,255,214,220,248,163,216,215,SP ,
/* 160 */ 225,237,243,250,241,209,170,186,191,174,
/* 170 */ 172,189,188,161,171,187,SP ,SP ,SP ,SP ,
/* 180 */ SP ,193,194,192,169,SP ,SP ,SP ,SP ,162,
/* 190 */ 165,SP ,SP ,SP ,SP ,SP ,SP ,SP ,227,195,
/* 200 */ SP ,SP ,SP ,SP ,SP ,SP ,SP ,164,240,208,
/* 210 */ 202,203,200,SP ,205,206,207,SP ,SP ,SP ,
/* 220 */ SP ,166,204,SP ,211,223,212,210,245,213,
/* 230 */ 181,254,222,218,219,217,253,221,175,180,
/* 240 */ 173,177,SP ,190,182,167,247,184,176,168,
/* 250 */ 183,185,179,178,SP ,SP };




/*** Global functions ***/

GSList *get_contact_from_clist( void )
{
    GtkCList *clist = GTK_CLIST( MainData->lb_userwin );
    g_return_val_if_fail( GTK_IS_WIDGET( clist ), NULL );

    if( clist->selection == NULL )
	    return NULL;

    return Find_User( GPOINTER_TO_INT( gtk_clist_get_row_data( clist, GPOINTER_TO_INT( clist->selection->data ) ) ) );
}

void select_clist_row_from_contact( CONTACT_PTR contact )
{
    GtkWidget *clist;

    clist = GTK_WIDGET ( Which_List( contact ) );

    MainData->lb_userwin = clist;
    gtk_clist_select_row( GTK_CLIST( clist ), contact->lb_index, 0 );
}

GList *get_time_zones( void )
{
	GList *l = NULL;
	int cx;

	for( cx = 0; time_zones[ cx ].gmt_offset != 100; cx ++ )
		l = g_list_prepend( l, _(time_zones[ cx ].str) );
	l = g_list_reverse( l );
	
	return l;
}

GList *get_country_codes( void )
{
  GList *l = NULL;
  gint cx;
  
  for( cx = 0; Country_Codes[ cx ].code != 0xffff; cx ++ )
    l = g_list_prepend( l, _(Country_Codes[ cx ].name) );
  l = g_list_sort( l, (GCompareFunc) strcoll );
  
  return l;
}

const gchar *Get_Country_Name( int code )
{
   gint i;
   
   for ( i = 0; Country_Codes[i].code != 0xffff; i++)
     if ( Country_Codes[i].code == code )
       return _(Country_Codes[i].name);

   return _(Country_Codes[i].name);
}

const gchar *Get_Time_Zone_String( char code )
{
	int cx;

	for( cx = 0; time_zones[ cx ].gmt_offset != 100; cx ++ )
	if( time_zones[ cx ].gmt_offset == code )
		return _(time_zones[ cx ].str);

	return _(time_zones[ cx ].str);
}

int Get_Country_Code( const gchar *country )
{
	int cx;

	for( cx = 0; Country_Codes[ cx ].code != 0xffff; cx++ )
	  if( !strcmp( _(Country_Codes[ cx ].name), country ) )
	    return Country_Codes[ cx ].code;

	return 0;
}

char Get_Time_Zone( const gchar *desc )
{
	int cx;

	for( cx = 0; time_zones[ cx ].gmt_offset != 100; cx ++ )
	{
		if( !strcmp( _(time_zones[ cx ].str), desc ) )
		{
			return time_zones[ cx ].gmt_offset;
		}
	}
	if( !strcmp( _(time_zones[ cx ].str), desc ) )
		return time_zones[ cx ].gmt_offset;
	return 0;
}

const gchar *get_status_str( DWORD status )
{
	if( status == STATUS_OFFLINE )
		return _("Offline");

	switch( status & 0xffff ) {
	case STATUS_ONLINE:
		return _("Online");
	case STATUS_AWAY:
		return _("Away");
	case STATUS_NA:
		return _("Not Available");
	case STATUS_FREE_CHAT:
		return _("Free For Chat");
	case STATUS_OCCUPIED:
		return _("Occupied");
	case STATUS_DND:
		return _("Do Not Disturb");
	case STATUS_INVISIBLE:
		return _("Invisible");
	default:
		return _("Unknown");
	}
}

/*******************************************************
Gets config info from the rc file in the users home 
directory.
********************************************************/
void Get_Unix_Config_Info( void )
{
	gchar *tmp;

#ifdef TRACE_FUNCTION
	g_print( "Get_Unix_Config_Info\n" );
#endif

	gnome_config_push_prefix( configfilename );

	if ( (tmp=gnome_config_get_string( "Existence/exists" )) == NULL )
		Initialize_RC_File();

	g_free(tmp);

	gnome_config_pop_prefix();

	Read_RC_File();
}


/********************************************
Converts an ip number character sequence to
a DWORD
The IP number is stored in big endian byte
order in the icq protocol
*********************************************/
DWORD IP_2_DW( const guchar buf[] )
{
       DWORD i;

       i= buf[0];
       i <<= 8;
       i+= buf[1];
       i <<= 8;
       i+= buf[2];
       i <<= 8;
       i+= buf[3];

       return i;
}


/********************************************
Converts an intel endian character sequence to
a DWORD
*********************************************/
DWORD Chars_2_DW( const guchar buf[] )
{
	DWORD i;

	i= buf[3];
	i <<= 8;
	i+= buf[2];
	i <<= 8;
	i+= buf[1];
	i <<= 8;
	i+= buf[0];

	return i;
}

/********************************************
Converts an intel endian character sequence to
a WORD
*********************************************/
WORD Chars_2_Word( const guchar *buf )
{
	WORD i;

	i= buf[1];
	i <<= 8;
	i += buf[0];

	return i;
}

/********************************************
Converts a DWORD to an IP number character 
sequence
The IP number is stored in big endian byte order
for use in the icq protocol
*********************************************/
void DW_2_IP( guchar buf[], DWORD num )
{
       buf[0] = ( guchar ) ((num)>>24)& 0x000000FF;
       buf[1] = ( guchar ) ((num)>>16)& 0x000000FF;
       buf[2] = ( guchar ) ((num)>>8)& 0x000000FF;
       buf[3] = ( guchar ) (num) & 0x000000FF;
}

/********************************************
Converts a DWORD to
an intel endian character sequence 
*********************************************/
void DW_2_Chars( guchar buf[], DWORD num )
{
	buf[3] = ( guchar ) ((num)>>24)& 0x000000FF;
	buf[2] = ( guchar ) ((num)>>16)& 0x000000FF;
	buf[1] = ( guchar ) ((num)>>8)& 0x000000FF;
	buf[0] = ( guchar ) (num) & 0x000000FF;
}

/********************************************
Converts a WORD to
an intel endian character sequence 
*********************************************/
void Word_2_Chars( guchar buf[], WORD num )
{
	buf[1] = ( guchar ) (((unsigned)num)>>8) & 0x00FF;
	buf[0] = ( guchar ) ((unsigned)num) & 0x00FF;
}

/* Strip '\r' from text */
gchar *stripr( const gchar *str )
{
	gchar *new;
	gint cx = 0, cy = 0;

	new = (gchar*)g_malloc0( strlen( str ) + 1 );

	while( str[cx] )
	{
		if( str[cx] != '\r' )
			new[cy++] = str[cx];
		cx++;
	}

	return new;
}

gchar *add_cr( const gchar *text )
{
        char *t;
        int cx, cy;

        cy = 0;
        for( cx = 0; cx < strlen( text ); cx ++ )
        {
                if( text[ cx ] == '\n' )
                        cy ++;
        }

        t = g_malloc( strlen( text ) + cy + 1 );

        cy = 0;
        for( cx = 0; cx < strlen( text ); cx ++ )
        {
                if( text[ cx ] != '\n' )
                        t[ cy ++ ] = text[ cx ];
                else
                {
                        t[ cy ++ ] = '\r';
                        t[ cy ++ ] = '\n';
                }
        }

        t[ cy ] = 0x00;

        return t;
}


GSList * Find_User( UIN_T uin )
{
	GSList *contact = Contacts;
	while( contact != NULL )
	{
		if( kontakt->uin == uin )
			break;
		contact = contact->next;
	}
	return contact;
}

GSList * Find_User_uid( WORD uid )
{
	GSList *contact = Contacts;
	while( contact != NULL )
	{
		if( kontakt->uid == uid ||
                    kontakt->vislist_uid == uid ||
                    kontakt->invlist_uid == uid ||
                    kontakt->ignorelist_uid == uid )
			break;
		contact = contact->next;
	}
	return contact;
}


GSList * Add_User( UIN_T uin, const gchar *name, gboolean inlist )
{
	GSList *contact;
	CONTACT_PTR contactdata;

#ifdef TRACE_FUNCTION
	g_print( "Add_User\n" );
#endif

	contact = Find_User( uin );
	if( contact != NULL )
		return contact;

	contactdata = g_new0( Contact_Member, 1 );

	contactdata->uin = uin;
	contactdata->icon_p = icon_offline_pixmap;
	contactdata->icon_b = icon_offline_bitmap;
	contactdata->stored_messages = NULL;
	contactdata->status = STATUS_OFFLINE;
	/* The following two is a hack for Show_Quick_Status_lower to add to
	 * it's OfflineList */
	contactdata->last_status = STATUS_NA;
	contactdata->need_update = FALSE;
	contactdata->last_time = -1L;
	contactdata->current_ip = -1L;
        contactdata->has_direct_connect = FALSE;
	contactdata->port = 0;
	contactdata->sok = 0;
	contactdata->invis_list = FALSE;
	contactdata->chat_requests = NULL;
	contactdata->msg_dlg_xml = NULL;
	contactdata->confirmed = inlist; /* Needs confirmation if not manually added*/

	if( uin == 10 )
		strncpy( contactdata->nick, _("Web Message"), 20 );
	else
	{
		if( name == NULL || name[0] == '\0' )
			g_snprintf( contactdata->nick, 20, "%d", uin );
		else
			strncpy( contactdata->nick, name, 20 );
	}

	contactdata->show_again = TRUE;
	contactdata->info = g_new0( USER_INFO_STRUCT, 1 );
	contactdata->info->sex = NOT_SPECIFIED;
	contactdata->info->country = 1;

	contactdata->tcp_seq = -1;

	contactdata->inlist = inlist;

	/* TODO: insert sorted */
	Contacts = g_slist_append( Contacts, contactdata );

        if (!inlist) {
          GSList *requestdat;
          DWORD reqid;

          reqid = v7_request_info(uin);
          
          requestdat =  v7_get_request_by_reqid(reqid);
          ((Request*)requestdat->data)->type = NEW_USER_VERIFICATION;
        }

        /* v7_addcontact(uin); */

/*	Show_Quick_Status_lower( inlist ? UPDATE_OFFLINE : UPDATE_NOTLIST, NULL );*/

	Save_RC();
	
	/* TODO: and find it */
	return g_slist_last( Contacts );
}

/********************************************
Converts an big endian character sequence to
a WORD 
*********************************************/
WORD CharsBE_2_Word( const guchar *buf )
{
	WORD i;

	i= buf[0];
	i <<= 8;
	i += buf[1];

	return i;
}

/********************************************
Converts a DWORD to
an intel endian character sequence 
*********************************************/
void DW_2_CharsBE( guchar buf[], DWORD num )
{
	buf[0] = ( guchar ) ((num)>>24)& 0x000000FF;
	buf[1] = ( guchar ) ((num)>>16)& 0x000000FF;
	buf[2] = ( guchar ) ((num)>>8)& 0x000000FF;
	buf[3] = ( guchar ) (num) & 0x000000FF;
}

/********************************************
Converts an intel endian character sequence to
a DWORD
*********************************************/
DWORD CharsBE_2_DW( const guchar buf[] )
{
	DWORD i;

	i= buf[0];
	i <<= 8;
	i+= buf[1];
	i <<= 8;
	i+= buf[2];
	i <<= 8;
	i+= buf[3];

	return i;
}

/********************************************
Converts a WORD to
an big endian character sequence 
*********************************************/
void Word_2_CharsBE( guchar buf[], WORD num )
{
	buf[0] = ( guchar ) (((unsigned)num)>>8) & 0x00FF;
	buf[1] = ( guchar ) ((unsigned)num) & 0x00FF;
}

gchar *dertf(gchar *rtfdata)
{

  gchar *finaltext;
  int i=1, j=0, crlf=2;
  int charset = 0;

#ifdef TRACE_FUNCTION
  g_print( "dertf\n" );
#endif
  

  finaltext = g_malloc0(strlen(rtfdata)+1);

  if (strncmp(rtfdata, "{\\rtf", 5) != 0) {
    strcpy(finaltext, rtfdata);
    return finaltext;
  }
  
  /* g_print("Origlen: %d\n", strlen(rtfdata)); */
  
  for(; i < strlen(rtfdata); i++) {
    /* g_print("Level1: %d %c\n", i, rtfdata[i]); */
    if (rtfdata[i] == '\\') {
      i++;

      if (!strncmp(rtfdata+i, "fbcharset", 8)) {
        i += 8;
        charset = strtol(rtfdata+i, NULL, 10);
      }
      else if (rtfdata[i] == '\'' &&
          isxdigit(rtfdata[i+1]) &&
          isxdigit(rtfdata[i+2])) {
        char blah[3] = "\0\0\0";
        int value;
        blah[0] =  rtfdata[++i];
        blah[1] =  rtfdata[++i];
        value = strtol(blah, NULL, 16);
        /* g_print("Acc char: %d %d  .. %c %c\n", value, value, 
           pc_to_iso1[value], pc_to_iso1[value]); */
        if (charset == 255)
          finaltext[j++] = (value>127) ? pc_to_iso1[value] : value;
        else 
          finaltext[j++] = value;
      }
      
      else {
        for (; i<strlen(rtfdata);i++) {
          /* g_print("Level2: %d %c\n", i, rtfdata[i]); */
          if (isalnum(rtfdata[i]) || rtfdata[i] == '-' || rtfdata[i] == '{') {
            if (rtfdata[i] == '{') {
              int par=0;
              for(; i < strlen(rtfdata); i++) {
                /* g_print("Level3: %d %d %c\n", par, i, rtfdata[i]); */
                if (rtfdata[i] == '{')
                  par++;
                if (rtfdata[i] == '}')
                  par--;
                if (par == 0)
                  break;
              }
              i--;
            }
          } else {
            if (! isspace(rtfdata[i]))
              i--;
            break;
          }
        }
      }
    } else if (rtfdata[i] == '{') {
      int par=0;
      for(; i < strlen(rtfdata); i++) {
        /* g_print("Level4: %d %d %c\n", i, par, rtfdata[i]); */
        if (rtfdata[i] == '{')
          par++;
        if (rtfdata[i] == '}')
          par--;
        if (par == 0)
          break;
      }
      i--;
    }
    else if (rtfdata[i] == '}')
      continue;
    else if (rtfdata[i] == '\r') {
      i++;
      if (crlf) 
        crlf--;
      else
        finaltext[j++] = '\n';
    }
    else
      finaltext[j++] = rtfdata[i];
    
  }
  
  finaltext[j-2] = 0;

  return finaltext;
}
