/*************************************
 Sends various messages to the server
 (c) 1999 Jeremy Wise
 GnomeICU
**************************************/

#include "common.h"
#include "history.h"
#include "kanji_conv.h"
#include "sendmsg.h"
#include "v7send.h"

DWORD our_session;

/*** Local function declarations ***/
static char *cr_convert( const gchar *text );

void icq_sendurl( GtkWidget *widget, struct URLInfo *data )
{
	UIN_T uin;
	gchar *url;
	gchar *desc;
	gchar *histtext;
	gchar *text;

#ifdef TRACE_FUNCTION
	g_print ("icq_sendurl\n");
#endif

	uin = ((CONTACT_PTR) data->contact->data)->uin;
	url = gtk_editable_get_chars (GTK_EDITABLE (data->url), 0, -1);
	desc = gtk_editable_get_chars (GTK_EDITABLE (data->desc), 0, -1);

	/* Add statement to personal history file */
	histtext = g_strdup_printf ("URL: %s \nDescription: %s", url, desc);
	history_add_outgoing (uin, histtext);
	g_free (histtext);

	kanji_conv_auto_s (&desc, KANJI_SJIS);
	text = cr_convert (desc);
	v7_sendurl (uin, url, text);
	g_free (text);

	g_free (url);
	g_free (desc);
}

/*** Local functions ***/
gchar *cr_convert( const gchar *text )
{
	char *t;
	int cx, cy;

	cy = 0;
	for( cx = 0; cx < strlen( text ); cx ++ )
	{
		if( text[ cx ] == '\n' )
			cy ++;
	}

	t = g_malloc( strlen( text ) + cy + 1 );

	cy = 0;
	for( cx = 0; cx < strlen( text ); cx ++ )
	{
		if( text[ cx ] != '\n' )
			t[ cy ++ ] = text[ cx ];
		else
		{
			t[ cy ++ ] = '\r';
			t[ cy ++ ] = '\n';
		}
	}

	t[ cy ] = 0x00;

	return t;
}
