/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __window_h
#define __window_h

#ifdef __cplusplus
extern "C" {
#endif

#include <gtk/gtkbutton.h>
#include <gtk/gtkeditable.h>
#include <gdk/gdktypes.h>
#include <gtk/gtknotebook.h>
#include "galeon_types.h"

/* window.c */
GaleonWindow *window_create (guint32 chrome_mask, GaleonWindow *previous);
void window_add_embed (GaleonWindow *window, GaleonEmbed *embed, 
		       EmbedCreateFlags flags);
void window_set_location_entry_text (GaleonWindow *window, const gchar *url);
void window_update_location_entry_text (GaleonWindow *window);
void window_update_title (GaleonWindow *window);
void window_toggle_fullscreen_mode (GaleonWindow *window);
void window_set_fullscreen_mode (GaleonWindow *window, gboolean active);
void window_show_open_dialog (GaleonWindow *window);
void window_show_openurl_dialog (GaleonWindow *window);
void window_toolbars_recreate (GaleonWindow *window);
void window_save_layout (GaleonWindow *window);
void window_restore_layout (GaleonWindow *window);
void window_show_one_embed (GaleonWindow *window);
void window_hide_one_embed (GaleonWindow *window);
void window_menubar_show (GaleonWindow *window);
void window_menubar_hide (GaleonWindow *window);
void window_toolbar_show (GaleonWindow *window);
void window_toolbar_hide (GaleonWindow *window);
void window_statusbar_show (GaleonWindow *window);
void window_statusbar_hide (GaleonWindow *window);
void window_statusbar_update_progress_bar (GaleonWindow *window);
void window_statusbar_update_message (GaleonWindow *window);
void window_close (GaleonWindow *window);
void window_load_url (GaleonWindow *window, const gchar *url);
void window_update_tab_controls (GaleonWindow *window);
void window_update_nav_controls (GaleonWindow *window);
void window_update_zoom (GaleonWindow *window);
void window_set_visibility (GaleonWindow *window, gboolean visible);
void window_set_layer (GaleonWindow *window);
void window_show_error (GaleonWindow *window, char *errormsg);
void window_close (GaleonWindow *window);
void window_go_home (GaleonWindow *window, LinkState state);
void window_reload_all (GaleonWindow *window);
void window_stop_all (GaleonWindow *window);
void window_undock (GaleonWindow *window);
void window_dock (GaleonWindow *window, GtkWidget *widget,
		  const gchar *width_pref);
GaleonWindow *window_from_widget (GtkWidget *widget);
void window_create_charset_submenus (GaleonWindow *window, 
				     GList *charset_titles);
void window_session_history_menu_create (GaleonWindow *window);
void window_session_history_update_all (void);
void window_update_bm_and_hist_buttons (GaleonWindow *window, gboolean bm,
				     	gboolean hist);
void
window_statusbar_set_security_icon (GaleonWindow *window, gboolean state,
				    gchar *tooltip);
void window_grab_location_focus (GaleonWindow *window);
void window_update_tabs_appearance (GaleonWindow *window);

/* window_callbacks.c */
gboolean window_back_forward_button_press_cb (GtkButton *button,
					      GdkEventButton *event,
					      GaleonWindow *window);
gboolean window_back_forward_button_release_cb (GtkButton *button,
					        GdkEventButton *event,
						GaleonWindow *window);
gboolean window_back_history_button_press_cb (GtkButton *button,
					      GdkEventButton *event,
					      GaleonWindow *window);
gboolean window_forward_history_button_press_cb (GtkButton *button,
						 GdkEventButton *event,
						 GaleonWindow *window);
gboolean window_new_button_press_cb (GtkButton *button, GdkEventButton *event,
				     GaleonWindow *window);
gboolean window_new_button_release_cb (GtkButton *button,
				       GdkEventButton *event,
				       GaleonWindow *window);
void window_new_button_drag_data_received_cb (GtkWidget *widget, 
					      GdkDragContext *drag_context,
					      gint x, gint y,
					      GtkSelectionData *selection_data,
					      guint info, guint time,
					      GaleonWindow *window);
gboolean window_up_button_release_event_cb (GtkButton *button, 
					    GdkEventButton *event,
					    GaleonWindow *window);
gboolean window_up_button_press_event_cb (GtkButton *button, 
					  GdkEventButton *event,
					  GaleonWindow *window);
gboolean window_refresh_button_press_event_cb (GtkButton *button,
					       GdkEventButton *event,
					       GaleonWindow *window);
gboolean
window_refresh_button_release_event_cb (GtkButton *button, 
					GdkEventButton *event,
					GaleonWindow *window);
gboolean window_home_button_press_event_cb (GtkButton *button,
					    GdkEventButton *event,
					    GaleonWindow *window);
gboolean window_home_button_release_event_cb (GtkButton *button,
					      GdkEventButton *event,
					      GaleonWindow *window);
void window_stop_button_clicked_cb (GtkButton *button, GaleonWindow *window);
gboolean window_stop_button_press_event_cb (GtkButton *button,
					    GdkEventButton *event,
					    GaleonWindow *window);
void window_zoom_spin_changed_cb (GtkEditable *editable, GaleonWindow *window);
gboolean window_zoom_spin_key_press_cb (GtkWidget *widget, GdkEventKey *event,
					GaleonWindow *window);
gboolean window_go_button_release_cb (GtkButton *button, GdkEventButton *event,
				      GaleonWindow *window);
gboolean window_clear_location_button_release_cb (GtkButton *button, 
						  GdkEventButton *event,
						  GaleonWindow *window);
gboolean window_find_button_release_cb (GtkButton *button, 
					GdkEventButton *event,
					GaleonWindow *window);
void window_drag_pixmap_drag_data_get_cb (GtkWidget *widget, 
					  GdkDragContext *context,
					  GtkSelectionData *selection_data, 
					  guint info, guint time, 
					  GaleonWindow *window);
gboolean window_drag_pixmap_button_press_event_cb (GtkWidget *widget,
					           GdkEventButton *event,
					           GaleonWindow *window);
void window_drag_data_get_cb (GtkWidget *widget, GdkDragContext *context,
			      GtkSelectionData *selection_data, 
			      guint info, guint time, 
			      GaleonWindow *window);
void open_url_handle_link (GaleonWindow *window, LinkState state);
gboolean open_url_ok_button_release_event_cb (GtkButton *button,
					      GdkEventButton *event,
					      GaleonWindow *window);
void open_url_clear_button_clicked_cb (GtkButton *button, 
				       GaleonWindow *window);
void open_url_cancel_button_clicked_cb (GtkButton *button,
					GaleonWindow *window);
gboolean window_location_entry_key_press_cb (GtkWidget *widget, 
					     GdkEventKey *event,
					     GaleonWindow *window);
void window_location_entry_drag_data_received_cb (GtkWidget *widget, 
						  GdkDragContext *drag_context,
						  gint x, gint y,
						  GtkSelectionData *sel_data, 
						  guint info,
						  guint time, 
						  GaleonWindow *window);
gboolean window_location_entry_button_press_cb (GtkWidget *entry, 
						GdkEventButton *event, 
						GaleonWindow *window);
gboolean window_location_entry_button_press_context_cb (GtkWidget *entry, 
						        GdkEventButton *event, 
						        GaleonWindow *window);
gboolean window_progress_action (GaleonWindow *window);
void window_location_gnomeentry_popwin_cb (GtkWidget *widget, 
					   GaleonWindow *window);
gboolean window_generic_button_press_event_cb (GtkButton *button, 
					       GdkEventButton *event,
					       GaleonWindow *window);
gboolean window_history_button_released_cb (GtkButton *button, 
					    GdkEventButton *event,
				            GaleonWindow *window);
gboolean window_bookmarks_button_released_cb (GtkButton *button, 
					      GdkEventButton *event,
					      GaleonWindow *window);
void window_print_button_clicked_cb (GtkButton *button, GaleonWindow *window);
void window_session_history_menuitem_activate_cb (GtkMenuItem *menuitem, 
						  gpointer data);
gboolean window_session_history_menuitem_button_press_event_cb (
						GtkMenuItem *menuitem, 
						GdkEventButton *event,
						gpointer data);
void window_notebook_switch_page_cb (GtkNotebook *notebook, 
				     GtkNotebookPage *page, guint page_num);
void window_notebook_add_remove_page_cb (GtkContainer *container,
					 GtkWidget *widget, 
					 GaleonWindow *window);
gboolean window_notebook_button_press_cb (GtkWidget *widget,
					  GdkEventButton *e,
					  GaleonWindow *window);
gboolean window_notebook_button_release_cb (GtkWidget *widget,
					    GdkEventButton *e,
					    GaleonWindow *window);
void window_notebook_drag_data_received_cb (GtkWidget *widget, 
				       	    GdkDragContext *drag_context,
				       	    gint x, gint y,
				       	    GtkSelectionData *selection_data,
				       	    guint info, guint time,
				       	    GaleonWindow *window);
gboolean window_key_press_event (GtkWidget *widget,
				 GdkEventKey *event,
				 GaleonWindow *window);
void window_move_tab_to_window_menu_cb (GtkMenuItem *menu, 
					GaleonWindow *window);
gboolean window_find_entry_activate_cb (GtkWidget *widget, 
				        GaleonWindow *window);
void window_toolbar_button_state_changed_cb (GtkWidget *widget,
				             GtkStateType old_state,
				             ToolbarItem *item);
void window_selection_received_cb (GtkWidget *widget,
				   GtkSelectionData *selection_data,
				   guint time, GaleonWindow *window);
void window_add_recent_menu_entry (GaleonWindow *window, const gchar *url,
				   const gchar *title_locale);
void window_backforward_button_state_changed_cb (GtkWidget *widget,
						 GtkStateType old_state,
						 ToolbarItem *item);
void window_fullscreen_button_clicked_cb (GtkButton *toggle,
					  GaleonWindow *window);
void window_security_icon_button_release_cb (GtkWidget *widget,
					     GdkEventButton *event,
					     GaleonWindow *window);

#ifdef __cplusplus
}
#endif
#endif
