/*
 *  Copyright (C) 2001 Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/* CREDITS:
 * This file is based in nautilus-mozilla-content-view.h, from Nautilus */

#ifndef GALEON_NAUTILUS_VIEW_H
#define GALEON_NAUTILUS_VIEW_H

#include <libnautilus/nautilus-view.h>
#include <gtk/gtkvbox.h>

#define GALEON_TYPE_NAUTILUS_VIEW            (galeon_nautilus_view_get_type ())
#define GALEON_NAUTILUS_VIEW(obj)	     (GTK_CHECK_CAST ((obj), GALEON_TYPE_NAUTILUS_VIEW, GaleonNautilusView))
#define GALEON_NAUTILUS_VIEW_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GALEON_TYPE_NAUTILUS_VIEW, \
								    GaleonNautilusViewClass))
#define GALEON_IS_NAUTILUS_VIEW(obj)	     (GTK_CHECK_TYPE ((obj), GALEON_TYPE_NAUTILUS_VIEW))
#define GALEON_IS_NAUTILUS_VIEW_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GALEON_IS_NAUTILUS_VIEW_CLASS))

typedef struct GaleonNautilusView GaleonNautilusView;
typedef struct GaleonNautilusViewClass GaleonNautilusViewClass;
typedef struct GaleonNautilusViewPrivate GaleonNautilusViewPrivate;

struct GaleonNautilusView {
	GtkVBox	parent;
	GaleonNautilusViewPrivate *priv;
};

struct GaleonNautilusViewClass {
	GtkVBoxClass parent_class;
};

/* GtkObject support */
GtkType galeon_nautilus_view_get_type (void);

/* Component embedding support */
BonoboObject *galeon_nautilus_view_new_component (void);

/* public methos */

void
galeon_nautilus_view_set_title (GaleonNautilusView *view,
				const gchar *title);
void 
galeon_nautilus_view_set_location (GaleonNautilusView *view, 
				   const gchar *uri);
void
galeon_nautilus_view_set_statusbar (GaleonNautilusView *view, 
				    const gchar *message);
void
galeon_nautilus_view_report_load_underway (GaleonNautilusView *view);
void
galeon_nautilus_view_report_load_complete (GaleonNautilusView *view);
void
galeon_nautilus_view_report_load_progress (GaleonNautilusView *view,
					   double value);
void galeon_nautilus_view_report_zoom (GaleonNautilusView *view,
				       gint level);
void galeon_nautilus_view_open_in_new_window (GaleonNautilusView *view,
					      const gchar *url);
#endif
