/*****************************************************************************\
    services.cpp : HP Inkjet Server

    Copyright (c) 2001 - 2002, Hewlett-Packard Co.
    All rights reserved.

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:
    1. Redistributions of source code must retain the above copyright
       notice, this list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
    3. Neither the name of the Hewlett-Packard nor the names of its
       contributors may be used to endorse or promote products derived
       from this software without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
    IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
    OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
    IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
    NOT LIMITED TO, PATENT INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR
    SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
    HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
    STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
    IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
    POSSIBILITY OF SUCH DAMAGE.
\*****************************************************************************/

#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <syslog.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include "header.h"
#include "ijs.h"
#include "ijs_server.h"
#include "hpijs.h"
#include "services.h"
APDK_BEGIN_NAMESPACE

extern char *ModelString[MAX_ID_STRING];
extern PRINTER_TYPE DevIDtoPT(unsigned int StringIndex);

APDK_END_NAMESPACE
#include "hpijs.h"


int UXServices::InitDuplexBuffer()
{
    /* Calculate duplex page buffer */
    CurrentRaster = ph.height - 1;  /* Height = physical page in pixels */
    RastersOnPage = (BYTE **) new BYTE[(ph.height) * sizeof (BYTE *)];
    for (int i = 0; i < ph.height; i++)
       RastersOnPage[i] = NULL;
    return 0;
}

int UXServices::SendBackPage()
{
    DRIVER_ERROR    err;
    int i = CurrentRaster+1;

    while (i < ph.height)
    {
        if ((err = pJob->SendRasters(RastersOnPage[i])) != NO_ERROR)
        {
            return err;
        }
        if (RastersOnPage[i])
            delete [] RastersOnPage[i];
        i++;
    }

    CurrentRaster = ph.height - 1;   /* reset raster index */

    return 0;
}

int UXServices::ProcessRaster(char *raster)
{
    if (!BackPage || (pPC->QueryDuplexMode() != DUPLEXMODE_BOOK))

        return pJob->SendRasters((unsigned char *)raster);
    else
    {
        if (CurrentRaster < 0)
           return -1;

        BYTE   *new_raster;
        int    new_raster_size;
        int    i;
        if (raster == NULL)
        {
           RastersOnPage[CurrentRaster--] = NULL;
           return 0;
        }
        new_raster_size = pPC->InputPixelsPerRow() * 3;
        new_raster = new BYTE[new_raster_size];
        if (new_raster == 0)
        {
            bug("unable to create duplex buffer, size=%d: %m\n", new_raster_size);
            return -1;
        }
        memset(new_raster, 0xFF, new_raster_size);
        RastersOnPage[CurrentRaster] = new_raster;
        CurrentRaster--;

        BYTE *p = new_raster + new_raster_size - 3;
        for (i = 0; i < new_raster_size; i += 3)
        {
            memcpy (p, raster+i, 3);
            p -= 3;
        }

        return 0;
    }
}

UXServices::UXServices():SystemServices()
{
   // instead of InitDeviceComm(), just do...
   IOMode.bDevID = IOMode.bStatus = FALSE;
   constructor_error = NO_ERROR;

   Quality = 0;     /* normal */
   MediaType = 0;   /* plain */
   ColorMode = 2;   /* color */
   PenSet = DUMMY_PEN;
   
   RastersOnPage = 0;
   pPC = NULL;
   pJob = NULL;
   Duplex = 0;
   Tumble = 0;
   FullBleed = 0;
   FirstRaster = 1;
}

UXServices::~UXServices()
{
    if (RastersOnPage)
        delete [] RastersOnPage;
}

DRIVER_ERROR UXServices::ToDevice(const BYTE * pBuffer, DWORD * Count)
{
   /* Write must be not-buffered, don't use streams */
   if (write(OutputPath, pBuffer, *Count) != (ssize_t)*Count) 
   {
      bug("unable to write to output, fd=%d, count=%d: %m\n", OutputPath, *Count);
      return IO_ERROR;
   }

   *Count = 0;
   return NO_ERROR;
}

void UXServices::MapModel(const char *nam)
{
   int i;

   Model = -1;

   for (i=0; i < MAX_ID_STRING; i++)
   {
      if (!strncmp(nam,ModelString[i],strlen(ModelString[i])))
      {
         Model = DevIDtoPT(i);
         break;
      }
   }
}

int UXServices::MapPaperSize(float width, float height, int model)
{
   int r, size;

   /* Map gs paper sizes to APDK paper sizes. */

   if (height >= 19)
      size = SUPERB;
   else if (height >= 17)
      size = LEDGER;
   else if (height >= 16.52)   /* de-sensitized from 16.53 */
      size = A3;
   else if (height >= 14.342)
      size = B4;
   else if (height >= 14)
      size = LEGAL;
   else if (height >= 13)
      size = FLSA;
   else if (height >= 11.69)
      size = A4;
   else if (height >= 11)
      size = LETTER;
   else if (height >= 10.5)
      size = EXECUTIVE;
   else if (height >= 10.125)
      size = B5;
   else if (height >= 8.26)   /* de-sensitized from 8.27 */
      size = A5;
   else if (height >= 7.87)
      size = OFUKU;
   else if (height >= 6)
      size = PHOTO_SIZE;
   else if ((width >= 4.12) && (height >= 5.83))
      size = A6;
   else if (height >= 5.83)
      size = HAGAKI;
   else
      size = UNSUPPORTED_SIZE;

   if ((r = pPC->SetPaperSize((PAPER_SIZE)size, FullBleed)) != NO_ERROR)
   {
//      if (r != ILLEGAL_COORDS)
      bug("unable to set paper size=%d, err=%d\n", size, r);
      return -1;
   }

   return 0; 
}

