#!/bin/bash
# samba-print-pdf
# This is a script which allows you to set up a virtual printer on samba
# which will take the file (generated by a postscript filter on windows)
# and turn it into a PDF, informing the user of where it is when it
# is done
#
# Buchan Milne <bgmilne@cae.co.za> 20020723
#
# Arguments:
# $1 = file (usually passed with %s from samba)
# $2 = unix prefix to where to place the file (~%u should work)
# $3 = windows prefix to the same location (//%L/%u should work)
# $4 = user/computer to send a notification to (%u or %m)
# $5 = IP address of client (%I)
# $6 = Name of destination file without extension (%J)


PS2PDF=ps2pdf13 
OPTIONS="-dAutoFilterColorImages=false -sColorImageFilter=FlateEncode"
INPUT=$1
KEEP_PS=1
PERMS=640
INFILE=$(basename $INPUT)
BASEFILE=pdf-service
PREFIX="$2"
NAME="$6"
WINBASE=$(echo "$3"|sed -e 's,/,\\\\,g')

#make a temp file to use for the output of the PDF
OUTPUT=`mktemp -q $2/$BASEFILE-XXXXXX`
if [ $? -ne 0 ]; then
	echo "$0: Can't create temp file $2/$BASEFILE-XXXXXX, exiting..."
	exit 1
fi
if [ "$NAME" != "" ]; then
	FINALOUTPUT="$PREFIX/$NAME"
else
	FINALOUTPUT="$OUTPUT"
fi
									
WIN_OUTPUT="$WINBASE\\"`basename "$FINALOUTPUT"`

# create the PDF:
$PS2PDF $OPTIONS $INPUT "$OUTPUT".pdf >/dev/null 2>&1
mv -f "$OUTPUT".pdf "$FINALOUTPUT".pdf

# Generate a message to send to the user, and deal with the original file:
MESSAGE=$(echo "Your PDF file has been created as $WIN_OUTPUT.pdf\n")

if [ $KEEP_PS ];then
	mv -f $INPUT "${FINALOUTPUT}".ps
	MESSAGE=$(echo "$MESSAGE and your postscript file as $WIN_OUTPUT.ps")
	# Fix permissions on the generated files
	chmod $PERMS "${FINALOUTPUT}".ps
else
	rm -f $INPUT
	chmod $PERMS "${FINALOUTPUT}".ps "${FINALOUTPUT}".pdf
	# Fix permissions on the generated files
fi
					                        
#Remove empty file from mktemp:
[ "x$NAME" -eq "x" ] && rm -f  $OUTPUT

# Send notification to user
echo -e $MESSAGE|smbclient -M $4 -I $5 -U "PDF Generator" >/dev/null 2>&1

