/*
 * lftp and utils
 *
 * Copyright (c) 1996-2002 by Alexander V. Lukyanov (lav@yars.free.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef CHARREADER_H
#define CHARREADER_H

#include "SMTask.h"

// CharReader fetches a single character from given file descriptor.
class CharReader : public SMTask
{
   int	 fd;
   int	 ch;

   int	 Do();

public:
   static const int NOCHAR=-2;
   static const int EOFCHAR=-1;

   int	 GetChar() { return ch; };

   CharReader(int new_fd)
   {
      fd=new_fd;
      ch=NOCHAR;
   }
};

#endif//CHARREADER_H
