/*
	create.c
	Create CD functions
	20.11.99 tn
*/

#include "largefile.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include "xcdrdata.h"
#include "xcdroast.h"
#include "main.h"
#include "xpms/minidata.xpm"
#include "xpms/miniaudio.xpm"
#include "xpms/mininodata.xpm"
#include "xpms/masteradd.xpm"
#include "xpms/masterdel.xpm"

extern gint debug;
extern gchar configdir[MAXLINE];
extern GtkWidget *toplevel;
extern GtkWidget *sidespace;
extern GtkWidget *workspace;
extern GtkWidget *actionspace;
extern gint wav_in;
extern GtkWidget *wav_quit_button;
extern gint wavplay_quit;
extern gint submenu;
extern track_read_set_t trackreadset;
extern setup_data_t setupdata;
extern current_set_t curset;
extern cd_info_t cdinfo;
extern track_info_t **trackinfo;
extern GtkCList *cdlist, *imglist;
extern GtkWidget *imglist_l1, *imglist_l2, *imglist_l3;
extern GtkWidget *cdlist_l1, *cdlist_l2, *cdlist_l3, *cdlist_l4;
extern GtkWidget *vrylist_l1, *vrylist_l2, *vrylist_l3, *vrylist_l4;
extern GList *imagelist;
extern GtkWidget *ctree_okbutton;

/* some stuff for the select-functions of the sidebar buttons */
guint side_handlers2[8];
GtkWidget *side_widgets2[8];
GtkCList *imglist2;
GList *writelist;
GtkWidget *isoopts[16];
GtkWidget *isoopt_omenu;
GtkWidget *isoopt_cmenu;
master_param_t masterparam;
GtkWidget *bootable_frame1;
GtkWidget *bootable_frame2;
GtkWidget *isoheader[7];
gchar **charset_types;
gchar *master_fname1 = NULL;
gchar *master_fname2 = NULL;
static GtkWidget *master_avail_entry, *master_ms_button;
static gint session_current_state;

extern void draw_info_menu();
extern void draw_play_tracks_menu();
extern void draw_delete_menu();
extern void devices_setup_read(gint row, GtkWidget *tbl, gint showspeed);
extern void devices_setup_image(gint row, GtkWidget *tbl);
extern void devices_setup_write(gint row, GtkWidget *tbl);
extern void readoptions_selected(GtkWidget *item, gpointer nr);
extern void verifyoptions_selected(GtkWidget *item, gpointer nr);
extern void set_image_prefix_callback(GtkWidget *widget, gpointer data);
extern void writeoptions_selected(GtkWidget *item, gpointer nr);
extern void writemode_selected(GtkWidget *item, gpointer data);
extern void cdrtype_selected(GtkWidget *item, gpointer mode);
extern void show_atip_info(GtkWidget *widget, gpointer data);
extern void blankcd_clicked(GtkWidget *widget, gpointer data);
extern void undo_selections(GtkWidget *clist, gint row, gint column,
	GdkEventButton *event, gpointer data);
extern void do_lock(gint plusgrab);
extern void do_unlock(gint plusgrab);

void fill_write_tracks();
void fill_session_view(gint checkmedia);
void set_sessionsize_unknown();

/* --------------- */

/* fill the entries in the read_tracks_menu */

void fill_read_tracks(gint dontupdatecd) {
gchar tmp[MAXLINE];
gchar tmp2[MAXLINE];
gchar tmp3[MAXLINE];
gchar titlestr[MAXLINE];
gint overwritefree, normalfree, biggestfree, overwritefreebiggest;
GtkStyle *style;
gchar *data[2];
GdkPixmap *pixmap1, *pixmap2;
GdkBitmap *mask1, *mask2;
gint i, lcount;

	/* update cd-info */
        if (curset.reader_devnr != -1) {
                get_cd_toc_and_volid(curset.reader_devnr);
        }

        /* file prefix */
        if (strcmp(curset.file_prefix,"") == 0) {
                g_free(curset.file_prefix);
                curset.file_prefix = g_strdup(IMGFILEPREFIX);
        }
        gtk_entry_set_text(GTK_ENTRY(imglist_l1), curset.file_prefix);
	gtk_entry_set_position(GTK_ENTRY(imglist_l1), 0);
        gtk_entry_select_region(GTK_ENTRY(imglist_l1), 0, 
                GTK_ENTRY(imglist_l1)->text_length);

        /* now check if the current filename has any influence on
           the available space - to complicated - REMOVED*/
	overwritefree = 0;
	overwritefreebiggest = 0;
/*
        overwritefree = 
                get_free_space_by_overwriting_trackfiles(&overwritefreebiggest);
*/
        /* free size */
        normalfree = determine_free_space(&biggestfree);
        convert_kbytes2mbminstring(normalfree,tmp3);

        /* additional free space when overwriting files? */
        if (cdinfo.nr_tracks > 0 && overwritefree > 0) {
                convert_kbytes2mbstring(normalfree+overwritefree, tmp2);
                g_snprintf(tmp,MAXLINE,"%s (%s)", tmp3, tmp2);
        } else {
                strcpy(tmp,tmp3);
        }
        gtk_entry_set_text(GTK_ENTRY(imglist_l2), tmp);
	gtk_entry_set_position(GTK_ENTRY(imglist_l2), 0);

        /* biggest free block */
        convert_kbytes2mbminstring(biggestfree,tmp3);

        if (cdinfo.nr_tracks > 0 && overwritefreebiggest > 0) {
                convert_kbytes2mbstring(biggestfree+overwritefreebiggest, tmp2);
                g_snprintf(tmp,MAXLINE,"%s (%s)", tmp3, tmp2);
        } else {
                strcpy(tmp,tmp3);
        }
        gtk_entry_set_text(GTK_ENTRY(imglist_l3), tmp);
	gtk_entry_set_position(GTK_ENTRY(imglist_l3), 0);


	/* dont change anything on the cd side */
	if (dontupdatecd) return;

	/* fill track-listing */
        /* clean up first */
        gtk_clist_clear(cdlist);

        /* cd loaded? */
        if (cdinfo.nr_tracks == -1) {
                gtk_entry_set_text(GTK_ENTRY(cdlist_l1), text(156));    
                gtk_entry_set_text(GTK_ENTRY(cdlist_l2),"");    
                return;
        }
        if (cdinfo.nr_tracks == -2) {
                gtk_entry_set_text(GTK_ENTRY(cdlist_l1), text(196));    
                gtk_entry_set_text(GTK_ENTRY(cdlist_l2),"");    
                return;
        }

        style = gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(cdlist)));
        pixmap1 = gdk_pixmap_create_from_xpm_d(cdlist->clist_window,
                &mask1, &style->bg[GTK_STATE_NORMAL],(gchar **)minidata_xpm);
        pixmap2 = gdk_pixmap_create_from_xpm_d(cdlist->clist_window,
                &mask2, &style->bg[GTK_STATE_NORMAL],(gchar **)miniaudio_xpm);

        data[0] = NULL;
        lcount = 0;

        for (i = 0; i < cdinfo.nr_tracks; i++) {

		strcpy(titlestr,"");

		/* we have cd-text for this track? */
                if (setupdata.option_displaycdtext) {
                        if (trackinfo[i]->title != NULL && 
                            trackinfo[i]->title[0] != '\0' ) {
				strcpy(titlestr, trackinfo[i]->title);
                        }
                }

                /* have we a cddb-title for this track? */
                if (trackinfo[i]->cddb_ttitle != NULL) {
			strcpy(titlestr, trackinfo[i]->cddb_ttitle);
                } else
                if (trackinfo[i]->volname != NULL) {
			strcpy(titlestr, trackinfo[i]->volname);
		}

                if (trackinfo[i]->type == 0) {
                        convert_frames2mbstring(trackinfo[i]->size,tmp2);
			if (strcmp(titlestr,"") == 0) {
				strcpy(titlestr,text(109));
			}
                        g_snprintf(tmp,MAXLINE,"%2d. %s [%s]",
                                trackinfo[i]->track_nr,
                                titlestr, tmp2);
                        data[1] = tmp;
                        gtk_clist_append(cdlist,data);
                        gtk_clist_set_pixmap(cdlist,lcount,0,pixmap1,mask1);
                        lcount++;
                } else {
                        convert_frames2minstring(trackinfo[i]->size,tmp2);
			if (strcmp(titlestr,"") == 0) {
				strcpy(titlestr,text(110));
			}
                        g_snprintf(tmp,MAXLINE,"%2d. %s [%s]",
                                trackinfo[i]->track_nr,
                                titlestr, tmp2);
                        data[1] = tmp;
                        gtk_clist_append(cdlist,data);
                        gtk_clist_set_pixmap(cdlist,lcount,0,pixmap2,mask2);
                        lcount++;
                }
	}

        /* cd-label */
        if (cdinfo.title && cdinfo.artist && 
                cdinfo.title[0] != '\0' && setupdata.option_displaycdtext) {
                g_snprintf(tmp,MAXLINE,"%s / %s", cdinfo.title, cdinfo.artist);
                gtk_entry_set_text(GTK_ENTRY(cdlist_l1), tmp);
                gtk_entry_set_position(GTK_ENTRY(cdlist_l1),0);
        } else 
        if (cdinfo.cddb_dtitle != NULL) {
                gtk_entry_set_text(GTK_ENTRY(cdlist_l1), cdinfo.cddb_dtitle);   
                gtk_entry_set_position(GTK_ENTRY(cdlist_l1),0);
        } else {
                gtk_entry_set_text(GTK_ENTRY(cdlist_l1),"");    
        }

	/* nothing selected at first */
        convert_frames2mbminstring(0, tmp);
        gtk_entry_set_text(GTK_ENTRY(cdlist_l2), tmp);
}


/* update currently selected track-sizes */

void update_read_size(gint clickrow) {
GList *sel;
gint row;
gint sizecount;
gchar tmp[MAXLINE];

	sizecount = 0;

        /* loop through all selected tracks */
        sel = cdlist->selection;
        while (sel) {
                row = GPOINTER_TO_INT(sel->data);               
		sizecount += trackinfo[row]->size;
                sel = sel->next;
        }

        convert_frames2mbminstring(sizecount, tmp);
        gtk_entry_set_text(GTK_ENTRY(cdlist_l2), tmp);
}


/* callbacks for button in read-screen */

void readsometracks_clicked(GtkWidget *widget, gpointer data) {
track_read_param_t *trackparam;
gfloat per;
gint ret, tcount, sizecount,nrtracks;
gint overwrite, overwritebiggest;
GList *sel;
gint row, sectorstoread,stat;

        /* no cd-reader defined */
        if (curset.reader_devnr == -1) {
                show_dialog(ICO_ERROR,text(203), T_OK, NULL, NULL, 0);
                return;
        }

        /* now check if our cd-information is still valid */
        get_cd_toc_and_volid(curset.reader_devnr);

        /* cd loaded? */
        if (cdinfo.nr_tracks < 0) {
                /* update screen ... */
                fill_read_tracks(0);
                show_dialog(ICO_WARN,text(266),T_OK,NULL,NULL,0);
                return;
        }

	sizecount = 0;
	nrtracks = 0;
        /* loop through all selected tracks to get number and sum of size */
        sel = cdlist->selection;
        while (sel) {
                row = GPOINTER_TO_INT(sel->data);               
		sizecount += trackinfo[row]->size;
		nrtracks++;
                sel = sel->next;
        }

	/* no tracks selected */
	if (nrtracks == 0) {
                show_dialog(ICO_WARN,text(302),T_OK,NULL,NULL,0);
                return;
	}

        /* lets check if the file-prefix-entry is up to date */
        set_image_prefix_callback(imglist_l1, NULL); 

        /* free structure first */
	clear_trackreadset();

        /* fill structure */
        trackreadset.nrtracks = nrtracks;

	tcount = 0;
        sel = cdlist->selection;
        while (sel) {
                row = GPOINTER_TO_INT(sel->data);               

                /* allocate memory */
                trackparam = g_new0(track_read_param_t,1);

                trackparam->trackinfo_index = row;
                trackparam->starttrack = trackinfo[row]->track_nr;
                trackparam->endtrack = 0;
                trackparam->tracktype = trackinfo[row]->type;
                per = (gfloat)trackinfo[row]->size * 100.0  / sizecount;
                trackparam->percent = per;
                
                if (trackparam->tracktype == 0) {
                        /* data track */
                        trackparam->kbyte = trackinfo[row]->size *
                                (DATASECTORSIZE/1024);
                        trackparam->frames = trackinfo[row]->size;
                        trackparam->startoffset = trackinfo[row]->start_sec;
                        if (row == cdinfo.nr_tracks-1) {
                                /* last track - leadout is track-end */
                                trackparam->endoffset = cdinfo.leadout - 2;     
                        } else {
                                /* sub 150 (2 sec leadout),
                                   sub 2 (2 run out sectors) */
                                trackparam->endoffset = 
                                        trackinfo[row+1]->start_sec -150-2; 
                        }
                        /* now do a paranoia check */
                        /* in some cases we skip to much of a track */
                        sectorstoread = trackparam->endoffset -
                                trackparam->startoffset;
			if (sectorstoread < trackinfo[row]->isosize) {
                                trackparam->endoffset =
                                        trackparam->startoffset +
                                                trackinfo[row]->isosize;
                                trackparam->kbyte = trackinfo[row]->isosize * 2;
				dodebug(1,"readsometracks_clicked: corrected data track size from %d to %d sectors.\n", sectorstoread, trackinfo[row]->isosize);
			}
                } else {
                        /* audio */
                        trackparam->kbyte = trackinfo[row]->size *
                                CDDAFRAME/1024;
                        trackparam->frames = trackinfo[row]->size;
                }

                trackreadset.trackparams = g_list_append(
                        trackreadset.trackparams, trackparam);

                sel = sel->next;
        }

        /* assign diskspace */
        stat = allocate_track_filenames(&overwrite, &overwritebiggest); 
        if (stat == 1) {
                /* not enough space */
                ret = show_dialog(ICO_WARN,text(299), T_ANYWAY, T_CANCEL, NULL, 1);
                if (ret == 1) {
                        /* abort */
                        return;
                }
        }

	/* no writeable dirs */
	if (stat == 2) {
		show_dialog(ICO_WARN,text(450), T_OK, NULL, NULL, 1);
		return;
	}

	/* assign an empty toc-filename */
        g_free(trackreadset.tocfile);
        trackreadset.tocfile = g_strdup("");

        /* now all parameters for reading are set - lets begin */
        show_and_do_read_tracks(curset.reader_devnr, 0);
}


void read_select_all(GtkWidget *widget, gpointer data) {

        gtk_clist_select_all(cdlist);
}

void read_select_none(GtkWidget *widget, gpointer data) {

        gtk_clist_unselect_all(cdlist);
}

void read_select_row(GtkWidget *clist, gint row, gint col,
        GdkEventButton *event, gpointer data) {

        update_read_size(row);
}


/* draw read-tracks menu */

void draw_read_tracks() {
GtkWidget *hbox, *vbox;
GtkWidget *f1,*f2, *f3;
GtkWidget *b1;
GtkWidget *e1;
GtkWidget *l1;
GtkWidget *tbl, *check;
GtkCList *clist;
gchar *titles[2];
GtkWidget *scrolled_win, *list;

        /* prepare draw area */
        clear_actionspace();

        f1 = gtk_frame_new(text(107));
        set_font_and_color(f1,BOLDFONT,NULL);
        gtk_box_pack_start(GTK_BOX(actionspace),f1,FALSE,FALSE,5);
        gtk_widget_show(f1);

        tbl = gtk_table_new(2,16*4,TRUE); 
        gtk_table_set_col_spacing(GTK_TABLE(tbl),4*4-1,5);
        gtk_table_set_col_spacing(GTK_TABLE(tbl),15*4-2,5);
        gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
        gtk_container_add(GTK_CONTAINER(f1),tbl);
        gtk_widget_show(tbl);

        devices_setup_read(0, tbl, 1);
        devices_setup_image(1, tbl);
        /* devices_setup_write(2, tbl); */

        /* left and right info-frames */
        tbl = gtk_table_new(1,2,TRUE);
        gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
        gtk_box_pack_start(GTK_BOX(actionspace),tbl,TRUE,TRUE,10);
        gtk_widget_show(tbl);
        vbox = gtk_vbox_new(FALSE,10);
        gtk_table_attach_defaults(GTK_TABLE(tbl),vbox,1,2,0,1);
        f1 = gtk_frame_new(text(96));
        set_font_and_color(f1,BOLDFONT,NULL);
        gtk_table_attach_defaults(GTK_TABLE(tbl),f1,0,1,0,1);
        gtk_widget_show(f1);
        f2 = gtk_frame_new(text(97));
        set_font_and_color(f2,BOLDFONT,NULL);
        gtk_box_pack_start(GTK_BOX(vbox),f2,TRUE,TRUE,0);
        gtk_widget_show(f2);
        f3 = gtk_frame_new(text(296));
        set_font_and_color(f3,BOLDFONT,NULL);
        gtk_box_pack_start(GTK_BOX(vbox),f3,FALSE,FALSE,0);
        gtk_widget_show(f3);
        gtk_widget_show(vbox);

        /* button bar at the bottom */
        hbox = gtk_hbox_new(TRUE,10);
        gtk_box_pack_start(GTK_BOX(actionspace),hbox,FALSE,TRUE,10);
        gtk_widget_show(hbox);

        b1 = gtk_button_new_with_label(text(221));
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,10);
        gtk_signal_connect(GTK_OBJECT(b1),"clicked",
                GTK_SIGNAL_FUNC(read_select_all), NULL);
	define_tooltip(b1,help(86));
        gtk_widget_show(b1);

        b1 = gtk_button_new_with_label(text(222));
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,10);
        gtk_signal_connect(GTK_OBJECT(b1),"clicked",
                GTK_SIGNAL_FUNC(read_select_none), NULL);
	define_tooltip(b1,help(87));
        gtk_widget_show(b1);

        b1 = gtk_button_new_with_label(text(298));
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,10);
        gtk_widget_show(b1);
	define_tooltip(b1,help(88));
        gtk_signal_connect(GTK_OBJECT(b1), "clicked",
                GTK_SIGNAL_FUNC(readsometracks_clicked), NULL);

	/* left frame */
        vbox = gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(f1),vbox);
        gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);
        gtk_widget_show(vbox);

        scrolled_win = gtk_scrolled_window_new (NULL, NULL);
        gtk_box_pack_start(GTK_BOX(vbox),scrolled_win,TRUE,TRUE,0);
        gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
                GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
        gtk_widget_show(scrolled_win);
        
        titles[0] = "";
        titles[1] = text(101);
        list = gtk_clist_new_with_titles(2,titles);
        gtk_container_add (GTK_CONTAINER (scrolled_win), list);
        gtk_widget_realize(list);
        clist = GTK_CLIST(list);
        cdlist = clist;
        gtk_signal_connect(GTK_OBJECT(clist), "select_row",
                GTK_SIGNAL_FUNC(read_select_row),NULL);
        gtk_signal_connect(GTK_OBJECT(clist), "unselect_row",
                GTK_SIGNAL_FUNC(read_select_row),NULL);
	gtk_clist_set_column_width(cdlist, 0, 16);
        gtk_clist_set_column_auto_resize(cdlist, 1, TRUE);
	if (setupdata.option_selectionmode == 0) {
		gtk_clist_set_selection_mode (clist, GTK_SELECTION_MULTIPLE);
	} else {
		gtk_clist_set_selection_mode (clist, GTK_SELECTION_EXTENDED);
	}
	gtk_widget_show(list);

        tbl = gtk_table_new(2,8,TRUE);
        gtk_table_set_row_spacings(GTK_TABLE(tbl),10);
        gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
        gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,10);
        gtk_widget_show(tbl);

        l1 = rightjust_gtk_label_new(text(104));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,0,1);
        gtk_widget_show(l1);

        e1 = gtk_entry_new();
        cdlist_l1 = e1;
        gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
        gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,8,0,1);
        gtk_widget_show(e1);
        l1 = rightjust_gtk_label_new(text(300));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,1,2);
        gtk_widget_show(l1);

        e1 = gtk_entry_new();
        cdlist_l2 = e1;
        gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
        gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,8,1,2);
        gtk_widget_show(e1);

        /* right info frame */
        vbox = gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(f2),vbox);
        gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);
        gtk_widget_show(vbox);

        tbl = gtk_table_new(4,8,TRUE);
        gtk_table_set_row_spacings(GTK_TABLE(tbl),10);
        gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
        gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,10);
        gtk_widget_show(tbl);

        l1 = rightjust_gtk_label_new(text(146));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,3,0,1);
        gtk_widget_show(l1);

        e1 = gtk_entry_new();
        imglist_l1 = e1;
        gtk_signal_connect(GTK_OBJECT(e1), "activate",
                GTK_SIGNAL_FUNC(set_image_prefix_callback),NULL);
        gtk_table_attach_defaults(GTK_TABLE(tbl),e1,3,8,0,1);
        gtk_widget_show(e1);
        define_tooltip(e1, help(51));

        l1 = rightjust_gtk_label_new(text(147));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,3,1,2);
        gtk_widget_show(l1);

        e1 = gtk_entry_new();
        imglist_l2 = e1;
        gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
        gtk_table_attach_defaults(GTK_TABLE(tbl),e1,3,8,1,2);
        gtk_widget_show(e1);

        l1 = leftjust_gtk_label_new(text(272));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,1,8,2,3);
        gtk_widget_show(l1);

        e1 = gtk_entry_new();
        imglist_l3 = e1;
        gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
        gtk_table_attach_defaults(GTK_TABLE(tbl),e1,3,8,3,4);
        gtk_widget_show(e1);

        /* options frame */
        vbox = gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(f3),vbox);
        gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
        gtk_widget_show(vbox);

        tbl = gtk_table_new(1,8,TRUE);
        gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
        gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,10);
        gtk_widget_show(tbl);

        check = gtk_check_button_new_with_label(text(297));
        gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(readoptions_selected),GINT_TO_POINTER(0));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,8,0,1);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                curset.indexscan);
	define_tooltip(check, help(80));
        gtk_widget_show(check);

	gtk_widget_show(actionspace);

	/* fill entries */
	fill_read_tracks(0);
}


/* fill the entries in the verify_tracks_menu */

void fill_verify_tracks(gint dontupdateimglist) {
gchar tmp[MAXLINE], tmp2[MAXLINE];
gchar titlestr[MAXLINE];
GList *loop;
GtkStyle *style;
gchar *data[2];
GdkPixmap *pixmap1, *pixmap2, *pixmap3;
GdkBitmap *mask1, *mask2, *mask3;
gchar basename[MAXLINE], imgdir[MAXLINE], fname[MAXLINE], *p;
gint lcount, count;
image_files_t *entry;


	/* update cd-info */
        if (curset.reader_devnr != -1) {
                get_cd_toc_and_volid(curset.reader_devnr);
        }

        /* cd loaded? */
        if (cdinfo.nr_tracks == -1) {
                gtk_entry_set_text(GTK_ENTRY(vrylist_l1), text(156));    
                gtk_entry_set_text(GTK_ENTRY(vrylist_l2),"");   
                gtk_entry_set_text(GTK_ENTRY(vrylist_l3),"");   
                gtk_entry_set_text(GTK_ENTRY(vrylist_l4),"");   
        }
        if (cdinfo.nr_tracks == -2) {
                gtk_entry_set_text(GTK_ENTRY(vrylist_l1), text(196));    
                gtk_entry_set_text(GTK_ENTRY(vrylist_l2),"");   
                gtk_entry_set_text(GTK_ENTRY(vrylist_l3),"");   
                gtk_entry_set_text(GTK_ENTRY(vrylist_l4),"");   
        }

	if (cdinfo.nr_tracks > 0) {
        	/* cd-type */
        	determine_cd_type(tmp,0);
        	gtk_entry_set_text(GTK_ENTRY(vrylist_l1), tmp); 

        	/* cd-label */
        	if (cdinfo.title && cdinfo.artist && 
                	cdinfo.title[0] != '\0' && setupdata.option_displaycdtext) {
	                g_snprintf(tmp,MAXLINE,"%s / %s", cdinfo.title, cdinfo.artist);
			gtk_entry_set_text(GTK_ENTRY(vrylist_l2), tmp);
        	        gtk_entry_set_position(GTK_ENTRY(vrylist_l2),0);
	        } else 
	        if (cdinfo.cddb_dtitle != NULL) {
	                gtk_entry_set_text(GTK_ENTRY(vrylist_l2), cdinfo.cddb_dtitle);
	                gtk_entry_set_position(GTK_ENTRY(vrylist_l2),0);
	        } else {
	                gtk_entry_set_text(GTK_ENTRY(vrylist_l2),"");    
	        }

	        /* cd-size */
	        convert_frames2mbminstring(cdinfo.total_size, tmp);
	        gtk_entry_set_text(GTK_ENTRY(vrylist_l3), tmp);

	        /* nr tracks */ 
	        g_snprintf(tmp,MAXLINE,"%d",cdinfo.nr_tracks);
	        gtk_entry_set_text(GTK_ENTRY(vrylist_l4), tmp);
	}

	/* now draw image-list */
	if (dontupdateimglist) return;

        /* clean up first */
        gtk_clist_clear(imglist);

        style = gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(imglist)));
        pixmap1 = gdk_pixmap_create_from_xpm_d(imglist->clist_window,
                &mask1, &style->bg[GTK_STATE_NORMAL],(gchar **)minidata_xpm);
        pixmap2 = gdk_pixmap_create_from_xpm_d(imglist->clist_window,
                &mask2, &style->bg[GTK_STATE_NORMAL],(gchar **)miniaudio_xpm);
        pixmap3 = gdk_pixmap_create_from_xpm_d(imglist->clist_window,
                &mask3, &style->bg[GTK_STATE_NORMAL],(gchar **)mininodata_xpm);


	data[0] = NULL;
        strcpy(imgdir,"");
        count = 1;
	lcount = 0;

        /* check image-selector */
        if (curset.image_index != -1) {
                /* no automatic setting? */
                strncpy(imgdir,(gchar *)g_list_nth_data(setupdata.image_dirs,
                        curset.image_index), MAXLINE);
        }

        loop = g_list_first(imagelist);
        while (loop) {
                entry = loop->data;

                /* get the base-dirname */
                strncpy(basename,entry->path,MAXLINE);  
                p = rindex(basename,'/');
                *p = '\0';
                if (strcmp(basename,"") == 0) {
                        strcpy(basename,"/");
                }
		strcpy(fname, p+1);

                if (strcmp(basename,imgdir) != 0 && imgdir[0] != '\0') {
                        /* skip not selected dirs */
                        loop = loop->next;
                        continue;
                }

		if (entry->readable == 0) {
			/* dont display not readable files */
                        loop = loop->next;
                        continue;
                }

		strcpy(titlestr,"");
		assign_trackname(titlestr, entry);

		/* no title found - so use filename as title */
		if (strcmp(titlestr,"") == 0) {
			strcpy(titlestr,fname);
		}

                /* iso9600-track/ unknown  */
                if (entry->type == 0 || entry->type == 3) {
                        convert_frames2mbstring((gint)((off_t)entry->size/DATASECTORSIZE),
                                tmp2);
                        g_snprintf(tmp,MAXLINE,"%2d. %s [%s]",
                                count, titlestr, tmp2);
                        data[1] = tmp;
                        gtk_clist_append(imglist,data);
                        if (entry->type == 0) {
                                gtk_clist_set_pixmap(imglist,lcount,0,pixmap1,mask1);   
                        } else {
                                gtk_clist_set_pixmap(imglist,lcount,0,pixmap3,mask3);   
                        }
                        count++;
			lcount++;
                }

                /* valid wav-file */
                if (entry->type == 1) {
                        convert_frames2minstring((gint)((off_t)entry->size/CDDAFRAME), tmp2);
                        g_snprintf(tmp,MAXLINE,"%2d. %s [%s]",
                                count, titlestr, tmp2);
                        data[1] = tmp;
                        gtk_clist_append(imglist,data);
                        gtk_clist_set_pixmap(imglist,lcount,0,pixmap2,mask2);   
                        lcount++;
                        count++;
                }       

		loop = loop->next;
	}

        /* nothing selected - no size of files */
        convert_kbytes2mbminstring(0, tmp);
        gtk_entry_set_text(GTK_ENTRY(imglist_l1), tmp);  
}


/* find out which trackfilename is in which row */
/* this is a little complicated because I have to recreate the
   exact order of tracks as they are filled by fill_verify_tracks */

gint get_trackname_from_row(gint row, gchar *tname) {
GList *loop;
image_files_t *entry;
gint count;
gchar basename[MAXLINE], imgdir[MAXLINE], fname[MAXLINE], *p;

	strcpy(imgdir,"");
	count = 0;

        /* check image-selector */
        if (curset.image_index != -1) {
                /* no automatic setting? */
                strncpy(imgdir,(gchar *)g_list_nth_data(setupdata.image_dirs,
                        curset.image_index), MAXLINE);
        }

        loop = g_list_first(imagelist);
        while (loop) {
                entry = loop->data;

                /* get the base-dirname */
                strncpy(basename,entry->path,MAXLINE);  
                p = rindex(basename,'/');
                *p = '\0';
                if (strcmp(basename,"") == 0) {
                        strcpy(basename,"/");
                }
                strcpy(fname, p+1);

                if (strcmp(basename,imgdir) != 0 && imgdir[0] != '\0') {
                        /* skip not selected dirs */
                        loop = loop->next;
                        continue;
                }

                if (entry->readable == 0) {
                        /* dont display not readable files */
                        loop = loop->next;
                        continue;
                }

		if (entry->type == 0 || entry->type == 3 || entry->type == 1) {

			/* matching row found */
			if (count == row) {
				strcpy(tname, entry->path);
				return 0;
			}	
			count++;
		}

                loop = loop->next;
        }

	/* no match */
	return 1;
}


/* update currently selected track-sizes */

void update_verify_size(gint clickrow) {
GList *sel;
gint row;
gint sizecount;
gchar tmp[MAXLINE];

        sizecount = 0;

        /* loop through all selected tracks */
        sel = imglist->selection;
        while (sel) {
                row = GPOINTER_TO_INT(sel->data);               
		if (get_trackname_from_row(row, tmp) == 0) {
			/* we get now the full track-filename in tmp */
			/* now get its size (in bytes) */
			sizecount+=(gint) ((off_t)get_size_from_imagelist(tmp) >>10);
		}
                sel = sel->next;
        }
        convert_kbytes2mbminstring(sizecount, tmp);
        gtk_entry_set_text(GTK_ENTRY(imglist_l1), tmp);
}


/* callbacks for verify menu */

void verifysometracks_clicked(GtkWidget *widget, gpointer data) {
track_read_param_t *trackparam;
GList *sellist;
gfloat per;
gint tcount, sizecount,nrtracks;
gint tracknr, size, type, sectorstoread;
GList *sel;
gint row, stat, stat2, abort;
gchar tmp[MAXLINE];
gchar volname[MAXLINE];
gchar *cell;
gchar *pt;

        /* no cd-reader defined */
        if (curset.reader_devnr == -1) {
                show_dialog(ICO_ERROR,text(203), T_OK, NULL, NULL, 0);
                return;
        }
        /* now check if our cd-information is still valid */
        get_cd_toc_and_volid(curset.reader_devnr);
        /* update screen ... */
        fill_verify_tracks(1);

        /* cd loaded? */
        if (cdinfo.nr_tracks < 0) {
                show_dialog(ICO_WARN,text(266),T_OK,NULL,NULL,0);
                return;
        }

        sizecount = 0;
        nrtracks = 0;
        /* loop through all selected tracks to get number */
        sel = imglist->selection;
        while (sel) {
                row = GPOINTER_TO_INT(sel->data);               
                nrtracks++;
                sel = sel->next;
        }

        /* no tracks selected */
        if (nrtracks == 0) {
                show_dialog(ICO_WARN,text(302),T_OK,NULL,NULL,0);
                return;
        }

	/* check if all the tracks selected match the current cd */
	abort = 0;
	sellist = NULL;
	sel = imglist->selection;
        while (sel) {
                row = GPOINTER_TO_INT(sel->data);
                if (get_trackname_from_row(row, tmp) == 0) {
                        /* we get now the full track-filename in tmp */
			/* check if track can be verified */
			stat = check_vrfy_track(tmp);
			stat2 = 0;

			/* get image-title from list */
			gtk_clist_get_text(imglist,row,1,&cell);

			if (stat == 0) {
				/* all ok */
                		sel = sel->next;
				continue;
			}

			if (stat == 1) {
				/* no info file */

				/* perhaps its a self-mastered track? */
				if (get_volname_from_imagelist(tmp,volname) == 0) {
					if (cdinfo.nr_tracks == 1) {
						pt = trackinfo[0]->volname;
						if (pt) {
							if (strcmp(volname,pt) == 0) {	
								/* ah nice, the isoname of the track does match the CD - allow verifying */
                						sel = sel->next;
								continue;
							}
						} else {
							/* special case, no volname at all set by both */
							if (strcmp(volname,"") == 0) {
                						sel = sel->next;
								continue;
							}
						}

					}
				}

				g_snprintf(tmp,MAXLINE,text(304),cell);
				stat2 = show_dialog(ICO_WARN,tmp,T_OK,T_CANCEL,text(412),0);
			}
			if (stat == 2) {
				/* track does not match to cd */
				g_snprintf(tmp,MAXLINE,text(303),cell);
				stat2 = show_dialog(ICO_WARN,tmp,T_OK,T_CANCEL,NULL,0);
			}
			if (stat == 3) {
				/* dont verify audio */
				g_snprintf(tmp,MAXLINE,text(305),cell);
				stat2 = show_dialog(ICO_WARN,tmp,T_OK,T_CANCEL,NULL,0);
			}

			/* aborting selected */
			if (stat2 == 1) {
				abort = 1;
				break;
			} 
			
			/* no info file, but verify anyway */
			if (stat2 == 2) {
                		sel = sel->next;
				continue;
			}

			/* save track nr - we are not allowed to
			   unselect tracks while we parsing the
			   selection itself */
			sellist = g_list_append(sellist, GINT_TO_POINTER(row));
                }
                sel = sel->next;
        }

	/* unselect all not fitting tracks */
	sel = g_list_first(sellist);
	while (sel) {
		row = (gint) sel->data;
		gtk_clist_unselect_row(imglist, row, 0);
		sel = sel->next;
	}
	g_list_free(sellist);

	/* user aborted? */
	if (abort) return;

	/* now check if any tracks are still selected */
	/* and calculate sum of size */
	sizecount = 0;
        nrtracks = 0;
        /* loop through all selected tracks to get number */
        sel = imglist->selection;
        while (sel) {
                row = GPOINTER_TO_INT(sel->data);               
                if (get_trackname_from_row(row, tmp) == 0) {
                        /* we get now the full track-filename in tmp */
                        /* now get its size (in bytes) */
                        sizecount+=(gint) ((off_t)get_size_from_imagelist(tmp) >> 10);
                }
                nrtracks++;
                sel = sel->next;
        }

        /* no tracks selected */
        if (nrtracks == 0) {
                show_dialog(ICO_WARN,text(302),T_OK,NULL,NULL,0);
                return;
        }

	/* so...if we are here, we have at least one selected track
	   that matches our CD */

        /* free structure first */
	clear_trackreadset();

        /* fill structure */
        trackreadset.nrtracks = nrtracks;

        tcount = 0;
        sel = imglist->selection;
        while (sel) {
                row = GPOINTER_TO_INT(sel->data);               

                if (get_trackname_from_row(row, tmp) != 0) {
			sel = sel->next; continue;
		}
                /* we get now the full track-filename in tmp */

		tracknr = get_tracknr_from_imagelist(tmp);
		if (get_type_from_imagelist(tmp) == 1) {
			/* audio */
			type = 1;
		} else {
			/* data */
			type = 0;
		}
		size = (gint) ((off_t)get_size_from_imagelist(tmp) >> 10);

		/* no info-file, therefore tracknr 0 */
		if (tracknr == 0) {
			/* we can only guess what the track could be -
			   track 1 seems to be the most sensible choice */
			tracknr = 1;
		}

                /* allocate memory */
                trackparam = g_new0(track_read_param_t,1);

	        trackparam->trackinfo_index = tracknr-1;
                trackparam->starttrack = tracknr;
                trackparam->endtrack = 0;
                trackparam->tracktype = type;
                per = (gfloat)size / sizecount;
                trackparam->percent = per;
                g_free(trackparam->trackfile);
                trackparam->trackfile = g_strdup(tmp);

		if (type == 0) {
			/* data track */
                        trackparam->kbyte = trackinfo[tracknr-1]->size *
                                (DATASECTORSIZE/1024);
                        trackparam->frames = trackinfo[tracknr-1]->size;
                        trackparam->startoffset = trackinfo[tracknr-1]->start_sec;
                        if (tracknr-1 == cdinfo.nr_tracks-1) {
                                /* last track - leadout is track-end */
                                trackparam->endoffset = cdinfo.leadout - 2;     
                        } else {
                                /* sub 150 (2 sec leadout),
                                   sub 2 (2 run out sectors) */
                                trackparam->endoffset = 
                                        trackinfo[tracknr]->start_sec -150-2; 
                        }
                        /* now do a paranoia check */
                        /* in some cases we skip to much of a track */
                        sectorstoread = trackparam->endoffset -
                                trackparam->startoffset;
			if (sectorstoread < trackinfo[tracknr-1]->isosize) {
                                trackparam->endoffset =
                                        trackparam->startoffset +
                                                trackinfo[tracknr-1]->isosize;
                                trackparam->kbyte = trackinfo[tracknr-1]->isosize * 2;
				dodebug(1,"verifysometracks_clicked: corrected data track size from %d to %d sectors.\n", sectorstoread, trackinfo[tracknr-1]->isosize);
			}
                } else {
                        /* audio */
                        trackparam->kbyte = trackinfo[tracknr-1]->size *
                                CDDAFRAME/1024;
                        trackparam->frames = trackinfo[tracknr-1]->size;
                }

		
                trackreadset.trackparams = g_list_append(
                        trackreadset.trackparams, trackparam);

                sel = sel->next;
        }

        /* assign an empty toc-filename */
        g_free(trackreadset.tocfile);
        trackreadset.tocfile = g_strdup("");

        /* now all parameters for verifying are set - lets begin */
        show_and_do_verify_tracks(curset.reader_devnr);
}


void verify_select_all(GtkWidget *widget, gpointer data) {

        gtk_clist_select_all(imglist);
}

void verify_select_none(GtkWidget *widget, gpointer data) {

        gtk_clist_unselect_all(imglist);
}

void verify_select_row(GtkWidget *clist, gint row, gint col,
        GdkEventButton *event, gpointer data) {

        update_verify_size(row);
}


/* draw verify-tracks menu */

void draw_verify_tracks() {
GtkWidget *hbox, *vbox;
GtkWidget *f1, *f2, *f3;
GtkWidget *b1;
GtkWidget *e1;
GtkWidget *l1;
GtkWidget *tbl, *check;
gchar *titles[2];
GtkWidget *scrolled_win, *img_list;

        /* prepare draw area */
        clear_actionspace();

        f1 = gtk_frame_new(text(107));
        set_font_and_color(f1,BOLDFONT,NULL);
        gtk_box_pack_start(GTK_BOX(actionspace),f1,FALSE,FALSE,5);
        gtk_widget_show(f1);

        tbl = gtk_table_new(2,16*4,TRUE); 
        gtk_table_set_col_spacing(GTK_TABLE(tbl),4*4-1,5);
        gtk_table_set_col_spacing(GTK_TABLE(tbl),15*4-2,5);
        gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
        gtk_container_add(GTK_CONTAINER(f1),tbl);
        gtk_widget_show(tbl);

        devices_setup_read(0, tbl, 1);
        devices_setup_image(1, tbl);

        /* left and right info-frames */
        tbl = gtk_table_new(1,2,TRUE);
        gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
        gtk_box_pack_start(GTK_BOX(actionspace),tbl,TRUE,TRUE,10);
        gtk_widget_show(tbl);
        vbox = gtk_vbox_new(FALSE,10);
        gtk_table_attach_defaults(GTK_TABLE(tbl),vbox,0,1,0,1);
        f1 = gtk_frame_new(text(96));
        set_font_and_color(f1,BOLDFONT,NULL);
        gtk_box_pack_start(GTK_BOX(vbox),f1,TRUE,TRUE,0);
        gtk_widget_show(f1);
        f3 = gtk_frame_new(text(233));
        set_font_and_color(f3,BOLDFONT,NULL);
        gtk_box_pack_start(GTK_BOX(vbox),f3,FALSE,FALSE,0);
        gtk_widget_show(f3);
        f2 = gtk_frame_new(text(232));
        set_font_and_color(f2,BOLDFONT,NULL);
        gtk_table_attach_defaults(GTK_TABLE(tbl),f2,1,2,0,1);
        gtk_widget_show(f2);
        gtk_widget_show(vbox);

        /* button bar at the bottom */
        hbox = gtk_hbox_new(TRUE,10);
        gtk_box_pack_start(GTK_BOX(actionspace),hbox,FALSE,TRUE,10);
        gtk_widget_show(hbox);

        b1 = gtk_button_new_with_label(text(221));
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,10);
        gtk_signal_connect(GTK_OBJECT(b1),"clicked",
                GTK_SIGNAL_FUNC(verify_select_all), NULL);
	define_tooltip(b1,help(89));
        gtk_widget_show(b1);

        b1 = gtk_button_new_with_label(text(222));
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,10);
        gtk_signal_connect(GTK_OBJECT(b1),"clicked",
                GTK_SIGNAL_FUNC(verify_select_none), NULL);
	define_tooltip(b1,help(90));
        gtk_widget_show(b1);

        b1 = gtk_button_new_with_label(text(301));
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,10);
        gtk_widget_show(b1);
        gtk_signal_connect(GTK_OBJECT(b1), "clicked",
                GTK_SIGNAL_FUNC(verifysometracks_clicked), NULL);
	define_tooltip(b1,help(91));

        /* left info frame */
        vbox = gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(f1),vbox);
        gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);
        gtk_widget_show(vbox);

        tbl = gtk_table_new(4,8,TRUE);
        gtk_table_set_row_spacings(GTK_TABLE(tbl),10);
        gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
        gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,10);
        gtk_widget_show(tbl);
        
        l1 = rightjust_gtk_label_new(text(103));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,0,1);
        gtk_widget_show(l1);

        e1 = gtk_entry_new();
        vrylist_l1 = e1;
        gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
        gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,8,0,1);
        gtk_widget_show(e1);

        l1 = rightjust_gtk_label_new(text(104));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,1,2);
        gtk_widget_show(l1);

        e1 = gtk_entry_new();
        vrylist_l2 = e1;
        gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
        gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,8,1,2);
        gtk_widget_show(e1);

        l1 = rightjust_gtk_label_new(text(105));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,2,3);
        gtk_widget_show(l1);

        e1 = gtk_entry_new();
        vrylist_l3 = e1;
        gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
        gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,8,2,3);
        gtk_widget_show(e1);

        l1 = rightjust_gtk_label_new(text(145));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,3,4);
        gtk_widget_show(l1);

        e1 = gtk_entry_new();
        vrylist_l4 = e1;
        gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
        gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,8,3,4);
        gtk_widget_show(e1);

        /* options frame */
        vbox = gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(f3),vbox);
        gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
        gtk_widget_show(vbox);

        tbl = gtk_table_new(2,8,TRUE);
        gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
        gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,10);
        gtk_widget_show(tbl);

        check = gtk_check_button_new_with_label(text(234));
        gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(verifyoptions_selected),GINT_TO_POINTER(0));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,8,0,1);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                curset.noaudioverify);
        gtk_widget_show(check);
        define_tooltip(check, help(53));
        
        check = gtk_check_button_new_with_label(text(236));
        gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(verifyoptions_selected),GINT_TO_POINTER(1));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,8,1,2);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                curset.verifyfailabort);
        gtk_widget_show(check);
        define_tooltip(check, help(54));
        
	/* right frame */
        vbox = gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(f2),vbox);
        gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);
        gtk_widget_show(vbox);

        scrolled_win = gtk_scrolled_window_new (NULL, NULL);
        gtk_box_pack_start(GTK_BOX(vbox),scrolled_win,TRUE,TRUE,0);
        gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
                GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
        gtk_widget_show(scrolled_win);
        
        titles[0] = g_strdup("");
        titles[1] = text(102);
        img_list = gtk_clist_new_with_titles(2,titles);
        gtk_container_add (GTK_CONTAINER (scrolled_win), img_list);
        imglist = GTK_CLIST(img_list);
        gtk_signal_connect(GTK_OBJECT(imglist), "select_row",
                GTK_SIGNAL_FUNC(verify_select_row),NULL);
        gtk_signal_connect(GTK_OBJECT(imglist), "unselect_row",
                GTK_SIGNAL_FUNC(verify_select_row),NULL);
        gtk_clist_set_column_width(imglist, 0, 16);
        gtk_clist_set_column_auto_resize(imglist, 1, TRUE);
	if (setupdata.option_selectionmode == 0) {
		gtk_clist_set_selection_mode (imglist, GTK_SELECTION_MULTIPLE);
	} else {
		gtk_clist_set_selection_mode (imglist, GTK_SELECTION_EXTENDED);
	}
        gtk_widget_show(img_list);
	gtk_widget_realize(img_list);

        tbl = gtk_table_new(1,8,TRUE);
        gtk_table_set_row_spacings(GTK_TABLE(tbl),10);
        gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
        gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,10);
        gtk_widget_show(tbl);
        
        l1 = rightjust_gtk_label_new(text(300));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,0,1);
        gtk_widget_show(l1);

        e1 = gtk_entry_new();
        imglist_l1 = e1;
        gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
        gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,8,0,1);
        gtk_widget_show(e1);

	gtk_widget_show(actionspace);

	/* fill entries */
	fill_verify_tracks(0);
}


/* callback for write button */

void writesometracks_clicked(GtkWidget *widget, gpointer data) {
gint ret, stat;
gint spaceneededoncd;
gint64 tmpsize;
gchar tmptoc[MAXLINE];
GList *loop;
track_read_param_t *trackparam;
gint cdsize, avail, found;
gint msinfo1, msinfo2, m1, m2;
gint msdisk1, msdisk2;

        /* no cd-writer defined */
        if (curset.writer_devnr == -1) {
                show_dialog(ICO_ERROR,text(204), T_OK, NULL, NULL, 0);
                return;
        }

	/* see if we have anything selected at all */
	if (g_list_first(trackreadset.trackparams) == NULL) {
		show_dialog(ICO_WARN,text(315),T_OK,NULL,NULL,0);
		return;
	}

	msinfo1 = -1;
	msinfo2 = -1;

	/* in multisession mode allow only to write one track at a time */
	if (curset.multisession == 1) {
		if (trackreadset.nrtracks > 1) {
			show_dialog(ICO_WARN,text(505),T_OK,NULL,NULL,0);
			return;
		}

		/* ok, one file to write...get msinfo data */
		loop = g_list_first(trackreadset.trackparams);
		trackparam = loop->data;
		if (trackparam->trackfile != NULL) {
			get_msinfo_from_imagelist(trackparam->trackfile,
				&msinfo1, &msinfo2);
		}	
	} else {
		/* no multisession.. */
		/* see if there is a track in the list that requires 
		   multisession */
		found = 0;
		loop = g_list_first(trackreadset.trackparams);
		while(loop) {
			trackparam = loop->data;
			if (trackparam->trackfile != NULL) {
				get_msinfo_from_imagelist(trackparam->trackfile,
					&m1, &m2);
				if (m1 >= 0 || m2 >= 0) {
					found = 1;
				}				
			}
			loop = loop->next;
		}

		/* warn about multisession */
		if (found) {
                	ret = show_dialog(ICO_WARN,text(506),T_ANYWAY,T_CANCEL,NULL,1);
                	if (ret == 1) {
				return;	
			}
		}
	}
	
	/* now check if the CD-R is the right one for our multisession
	   needs */
	if (curset.multisession == 1) {
		get_cd_toc_and_volid(curset.writer_devnr);
	        if (cdinfo.nr_tracks != -1) {
        	        get_msinfo_info(curset.writer_devnr, 
                                &msdisk1, &msdisk2);
        	} else {
                	/* no cd loaded? abort */
                	show_dialog(ICO_WARN,text(508),T_OK,NULL,NULL,0);
                        return;
		}

		/* does the session info match to disk? */
		if (msdisk1 != msinfo1 || msdisk2 != msinfo2) {
			ret = show_dialog(ICO_WARN,text(507), T_ANYWAY, T_CANCEL, NULL, 1);
			if (ret == 1) {
				return;	
			}
		}
	}

	tmpsize = (gint64)trackreadset.cdsize * 1024;
	spaceneededoncd = (gint) ((gint64)tmpsize/CDDAFRAME);

	/* first check if all tracks we need are available on hd */
	/* dont check for file sizes, we assume the user did not
	   modify them since the last update of the imagelist */
        stat = check_write_files(1);
        switch(stat) {
                /* files with wrong size */
                case 1:
                        break;
                /* files missing */
                case 2:
                        show_dialog(ICO_ERROR,text(316),T_OK,NULL,NULL,0);
                        return;

                /* no permission/invalid */
                case 3:
                        show_dialog(ICO_ERROR,text(201),T_OK,NULL,NULL,0);
                        return;

	}

        /* check if enough space on cd-r? */
        dodebug(2,"Sectors required: %d, Mediatype = %d\n", spaceneededoncd,
                curset.cdrtype);

        if (curset.cdrtype < 1000) {
                cdsize = curset.cdrtype*60*75;
        } else {
                cdsize = curset.cdrtype*512;
        }
        avail = cdsize;

        /* we want to write multisession? consider session overhead */
        if (curset.multisession == 1) {
                if (cdinfo.nr_tracks > 0) {
                        /* additional sessions */
                        avail -= 6900;   /* about 13 MB */
                } else {
                        /* first session */
                        avail -= 11400;   /* about 22 MB */
                }
        }

        if (spaceneededoncd > avail) {
                ret = show_dialog(ICO_WARN,text(278),T_ANYWAY,T_CANCEL,NULL,1);
                if (ret == 1) {
                        /* aborted */
                        return;
                }       
        }

        /* ok, now we are sure that all tracks are fine ...prompt for CD-R */
	if (curset.multisession == 0) {
        	ret = show_dialog(ICO_INFO,text(202),T_OK,T_CANCEL,NULL,0);
	} else {
		/* multisession */
		if (msinfo2 > 0) {
			/* add new session */
                        ret = show_dialog(ICO_INFO,text(499),T_OK,T_CANCEL,NULL,0);
		} else {
                        /* write first session */
                        ret = show_dialog(ICO_INFO,text(498),T_OK,T_CANCEL,NULL,0);
		}
	}
        if (ret != 0) {
                return;
        }

	/* if we should write CD-Text then edit the .inf files from cdda2wav */
	if (curset.writecdtext) {
		loop = g_list_first(trackreadset.trackparams);
		while(loop) {
			trackparam = loop->data;
			if (trackparam->trackfile != NULL) {
				generate_tmp_tocfile_name(tmptoc);
				edit_xinf_for_cdtext(trackparam->trackfile,
					tmptoc);
			}
			loop = loop->next;
		}	

	}

	/* start writing */
        show_and_do_write_tracks(curset.writer_devnr, -1, 0);
}


/* callback for fixate cdr */

void fixate_clicked(GtkWidget *widget, gpointer data) {
gint ret;

        /* no cd-writer defined */
        if (curset.writer_devnr == -1) {
                show_dialog(ICO_ERROR,text(204), T_OK, NULL, NULL, 0);
                return;
        }

        /* prompt for CD-R */
        ret = show_dialog(ICO_INFO,text(202),T_OK,T_CANCEL,NULL,0);
        if (ret != 0) {
                return;
        }

	/* start fixating */
	show_and_do_write_tracks(curset.writer_devnr, -1, 2);
}


/* redraw the selected-tracks list */

void redraw_writelist(GtkCList *llist, GtkWidget *lentry) {
GList *loop;
gchar *track;
gchar tmp[MAXLINE];
gchar tmp2[MAXLINE];
gchar titlestr[MAXLINE];
GtkStyle *style;
gchar *data[2];
GdkPixmap *pixmap1, *pixmap2, *pixmap3;
GdkBitmap *mask1, *mask2, *mask3;
gchar basename[MAXLINE], fname[MAXLINE], *p;
image_files_t *entry;
gint count,lcount;
gint sizecount;

        /* clean up first */
        gtk_clist_clear(llist);

        style = gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(imglist)));
        pixmap1 = gdk_pixmap_create_from_xpm_d(llist->clist_window,
                &mask1, &style->bg[GTK_STATE_NORMAL],(gchar **)minidata_xpm);
        pixmap2 = gdk_pixmap_create_from_xpm_d(llist->clist_window,
                &mask2, &style->bg[GTK_STATE_NORMAL],(gchar **)miniaudio_xpm);
        pixmap3 = gdk_pixmap_create_from_xpm_d(llist->clist_window,
                &mask3, &style->bg[GTK_STATE_NORMAL],(gchar **)mininodata_xpm);

        data[0] = NULL;
	count = 1;
	lcount = 0;
	sizecount = 0;

	loop = g_list_first(writelist);
	while (loop) {
		track = loop->data;
		entry = get_entry_from_imagelist(track);
		if (entry == NULL) {
			/* should never happen */
			loop = loop->next;
			continue;
		}
                /* get the base-dirname */
                strncpy(basename,entry->path,MAXLINE);  
                p = rindex(basename,'/');
                *p = '\0';
                if (strcmp(basename,"") == 0) {
                        strcpy(basename,"/");
                }
                strcpy(fname, p+1);
	
		sizecount+=(gint) ((off_t)get_size_from_imagelist(track) >> 10);
                strcpy(titlestr,"");
                assign_trackname(titlestr, entry);

                /* no title found - so use filename as title */
                if (strcmp(titlestr,"") == 0) {
                        strcpy(titlestr,fname);
                }

                /* iso9600-track/ unknown  */
                if (entry->type == 0 || entry->type == 3) {
                        convert_frames2mbstring((gint)((off_t)entry->size/DATASECTORSIZE),
                                tmp2);
                        g_snprintf(tmp,MAXLINE,"%2d. %s [%s]",
                                count, titlestr, tmp2);
                        data[1] = tmp;
                        gtk_clist_append(llist,data);
                        if (entry->type == 0) {
                                gtk_clist_set_pixmap(llist,lcount,0,pixmap1,mask1);   
                        } else {
                                gtk_clist_set_pixmap(llist,lcount,0,pixmap3,mask3);   
                        }
                        count++;
                        lcount++;
                }

                /* valid wav-file */
                if (entry->type == 1) {
                        convert_frames2minstring((gint)((off_t)entry->size/CDDAFRAME), tmp2);
                        g_snprintf(tmp,MAXLINE,"%2d. %s [%s]",
                                count, titlestr, tmp2);
                        data[1] = tmp;
                        gtk_clist_append(llist,data);
                        gtk_clist_set_pixmap(llist,lcount,0,pixmap2,mask2);   
                        lcount++;
                        count++;
                }       
		
		loop = loop->next;
	}
	
        convert_kbytes2mbminstring(sizecount, tmp);
        gtk_entry_set_text(GTK_ENTRY(lentry), tmp);
}


/* fill the tracks-to-write list */

void fill_writelist2(GtkCList *llist, GtkWidget *lentry) {
GList *loop;
track_read_param_t *trackparam;
gchar track[MAXLINE];
gchar tmp[MAXLINE];
gchar tmp2[MAXLINE];
gchar titlestr[MAXLINE];
GtkStyle *style;
gchar *data[2];
GdkPixmap *pixmap1, *pixmap2, *pixmap3;
GdkBitmap *mask1, *mask2, *mask3;
gchar basename[MAXLINE], fname[MAXLINE], *p;
image_files_t *entry;
gint count,lcount;

        /* clean up first */
        gtk_clist_clear(llist);

        style = gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(imglist)));
        pixmap1 = gdk_pixmap_create_from_xpm_d(llist->clist_window,
                &mask1, &style->bg[GTK_STATE_NORMAL],(gchar **)minidata_xpm);
        pixmap2 = gdk_pixmap_create_from_xpm_d(llist->clist_window,
                &mask2, &style->bg[GTK_STATE_NORMAL],(gchar **)miniaudio_xpm);
        pixmap3 = gdk_pixmap_create_from_xpm_d(llist->clist_window,
                &mask3, &style->bg[GTK_STATE_NORMAL],(gchar **)mininodata_xpm);

        data[0] = NULL;
	count = 1;
	lcount = 0;

	loop = g_list_first(trackreadset.trackparams);
	while (loop) {
		trackparam = loop->data;

		strcpy(track, trackparam->trackfile);

		entry = get_entry_from_imagelist(track);
		if (entry == NULL) {
			/* should never happen */
			loop = loop->next;
			continue;
		}
                /* get the base-dirname */
                strncpy(basename,track,MAXLINE);  
                p = rindex(basename,'/');
                *p = '\0';
                if (strcmp(basename,"") == 0) {
                        strcpy(basename,"/");
                }
                strcpy(fname, p+1);
	
                strcpy(titlestr,"");
                assign_trackname(titlestr, entry);

                /* no title found - so use filename as title */
                if (strcmp(titlestr,"") == 0) {
                        strcpy(titlestr,fname);
                }

                /* data  */
                if (trackparam->tracktype == 0) {
                        convert_frames2mbstring((gint)((off_t)entry->size/DATASECTORSIZE),
                                tmp2);
                        g_snprintf(tmp,MAXLINE,"%2d. %s [%s]",
                                count, titlestr, tmp2);
                        data[1] = tmp;
                        gtk_clist_append(llist,data);
                        if (entry->type == 0) {
                                gtk_clist_set_pixmap(llist,lcount,0,pixmap1,mask1);   
                        } else {
                                gtk_clist_set_pixmap(llist,lcount,0,pixmap3,mask3);   
                        }
                        count++;
                        lcount++;
                }

                /* valid wav-file */
                if (entry->type == 1) {
                        convert_frames2minstring((gint)((off_t)entry->size/CDDAFRAME), tmp2);
                        g_snprintf(tmp,MAXLINE,"%2d. %s [%s]",
                                count, titlestr, tmp2);
                        data[1] = tmp;
                        gtk_clist_append(llist,data);
                        gtk_clist_set_pixmap(llist,lcount,0,pixmap2,mask2);   
                        lcount++;
                        count++;
                }       
		
		loop = loop->next;
	}
	
        convert_kbytes2mbminstring(trackreadset.cdsize, tmp);
        gtk_entry_set_text(GTK_ENTRY(lentry), tmp);
}


void write_delete_tracks(GtkWidget *widget, gpointer data) {
gint nrtracks;
GList *sel, *loop, *loop2;
gint row;

        nrtracks = 0;

	/* get the list of track-filenames to remove from the write-list */
        sel = cdlist->selection;
        while (sel) {
                row = GPOINTER_TO_INT(sel->data);
		loop = g_list_nth(writelist,row);
		if (loop->data) {
			/* mark as deleted */
			g_free(loop->data);
			loop->data = NULL;
		}
                nrtracks++;
                sel = sel->next;
        }

        /* no tracks selected */
        if (nrtracks == 0) {
                show_dialog(ICO_WARN,text(302),T_OK,NULL,NULL,0);
                return;
        }

	/* now really remove from list */
	loop = g_list_first(writelist);
	while (loop) {
		loop2 = loop->next;
		if (loop->data == NULL) {
			writelist = g_list_remove_link(writelist, loop);
		}
		loop = loop2;
	}

	redraw_writelist(cdlist,cdlist_l1);
	fill_write_tracks();
}


void write_add_tracks(GtkWidget *widget, gpointer data) {
gint nrtracks;
GList *sel;
gint row;
gchar tmp[MAXLINE];

        nrtracks = 0;

	/* get the list of track-filenames to add to the write-list */
        sel = imglist->selection;
        while (sel) {
                row = GPOINTER_TO_INT(sel->data);
                if (get_trackname_from_row(row, tmp) == 0) {
                        /* we get now the full track-filename in tmp */
			/* add to list */
			writelist = g_list_append(writelist,g_strdup(tmp));
		}
                nrtracks++;
                sel = sel->next;
        }

        /* no tracks selected */
        if (nrtracks == 0) {
                show_dialog(ICO_WARN,text(302),T_OK,NULL,NULL,0);
                return;
        }

	redraw_writelist(cdlist,cdlist_l1);
	fill_write_tracks();
}


/* this is the callback of a timeout  - we need that to
   silently update the track-listing after the user reordered the list */

gint redraw_tracklist_callback(gpointer data) {

	redraw_writelist(cdlist,cdlist_l1);
	/* call this only once */
	return(FALSE);
}


/* called when you change order of entries in clist */

void write_move_row(GtkWidget *clist, gint row1, gint row2, gpointer data) {
GList *l1;

	/* reorder memory-structure exactly like the clist does */
	l1 = g_list_nth(writelist,row1);
	if (row1 > row2) {
		writelist = g_list_insert(writelist, l1->data, row2);
		writelist = g_list_remove_link(writelist, l1);
	} else {
		writelist = g_list_insert(writelist, l1->data, row2+1);
		writelist = g_list_remove_link(writelist, l1);
	}

	/* set timeout to update the clist */
	gtk_timeout_add(10, redraw_tracklist_callback, NULL);
}


/* accept tracklayout button */

void accept_layout_clicked(GtkWidget *widget, gpointer notebook) {
GList *loop;
track_read_param_t *trackparam;
gchar *track;
gint count,cdsize;
image_files_t *entry;
gfloat per;

	if (notebook) {
		/* see if we have anything selected at all */
		if (g_list_first(writelist) == NULL) {
			show_dialog(ICO_WARN,text(315),T_OK,NULL,NULL,0);
			return;
		}
	}

	/* fill the trackreadset with our tracks to write */
	/* clear first */
	clear_trackreadset();

        cdsize = 0;
	count = 1;
        trackreadset.tocfile=g_strdup("");

        loop = g_list_first(writelist);
        while (loop) {
                track = loop->data;
                entry = get_entry_from_imagelist(track);
                if (entry == NULL) {
                        /* should never happen */
                        loop = loop->next;
                        continue;
                }

                /* allocate memory */
                trackparam = g_new0(track_read_param_t,1);

                trackparam->trackinfo_index = -1;
                trackparam->starttrack = count;
                trackparam->endtrack = 0;
		if (entry->type == 1) {
			/* audio */
			trackparam->tracktype = 1;
			trackparam->frames = (gint) ((off_t)entry->size/CDDAFRAME);
		} else {
			/* data */
			trackparam->tracktype = 0;
			trackparam->frames = (gint) ((off_t)entry->size/DATASECTORSIZE);
		}
		trackparam->kbyte = (gint) ((off_t)entry->size >> 10);	
		g_free(trackparam->trackfile);
		trackparam->trackfile = g_strdup(track);

		cdsize += trackparam->kbyte;
                trackreadset.nrtracks++;        
		count++;

		trackreadset.trackparams = g_list_append(
			trackreadset.trackparams, trackparam);

                loop = loop->next;
        }

        trackreadset.cdsize = cdsize;

        /* ok..all data read - now calculate the percentages */
        loop = g_list_first(trackreadset.trackparams);
        while(loop) {
                trackparam = loop->data;
                per = (gfloat)trackparam->kbyte / cdsize;
                trackparam->percent = per;

                loop = loop->next;
        }

        if (debug > 1) 
                print_trackreadset();

	/* fill listing on page 1 */
	fill_writelist2(imglist2,imglist_l2);

	if (notebook) {
		/* now change notebook tab back to page 1 */
		gtk_notebook_set_page(GTK_NOTEBOOK(notebook), 0);
	}
}


/* called when you change tabs in the write tracks menu */
/* detect when switching from layout to view mode */

static void writetracks_notebookswitch(GtkWidget *widget, GtkNotebookPage *page, gint page_num) {
gint curpage;

	curpage = gtk_notebook_get_current_page(GTK_NOTEBOOK(widget));

	/* user clicked "write tracks" while in "layout tracks" */
	if (curpage == 1 && page_num == 0) {	
		/* simulate click on accept layout */
		accept_layout_clicked(widget, NULL);
	}
}


void fill_write_tracks() {
gchar tmp[MAXLINE], tmp2[MAXLINE];
gchar titlestr[MAXLINE];
GList *loop;
GtkStyle *style;
gchar *data[2];
GdkPixmap *pixmap1, *pixmap2, *pixmap3;
GdkBitmap *mask1, *mask2, *mask3;
gchar basename[MAXLINE], imgdir[MAXLINE], fname[MAXLINE], *p;
gint lcount, count;
image_files_t *entry;

        /* clean up first */
        gtk_clist_clear(imglist);

        style = gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(imglist)));
        pixmap1 = gdk_pixmap_create_from_xpm_d(imglist->clist_window,
                &mask1, &style->bg[GTK_STATE_NORMAL],(gchar **)minidata_xpm);
        pixmap2 = gdk_pixmap_create_from_xpm_d(imglist->clist_window,
                &mask2, &style->bg[GTK_STATE_NORMAL],(gchar **)miniaudio_xpm);
        pixmap3 = gdk_pixmap_create_from_xpm_d(imglist->clist_window,
                &mask3, &style->bg[GTK_STATE_NORMAL],(gchar **)mininodata_xpm);

        data[0] = NULL;
        strcpy(imgdir,"");
        count = 1;
        lcount = 0;

        /* check image-selector */
        if (curset.image_index != -1) {
                /* no automatic setting? */
                strncpy(imgdir,(gchar *)g_list_nth_data(setupdata.image_dirs,
                        curset.image_index), MAXLINE);
        }

        loop = g_list_first(imagelist);
        while (loop) {
                entry = loop->data;

                /* get the base-dirname */
                strncpy(basename,entry->path,MAXLINE);  
                p = rindex(basename,'/');
                *p = '\0';
                if (strcmp(basename,"") == 0) {
                        strcpy(basename,"/");
                }
                strcpy(fname, p+1);

                if (strcmp(basename,imgdir) != 0 && imgdir[0] != '\0') {
                        /* skip not selected dirs */
                        loop = loop->next;
                        continue;
                }

                if (entry->readable == 0) {
                        /* dont display not readable files */
                        loop = loop->next;
                        continue;
                }

                strcpy(titlestr,"");
		assign_trackname(titlestr, entry);

                /* no title found - so use filename as title */
                if (strcmp(titlestr,"") == 0) {
                        strcpy(titlestr,fname);
                }

                /* iso9600-track/ unknown  */
                if (entry->type == 0 || entry->type == 3) {
                        convert_frames2mbstring((gint)((off_t)entry->size/DATASECTORSIZE),
                                tmp2);
                        g_snprintf(tmp,MAXLINE,"%2d. %s [%s] (%s)",
                                count, titlestr, tmp2, entry->path);
                        data[1] = tmp;
                        gtk_clist_append(imglist,data);

			if (is_on_writelist(entry->path)) {
				/* already on writelist? change color */
				set_clist_row_color(imglist,
					lcount,SELECTEDCLISTCOL);
			}

                        if (entry->type == 0) {
                                gtk_clist_set_pixmap(imglist,lcount,0,pixmap1,mask1);   
                        } else {
                                gtk_clist_set_pixmap(imglist,lcount,0,pixmap3,mask3);   
                        }
                        count++;
                        lcount++;
                }

                /* valid wav-file */
                if (entry->type == 1) {
                        convert_frames2minstring((gint)((off_t)entry->size/CDDAFRAME), tmp2);
                        g_snprintf(tmp,MAXLINE,"%2d. %s [%s] (%s)",
                                count, titlestr, tmp2, entry->path);
                        data[1] = tmp;
                        gtk_clist_append(imglist,data);

			if (is_on_writelist(entry->path)) {
				/* already on writelist? change color */
				set_clist_row_color(imglist,
					lcount,SELECTEDCLISTCOL);
			}

                        gtk_clist_set_pixmap(imglist,lcount,0,pixmap2,mask2);   
                        lcount++;
                        count++;
                }       

                loop = loop->next;
        }

        /* nothing selected - no size of files */
        convert_kbytes2mbminstring(0, tmp);
        gtk_entry_set_text(GTK_ENTRY(imglist_l1), tmp);  
}


/* draw the write-tracks menu */

void draw_write_tracks() {
gchar tmp[MAXLINE];
gchar tmp2[MAXLINE];
gchar tmptoc[MAXLINE];
GtkWidget *hbox, *vbox;
GtkWidget *f1,*f2;
GtkWidget *b1;
GtkWidget *e1, *check;
GtkWidget *l1;
GtkWidget *tbl;
GtkWidget *sep;
GtkWidget *omenu;
GtkWidget *menu;
GtkWidget *menu_item;
gint cdrtypes[] = CDR_TYPES_MIN;
gint dvdtypes[] = DVD_TYPES_MB;
gint writemodes[] = WRITE_MODES;
gint helpwritemodes[] = HELP_WRITE_MODES;
gint i, tmpval;
gint menuidx, menuhistory;
GtkWidget *notebook, *halign;
gchar *titles[2];
GtkWidget *scrolled_win, *img_list, *cd_list, *img_list2;

        /* prepare draw area */
        clear_actionspace();

        f1 = gtk_frame_new(text(107));
        set_font_and_color(f1,BOLDFONT,NULL);
        gtk_box_pack_start(GTK_BOX(actionspace),f1,FALSE,FALSE,5);
        gtk_widget_show(f1);

        tbl = gtk_table_new(2,16*4,TRUE); 
        gtk_table_set_col_spacing(GTK_TABLE(tbl),4*4-1,5);
        gtk_table_set_col_spacing(GTK_TABLE(tbl),15*4-2,5);
        gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
        gtk_container_add(GTK_CONTAINER(f1),tbl);
        gtk_widget_show(tbl);

        devices_setup_image(0, tbl);
        devices_setup_write(1, tbl);

        gtk_widget_show(actionspace);

	/* notebook tabs */
        notebook = gtk_notebook_new();
        gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
        gtk_box_pack_start(GTK_BOX(actionspace),notebook,TRUE,TRUE,2);
        gtk_widget_show(notebook);

      	gtk_signal_connect (GTK_OBJECT (notebook), "switch_page",
	  	GTK_SIGNAL_FUNC (writetracks_notebookswitch), NULL);

	vbox = gtk_vbox_new(FALSE,0);
	l1 = gtk_label_new(text(307));
	gtk_notebook_append_page(GTK_NOTEBOOK (notebook),vbox,l1);
	gtk_widget_show(vbox);

        /* left and right info-frames */
        tbl = gtk_table_new(1,2,TRUE);
        gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
        gtk_table_set_col_spacings(GTK_TABLE(tbl),5);
        gtk_box_pack_start(GTK_BOX(vbox),tbl,TRUE,TRUE,0);
        gtk_widget_show(tbl);
        f1 = gtk_frame_new(text(306));
        set_font_and_color(f1,BOLDFONT,NULL);
        gtk_table_attach_defaults(GTK_TABLE(tbl),f1,0,1,0,1);
        gtk_widget_show(f1);
        f2 = gtk_frame_new(text(169));
        set_font_and_color(f2,BOLDFONT,NULL);
        gtk_table_attach_defaults(GTK_TABLE(tbl),f2,1,2,0,1);
        gtk_widget_show(f2);

        /* button bar at the bottom */
        hbox = gtk_hbox_new(TRUE,10);
        gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,TRUE,5);
        gtk_widget_show(hbox);
        b1 = gtk_button_new_with_label(text(307));
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,10);
        gtk_widget_show(b1);
        gtk_signal_connect(GTK_OBJECT(b1), "clicked",
                GTK_SIGNAL_FUNC(writesometracks_clicked), NULL);
        define_tooltip(b1,help(94));

        b1 = gtk_button_new_with_label(text(308));
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,10);
        gtk_widget_show(b1);
        gtk_signal_connect(GTK_OBJECT(b1), "clicked",
                GTK_SIGNAL_FUNC(fixate_clicked), NULL);
        define_tooltip(b1,help(95));

        b1 = gtk_button_new_with_label(text(171));
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,10);
        gtk_widget_show(b1);
        gtk_signal_connect(GTK_OBJECT(b1), "clicked",
                GTK_SIGNAL_FUNC(blankcd_clicked), NULL);
        define_tooltip(b1,help(64));

	/* left info frame */
        vbox = gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(f1),vbox);
        gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);
        gtk_widget_show(vbox);

        scrolled_win = gtk_scrolled_window_new (NULL, NULL);
        gtk_box_pack_start(GTK_BOX(vbox),scrolled_win,TRUE,TRUE,0);
        gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
                GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
        gtk_widget_show(scrolled_win);
        
        titles[0] = g_strdup("");
        titles[1] = text(102);
        img_list2 = gtk_clist_new_with_titles(2,titles);
        gtk_container_add (GTK_CONTAINER (scrolled_win), img_list2);
        imglist2 = GTK_CLIST(img_list2);
        gtk_signal_connect(GTK_OBJECT(imglist2), "select_row",
                GTK_SIGNAL_FUNC(undo_selections),NULL);
        gtk_clist_set_column_width(imglist2, 0, 16);
        gtk_clist_set_column_auto_resize(imglist2, 1, TRUE);
        gtk_widget_show(img_list2);
        gtk_widget_realize(img_list2);

        tbl = gtk_table_new(2,8,TRUE);
        gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
        gtk_table_set_row_spacings(GTK_TABLE(tbl),5);
        gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,5);
        gtk_widget_show(tbl);
        
        l1 = rightjust_gtk_label_new(text(105));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,0,1);
        gtk_widget_show(l1);

        e1 = gtk_entry_new();
        imglist_l2 = e1;
        gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
        gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,8,0,1);
        gtk_widget_show(e1);

        check = gtk_check_button_new_with_label(text(311));
        gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(writeoptions_selected),GINT_TO_POINTER(5));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,2,8,1,2);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                curset.multisession);
        gtk_widget_show(check);
        define_tooltip(check,help(92));

        /* right info frame */
        /* write-parameters */
        vbox = gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(f2),vbox);
        gtk_container_set_border_width (GTK_CONTAINER (vbox), 7);
        gtk_widget_show(vbox);

        tbl = gtk_table_new(11,16,FALSE);
        gtk_table_set_row_spacing(GTK_TABLE(tbl),0,2);
        gtk_table_set_row_spacing(GTK_TABLE(tbl),1,5);
        gtk_table_set_row_spacing(GTK_TABLE(tbl),2,5);
        gtk_table_set_col_spacings(GTK_TABLE(tbl),5);
        gtk_table_set_col_spacing(GTK_TABLE(tbl),14,0);
        gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,0);
        gtk_widget_show(tbl);
        
        l1 = rightjust_gtk_label_new(text(173));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,6,0,1);
        gtk_widget_show(l1);

        omenu = gtk_option_menu_new();
        menu = gtk_menu_new();
        menuidx = 0; menuhistory = 0;

        i = 0;
        tmpval = curset.cdrtype;
        while (cdrtypes[i] != 0) {
                /* contruct minute-list */
                g_snprintf(tmp,MAXLINE,"%d min",abs(cdrtypes[i]));

                menu_item = gtk_menu_item_new_with_label(tmp);
                gtk_signal_connect(GTK_OBJECT(menu_item),
                        "activate", GTK_SIGNAL_FUNC(cdrtype_selected),
                        GINT_TO_POINTER(abs(cdrtypes[i])));
                gtk_menu_append (GTK_MENU (menu), menu_item);
                if (tmpval == abs(cdrtypes[i])) { 
                        menuhistory = menuidx;
                }
                /* default set defined by negativ value */
                if (tmpval == 0 && cdrtypes[i] < 0) {
                        menuhistory = menuidx;
                        curset.cdrtype = abs(cdrtypes[i]);
                }
                menuidx++;
                gtk_widget_show (menu_item);
                i++;
        }
        if (curset.isProDVD) {
                i = 0;
                tmpval = curset.cdrtype;
                while (dvdtypes[i] != 0) {
                        /* contruct GB-list */
                        g_snprintf(tmp2,MAXLINE,"%.2f", (gfloat)dvdtypes[i]/1000);
                        /* strip last 0 */
                        if (tmp2[strlen(tmp2)-1] == '0') {
                                tmp2[strlen(tmp2)-1] = '\0';
                        }
                        g_snprintf(tmp,MAXLINE,"%s GB",tmp2);

                        menu_item = gtk_menu_item_new_with_label(tmp);
                        gtk_signal_connect(GTK_OBJECT(menu_item),
                        "activate", GTK_SIGNAL_FUNC(cdrtype_selected),
                        GINT_TO_POINTER(dvdtypes[i]));
                        gtk_menu_append (GTK_MENU (menu), menu_item);
                        if (tmpval == abs(dvdtypes[i])) {
                                menuhistory = menuidx;
                        }
                        menuidx++;
                        gtk_widget_show (menu_item);
                        i++;
                }
        }

        gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
        gtk_option_menu_set_history(GTK_OPTION_MENU (omenu),menuhistory);
        gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,6,11,0,1);
        gtk_widget_show(omenu);
        define_tooltip(omenu,help(66));

        b1 = gtk_button_new_with_label(text(175));
        gtk_signal_connect (GTK_OBJECT (b1), "clicked",
                GTK_SIGNAL_FUNC(show_atip_info),NULL);
        gtk_table_attach_defaults(GTK_TABLE(tbl),b1,11,16,0,1);
        gtk_widget_show(b1);
        define_tooltip(b1,help(67));


        /* write-mode */
        l1 = rightjust_gtk_label_new(text(174));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,6,1,2);
        gtk_widget_show(l1);

	omenu = gtk_option_menu_new ();
	menu = gtk_menu_new();

	i = 0;
	while (writemodes[i]) {
		menu_item = gtk_menu_item_new_with_label(text(writemodes[i]));
		gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(writemode_selected),
			GINT_TO_POINTER(i));
		gtk_menu_append (GTK_MENU (menu), menu_item);
		gtk_widget_show (menu_item);
		if (helpwritemodes[i]) 
        		define_tooltip(menu_item,help(helpwritemodes[i]));
		i++;
	}

/*

        btn = gtk_radio_button_new_with_label(NULL,text(178));
        gtk_signal_connect(GTK_OBJECT(btn),"clicked",
                GTK_SIGNAL_FUNC(writemode_selected),GINT_TO_POINTER(0));
        gtk_table_attach_defaults(GTK_TABLE(tbl),btn,6,16,1,2);
        gtk_widget_show(btn);
        if (curset.writemode == 0) 
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn), 1);
        define_tooltip(btn,help(68));

        if (!isroot() && !setupdata.root_option_change_writeparam) {
                gtk_widget_set_sensitive(btn,FALSE);
        }


        group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));
        btn = gtk_radio_button_new_with_label(group,text(179));
        gtk_signal_connect(GTK_OBJECT(btn),"clicked",
                GTK_SIGNAL_FUNC(writemode_selected),GINT_TO_POINTER(1));
        gtk_table_attach_defaults(GTK_TABLE(tbl),btn,6,16,2,3);
        gtk_widget_show(btn);
        if (curset.writemode == 1) 
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn), 1);
        define_tooltip(btn,help(69));

        if (!isroot() && !setupdata.root_option_change_writeparam) {
                gtk_widget_set_sensitive(btn,FALSE);
        }

        group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));
        btn = gtk_radio_button_new_with_label(group,text(276));
        gtk_signal_connect(GTK_OBJECT(btn),"clicked",
                GTK_SIGNAL_FUNC(writemode_selected),GINT_TO_POINTER(2));
        gtk_table_attach_defaults(GTK_TABLE(tbl),btn,6,16,3,4);
        gtk_widget_show(btn);
        if (curset.writemode == 2) 
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn), 1);
        define_tooltip(btn,help(70));
*/
	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	gtk_option_menu_set_history(GTK_OPTION_MENU (omenu), 
		curset.writemode);
        gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,6,16,1,2);
	gtk_widget_show(omenu);
	/* concat 2 help strings */
        g_snprintf(tmp,MAXLINE,"%s %s",help(180), help(182));
        define_tooltip(omenu,tmp);

        if (!isroot() && !setupdata.root_option_change_writeparam) {
                gtk_widget_set_sensitive(omenu,FALSE);
        }

        sep = gtk_hseparator_new();
        gtk_table_attach_defaults(GTK_TABLE(tbl),sep,0,16,2,3);
        gtk_widget_show(sep);

        check = gtk_check_button_new_with_label(text(180));
        gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(writeoptions_selected),GINT_TO_POINTER(0));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,2,16,3,4);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                curset.writesimul);
        gtk_widget_show(check);
        define_tooltip(check,help(71));

        check = gtk_check_button_new_with_label(text(181));
        gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(writeoptions_selected),GINT_TO_POINTER(1));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,2,16,4,5);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                curset.writeeject);
        gtk_widget_show(check);
        define_tooltip(check,help(72));
        
        check = gtk_check_button_new_with_label(text(182));
        gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(writeoptions_selected),GINT_TO_POINTER(2));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,2,16,5,6);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                curset.writepad);
        gtk_widget_show(check);
        define_tooltip(check,help(152));
        
        check = gtk_check_button_new_with_label(text(183));
        gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(writeoptions_selected),GINT_TO_POINTER(3));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,2,16,6,7);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                curset.writeswap);
        gtk_widget_show(check);
        define_tooltip(check,help(74));

        check = gtk_check_button_new_with_label(text(310));
        gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(writeoptions_selected),GINT_TO_POINTER(4));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,2,16,7,8);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                curset.nofixate);
        gtk_widget_show(check);
        define_tooltip(check,help(153));
       
        check = gtk_check_button_new_with_label(text(470));
        gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(writeoptions_selected),GINT_TO_POINTER(7));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,2,16,8,9);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                curset.writeoverburn);
        gtk_widget_show(check);
        define_tooltip(check,help(184));

        check = gtk_check_button_new_with_label(text(471));
        gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(writeoptions_selected),GINT_TO_POINTER(8));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,2,16,9,10);
        if (does_support_burnproof()) {
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                        curset.writeburnfree);
        }
        gtk_widget_show(check);
        define_tooltip(check,help(185));

        if (!does_support_burnproof())
                gtk_widget_set_sensitive(check,FALSE);
 
        check = gtk_check_button_new_with_label(text(469));
        gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(writeoptions_selected),GINT_TO_POINTER(6));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,2,9,10,11);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                curset.writecdtext);
        gtk_widget_show(check);
        define_tooltip(check,help(183));

        b1 = gtk_button_new_with_label(text(473));
        gtk_signal_connect (GTK_OBJECT (b1), "clicked",
                GTK_SIGNAL_FUNC(edit_cdtext_clicked), GINT_TO_POINTER(2));
        gtk_table_attach_defaults(GTK_TABLE(tbl),b1,9,16,10,11);
        gtk_widget_show(b1);
        define_tooltip(b1,help(187));

	/* second notebook tab */

	vbox = gtk_vbox_new(FALSE,0);
	l1 = gtk_label_new(text(309));
	gtk_notebook_append_page(GTK_NOTEBOOK (notebook),vbox,l1);
	gtk_widget_show(vbox);

        /* left and right info-frames */
        tbl = gtk_table_new(1,2,TRUE);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
        gtk_table_set_col_spacings(GTK_TABLE(tbl),5);
        gtk_box_pack_start(GTK_BOX(vbox),tbl,TRUE,TRUE,0);
        gtk_widget_show(tbl);
        f1 = gtk_frame_new(text(306));
        set_font_and_color(f1,BOLDFONT,NULL);
        gtk_table_attach_defaults(GTK_TABLE(tbl),f1,0,1,0,1);
        gtk_widget_show(f1);
        f2 = gtk_frame_new(text(97));
        set_font_and_color(f2,BOLDFONT,NULL);
        gtk_table_attach_defaults(GTK_TABLE(tbl),f2,1,2,0,1);
        gtk_widget_show(f2);

        /* button bar at the bottom */
        hbox = gtk_hbox_new(TRUE,10);
        gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,TRUE,5);
        gtk_widget_show(hbox);
	halign = gtk_alignment_new(0.5, 0.5, 0.5, 0);
        gtk_box_pack_start(GTK_BOX(hbox),halign,TRUE,TRUE,10);
	gtk_widget_show(halign);

        b1 = gtk_button_new_with_label(text(312));
	gtk_container_add(GTK_CONTAINER(halign),b1);
        gtk_widget_show(b1);
        gtk_signal_connect(GTK_OBJECT(b1), "clicked",
                GTK_SIGNAL_FUNC(accept_layout_clicked), notebook);
/*
	this crashed the eazel-gtk-engine

	GTK_WIDGET_SET_FLAGS (b1, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (b1);
*/
        define_tooltip(b1,help(96));

        /* left info frame */
        vbox = gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(f1),vbox);
        gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);
        gtk_widget_show(vbox);

        scrolled_win = gtk_scrolled_window_new (NULL, NULL);
        gtk_box_pack_start(GTK_BOX(vbox),scrolled_win,TRUE,TRUE,0);
        gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
                GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
        gtk_widget_show(scrolled_win);
        
        titles[0] = g_strdup("");
        titles[1] = text(102);
        cd_list = gtk_clist_new_with_titles(2,titles);
        gtk_container_add (GTK_CONTAINER (scrolled_win), cd_list);
        cdlist = GTK_CLIST(cd_list);
        gtk_signal_connect(GTK_OBJECT(cdlist), "row_move",
                GTK_SIGNAL_FUNC(write_move_row),NULL);
        gtk_clist_set_column_width(cdlist, 0, 16);
        gtk_clist_set_column_auto_resize(cdlist, 1, TRUE);
	if (setupdata.option_selectionmode == 0) {
		gtk_clist_set_selection_mode (cdlist, GTK_SELECTION_MULTIPLE);
	} else {
		gtk_clist_set_selection_mode (cdlist, GTK_SELECTION_EXTENDED);
	}
	gtk_clist_set_reorderable(cdlist, TRUE);
	gtk_clist_set_use_drag_icons(cdlist, TRUE);
        gtk_widget_show(cd_list);
	gtk_widget_realize(cd_list);

        tbl = gtk_table_new(1,8,TRUE);
        gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
        gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,5);
        gtk_widget_show(tbl);
        
        l1 = rightjust_gtk_label_new(text(105));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,0,1);
        gtk_widget_show(l1);

        e1 = gtk_entry_new();
        cdlist_l1 = e1;
        gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
        gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,8,0,1);
        gtk_widget_show(e1);

        hbox = gtk_hbox_new(TRUE,10);
        gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,TRUE,5);
        gtk_widget_show(hbox);
        b1 = gtk_button_new_with_label(text(313));
        gtk_signal_connect(GTK_OBJECT(b1),"clicked",
                GTK_SIGNAL_FUNC(read_select_all), NULL);
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,3);
        gtk_widget_show(b1);
        define_tooltip(b1,help(97));
        b1 = gtk_button_new_with_label(text(314));
        gtk_signal_connect(GTK_OBJECT(b1),"clicked",
                GTK_SIGNAL_FUNC(read_select_none), NULL);
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,3);
        gtk_widget_show(b1);
        define_tooltip(b1,help(98));
        b1 = gtk_button_new_with_label(text(48));
        gtk_signal_connect(GTK_OBJECT(b1),"clicked",
                GTK_SIGNAL_FUNC(write_delete_tracks), NULL);
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,3);
        gtk_widget_show(b1);
        define_tooltip(b1,help(99));

        /* right info frame */
        vbox = gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(f2),vbox);
        gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);
        gtk_widget_show(vbox);

        scrolled_win = gtk_scrolled_window_new (NULL, NULL);
        gtk_box_pack_start(GTK_BOX(vbox),scrolled_win,TRUE,TRUE,0);
        gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
                GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
        gtk_widget_show(scrolled_win);
        
        titles[0] = g_strdup("");
        titles[1] = text(102);
        img_list = gtk_clist_new_with_titles(2,titles);
        gtk_signal_connect(GTK_OBJECT(img_list), "select_row",
                GTK_SIGNAL_FUNC(verify_select_row),NULL);
        gtk_signal_connect(GTK_OBJECT(img_list), "unselect_row",
                GTK_SIGNAL_FUNC(verify_select_row),NULL);
        gtk_container_add (GTK_CONTAINER (scrolled_win), img_list);
        imglist = GTK_CLIST(img_list);
        gtk_clist_set_column_width(imglist, 0, 16);
        gtk_clist_set_column_auto_resize(imglist, 1, TRUE);
	if (setupdata.option_selectionmode == 0) {
		gtk_clist_set_selection_mode (imglist, GTK_SELECTION_MULTIPLE);
	} else {
		gtk_clist_set_selection_mode (imglist, GTK_SELECTION_EXTENDED);
	}
        gtk_widget_show(img_list);
	gtk_widget_realize(img_list);

        tbl = gtk_table_new(1,8,TRUE);
        gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
        gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,5);
        gtk_widget_show(tbl);
        
        l1 = rightjust_gtk_label_new(text(300));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,0,1);
        gtk_widget_show(l1);

        e1 = gtk_entry_new();
        imglist_l1 = e1;
        gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
        gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,8,0,1);
        gtk_widget_show(e1);

        hbox = gtk_hbox_new(TRUE,10);
        gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,TRUE,5);
        gtk_widget_show(hbox);
        b1 = gtk_button_new_with_label(text(313));
        gtk_signal_connect(GTK_OBJECT(b1),"clicked",
                GTK_SIGNAL_FUNC(verify_select_all), NULL);
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,3);
        gtk_widget_show(b1);
        define_tooltip(b1,help(100));
        b1 = gtk_button_new_with_label(text(314));
        gtk_signal_connect(GTK_OBJECT(b1),"clicked",
                GTK_SIGNAL_FUNC(verify_select_none), NULL);
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,3);
        gtk_widget_show(b1);
        define_tooltip(b1,help(101));
        b1 = gtk_button_new_with_label(text(47));
        gtk_signal_connect(GTK_OBJECT(b1),"clicked",
                GTK_SIGNAL_FUNC(write_add_tracks), NULL);
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,3);
        gtk_widget_show(b1);
        define_tooltip(b1,help(102));

	/* init write-list again - so each time we enter this menu
	   we start with an empty set */
	free_glist(&writelist);
	clear_trackreadset();

	/* write fresh tmp tocfile */
	generate_tmp_tocfile_name(tmptoc);
	create_tmp_writetracks_tocfile(tmptoc);

        /* fill entries */
	fill_write_tracks();
	redraw_writelist(cdlist,cdlist_l1);
	fill_writelist2(imglist2,imglist_l2);
}


void dirview_selected(GtkWidget *item, GtkWidget *entry) {
gint sel;

        sel = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item));
	masterparam.show_only_dirs = sel;	

	/* redraw the tree to the current setting */
	ctree_change_viewmode(!sel);

	/* now expand back to the level we described in the entry-field */
	ctree_expand_manualpath(entry);
}

void entry_masterdir_callback(GtkWidget *widget, gpointer data) {
gchar dir[MAXLINE];

	/* expand tilde */
        strcpy(dir,gtk_entry_get_text(GTK_ENTRY(widget)));
        check_tilde(dir);
        gtk_entry_set_text(GTK_ENTRY(widget), dir);

	ctree_expand_manualpath(widget);
}


/* calculate redir path for a master path and add it */
 
gint add_mult_mstr_file(gchar *path, gint stat, gchar *redir, gchar *common) {
mstr_redirect_t *mstr;
gchar redir2[MAXLINE];
gchar redir3[MAXLINE];

	/* path already added? ignore */
	if (check_in_mstr_glist(&masterparam.mstr_redir, path) != 0) {
		return 0;
	}

	/* get base path of our given directory */
	strncpy(redir2, path, MAXLINE);
	get_basedir(redir2);
	if (redir2 == NULL) { strcpy(redir2,"/"); }
	/* add a slash now, too */
        if (strlen(redir2) > 0) {
        	if (redir2[strlen(redir2)-1] != '/') {
                	strcat(redir2,"/");
                }       
	}

	/* allocate new entry */
	mstr = g_new0(mstr_redirect_t,1);
	mstr->mstr_path = g_strdup(path);
	masterparam.mstr_redir = g_list_append(masterparam.mstr_redir, mstr);

	/* add with full path */
	if (stat == 0) {
		if (strlen(redir2) > 0) {
			add_redir_mstr_glist( &masterparam.mstr_redir,
					path, redir2);
		}
		return 1;
	} 
	/* add with common part removed */
	if (stat == 1) {
		strncpy(redir3,redir2+strlen(common), MAXLINE);
		if (strlen(redir3) > 0) {
			add_redir_mstr_glist( &masterparam.mstr_redir,
					path, redir3);
		}
		return 1;
	}
	/* add with common part replaced */
	if (stat == 2) {
		strncpy(redir3,redir2+strlen(common), MAXLINE);
		strncpy(redir2,redir, MAXLINE);
		strcat(redir2, redir3);
		if (strlen(redir2) > 1) {
			if (redir2[0] == '/' && redir2[1] == '/') {
				/* on slash to much - remove it */
				strncpy(redir3, redir2+1, MAXLINE);
				strncpy(redir2, redir3, MAXLINE);
			}
		}
		if (strlen(redir2) > 0) {
			add_redir_mstr_glist( &masterparam.mstr_redir,
					path, redir2);
		}
		return 1;
	}

	return 0;
}


/* callback for add-button in master-source */

void add_master_dir(GtkWidget *widget, GtkWidget *entry) {
gchar dir[MAXLINE], redir[MAXLINE];
mstr_redirect_t *mstr;
gint stat, added;
GList *sel_dirs, *loop;
gchar commonstr[MAXLINE];

	sel_dirs = NULL;
	added = 0;

        strcpy(dir,gtk_entry_get_text(GTK_ENTRY(entry)));
	strip_string(dir);

	/* empty string? abort */
	if (!*dir) return;

	/* expand tilde */
        check_tilde(dir);
        gtk_entry_set_text(GTK_ENTRY(entry), dir);

	if (dir[0] == '(') {
		/* multiple selected? get from ctree */
		ctree_get_selected(&sel_dirs);
	} else {
		sel_dirs=g_list_append(sel_dirs, g_strdup(dir));
	}

	/* handling for single selected files */
	if (g_list_length(sel_dirs) == 1) {
        	/* valid file? */
        	if (is_file(dir) == 0) {
                	show_dialog(ICO_INFO,text(78),T_OK,NULL,NULL,0);        
                	return;
        	}
	
		/* add to glist */
		if (check_in_mstr_glist(&masterparam.mstr_redir, dir) == 0) {

			/* show menu selecting where to add the file */
			stat = show_mstr_redir(dir, redir);
			if (stat == 0) {
				mstr = g_new0(mstr_redirect_t,1);
				mstr->mstr_path = g_strdup(dir);
				masterparam.mstr_redir = g_list_append(masterparam.mstr_redir, mstr);
				if (strlen(redir) > 0) {
					add_redir_mstr_glist(
						&masterparam.mstr_redir,
						dir, redir);
				}
				added = 1;
			}

		} else {
			/* path already added */
       	         	show_dialog(ICO_WARN,text(380),T_OK,NULL,NULL,0); 
			return;
		}
	} else {
		/* multiple files selected */

		/* get common path component */
		get_common_path_component(sel_dirs, commonstr);

		stat = show_mstr_redir_multi(commonstr, 
				g_list_length(sel_dirs), redir);
		if (stat >= 0) {
			loop = g_list_first(sel_dirs);
			while (loop) {
				added += add_mult_mstr_file(
					(gchar *) loop->data,
					stat, redir, commonstr);

				loop = loop->next;
			}
		}
	}

	free_glist(&sel_dirs);
	if (added) {
		ctree_unselect_all();
	}

	fill_session_view(0);
}


/* callback for exclude-button in master-source */

void exclude_master_dir(GtkWidget *widget, GtkWidget *entry) {
gchar dir[MAXLINE];
GList *sel_dirs, *loop;
gint added;

	sel_dirs = NULL;
	added = 0;

	/* multiple dirs selected? */
        strcpy(dir,gtk_entry_get_text(GTK_ENTRY(entry)));
	strip_string(dir);

	/* empty string? abort */
	if (!*dir) return;

	if (dir[0] == '(') {
		/* multiple selected? get from ctree */
		ctree_get_selected(&sel_dirs);
	} else {
		sel_dirs=g_list_append(sel_dirs, g_strdup(dir));
	}

        /* valid file? */
	/* disabled..allow all here now */
/*
        if (is_file(dir) == 0) {
                show_dialog(ICO_INFO,text(78),T_OK,NULL,NULL,0);        
                return;
        }
*/
	loop = g_list_first(sel_dirs);
	while (loop) {
		/* add to glist */
		if (check_in_glist(&masterparam.exclude_paths, loop->data ) == 0) {
			masterparam.exclude_paths = g_list_append(
				masterparam.exclude_paths, g_strdup(loop->data));
			added = 1;
		} else {
			/* path already added */
			if (g_list_length(sel_dirs) == 1) 
				show_dialog(ICO_WARN,text(380),T_OK,NULL,NULL,0);
		}
		loop = loop->next;
	}

	free_glist(&sel_dirs);
	if (added) {
		ctree_unselect_all();
	}

	fill_session_view(0);
}


/* callback for remove-button in master-source */

void remove_master_dir(GtkWidget *widget, gpointer data) {
GList *sel;
gint row, type;
gchar *rowdata;
gchar tmp2[MAXLINE];

	sel = cdlist->selection;
	if (sel != NULL) {
		row = GPOINTER_TO_INT(sel->data);
		type = GPOINTER_TO_INT(gtk_clist_get_row_data(cdlist,row));
		if (type == 0) {
			/* invalid row */
			show_dialog(ICO_WARN,text(78),T_OK,NULL,NULL,0); 
		} else {
			gtk_clist_get_text(cdlist,row,1,&rowdata);
			extract_mstr_path_from_clist(rowdata, tmp2);
			if (type == 1) {
				del_mstr_glist_link(&masterparam.mstr_redir,
					tmp2, 1);
			} else {
				del_glist_link(&masterparam.exclude_paths,
					tmp2);
			}	
			fill_session_view(0);
		}
	} else {
		show_dialog(ICO_INFO,text(77),T_OK,NULL,NULL,0); 
	}
}


/* callback for redirect path */

void redirect_master_dir(GtkWidget *widget, gpointer data) {
GList *sel;
gint row, type;
gchar *rowdata;
gchar tmp[MAXLINE];
gchar tmp2[MAXLINE];

	sel = cdlist->selection;
	if (sel != NULL) {
		row = GPOINTER_TO_INT(sel->data);
		type = GPOINTER_TO_INT(gtk_clist_get_row_data(cdlist,row));
		if (type == 0) {
			/* invalid row */
			show_dialog(ICO_WARN,text(78),T_OK,NULL,NULL,0); 
		} else 
		if (type == 2) {
			/* excluded row */
			show_dialog(ICO_WARN,text(381),T_OK,NULL,NULL,0); 
		} else {
			gtk_clist_get_text(cdlist,row,1,&rowdata);
			extract_mstr_path_from_clist(rowdata, tmp2);
			get_redir_path_from_mstr_glist(&masterparam.mstr_redir,
				tmp2, tmp);
			if (show_request_redirect_path(tmp2, tmp) == 0) {
				if (strlen(tmp) > 0) {
					add_redir_mstr_glist(
						&masterparam.mstr_redir,
						tmp2, tmp);
				} else {
					/* remove redirection */
					del_mstr_glist_link(
						&masterparam.mstr_redir,
						tmp2, -1);
				}
			}

			fill_session_view(0);
		}
	} else {
		show_dialog(ICO_INFO,text(410),T_OK,NULL,NULL,0); 
	}
}


/* fill the session-view clist */
/* if checkmedia = -1, then dont check, but show info about update button */

void fill_session_view(gint checkmedia) {
GtkStyle *style;
gchar *data[2];
GdkPixmap *pixmap1, *pixmap2, *pixmap3, *pixmap4;
GdkBitmap *mask1, *mask2, *mask3, *mask4;
gint i, lcount, orglcount;
gchar tmp[MAXLINE];
gchar tmp2[MAXLINE];
GList *loop;
mstr_redirect_t *mstr;
gint msinfo1, msinfo2;


        /* clean up first */
        gtk_clist_clear(cdlist);

        style = gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(cdlist)));
        pixmap1 = gdk_pixmap_create_from_xpm_d(cdlist->clist_window,
                &mask1, &style->bg[GTK_STATE_NORMAL],(gchar **)minidata_xpm);
        pixmap2 = gdk_pixmap_create_from_xpm_d(cdlist->clist_window,
                &mask2, &style->bg[GTK_STATE_NORMAL],(gchar **)miniaudio_xpm);
        pixmap3 = gdk_pixmap_create_from_xpm_d(cdlist->clist_window,
                &mask3, &style->bg[GTK_STATE_NORMAL],(gchar **)masteradd_xpm);
        pixmap4 = gdk_pixmap_create_from_xpm_d(cdlist->clist_window,
                &mask4, &style->bg[GTK_STATE_NORMAL],(gchar **)masterdel_xpm);

        lcount = 0;
	msinfo1 = -1;
	msinfo2 = -1;
        data[0] = NULL;

        /* no cd loaded? */
        if (cdinfo.nr_tracks == -1) {
		data[1] = text(156);
                gtk_clist_append(cdlist,data);
		gtk_clist_set_row_data(cdlist,lcount,GINT_TO_POINTER(0));
		lcount++;
        } else {
		/* at least something in drive? try to get msinfo */
        	if (curset.writer_devnr != -1 && checkmedia == 1) {
			get_msinfo_info(curset.writer_devnr, &msinfo1, 
				&msinfo2);
		}
	}

	if (checkmedia == 1) {
		/* save session info */
		masterparam.last_session_start = msinfo1;
		masterparam.next_session_start = msinfo2;

		/* remember we requested the session info */
		session_current_state = 1;
	}

	if (checkmedia == -1) {
		/* just entered menu anew? */
		/* set state to "we dont know session info yet" */
		session_current_state = 0;
	}

	/* empty cd loaded */
        if (cdinfo.nr_tracks == -2) {
		data[1] = text(196);
                gtk_clist_append(cdlist,data);
		gtk_clist_set_row_data(cdlist,lcount,GINT_TO_POINTER(0));
		lcount++;
	}

	if (session_current_state == 0 && cdinfo.nr_tracks > 0) {
		/* CD inserted, but we havnt checked for msinfo? */
		/* tell the user to click 'update' to see more */
		data[1] = text(535);
                gtk_clist_append(cdlist,data);
		gtk_clist_set_row_data(cdlist,lcount,GINT_TO_POINTER(0));
		lcount++;
		data[1] = text(536);
                gtk_clist_append(cdlist,data);
		gtk_clist_set_row_data(cdlist,lcount,GINT_TO_POINTER(0));
		lcount++;
	
		/* invalidate session info */
		masterparam.last_session_start = -1;
		masterparam.next_session_start = -1;

	} else {
		/* display track listing */
	       	 for (i = 0; i < cdinfo.nr_tracks; i++) {
	                if (trackinfo[i]->type == 0) {
 	                       convert_frames2mbstring(trackinfo[i]->size,tmp2);
	                        g_snprintf(tmp,MAXLINE,"%2d. %s [%s]",
  	                              trackinfo[i]->track_nr,
       		                         text(109), tmp2);
	                        data[1] = tmp;
	                        gtk_clist_append(cdlist,data);
        	                gtk_clist_set_pixmap(cdlist,lcount,0,pixmap1,mask1);
				gtk_clist_set_row_data(cdlist,lcount,GINT_TO_POINTER(0));
              	          lcount++;
	                } else {
	                        convert_frames2minstring(trackinfo[i]->size,tmp2);
	                        g_snprintf(tmp,MAXLINE,"%2d. %s [%s]",
        	                        trackinfo[i]->track_nr,
                	                text(110), tmp2);
 	                       data[1] = tmp;
        	                gtk_clist_append(cdlist,data);
    	                    gtk_clist_set_pixmap(cdlist,lcount,0,pixmap2,mask2);
				gtk_clist_set_row_data(cdlist,lcount,GINT_TO_POINTER(0));
        	                lcount++;
           	     }
		}
	}

	/* draw seperator */
	strcpy(tmp,"_________________");
	data[1] = tmp;
        gtk_clist_append(cdlist,data);
	gtk_clist_set_row_data(cdlist,lcount,GINT_TO_POINTER(0));
	lcount++;
	strcpy(tmp,"");
	data[1] = tmp;
        gtk_clist_append(cdlist,data);
	gtk_clist_set_row_data(cdlist,lcount,GINT_TO_POINTER(0));
	lcount++;

	orglcount = lcount;

	/* draw master-dirs */
	loop = g_list_first(masterparam.mstr_redir);
	while (loop) {
		mstr = (mstr_redirect_t *) loop->data;
		if (mstr) {
			if (mstr->mstr_path && !mstr->redir_path) {
				/* no redir available */
				data[1] = mstr->mstr_path;
			} else 
			if (mstr->mstr_path && mstr->redir_path) {
				g_snprintf(tmp,MAXLINE,"%s => %s", 
					mstr->mstr_path, mstr->redir_path);	
				data[1] = tmp;
			} else {
				data[1] = "";
			}
		} else {
			data[1] = "";
		}
		
                gtk_clist_append(cdlist,data);
                gtk_clist_set_pixmap(cdlist,lcount,0,pixmap3,mask3);
		gtk_clist_set_row_data(cdlist,lcount,GINT_TO_POINTER(1));
                lcount++;

		loop = loop->next;
	}

	/* draw exclude-dirs */
	loop = g_list_first(masterparam.exclude_paths);
	while (loop) {
		data[1] = (gchar *)loop->data;

                gtk_clist_append(cdlist,data);
                gtk_clist_set_pixmap(cdlist,lcount,0,pixmap4,mask4);
		gtk_clist_set_row_data(cdlist,lcount,GINT_TO_POINTER(2));
                lcount++;

		loop = loop->next;
	}

	/* make session-size invalid, because we changed the paths */
	set_sessionsize_unknown();

	/* have we added any paths? No? Show help about right click */
	if (orglcount == lcount) {
		data[1] = text(484);
        	gtk_clist_append(cdlist,data);
		gtk_clist_set_row_data(cdlist,lcount,GINT_TO_POINTER(0));
		lcount++;
	}

}


/* calculate free and used space and display */

static void fill_session_available() {
gchar tmp[MAXLINE];
gint cdsize, used, avail;

	/* current available size according to media-selector */
	/* in sectors */
	if (curset.cdrtype < 1000) {
		cdsize = curset.cdrtype*60*75;
	} else {
		cdsize = curset.cdrtype*512;
	}
	used = 0;
	avail = cdsize;

	/* we want to write multisession? consider session overhead */
	if (curset.multisession == 1) {
		if (cdinfo.nr_tracks > 0) {
			/* additional sessions */
			avail -= 6900;   /* about 13 MB */
		} else {
			/* first session */
			avail -= 11400;   /* about 22 MB */
		}
	}

	/* multisession CD with some sessions? */
	if (masterparam.next_session_start > 0) {
		used += masterparam.next_session_start;
		avail -= masterparam.next_session_start;
	}
	/* transform sectors into MB */
	used = used * (DATASECTORSIZE/1024)/1024;
	avail = avail * (DATASECTORSIZE/1024)/1024;

	/* tracks, but not yet checked for msinfo? */
	if (cdinfo.nr_tracks > 0 && session_current_state == 0) {
		strncpy(tmp,text(127), MAXLINE);
	} else 
	/* tracks, but no multisession? */
	if (cdinfo.nr_tracks > 0 && masterparam.next_session_start == -1) {
		strncpy(tmp,text(493), MAXLINE);
	} else {
		/* empty/no CD or multisession CD */
		g_snprintf(tmp,MAXLINE,"%dMB / %dMB", used, avail);
	}
	gtk_entry_set_text(GTK_ENTRY(master_avail_entry), tmp);

	/* tracks, but not yet checked for msinfo? */
	if (cdinfo.nr_tracks > 0 && session_current_state == 0) {
		g_snprintf(tmp,MAXLINE," - / %dMB", avail);
	} else 
	/* tracks, but no multisession? (display in menu5) */
	if (cdinfo.nr_tracks > 0 && masterparam.next_session_start == -1) {
		g_snprintf(tmp,MAXLINE," - / %dMB", avail);
	} else {
		/* empty/no CD or multisession CD */
		g_snprintf(tmp,MAXLINE,"%dMB / %dMB", used, avail);
	}
	if (cdlist_l1) {
		gtk_entry_set_text(GTK_ENTRY(cdlist_l1), tmp);
	}
}


/* check cd in writer-dev and redraw */

void session_view_update(GtkWidget *widget, gpointer data) {
GdkWindowAttr *win_attr;
GdkCursor *cursor,*normal_cursor;

        do_lock(1);
        /* change cursor to watch */
        gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
                (gpointer) &win_attr);
        normal_cursor = win_attr->cursor;
        cursor = gdk_cursor_new(GDK_WATCH);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);
        while (gtk_events_pending())
                gtk_main_iteration();

        if (curset.writer_devnr != -1) {
                get_cd_toc_and_volid(curset.writer_devnr);
        }
	/* called from button */
	if (widget) {
		fill_session_view(1);
	} else {
		/* called from startup */
		fill_session_view(-1);
	}

	fill_session_available();

        /* reset cursor */
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);

        do_unlock(1);
}


/* called when a context menu entry is selected */

static void context_response(gint nr) {
gchar tmp[MAXLINE];
gchar tmp2[MAXLINE];
gint stat;
	
	/* load list selected? */
	if (nr == 0) {
		/* show fileselector */
		show_file_selector(text(486), SAVEMASTERLIST,tmp);

		if (strcmp(tmp,"") != 0) {
			stat = load_master_list(tmp);
			if (stat == 1) {
				/* load failed */
				g_snprintf(tmp2,MAXLINE,text(492),tmp);
				show_dialog(ICO_ERROR,tmp2, T_OK, NULL, NULL, 0);
			}
			fill_session_view(0);
		}
	}

	/* save list selected? */
	if (nr == 1) {
		/* show fileselector */
		show_file_selector(text(487), SAVEMASTERLIST,tmp);

		if (strcmp(tmp,"") != 0) {
			stat = save_master_list(tmp);
			if (stat == 1) {
				/* save failed */
				g_snprintf(tmp2,MAXLINE,text(490),tmp);
				show_dialog(ICO_ERROR,tmp2, T_OK, NULL, NULL, 0);
			}
			if (stat == 0) {
				/* save ok */
				show_dialog(ICO_INFO,text(491), T_OK, NULL, NULL, 0);
			}
		}
	}

	/* delete list selected ? */
	if (nr == 2) {
		stat = show_dialog(ICO_WARN,text(485),T_YES,T_NO,NULL,0);
		if (stat == 1) return;

		/* user is sure, so clear list */
		clear_mstr_glist(&masterparam.mstr_redir);
		free_glist(&masterparam.exclude_paths);

		fill_session_view(0);
	}
}


/* called when a context menu entry is selected in the directory view */

static void context_response2(gint nr) {
	
	/* unselect all selected? */
	if (nr == 0) {
		ctree_unselect_all();
	}
}


/* called by a click on the session-view or directory-view */

static gint activate_context(GtkWidget *widget, GdkEvent *event) {

	if (event->button.button == 3) {
		/* show context menu */
		gtk_menu_popup(GTK_MENU(widget), NULL, NULL, 
			NULL, NULL, event->button.button, event->button.time);
		return TRUE;
	}
	return FALSE;
}


/* first submenu of master menu */

void draw_master_menu1(GtkWidget *box) {
GtkWidget *vbox, *hbox;
GtkWidget *f1,*f2;
GtkWidget *e1, *l1, *entry1;
GtkWidget *tbl, *b1;
GtkWidget *scrolled_win, *cd_list;
GtkWidget *check;
GtkCTree *ctree;
GtkWidget *context_menu, *context_items, *context_menu2;
gint context_text[] = { 481, 482, 483, 0 };
gint i;
gchar tmp[MAXLINE];

	cdlist_l1 = NULL;

        /* left and right info-frames */
        tbl = gtk_table_new(1,2,TRUE);
        gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
        gtk_table_set_col_spacings(GTK_TABLE(tbl),5);
        gtk_box_pack_start(GTK_BOX(box),tbl,TRUE,TRUE,0);
        gtk_widget_show(tbl);
        f1 = gtk_frame_new(text(325));
        set_font_and_color(f1,BOLDFONT,NULL);
        gtk_table_attach_defaults(GTK_TABLE(tbl),f1,0,1,0,1);
        gtk_widget_show(f1);
        f2 = gtk_frame_new(text(326));
        set_font_and_color(f2,BOLDFONT,NULL);
        gtk_table_attach_defaults(GTK_TABLE(tbl),f2,1,2,0,1);
        gtk_widget_show(f2);

        /* left info frame */
        vbox = gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(f1),vbox);
        gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);
        gtk_widget_show(vbox);

        scrolled_win = gtk_scrolled_window_new (NULL, NULL);
        gtk_box_pack_start(GTK_BOX(vbox),scrolled_win,TRUE,TRUE,0);
        gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
                GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
        gtk_widget_show(scrolled_win);

	cd_list = gtk_clist_new(2);
	gtk_container_add (GTK_CONTAINER (scrolled_win), cd_list);
	cdlist = GTK_CLIST(cd_list);
        gtk_clist_set_column_width(cdlist, 0, 16);
        gtk_clist_set_column_auto_resize(cdlist, 1, TRUE);
	gtk_widget_show(cd_list);

	/* init context menu */
	context_menu = gtk_menu_new();
	i = 0;
	while(context_text[i]) {
		context_items = gtk_menu_item_new_with_label(
					text(context_text[i]));
		gtk_menu_append(GTK_MENU(context_menu), context_items);
		gtk_signal_connect_object (GTK_OBJECT (context_items), 
			"activate", GTK_SIGNAL_FUNC(context_response),
			GINT_TO_POINTER(i));
		gtk_widget_show(context_items);
		i++;
	}

	gtk_signal_connect_object(GTK_OBJECT(cdlist), "button_press_event",
		GTK_SIGNAL_FUNC(activate_context), GTK_OBJECT(context_menu));

        tbl = gtk_table_new(1,8,TRUE);
        gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
        gtk_table_set_row_spacings(GTK_TABLE(tbl),3);
        gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,5);
        gtk_widget_show(tbl);

        l1 = rightjust_gtk_label_new(text(327));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,4,0,1);
        gtk_widget_show(l1);

        e1 = gtk_entry_new();
        master_avail_entry = e1;
        gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
        gtk_table_attach_defaults(GTK_TABLE(tbl),e1,4,8,0,1);
        gtk_widget_show(e1);
	define_tooltip(e1, help(191));

	/* buttons at bottom */
        hbox = gtk_hbox_new(TRUE,10);
        gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,TRUE,5);
        gtk_widget_show(hbox);
        b1 = gtk_button_new_with_label(text(48));
        gtk_signal_connect(GTK_OBJECT(b1), "clicked",
                GTK_SIGNAL_FUNC(remove_master_dir), NULL);
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,3);
        gtk_widget_show(b1);
	define_tooltip(b1, help(103));

        b1 = gtk_button_new_with_label(text(329));
        gtk_signal_connect(GTK_OBJECT(b1), "clicked",
                GTK_SIGNAL_FUNC(redirect_master_dir), NULL);
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,3);
        gtk_widget_show(b1);
	define_tooltip(b1, help(104));

        hbox = gtk_hbox_new(TRUE,0);
        gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,TRUE,0);
        gtk_widget_show(hbox);
        b1 = gtk_button_new_with_label(text(328));
        gtk_signal_connect(GTK_OBJECT(b1), "clicked",
                GTK_SIGNAL_FUNC(session_view_update), NULL);
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,3);
        gtk_widget_show(b1);
	define_tooltip(b1, help(105));

        /* right info frame */
        vbox = gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(f2),vbox);
        gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);
        gtk_widget_show(vbox);

        scrolled_win = gtk_scrolled_window_new (NULL, NULL);
        gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
                GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
        gtk_box_pack_start(GTK_BOX(vbox),scrolled_win,TRUE,TRUE,0);
	gtk_widget_realize(scrolled_win);
        gtk_widget_show(scrolled_win);

        entry1 = gtk_entry_new();
        gtk_signal_connect(GTK_OBJECT(entry1), "activate",
                GTK_SIGNAL_FUNC(entry_masterdir_callback),NULL);
        gtk_box_pack_start(GTK_BOX(vbox),entry1,FALSE,FALSE,3);
        gtk_widget_show(entry1);

	ctree_okbutton = NULL;
        ctree = create_directory_ctree("/",NULL,toplevel,entry1, 
			!masterparam.show_only_dirs);
 	gtk_clist_set_column_auto_resize(GTK_CLIST(ctree),0,TRUE); 
	if (setupdata.option_selectionmode == 0) {
		gtk_clist_set_selection_mode (GTK_CLIST(ctree), GTK_SELECTION_MULTIPLE);
	} else {
		gtk_clist_set_selection_mode (GTK_CLIST(ctree), GTK_SELECTION_EXTENDED);
	}
 
        gtk_container_add (GTK_CONTAINER (scrolled_win), GTK_WIDGET (ctree));
        gtk_widget_show( GTK_WIDGET (ctree));

	/* init context menu */
	context_menu2 = gtk_menu_new();
	context_items = gtk_menu_item_new_with_label(
					text(524));
	gtk_menu_append(GTK_MENU(context_menu2), context_items);
	gtk_signal_connect_object (GTK_OBJECT (context_items), 
		"activate", GTK_SIGNAL_FUNC(context_response2),
		GINT_TO_POINTER(0));
	gtk_widget_show(context_items);

	gtk_signal_connect_object(GTK_OBJECT(ctree), "button_press_event",
		GTK_SIGNAL_FUNC(activate_context), GTK_OBJECT(context_menu2));

        tbl = gtk_table_new(1,8,TRUE);
        gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
        gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,0);
        gtk_widget_show(tbl);

        check = gtk_check_button_new_with_label(text(330));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(dirview_selected), entry1);
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,8,0,1);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                masterparam.show_only_dirs);
        gtk_widget_show(check);
	define_tooltip(check, help(106));

	/* buttons at bottom */
        hbox = gtk_hbox_new(TRUE,10);
        gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,TRUE,5);
        gtk_widget_show(hbox);
        b1 = gtk_button_new_with_label(text(47));
	gtk_signal_connect(GTK_OBJECT(b1),"clicked",
                GTK_SIGNAL_FUNC(add_master_dir), entry1);
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,3);
        gtk_widget_show(b1);
	define_tooltip(b1, help(107));

        b1 = gtk_button_new_with_label(text(331));
	gtk_signal_connect(GTK_OBJECT(b1),"clicked",
                GTK_SIGNAL_FUNC(exclude_master_dir), entry1);
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,3);
        gtk_widget_show(b1);

	/* concat 2 help strings */
	g_snprintf(tmp,MAXLINE,"%s %s",help(108), help(193));
	define_tooltip(b1, tmp);

	/* by default go to home dir of user in dir browser */
	if (g_get_home_dir()) {
		gtk_entry_set_text(GTK_ENTRY(entry1), g_get_home_dir());
		ctree_expand_manualpath(entry1);
		ctree_unselect_all();
	}

	/* update session-view */
	session_view_update(NULL,NULL);
}


/* redraw the option-grid */

void draw_option_grid(gint val) {
gint i;
gint types[][16] = MASTER_TYPES;

	if (val == -1) {
		/* custom setting? */
		return;
	}

	for(i = 0; i < 16; i++) {
        	gtk_toggle_button_set_active(
			GTK_TOGGLE_BUTTON(isoopts[i]), types[val][i]);
	}			

	/* set joilet charset */
	gtk_option_menu_set_history(GTK_OPTION_MENU(isoopt_cmenu), 
		masterparam.charset);

	/* jcharset is meaningful only if Joliet extensions are active */
	if (masterparam.opt[1])	gtk_widget_set_sensitive(isoopt_cmenu,TRUE);
	else			gtk_widget_set_sensitive(isoopt_cmenu,FALSE);
}


/* read the current option-grid and determine the fitting preset mode */

void read_option_grid() {
gint master_texts[] = MASTER_TEXTS;
gint types[][16] = MASTER_TYPES;
gint i,j, nomatch;
gint preset;

	/* custom setting is default */
	preset = -1;
	i = 0;
	while (master_texts[i] != 0) {
		nomatch = 0;
		for (j=0; j<16; j++) {
			if (types[i][j] != masterparam.opt[j]) {
				nomatch = 1;
			}	
		}
		/* all settings identical? */
		if (nomatch == 0) {
			preset = i;
			break;
		}
		i++;
	}

	if (preset == -1) {
		/* custom is last value in menu */
		preset = i;
	}	

	/* now we found the setting fitting for our option-grid */
	/* set the option menu to this value */

	/* block callback for option menu to avoid loop */
	gtk_option_menu_set_history(GTK_OPTION_MENU(isoopt_omenu), preset);
	masterparam.image_type = preset;

	/* set joilet charset */
	gtk_option_menu_set_history(GTK_OPTION_MENU(isoopt_cmenu), 
		masterparam.charset);

	/* jcharset is meaningful only if Joliet extensions are active */
	if (masterparam.opt[1])	gtk_widget_set_sensitive(isoopt_cmenu,TRUE);
	else			gtk_widget_set_sensitive(isoopt_cmenu,FALSE);
}


/* called when you click on the check-buttons */

void isooptions_selected(GtkWidget *item, gpointer nr) {
gboolean sel;

        sel = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item));

	masterparam.opt[GPOINTER_TO_INT(nr)] = sel;

	/* see if new setting match predefined type */
	read_option_grid();

	set_sessionsize_unknown();
}


/* called by the optionmenu */

void isoopts_selected(GtkWidget *item, gpointer nr) {

	draw_option_grid(GPOINTER_TO_INT(nr));
}

void csetopts_selected(GtkWidget *item, gpointer nr) {

	masterparam.charset = GPOINTER_TO_INT(nr);
}


/* called by save button */

void save_isooptions(GtkWidget *widget, gpointer data) {
gchar tmp2[MAXLINE];

	dolog(2, "Save iso-options as default\n");

	/* write file */
	if (save_isooptions_file(configdir, ISOOPTFILE) == 1) {
		/* save failed */
                g_snprintf(tmp2,MAXLINE,text(388), ISOOPTFILE);
                show_dialog(ICO_WARN, tmp2, T_OK, NULL, NULL, 0);
	} else {
		/* save ok */
                show_dialog(ICO_INFO,text(389), T_OK, NULL, NULL, 0);
	}
}


/* second submenu of master menu (iso-options) */

void draw_master_menu2(GtkWidget *box) {
GtkWidget *vbox, *hbox;
GtkWidget *f1,*b1;
GtkWidget *l1,*l2,*tbl;
GtkWidget *omenu, *cmenu, *check;
GtkWidget *menu, *menu_item;
gint master_texts[] = MASTER_TEXTS;
gint i;

	f1 = gtk_frame_new(text(332));
	set_font_and_color(f1,BOLDFONT,NULL);
        gtk_container_set_border_width(GTK_CONTAINER (f1),5);
	gtk_box_pack_start(GTK_BOX(box),f1,TRUE,TRUE,0);
	gtk_widget_show(f1);

        vbox = gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(f1),vbox);
        gtk_container_set_border_width (GTK_CONTAINER (vbox), 10); 
        gtk_widget_show(vbox);

	tbl = gtk_table_new(1,16,TRUE);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),5,10);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),12,10);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,0);
	gtk_widget_show(tbl);

        l1 = rightjust_gtk_label_new(text(333));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,6,0,1);
        gtk_widget_show(l1);

        omenu = gtk_option_menu_new ();
	isoopt_omenu = omenu;
	menu = gtk_menu_new();
	i = 0;
	while (master_texts[i] != 0) {
		menu_item = gtk_menu_item_new_with_label(text(master_texts[i]));
		gtk_signal_connect(GTK_OBJECT(menu_item),
			"activate", GTK_SIGNAL_FUNC(isoopts_selected),
			GINT_TO_POINTER(i));
		gtk_menu_append(GTK_MENU (menu), menu_item);
		gtk_widget_show(menu_item);
		i++;
	}
	/* now add the custom value */
	menu_item = gtk_menu_item_new_with_label(text(387));
	gtk_signal_connect(GTK_OBJECT(menu_item),
		"activate", GTK_SIGNAL_FUNC(isoopts_selected),
		GINT_TO_POINTER(-1));
	gtk_menu_append(GTK_MENU (menu), menu_item);
	gtk_widget_show(menu_item);
	define_tooltip(omenu, help(109));

	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
        gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,6,11,0,1);
        gtk_widget_show(omenu);

	/* -jcharset CHARSET */
        l2 = rightjust_gtk_label_new(text(439));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l2,11,13,0,1);
        gtk_widget_show(l2);

        cmenu = gtk_option_menu_new ();
	isoopt_cmenu = cmenu;
	menu = gtk_menu_new();
	i = 0;
	while (charset_types[i] != NULL) {
		menu_item = gtk_menu_item_new_with_label(charset_types[i]);
		gtk_signal_connect(GTK_OBJECT(menu_item),
			"activate", GTK_SIGNAL_FUNC(csetopts_selected),
			GINT_TO_POINTER(i));
		gtk_menu_append(GTK_MENU (menu), menu_item);
		gtk_widget_show(menu_item);
		i++;
	}
	define_tooltip(cmenu, help(175));

	gtk_option_menu_set_menu (GTK_OPTION_MENU (cmenu), menu);
        gtk_table_attach_defaults(GTK_TABLE(tbl),cmenu,13,16,0,1);
        gtk_widget_show(cmenu);

	f1 = gtk_frame_new(NULL);
        gtk_container_set_border_width(GTK_CONTAINER (f1),5);
	gtk_box_pack_start(GTK_BOX(vbox),f1,TRUE,TRUE,0);
	gtk_widget_show(f1);

	tbl = gtk_table_new(8,8,TRUE);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
        gtk_container_add(GTK_CONTAINER(f1),tbl);
	gtk_widget_show(tbl);

	/* mkisofs options */

	/* -r anon rockridge */
        check = gtk_check_button_new_with_label(text(334));
	isoopts[0] = check;
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(isooptions_selected),GINT_TO_POINTER(0));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,0,4,0,1);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                masterparam.opt[0]);
	gtk_widget_show(check);
	define_tooltip(check, help(110));

	/* -J add joliet */
        check = gtk_check_button_new_with_label(text(335));
	isoopts[1] = check;
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(isooptions_selected),GINT_TO_POINTER(1));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,4,8,0,1);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                masterparam.opt[1]);
	gtk_widget_show(check);
	define_tooltip(check, help(111));

	/* -R rockridge */
        check = gtk_check_button_new_with_label(text(336));
	isoopts[2] = check;
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(isooptions_selected),GINT_TO_POINTER(2));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,0,4,1,2);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                masterparam.opt[2]);
	gtk_widget_show(check);
	define_tooltip(check, help(112));

	/* -f follow symb links */
        check = gtk_check_button_new_with_label(text(337));
	isoopts[3] = check;
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(isooptions_selected),GINT_TO_POINTER(3));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,4,8,1,2);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                masterparam.opt[3]);
	gtk_widget_show(check);
	define_tooltip(check, help(113));

	/* -l allow 30 chars filenames */
        check = gtk_check_button_new_with_label(text(338));
	isoopts[4] = check;
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(isooptions_selected),GINT_TO_POINTER(4));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,0,4,2,3);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                masterparam.opt[4]);
	gtk_widget_show(check);
	define_tooltip(check, help(114));

	/* -T transtable */
        check = gtk_check_button_new_with_label(text(339));
	isoopts[5] = check;
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(isooptions_selected),GINT_TO_POINTER(5));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,4,8,2,3);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                masterparam.opt[5]);
	gtk_widget_show(check);
	define_tooltip(check, help(115));

	/* -D do not use deep directory relocation */
        check = gtk_check_button_new_with_label(text(340));
	isoopts[6] = check;
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(isooptions_selected),GINT_TO_POINTER(6));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,0,4,3,4);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                masterparam.opt[6]);
	gtk_widget_show(check);
	define_tooltip(check, help(116));

	/* -L allow isonames with starting period */
        check = gtk_check_button_new_with_label(text(341));
	isoopts[7] = check;
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(isooptions_selected),GINT_TO_POINTER(7));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,4,8,3,4);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                masterparam.opt[7]);
	gtk_widget_show(check);
	define_tooltip(check, help(117));

	/* -d omit trailing period */
        check = gtk_check_button_new_with_label(text(342));
	isoopts[8] = check;
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(isooptions_selected),GINT_TO_POINTER(8));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,0,4,4,5);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                masterparam.opt[8]);
	gtk_widget_show(check);
	define_tooltip(check, help(118));

	/* -N omit version numbers */
        check = gtk_check_button_new_with_label(text(343));
	isoopts[9] = check;
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(isooptions_selected),GINT_TO_POINTER(9));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,4,8,4,5);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                masterparam.opt[9]);
	gtk_widget_show(check);
	define_tooltip(check, help(119));

	/* -U untranslated files */
        check = gtk_check_button_new_with_label(text(344));
	isoopts[10] = check;
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(isooptions_selected),GINT_TO_POINTER(10));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,0,4,5,6);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                masterparam.opt[10]);
	gtk_widget_show(check);
	define_tooltip(check, help(120));

	/* -no-bak  */
        check = gtk_check_button_new_with_label(text(345));
	isoopts[11] = check;
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(isooptions_selected),GINT_TO_POINTER(11));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,4,8,5,6);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                masterparam.opt[11]);
	gtk_widget_show(check);
	define_tooltip(check, help(121));

	/* -hide-rr-moved */
        check = gtk_check_button_new_with_label(text(346));
	isoopts[12] = check;
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(isooptions_selected),GINT_TO_POINTER(12));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,0,4,6,7);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                masterparam.opt[12]);
	gtk_widget_show(check);
	define_tooltip(check, help(122));

	/* -hide-joliet-trans-tbl */
        check = gtk_check_button_new_with_label(text(347));
	isoopts[13] = check;
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(isooptions_selected),GINT_TO_POINTER(13));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,4,8,6,7);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                masterparam.opt[13]);
	gtk_widget_show(check);
	define_tooltip(check, help(123));

	/* -no-rr */
        check = gtk_check_button_new_with_label(text(348));
	isoopts[14] = check;
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(isooptions_selected),GINT_TO_POINTER(14));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,0,4,7,8);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                masterparam.opt[14]);
	gtk_widget_show(check);
	define_tooltip(check, help(124));

	/* -no-iso-translate */
        check = gtk_check_button_new_with_label(text(440));
	isoopts[15] = check;
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(isooptions_selected),GINT_TO_POINTER(15));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,4,8,7,8);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                masterparam.opt[15]);
	gtk_widget_show(check);
	define_tooltip(check, help(176));

	/* unsupported options for now */
	/* -no-split-symlink-fields */
	/* -no-split-symlink-components */



	/* button bar at bottom */
        hbox = gtk_hbox_new(TRUE,10);
        gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,TRUE,10);
        gtk_widget_show(hbox);

	b1 = gtk_button_new_with_label(text(349));
        gtk_signal_connect (GTK_OBJECT (b1), "clicked",
                GTK_SIGNAL_FUNC(save_isooptions),NULL);
	gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,10);
	gtk_widget_show(b1);
	define_tooltip(b1, help(125));

	/* first call to that menu? */
	if (masterparam.image_type == -1) {
		/* set first as default setting */
		draw_option_grid(0);
		masterparam.image_type = 0;
	}
}


/* make sure a text-field does not contain more chars than 128 */

void isoheader_text_callback(GtkWidget *widget, gpointer data) {
int max, cur;
gchar **p;
gchar *buf;

	/* get pointer to char variable, so that we can update it directly */
	p = (gchar **) data;

	max = 128; 
	cur = gtk_text_get_length(GTK_TEXT(widget));

	/* to much chars? */
	if (cur > max) {
		gtk_text_backward_delete(GTK_TEXT(widget), cur-max);
		cur = gtk_text_get_length(GTK_TEXT(widget));
	}

	/* now update given variable */
	g_free(*p);
	buf = gtk_editable_get_chars(GTK_EDITABLE(widget),0,cur);
	*p = g_strdup(buf);
}


/* set the text of a text-widget */

void boottext_set_text(GtkWidget *widget, gchar *txt) {

	/* delete old contents */
	gtk_text_backward_delete(GTK_TEXT(widget),
		gtk_text_get_length(GTK_TEXT(widget)));
	gtk_text_insert(GTK_TEXT(widget),
		NULL,NULL,NULL, txt, strlen(txt));

}

void isoheader_entry_callback(GtkWidget *widget, gpointer data) {
gchar **p;

	/* get pointer to char variable, so that we can update it directly */
	p = (gchar **) data;

	g_free(*p);
	*p = g_strdup(gtk_entry_get_text(GTK_ENTRY(widget)));
}


/* clear isoheaders */

void isoheader_clear(GtkWidget *widget, gpointer data) {

	gtk_entry_set_text(GTK_ENTRY(isoheader[0]),g_strdup(""));
	g_free(masterparam.volid);
	masterparam.volid = g_strdup("");

	gtk_text_set_point(GTK_TEXT(isoheader[1]),
		gtk_text_get_length(GTK_TEXT(isoheader[1])));
	gtk_text_backward_delete(GTK_TEXT(isoheader[1]),
		gtk_text_get_length(GTK_TEXT(isoheader[1])));
	g_free(masterparam.publisher);
	masterparam.publisher = g_strdup("");

	gtk_text_set_point(GTK_TEXT(isoheader[2]),
		gtk_text_get_length(GTK_TEXT(isoheader[2])));
	gtk_text_backward_delete(GTK_TEXT(isoheader[2]),
		gtk_text_get_length(GTK_TEXT(isoheader[2])));
	g_free(masterparam.preparer);
	masterparam.preparer = g_strdup("");

	/*
	gtk_text_set_point(GTK_TEXT(isoheader[3]),
		gtk_text_get_length(GTK_TEXT(isoheader[3])));
	gtk_text_backward_delete(GTK_TEXT(isoheader[3]),
		gtk_text_get_length(GTK_TEXT(isoheader[3])));
	g_free(masterparam.application);
	masterparam.application = g_strdup("");
	*/

	gtk_entry_set_text(GTK_ENTRY(isoheader[4]),"");
	g_free(masterparam.abstract);
	masterparam.abstract = g_strdup("");

	gtk_entry_set_text(GTK_ENTRY(isoheader[5]),"");
	g_free(masterparam.biblio);
	masterparam.biblio = g_strdup("");

	gtk_entry_set_text(GTK_ENTRY(isoheader[6]),"");
	g_free(masterparam.copyright);
	masterparam.copyright = g_strdup("");
}


void isoheader_save(GtkWidget *widget, gpointer data) {
gchar tmp2[MAXLINE];

        dolog(2, "Save iso-headers as default\n");

        /* write file */
        if (save_isoheaders_file(configdir, ISOHEADERFILE) == 1) {
                /* save failed */
                g_snprintf(tmp2,MAXLINE,text(392), ISOHEADERFILE);
                show_dialog(ICO_WARN, tmp2, T_OK, NULL, NULL, 0);
        } else {
                /* save ok */
                show_dialog(ICO_INFO,text(393), T_OK, NULL, NULL, 0);
        }

}

void isoheader_readfromcd(GtkWidget *widget, gpointer data) {

	/* not implemented yet */
	show_dialog(ICO_INFO,text(394), T_OK, NULL, NULL, 0);
}


/* third submenu of master menu (iso-header) */

void draw_master_menu3(GtkWidget *box) {
GtkWidget *vbox, *hbox;
GtkWidget *f1,*b1;
GtkWidget *l1,*tbl;
GtkWidget *e1;
GtkWidget *scrolled_win;

	f1 = gtk_frame_new(text(350));
	set_font_and_color(f1,BOLDFONT,NULL);
        gtk_container_set_border_width(GTK_CONTAINER (f1),5);
	gtk_box_pack_start(GTK_BOX(box),f1,TRUE,TRUE,0);
	gtk_widget_show(f1);

        vbox = gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(f1),vbox);
        gtk_container_set_border_width (GTK_CONTAINER (vbox), 10); 
        gtk_widget_show(vbox);

        tbl = gtk_table_new(6,16,FALSE);
        gtk_table_set_col_spacing(GTK_TABLE(tbl),3,10);
        gtk_table_set_row_spacings(GTK_TABLE(tbl),10);
        gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
        gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,0);
        gtk_widget_show(tbl);

	/* -V volid 32 chars */
	l1 = rightjust_gtk_label_new(text(351));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,4,0,1);
	gtk_widget_show(l1);

	e1 = gtk_entry_new_with_max_length(32);
	isoheader[0] = e1;
        gtk_signal_connect(GTK_OBJECT(e1), "changed",
                GTK_SIGNAL_FUNC(isoheader_entry_callback), &masterparam.volid);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,4,16,0,1);
        if (masterparam.volid != NULL) {
                gtk_entry_set_text(GTK_ENTRY(e1), masterparam.volid);
	}
	gtk_widget_show(e1);
	define_tooltip(e1, help(126));

	/* -P publisher_id 128 chars */
	l1 = rightjust_gtk_label_new(text(352));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,4,1,2);
	gtk_widget_show(l1);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
                GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	gtk_widget_set_usize(scrolled_win,0,tbf(36));
	gtk_table_attach_defaults(GTK_TABLE(tbl),scrolled_win,4,16,1,2);
	gtk_widget_show(scrolled_win);

	e1 = gtk_text_new(NULL,NULL);
	isoheader[1] = e1;
	gtk_text_set_editable(GTK_TEXT(e1),TRUE);
	gtk_text_set_word_wrap(GTK_TEXT(e1),TRUE);
	gtk_signal_connect(GTK_OBJECT(e1),"changed",
		GTK_SIGNAL_FUNC(isoheader_text_callback), 
		&masterparam.publisher);
	gtk_container_add (GTK_CONTAINER (scrolled_win), e1);
        if (masterparam.publisher != NULL) {
                boottext_set_text(e1, masterparam.publisher);
	}
	gtk_widget_show(e1);
	define_tooltip(e1, help(127));

	/* -p preparer_id 128 chars */
	l1 = rightjust_gtk_label_new(text(353));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,4,2,3);
	gtk_widget_show(l1);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
                GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	gtk_widget_set_usize(scrolled_win,0,tbf(36));
	gtk_table_attach_defaults(GTK_TABLE(tbl),scrolled_win,4,16,2,3);
	gtk_widget_show(scrolled_win);

	e1 = gtk_text_new(NULL,NULL);
	isoheader[2] = e1;
	gtk_text_set_editable(GTK_TEXT(e1),TRUE);
	gtk_text_set_word_wrap(GTK_TEXT(e1),TRUE);
	gtk_signal_connect(GTK_OBJECT(e1),"changed",
		GTK_SIGNAL_FUNC(isoheader_text_callback), 
		&masterparam.preparer);
	gtk_container_add (GTK_CONTAINER (scrolled_win), e1);
        if (masterparam.preparer != NULL) {
                boottext_set_text(e1, masterparam.preparer);
	}
	gtk_widget_show(e1);
	define_tooltip(e1, help(128));

	/* -A application_id 128 chars */
	/*
	l1 = rightjust_gtk_label_new(text(354));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,4,3,4);
	gtk_widget_show(l1);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
                GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	gtk_widget_set_usize(scrolled_win,0,tbf(36));
	gtk_table_attach_defaults(GTK_TABLE(tbl),scrolled_win,4,16,3,4);
	gtk_widget_show(scrolled_win);

	e1 = gtk_text_new(NULL,NULL);
	isoheader[3] = e1;
	gtk_text_set_editable(GTK_TEXT(e1),TRUE);
	gtk_text_set_word_wrap(GTK_TEXT(e1),TRUE);
	gtk_signal_connect(GTK_OBJECT(e1),"changed",
		GTK_SIGNAL_FUNC(isoheader_text_callback), 
		&masterparam.application);
	gtk_container_add (GTK_CONTAINER (scrolled_win), e1);
        if (masterparam.application != NULL) {
                boottext_set_text(e1, masterparam.application);
	}
	gtk_widget_show(e1);
	define_tooltip(e1, help(129));
	*/

	/* -abstract file 37 chars */
	l1 = rightjust_gtk_label_new(text(355));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,4,3,4);
	gtk_widget_show(l1);

	e1 = gtk_entry_new_with_max_length(37);
	isoheader[4] = e1;
        gtk_signal_connect(GTK_OBJECT(e1), "changed",
                GTK_SIGNAL_FUNC(isoheader_entry_callback), 
			&masterparam.abstract);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,4,16,3,4);
        if (masterparam.abstract != NULL) {
                gtk_entry_set_text(GTK_ENTRY(e1), masterparam.abstract);
	}
	gtk_widget_show(e1);
	define_tooltip(e1, help(130));

	/* -biblio file 37 chars */
	l1 = rightjust_gtk_label_new(text(356));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,4,4,5);
	gtk_widget_show(l1);

	e1 = gtk_entry_new_with_max_length(37);
	isoheader[5] = e1;
        gtk_signal_connect(GTK_OBJECT(e1), "changed",
                GTK_SIGNAL_FUNC(isoheader_entry_callback), 
			&masterparam.biblio);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,4,16,4,5);
        if (masterparam.biblio != NULL) {
                gtk_entry_set_text(GTK_ENTRY(e1), masterparam.biblio);
	}
	gtk_widget_show(e1);
	define_tooltip(e1, help(131));

	/* -copyright file 37 chars */
	l1 = rightjust_gtk_label_new(text(357));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,4,5,6);
	gtk_widget_show(l1);

	e1 = gtk_entry_new_with_max_length(37);
	isoheader[6] = e1;
        gtk_signal_connect(GTK_OBJECT(e1), "changed",
                GTK_SIGNAL_FUNC(isoheader_entry_callback), 
			&masterparam.copyright);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,4,16,5,6);
        if (masterparam.copyright != NULL) {
                gtk_entry_set_text(GTK_ENTRY(e1), masterparam.copyright);
	}
	gtk_widget_show(e1);
	define_tooltip(e1, help(132));

	/* not yet supported */
	/* -sysid 32 chars */
	/* -volset 128 chars */

	/* fill block */
	hbox = gtk_hbox_new(TRUE,0);
        gtk_box_pack_start(GTK_BOX(vbox),hbox,TRUE,TRUE,5);
        gtk_widget_show(hbox);

        /* button bar at bottom */
        hbox = gtk_hbox_new(TRUE,10);
        gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,TRUE,5);
        gtk_widget_show(hbox);

        b1 = gtk_button_new_with_label(text(358));
        gtk_signal_connect(GTK_OBJECT(b1),"clicked",
                GTK_SIGNAL_FUNC(isoheader_save), NULL);
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,5);
        gtk_widget_show(b1);
	define_tooltip(b1, help(133));

        b1 = gtk_button_new_with_label(text(359));
        gtk_signal_connect(GTK_OBJECT(b1),"clicked",
                GTK_SIGNAL_FUNC(isoheader_readfromcd), NULL);
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,5);
        gtk_widget_show(b1);
	define_tooltip(b1, help(134));

        b1 = gtk_button_new_with_label(text(360));
        gtk_signal_connect(GTK_OBJECT(b1),"clicked",
                GTK_SIGNAL_FUNC(isoheader_clear), NULL);
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,5);
        gtk_widget_show(b1);
	define_tooltip(b1, help(135));

}


/* enable/disable boot-platforms */

void set_boot_platform(gint val) {

	/* at startup these are not yet defined */
	if (!bootable_frame1 || !bootable_frame2) return;

	switch(val) {
		case 0:
			gtk_widget_set_sensitive(bootable_frame1,FALSE);
			gtk_widget_set_sensitive(bootable_frame2,FALSE);
			break;
		case 1:
			gtk_widget_set_sensitive(bootable_frame1,TRUE);
			gtk_widget_set_sensitive(bootable_frame2,FALSE);
			break;
		case 2:
			gtk_widget_set_sensitive(bootable_frame1,FALSE);
			gtk_widget_set_sensitive(bootable_frame2,TRUE);
			break;
	}
}


void bootmode_selected(GtkWidget *item, gpointer data) {
gint val;
	
	val = GPOINTER_TO_INT(data);
        masterparam.bootable = val;

	set_boot_platform(val);
	set_sessionsize_unknown();
}


void toritomode_selected(GtkWidget *item, gpointer data) {
gint val;
	
	val = GPOINTER_TO_INT(data);
        masterparam.boot_type = val;
	set_sessionsize_unknown();
}

void bootfile_browse_callback(GtkWidget *widget, GtkEntry *entry) {
char tmp[MAXLINE];

        show_file_selector(text(488), gtk_entry_get_text(entry),tmp);
        if (strcmp(tmp,"") != 0) {
                gtk_entry_set_text(entry,tmp);
                g_free(masterparam.boot_image);
                masterparam.boot_image = g_strdup(gtk_entry_get_text(entry));
		set_sessionsize_unknown();
        }
}

void bootopt_entry_callback(GtkWidget *widget, gpointer data) {
gchar **p;

        /* get pointer to char variable, so that we can update it directly */
        p = (gchar **) data;

        g_free(*p);
        *p = g_strdup(gtk_entry_get_text(GTK_ENTRY(widget)));

	set_sessionsize_unknown();
}


/* fourth submenu of master menu (boot options) */

void draw_master_menu4(GtkWidget *box) {
GtkWidget *vbox;
GtkWidget *f1,*b1;
GtkWidget *l1,*tbl;
GtkWidget *e1;
GSList *group;
GtkWidget *btn;

	/* mark as not defined yet */
	bootable_frame1 = NULL;
	bootable_frame2 = NULL;

	f1 = gtk_frame_new(text(362));
	set_font_and_color(f1,BOLDFONT,NULL);
        gtk_container_set_border_width(GTK_CONTAINER (f1),5);
	gtk_box_pack_start(GTK_BOX(box),f1,TRUE,TRUE,0);
	gtk_widget_show(f1);

        vbox = gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(f1),vbox);
        gtk_container_set_border_width (GTK_CONTAINER (vbox), 10); 
        gtk_widget_show(vbox);

        tbl = gtk_table_new(2,15,TRUE); 
	gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
	gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,0);
        gtk_widget_show(tbl);

        l1 = rightjust_gtk_label_new(text(390));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,5,0,1);
        gtk_widget_show(l1);

        btn = gtk_radio_button_new_with_label(NULL,text(391));
        gtk_signal_connect(GTK_OBJECT(btn),"clicked",
                GTK_SIGNAL_FUNC(bootmode_selected),GINT_TO_POINTER(0));
        gtk_table_attach_defaults(GTK_TABLE(tbl),btn,5,15,0,1);
        gtk_widget_show(btn);
	define_tooltip(btn, help(136));
	if (masterparam.bootable == 0) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn), 1);
        group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));

        btn = gtk_radio_button_new_with_label(group, text(363));
        gtk_signal_connect(GTK_OBJECT(btn),"clicked",
                GTK_SIGNAL_FUNC(bootmode_selected),GINT_TO_POINTER(1));
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,5,10,1,2);
        gtk_widget_show(btn);
	define_tooltip(btn, help(137));
	if (masterparam.bootable == 1) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn), 1);
        group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));

        btn = gtk_radio_button_new_with_label(group, text(370));
        gtk_signal_connect(GTK_OBJECT(btn),"clicked",
                GTK_SIGNAL_FUNC(bootmode_selected),GINT_TO_POINTER(2));
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,10,15,1,2);
        gtk_widget_show(btn);
	define_tooltip(btn, help(138));
	if (masterparam.bootable == 2) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn), 1);

	/* el torito */
	f1 = gtk_frame_new(text(363));
	bootable_frame1 = f1;
	set_font_and_color(f1,BOLDFONT,NULL);
        gtk_container_set_border_width(GTK_CONTAINER (f1),5);
	gtk_box_pack_start(GTK_BOX(vbox),f1,FALSE,FALSE,0);
	gtk_widget_show(f1);

        tbl = gtk_table_new(4,16,TRUE);
        gtk_table_set_col_spacing(GTK_TABLE(tbl),3,10);
        gtk_table_set_col_spacing(GTK_TABLE(tbl),12,10);
        gtk_table_set_row_spacing(GTK_TABLE(tbl),0,5);
        gtk_table_set_row_spacing(GTK_TABLE(tbl),1,5);
        gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
        gtk_container_add(GTK_CONTAINER(f1),tbl);
        gtk_widget_show(tbl);

	l1 = rightjust_gtk_label_new(text(364));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,4,0,1);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
        gtk_signal_connect(GTK_OBJECT(e1), "changed",
                GTK_SIGNAL_FUNC(bootopt_entry_callback), 
		&masterparam.boot_image);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,4,13,0,1);
	if (masterparam.boot_image != NULL) {
		gtk_entry_set_text(GTK_ENTRY(e1), masterparam.boot_image);
	}
	gtk_widget_show(e1);
	define_tooltip(e1, help(139));

        b1 = gtk_button_new_with_label(text(45));
        gtk_signal_connect (GTK_OBJECT (b1), "clicked",
                GTK_SIGNAL_FUNC(bootfile_browse_callback),GTK_ENTRY(e1));
        gtk_table_attach_defaults(GTK_TABLE(tbl),b1,13,16,0,1);
        gtk_widget_show(b1);

	l1 = rightjust_gtk_label_new(text(365));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,4,1,2);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
        gtk_signal_connect(GTK_OBJECT(e1), "changed",
                GTK_SIGNAL_FUNC(bootopt_entry_callback), 
		&masterparam.boot_catalog);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,4,13,1,2);
	if (masterparam.boot_catalog != NULL) {
		gtk_entry_set_text(GTK_ENTRY(e1), masterparam.boot_catalog);
	}
	gtk_widget_show(e1);
	define_tooltip(e1, help(140));

        btn = gtk_radio_button_new_with_label(NULL,text(366));
        gtk_signal_connect(GTK_OBJECT(btn),"clicked",
                GTK_SIGNAL_FUNC(toritomode_selected),GINT_TO_POINTER(0));
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,4,10,2,3);
        gtk_widget_show(btn);
	define_tooltip(btn, help(141));
        group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));
	if (masterparam.boot_type == 0) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn), 1);

        btn = gtk_radio_button_new_with_label(group, text(367));
        gtk_signal_connect(GTK_OBJECT(btn),"clicked",
                GTK_SIGNAL_FUNC(toritomode_selected),GINT_TO_POINTER(1));
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,10,16,2,3);
        gtk_widget_show(btn);
	define_tooltip(btn, help(142));
        group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));
	if (masterparam.boot_type == 1) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn), 1);

        btn = gtk_radio_button_new_with_label(group, text(368));
        gtk_signal_connect(GTK_OBJECT(btn),"clicked",
                GTK_SIGNAL_FUNC(toritomode_selected),GINT_TO_POINTER(2));
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,4,10,3,4);
        gtk_widget_show(btn);
	define_tooltip(btn, help(143));
        group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));
	if (masterparam.boot_type == 2) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn), 1);

        btn = gtk_radio_button_new_with_label(group, text(369));
        gtk_signal_connect(GTK_OBJECT(btn),"clicked",
                GTK_SIGNAL_FUNC(toritomode_selected),GINT_TO_POINTER(3));
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,10,16,3,4);
        gtk_widget_show(btn);
	define_tooltip(btn, help(144));
	if (masterparam.boot_type == 3) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn), 1);


	/* sparc */
	f1 = gtk_frame_new(text(370));
	bootable_frame2 = f1;
	set_font_and_color(f1,BOLDFONT,NULL);
        gtk_container_set_border_width(GTK_CONTAINER (f1),5);
	gtk_box_pack_start(GTK_BOX(vbox),f1,FALSE,FALSE,0);
	gtk_widget_show(f1);

        tbl = gtk_table_new(1,16,TRUE);
        gtk_table_set_col_spacing(GTK_TABLE(tbl),3,10);
        gtk_container_set_border_width(GTK_CONTAINER (tbl),10);
        gtk_container_add(GTK_CONTAINER(f1),tbl);
        gtk_widget_show(tbl);

	l1 = rightjust_gtk_label_new(text(371));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,4,0,1);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
        gtk_signal_connect(GTK_OBJECT(e1), "changed",
                GTK_SIGNAL_FUNC(bootopt_entry_callback), 
		&masterparam.sparc_boot);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,4,13,0,1);
	gtk_widget_show(e1);
	define_tooltip(e1, help(145));
	if (masterparam.sparc_boot != NULL) {
		gtk_entry_set_text(GTK_ENTRY(e1), masterparam.sparc_boot);
	}

	set_boot_platform(masterparam.bootable);
}


/* fill the entry for image-size */

void update_session_size_display() {
gint kb;
gchar tmp[MAXLINE];

	/* not yet activated */
	if (cdlist_l2 == NULL) return;

	if (masterparam.session_size > 0) {
		kb = masterparam.session_size * 2;
		convert_kbytes2mbcorrectminstring(kb,tmp);
		gtk_entry_set_text(GTK_ENTRY(cdlist_l2), tmp);
	} else {
		gtk_entry_set_text(GTK_ENTRY(cdlist_l2), text(397));
	}
}


/* mark our session-size as unknown and update entry */
/* this forces the user to recalculate the size */

void set_sessionsize_unknown() {

	masterparam.session_size = 0;
	update_session_size_display();	
}


/* called from "calculate size" button or from auto mode when entering
   the last page of the master menu */

void calc_size_callback(GtkWidget *widget, gpointer data) {
gint automode;
gint ret;

	/* called from automatic? */
	automode = GPOINTER_TO_INT(data);

	/* check if multisession on DVD? */
	if (curset.multisession == 1 && curset.cdrtype >= 1000) {
		ret = show_dialog(ICO_WARN,text(518), T_ANYWAY, T_CANCEL, NULL, 1);
		if (ret != 0) return;
	}

	/* check if we have already some directories added */
	if (masterparam.mstr_redir == NULL) {
		if (automode == 0) 
			show_dialog(ICO_WARN,text(407), T_OK, NULL, NULL, 0);
		return;
	}

	/* now check if we have specified a valid boot image */
	if (masterparam.bootable == 1) {
		/* el torito */
		if (strcmp(masterparam.boot_image,"") == 0 ||
		    strcmp(masterparam.boot_catalog,"") == 0) {

			if (automode == 0) 
				show_dialog(ICO_WARN,text(408), T_OK, NULL, NULL, 0);
			return;
		}
	}
	if (masterparam.bootable == 2) {
		/* sparc boot */
		if (strcmp(masterparam.sparc_boot,"") == 0) {
			if (automode == 0)
				show_dialog(ICO_WARN,text(409), T_OK, NULL, NULL, 0);
			return;
		}
	}
	

	show_mkisofs_check_output(automode);
	
	/* if session_size is now defined scanning was ok */
	update_session_size_display();
}


/* called when the create-image button is pressed */

void master_image_callback(GtkWidget *widget, gpointer data) {
gint stat, ret, session_nr;
gint overwritefree, overwritefreebiggest;

	/* first check if image-size has been calculated */
	if (masterparam.session_size <= 0) {
		show_dialog(ICO_WARN,text(398),T_OK,NULL,NULL,0);
		return;
	}

	session_nr = 1;

	/* now checks for multisession mode */
	if (curset.multisession == 1) {
		/* ask if we want do a first or additional session */
		ret = show_dialog(ICO_QUEST,text(501), text(502), text(503),
			T_CANCEL,2);
		if (ret == 0) {
			/* first session */
			masterparam.last_session_start = -1;
			masterparam.next_session_start = -1;
		}
		if (ret == 1) {
			/* additional session */

		        /* no cd-writer defined */
        		if (curset.writer_devnr == -1) {
                		show_dialog(ICO_ERROR,text(204), T_OK, NULL, NULL, 0);
                		return;
        		}

			/* check if CD is loaded? */
		        get_cd_toc_and_volid(curset.writer_devnr);
       			if (cdinfo.nr_tracks != -1) {
                		get_msinfo_info(curset.writer_devnr, 
                                 &masterparam.last_session_start, 
                                 &masterparam.next_session_start);
        		} else {
		                /* no cd loaded? abort */
               			show_dialog(ICO_WARN,text(496),T_CANCEL,NULL,NULL,0);
                        	return;
        		}

			/* got good session offsets? */
			if (masterparam.next_session_start == -1) {
				/* unappendable CD */
               			show_dialog(ICO_WARN,text(504),T_CANCEL,NULL,NULL,0);
				return;
			}

			/* use next session nr */
			session_nr = cdinfo.nr_tracks+1;
		} 
		if (ret == 2) {
			/* cancel */
			return;
		}

		/* check if rockridge is enabled */
                if ((masterparam.opt[0] + masterparam.opt[2]) == 0) {
                        show_dialog(ICO_WARN,text(500),T_OK,NULL, NULL, 0);
                        return; 
                }
	} else {
		/* no multisession */
		masterparam.last_session_start = -1;
		masterparam.next_session_start = -1;
	}

	/* lets check if the file-prefix-entry is up to date */
	set_image_prefix_callback(imglist_l1, NULL);

	/* allocate master-filename and path */
	stat = allocate_master_filename(masterparam.session_size * 2, 
		session_nr, &masterparam.image_filename, &overwritefree, 
		&overwritefreebiggest);

	/* enough free space? */
	if (stat == 1) {
		show_dialog(ICO_WARN,text(267), T_OK, NULL, NULL, 1);
		return;
	}

	/* no writeable directory? */
	if (stat == 2) {
		show_dialog(ICO_WARN,text(450), T_OK, NULL, NULL, 1);
		return;
	}

	/* start mastering */
	show_and_start_master();

	/* now write xinf file with track multisession infos */
	write_inf_file_for_master(masterparam.image_filename, session_nr);
}


/* called when the create-onthefly button is pressed */

void master_onthefly_callback(GtkWidget *widget, gpointer data) {
gint spaceneededoncd;
gint ret, avail, cdsize;

	/* first check if image-size has been calculated */
	if (masterparam.session_size <= 0) {
		show_dialog(ICO_WARN,text(398),T_OK,NULL,NULL,0);
		return;
	}

        /* no cd-writer defined */
        if (curset.writer_devnr == -1) {
                show_dialog(ICO_ERROR,text(204), T_OK, NULL, NULL, 0);
                return;
        }

	
	/* check if some CD is loaded? */
	get_cd_toc_and_volid(curset.writer_devnr);
	if (cdinfo.nr_tracks != -1) {
		get_msinfo_info(curset.writer_devnr, 
				&masterparam.last_session_start, 
                                &masterparam.next_session_start);
	} else {
		/* no cd loaded? abort */
        	ret = show_dialog(ICO_WARN,text(496),T_OK,T_ANYWAY,T_CANCEL,0);
		if (ret != 1) {
			return;
		}
	}
	
	/* multisession CD in drive, but no multisession choosen? */
	if (curset.multisession == 0 && 
		masterparam.next_session_start != -1) {

                ret = show_dialog(ICO_WARN,text(494),text(495),T_ANYWAY,T_CANCEL,0);
                if (ret == 0) {
			curset.multisession = 1;
        		gtk_toggle_button_set_active(
				GTK_TOGGLE_BUTTON(master_ms_button), 1);
		}
		if (ret == -1 || ret == 2) {
			/* cancel */
			return;
		}	
	}

	/* check if rockridge is enabled */
	if (curset.multisession == 1) {
		if ((masterparam.opt[0] + masterparam.opt[2]) == 0) {
                	show_dialog(ICO_WARN,text(500),T_OK,NULL, NULL, 0);
			return;	
		}
	}

	spaceneededoncd = masterparam.session_size;

        /* check if enough space on cd-r? */
        dodebug(2,"Sectors required: %d, Mediatype = %d, Next session start = %d\n", spaceneededoncd, curset.cdrtype, masterparam.next_session_start);
        if (curset.cdrtype < 1000) {
                cdsize = curset.cdrtype*60*75;
        } else {
                cdsize = curset.cdrtype*512;
        }
	avail = cdsize;

        /* we want to write multisession? consider session overhead */
        if (curset.multisession == 1) {
                if (cdinfo.nr_tracks > 0) {
                        /* additional sessions */
                        avail -= 6900;   /* about 13 MB */
                } else {
                        /* first session */
                        avail -= 11400;   /* about 22 MB */
                }
        }

	if (masterparam.next_session_start > 0) {
		avail -= masterparam.next_session_start;
	}
        if (spaceneededoncd > avail) {
                ret = show_dialog(ICO_WARN,text(278),T_ANYWAY,T_CANCEL,NULL,1);
                if (ret == 1) {
                        /* aborted */
                        return;
                }       
        }

        /* ok, now we are sure that all tracks are fine ...prompt for CD-R */
	if (curset.multisession == 0) {
        	ret = show_dialog(ICO_INFO,text(497),T_OK,T_CANCEL,NULL,0);
	} else {
		/* multisession */
		if (masterparam.next_session_start > 0) {
			/* add new session */
        		ret = show_dialog(ICO_INFO,text(499),T_OK,T_CANCEL,NULL,0);
		} else {
			/* write first session */
        		ret = show_dialog(ICO_INFO,text(498),T_OK,T_CANCEL,NULL,0);
		}
	}
	/* canceled? */
       	if (ret != 0) {
               	return;
       	}

	/* start mastering */
	show_and_do_write_tracks(curset.writer_devnr, -1, 3);
}


/* calculate the space that would be recycled on the harddrive
   when reading tracks and overwriting the ones with same names.
   This is used to show the user what space really is free 
   dependant of the name he chooses for his files */

gint get_free_space_by_overwriting_masterimage(gint *biggest) {
gint overwrite;
gint overwritebiggest;

	if (allocate_master_filename(masterparam.session_size * 2,1, 
		NULL, &overwrite, &overwritebiggest) == 0) {
		*biggest = overwritebiggest;
		return overwrite;
	} else {
		/* no space for image - so nothing to overwrite */
		*biggest = 0;
		return 0;
	}
}


/* fill the entries in the master-menu 5 */

void fill_master_write_menu() {
gchar tmp[MAXLINE];
gchar tmp2[MAXLINE];
gchar tmp3[MAXLINE];
gint overwritefree, normalfree, biggestfree, overwritefreebiggest;

        /* file prefix */
        if (strcmp(curset.file_prefix,"") == 0) {
                g_free(curset.file_prefix);
                curset.file_prefix = g_strdup(IMGFILEPREFIX);
        }
        gtk_entry_set_text(GTK_ENTRY(imglist_l1), curset.file_prefix);
        gtk_entry_select_region(GTK_ENTRY(imglist_l1), 0, 
                GTK_ENTRY(imglist_l1)->text_length);

        /* now check if the current filename has any influence on
           the available space */
        overwritefree = 
                get_free_space_by_overwriting_masterimage(&overwritefreebiggest);

        /* free size */
        normalfree = determine_free_space(&biggestfree);
        convert_kbytes2mbminstring(normalfree,tmp3);

        /* additional free space when overwriting files? */
        if (cdinfo.nr_tracks > 0 && overwritefree > 0) {
                convert_kbytes2mbstring(normalfree+overwritefree, tmp2);
                g_snprintf(tmp,MAXLINE,"%s (%s)", tmp3, tmp2);
        } else {
                strcpy(tmp,tmp3);
        }
        gtk_entry_set_text(GTK_ENTRY(imglist_l2), tmp);
	gtk_entry_set_position(GTK_ENTRY(imglist_l2), 0);

        /* biggest free block */
        convert_kbytes2mbminstring(biggestfree,tmp3);

        if (cdinfo.nr_tracks > 0 && overwritefreebiggest > 0) {
                convert_kbytes2mbstring(biggestfree+overwritefreebiggest, tmp2);
                g_snprintf(tmp,MAXLINE,"%s (%s)", tmp3, tmp2);
        } else {
                strcpy(tmp,tmp3);
        }
        gtk_entry_set_text(GTK_ENTRY(imglist_l3), tmp);
	gtk_entry_set_position(GTK_ENTRY(imglist_l3), 0);

	/* session information */
	update_session_size_display();
}


/* special version to also update the available calculator */

void cdrtype_mstr_selected(GtkWidget *item, gpointer mode) {

	curset.cdrtype = GPOINTER_TO_INT(mode);
	fill_session_available();
}


/* special version to also update availsize session size */

void writeoptions_selected_mstr(GtkWidget *item, gpointer nr) {
gint sel;

        sel = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item));

        switch(GPOINTER_TO_INT(nr)) {
                case 5:
                        curset.multisession = sel;
			fill_session_available();
			/* force recalc of session size if dvd */
			/* so he will get the multisession warning */
			if (curset.cdrtype >= 1000 && curset.isProDVD == 1 && curset.multisession == 1) {
				set_sessionsize_unknown();	
			}
			break;
		case 9:
			curset.mstr_auto_calc = sel;
			break;
		default:
			break;
	}
}


/* fifth submenu of master menu (create session) */

void draw_master_menu5(GtkWidget *box) {
GtkWidget *vbox, *hbox, *vbox2;
GtkWidget *f1, *f2, *f3, *e1;
GtkWidget *tbl, *l1, *b1;
GtkWidget *sep, *check;
GtkWidget *omenu;
GtkWidget *menu;
GtkWidget *menu_item;
gint menuidx, menuhistory;
gint cdrtypes[] = CDR_TYPES_MIN;
gint dvdtypes[] = DVD_TYPES_MB;
gint i, tmpval;
gchar tmp[MAXLINE];
gchar tmp2[MAXLINE];

        /* left and right info-frames */
        tbl = gtk_table_new(1,2,TRUE);
        gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
        gtk_table_set_col_spacings(GTK_TABLE(tbl),5);
        gtk_box_pack_start(GTK_BOX(box),tbl,TRUE,TRUE,0);
        gtk_widget_show(tbl);

        vbox2 = gtk_vbox_new(FALSE,0);
        gtk_table_attach_defaults(GTK_TABLE(tbl),vbox2,0,1,0,1);
        gtk_widget_show(vbox2);

        f1 = gtk_frame_new(text(533));
        set_font_and_color(f1,BOLDFONT,NULL);
        gtk_box_pack_start(GTK_BOX(vbox2),f1,TRUE,TRUE,0);
        gtk_widget_show(f1);

	/* fill block */
	hbox = gtk_hbox_new(TRUE,0);
        gtk_box_pack_start(GTK_BOX(vbox2),hbox,FALSE,TRUE,2);
        gtk_widget_show(hbox);

        f3 = gtk_frame_new(text(373));
        set_font_and_color(f3,BOLDFONT,NULL);
        gtk_box_pack_start(GTK_BOX(vbox2),f3,TRUE,TRUE,0);
        gtk_widget_show(f3);
        f2 = gtk_frame_new(text(374));
        set_font_and_color(f2,BOLDFONT,NULL);
        gtk_table_attach_defaults(GTK_TABLE(tbl),f2,1,2,0,1);
        gtk_widget_show(f2);

	/* left info frame */
        vbox = gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(f1),vbox);
        gtk_container_set_border_width (GTK_CONTAINER (vbox), 5); 
        gtk_widget_show(vbox);

        tbl = gtk_table_new(4,16,TRUE);
        gtk_table_set_row_spacings(GTK_TABLE(tbl),5);
        gtk_table_set_col_spacings(GTK_TABLE(tbl),5);
        gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,0);
        gtk_widget_show(tbl);

  /*      l1 = rightjust_gtk_label_new(text(376)); */
        l1 = rightjust_gtk_label_new(text(327));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,8,0,1);
        gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cdlist_l1 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,8,16,0,1);
	gtk_widget_show(e1);
/*	define_tooltip(e1, help(146)); */
	define_tooltip(e1, help(191));

        l1 = rightjust_gtk_label_new(text(377));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,8,1,2);
        gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cdlist_l2 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,8,16,1,2);
	gtk_widget_show(e1);
	define_tooltip(e1, help(147));

	b1 = gtk_button_new_with_label(text(378));
        gtk_signal_connect (GTK_OBJECT (b1), "clicked",
                GTK_SIGNAL_FUNC(calc_size_callback),GINT_TO_POINTER(0));
	gtk_table_attach_defaults(GTK_TABLE(tbl),b1,6,16,2,3);
	gtk_widget_show(b1);
	define_tooltip(b1, help(148));

        check = gtk_check_button_new_with_label(text(509));
        gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(writeoptions_selected_mstr),GINT_TO_POINTER(9));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,6,16,3,4);
	gtk_widget_show(check);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                curset.mstr_auto_calc);
	define_tooltip(check, help(192));

	/* lower left info frame */
        vbox = gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(f3),vbox);
        gtk_container_set_border_width (GTK_CONTAINER (vbox), 5); 
        gtk_widget_show(vbox);

        tbl = gtk_table_new(5,16,TRUE);
        gtk_table_set_row_spacings(GTK_TABLE(tbl),5);
        gtk_table_set_col_spacings(GTK_TABLE(tbl),5);
        gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,0);
        gtk_widget_show(tbl);

        l1 = rightjust_gtk_label_new(text(146));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,6,0,1);
        gtk_widget_show(l1);

	e1 = gtk_entry_new();
	imglist_l1 = e1;
        gtk_signal_connect(GTK_OBJECT(e1), "activate",
                GTK_SIGNAL_FUNC(set_image_prefix_callback),NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,6,16,0,1);
	gtk_widget_show(e1);
	define_tooltip(e1, help(51));

        l1 = rightjust_gtk_label_new(text(147));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,6,1,2);
        gtk_widget_show(l1);

	e1 = gtk_entry_new();
	imglist_l2 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,6,16,1,2);
	gtk_widget_show(e1);

        l1 = leftjust_gtk_label_new(text(272));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,2,16,2,3);
        gtk_widget_show(l1);

        e1 = gtk_entry_new();
        imglist_l3 = e1;
        gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
        gtk_table_attach_defaults(GTK_TABLE(tbl),e1,6,16,3,4);
        gtk_widget_show(e1);

	/* fill block */
	hbox = gtk_hbox_new(TRUE,0);
        gtk_box_pack_start(GTK_BOX(vbox),hbox,TRUE,TRUE,0);
        gtk_widget_show(hbox);
	
        /* buttons at bottom */
        hbox = gtk_hbox_new(TRUE,10);
        gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,TRUE,5);
        gtk_widget_show(hbox);
        b1 = gtk_button_new_with_label(text(379));
        gtk_signal_connect (GTK_OBJECT (b1), "clicked",
                GTK_SIGNAL_FUNC(master_image_callback),NULL);
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,3);
        gtk_widget_show(b1);
	define_tooltip(b1, help(149));


        /* right info frame */
        vbox = gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(f2),vbox);
        gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
        gtk_widget_show(vbox);

        tbl = gtk_table_new(10,16,FALSE);
        gtk_table_set_row_spacing(GTK_TABLE(tbl),0,5);
        gtk_table_set_row_spacing(GTK_TABLE(tbl),1,5);
        gtk_table_set_col_spacings(GTK_TABLE(tbl),5);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),14,0);
        gtk_table_set_row_spacing(GTK_TABLE(tbl),8,5);
        gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,0);
        gtk_widget_show(tbl);

        l1 = rightjust_gtk_label_new(text(173));
        gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,6,0,1);
        gtk_widget_show(l1);

        omenu = gtk_option_menu_new();
        menu = gtk_menu_new();
        menuidx = 0; menuhistory = 0;
        i = 0;
        tmpval = curset.cdrtype;
        while (cdrtypes[i] != 0) {
                /* contruct minute-list */
                g_snprintf(tmp,MAXLINE,"%d min",abs(cdrtypes[i]));

                menu_item = gtk_menu_item_new_with_label(tmp);
                gtk_signal_connect(GTK_OBJECT(menu_item),
                        "activate", GTK_SIGNAL_FUNC(cdrtype_mstr_selected),
                        GINT_TO_POINTER(abs(cdrtypes[i])));
                gtk_menu_append (GTK_MENU (menu), menu_item);
                if (tmpval == abs(cdrtypes[i])) { 
                        menuhistory = menuidx;
                }
                /* default set definded by negativ value */
                if (tmpval == 0 && cdrtypes[i] < 0) {
                        menuhistory = menuidx;
                        curset.cdrtype = abs(cdrtypes[i]);
                }
                menuidx++;
                gtk_widget_show (menu_item);
                i++;
        }
        if (curset.isProDVD) {
                i = 0;
                tmpval = curset.cdrtype;
                while (dvdtypes[i] != 0) {
                        /* contruct GB-list */
                        g_snprintf(tmp2,MAXLINE,"%.2f", (gfloat)dvdtypes[i]/1000);
                        /* strip last 0 */
                        if (tmp2[strlen(tmp2)-1] == '0') {
                                tmp2[strlen(tmp2)-1] = '\0';
                        }
                        g_snprintf(tmp,MAXLINE,"%s GB",tmp2);

                        menu_item = gtk_menu_item_new_with_label(tmp);
                        gtk_signal_connect(GTK_OBJECT(menu_item),
                        "activate", GTK_SIGNAL_FUNC(cdrtype_mstr_selected),
                        GINT_TO_POINTER(dvdtypes[i]));
                        gtk_menu_append (GTK_MENU (menu), menu_item);
                        if (tmpval == abs(dvdtypes[i])) {
                                menuhistory = menuidx;
                        }
                        menuidx++;
                        gtk_widget_show (menu_item);
                        i++;
                }
        }

        gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
        gtk_option_menu_set_history(GTK_OPTION_MENU (omenu),menuhistory);
        gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,6,11,0,1);
        gtk_widget_show(omenu);
        define_tooltip(omenu,help(66));

        b1 = gtk_button_new_with_label(text(175));
        gtk_signal_connect (GTK_OBJECT (b1), "clicked",
                GTK_SIGNAL_FUNC(show_atip_info),NULL);
        gtk_table_attach_defaults(GTK_TABLE(tbl),b1,11,16,0,1);
        gtk_widget_show(b1);
        define_tooltip(b1,help(67));


        sep = gtk_hseparator_new();
        gtk_table_attach_defaults(GTK_TABLE(tbl),sep,0,16,1,2);
        gtk_widget_show(sep);

        check = gtk_check_button_new_with_label(text(311));
	master_ms_button = check;
        gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(writeoptions_selected_mstr),GINT_TO_POINTER(5));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,2,16,2,3);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                curset.multisession);
        gtk_widget_show(check);
        define_tooltip(check,help(92));

        check = gtk_check_button_new_with_label(text(180));
        gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(writeoptions_selected),GINT_TO_POINTER(0));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,2,16,3,4);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                curset.writesimul);
        gtk_widget_show(check);
        define_tooltip(check,help(71));

        check = gtk_check_button_new_with_label(text(181));
        gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(writeoptions_selected),GINT_TO_POINTER(1));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,2,16,4,5);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                curset.writeeject);
        gtk_widget_show(check);
        define_tooltip(check,help(72));
        
        check = gtk_check_button_new_with_label(text(182));
        gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(writeoptions_selected),GINT_TO_POINTER(2));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,2,16,5,6);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                curset.writepad);
        gtk_widget_show(check);
        define_tooltip(check,help(152));
        
        check = gtk_check_button_new_with_label(text(310));
        gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(writeoptions_selected),GINT_TO_POINTER(4));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,2,16,6,7);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                curset.nofixate);
        gtk_widget_show(check);
        define_tooltip(check,help(153));

        check = gtk_check_button_new_with_label(text(470));
        gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(writeoptions_selected),GINT_TO_POINTER(7));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,2,16,7,8);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                curset.writeoverburn);
        gtk_widget_show(check);
        define_tooltip(check,help(184));

        check = gtk_check_button_new_with_label(text(471));
        gtk_signal_connect(GTK_OBJECT(check),"clicked",
                GTK_SIGNAL_FUNC(writeoptions_selected),GINT_TO_POINTER(8));
        gtk_table_attach_defaults(GTK_TABLE(tbl),check,2,16,8,9);
        if (does_support_burnproof()) {
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                        curset.writeburnfree);
        }
        gtk_widget_show(check);
        define_tooltip(check,help(185));

        if (!does_support_burnproof())
                gtk_widget_set_sensitive(check,FALSE);

	/* blank button */
        b1 = gtk_button_new_with_label(text(171));
        gtk_signal_connect (GTK_OBJECT (b1), "clicked",
                GTK_SIGNAL_FUNC(blankcd_clicked), NULL);
        gtk_table_attach_defaults(GTK_TABLE(tbl),b1,2,12,9,10);
	gtk_widget_show(b1); 
        define_tooltip(b1,help(64));
       
	/* fill block */
	hbox = gtk_hbox_new(TRUE,0);
        gtk_box_pack_start(GTK_BOX(vbox),hbox,TRUE,TRUE,0);
        gtk_widget_show(hbox);
	
        /* buttons at bottom */
        hbox = gtk_hbox_new(TRUE,10);
        gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,TRUE,5);
        gtk_widget_show(hbox);
        b1 = gtk_button_new_with_label(text(375));
        gtk_signal_connect (GTK_OBJECT (b1), "clicked",
                GTK_SIGNAL_FUNC(master_onthefly_callback),NULL);
        gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,3);
        gtk_widget_show(b1);
	define_tooltip(b1, help(150));
 
	/* invalidate session info */
	masterparam.last_session_start = -1;
	masterparam.next_session_start = -1;

	/* fill entries */
	fill_master_write_menu();
	fill_session_available();
}


/* detect when we enter the menu5 to auto calc the session size */

static void mastertracks_notebookswitch(GtkWidget *widget, GtkNotebookPage *page, gint page_num) {
gint curpage;

	curpage = gtk_notebook_get_current_page(GTK_NOTEBOOK(widget));

	if (curpage != -1 && page_num == 4) {
		if (curset.mstr_auto_calc == 1 && 
		    masterparam.session_size <= 0) {
			/* auto calc is on and session size is unknown */

			dodebug(2,"Try automatically calculation of session size\n"); 
			calc_size_callback(NULL, GINT_TO_POINTER(1));
		}
	}
}


/* draw the master menu */

void draw_master_menu() {
GtkWidget *notebook;
GtkWidget *tbl, *f1;
GtkWidget *vbox, *l1;
gchar tmp[MAXLINE];

        /* prepare draw area */
        clear_actionspace();

	/* session-size-entry, init with NULL to prevent error when
	   drawing the notebooktabs */
	cdlist_l2 = NULL;

        f1 = gtk_frame_new(text(107));
        set_font_and_color(f1,BOLDFONT,NULL);
        gtk_box_pack_start(GTK_BOX(actionspace),f1,FALSE,FALSE,5);
        gtk_widget_show(f1);

        tbl = gtk_table_new(2,16*4,TRUE); 
        gtk_table_set_col_spacing(GTK_TABLE(tbl),4*4-1,5);
        gtk_table_set_col_spacing(GTK_TABLE(tbl),15*4-2,5);
        gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
        gtk_container_add(GTK_CONTAINER(f1),tbl);
        gtk_widget_show(tbl);

        devices_setup_image(0, tbl);
        devices_setup_write(1, tbl);

        gtk_widget_show(actionspace);

        /* notebook tabs */
        notebook = gtk_notebook_new();
        gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
        gtk_box_pack_start(GTK_BOX(actionspace),notebook,TRUE,TRUE,2);
        gtk_widget_show(notebook);

        gtk_signal_connect_after (GTK_OBJECT (notebook), "switch_page",
                GTK_SIGNAL_FUNC (mastertracks_notebookswitch), NULL);

        vbox = gtk_vbox_new(FALSE,0);
        l1 = gtk_label_new(text(321));
        gtk_notebook_append_page(GTK_NOTEBOOK (notebook),vbox,l1);
        gtk_widget_show(vbox);
	draw_master_menu1(vbox);
 
        vbox = gtk_vbox_new(FALSE,0);
        l1 = gtk_label_new(text(322));
        gtk_notebook_append_page(GTK_NOTEBOOK (notebook),vbox,l1);
        gtk_widget_show(vbox);
	draw_master_menu2(vbox);

        vbox = gtk_vbox_new(FALSE,0);
        l1 = gtk_label_new(text(361));
        gtk_notebook_append_page(GTK_NOTEBOOK (notebook),vbox,l1);
        gtk_widget_show(vbox);
	draw_master_menu4(vbox);

        vbox = gtk_vbox_new(FALSE,0);
        l1 = gtk_label_new(text(323));
        gtk_notebook_append_page(GTK_NOTEBOOK (notebook),vbox,l1);
        gtk_widget_show(vbox);
	draw_master_menu3(vbox);

        vbox = gtk_vbox_new(FALSE,0);
        l1 = gtk_label_new(text(324));
        gtk_notebook_append_page(GTK_NOTEBOOK (notebook),vbox,l1);
        gtk_widget_show(vbox);
	draw_master_menu5(vbox);

	/* now generate 2 empty files to hold our master paths */
	/* will be removed when the master menu is quit */
	if (master_fname1) {
		g_free(master_fname1);
		master_fname1 = NULL;
	}
	generate_tmp_file_name("mstr", tmp);
	if (*tmp) {
		if (write_empty_file(tmp) == 0)
			master_fname1 = g_strdup(tmp);
	}
	if (!master_fname1) 
		g_warning("failed to generate temporary master file1\n");

	if (master_fname2) {
		g_free(master_fname2);
		master_fname2 = NULL;
	}
	generate_tmp_file_name("excl", tmp);
	if (*tmp) {
		if (write_empty_file(tmp) == 0)
			master_fname2 = g_strdup(tmp);
	}
	if (!master_fname2) 
		g_warning("failed to generate temporary master file2\n");
}


/* -------------------------------- */

/* unselects all buttons on the sidebar (except the one given)
   So there is always only one selected */

void reset_duplicate_buttons2(GtkWidget *exclude, gint fromunlock) {
gchar tmptoc[MAXLINE];
int i;

        for (i = 0; i < 8; i++) {
                if (side_widgets2[i] != exclude) {
                        gtk_signal_handler_block(GTK_OBJECT(side_widgets2[i]),side_handlers2[i]);
                        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(side_widgets2[i]),0);
                        gtk_signal_handler_unblock(GTK_OBJECT(side_widgets2[i]),side_handlers2[i]);
                }
        }

        /* because this is called whenever somebody clicks on a
           sidebar button, we can here check if the wav-player
           process from "play track" is still running, when the
           user quits this menu. So lets care here that it is
           terminated in a nice way */

        if (wav_in != -1) {
		do_lock(0);

                /* we want to quit the wavplayer.. */
                wavplay_quit = 1;

                /* simulate quit-button-press */
                gtk_button_clicked(GTK_BUTTON(wav_quit_button));

                /* now wait until we are really finished */
                while (wav_in != -1) {
                        wait_and_process_events();
                }

                /* now give gtk some extra time to initialize */
                for (i = 0; i < 3; i++) {
                        wait_and_process_events();
                }

		do_unlock(0);
        }

	if (!fromunlock) {
		/* when changing the menus, remove temporary toc files */ 
		generate_tmp_tocfile_name(tmptoc);
		remove_tmp_writetracks_tocfile(tmptoc);
	
		/* also remove any temporary master files */
		if (master_fname1) {
			remove_tmp_writetracks_tocfile(master_fname1);
			g_free(master_fname1);
			master_fname1 = NULL;
		}
		if (master_fname2) {
			remove_tmp_writetracks_tocfile(master_fname2);
			g_free(master_fname2);
			master_fname2 = NULL;
		}
	}
}

void menu_create_info(GtkWidget *widget, gpointer data) {

        /* if button already pressed ignore and undo click */
        if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)) == 0) {
                gtk_signal_handler_block(GTK_OBJECT(widget),side_handlers2[0]);
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),1);
                gtk_signal_handler_unblock(GTK_OBJECT(widget),side_handlers2[0]);
                return;
        }
        reset_duplicate_buttons2(widget,0);

        dolog(2, "Entering create: info menu\n");
        draw_info_menu();
}


void menu_create_read(GtkWidget *widget, gpointer data) {

        /* if button already pressed ignore and undo click */
        if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)) == 0) {
                gtk_signal_handler_block(GTK_OBJECT(widget),side_handlers2[1]);
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),1);
                gtk_signal_handler_unblock(GTK_OBJECT(widget),side_handlers2[1]);
                return;
        }
        reset_duplicate_buttons2(widget,0);

        dolog(2, "Entering create: read menu\n");
	draw_read_tracks();
}


void menu_create_verify(GtkWidget *widget, gpointer data) {

        /* if button already pressed ignore and undo click */
        if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)) == 0) {
                gtk_signal_handler_block(GTK_OBJECT(widget),side_handlers2[2]);
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),1);
                gtk_signal_handler_unblock(GTK_OBJECT(widget),side_handlers2[2]);
                return;
        }
        reset_duplicate_buttons2(widget,0);

        dolog(2, "Entering create: verify menu\n");
	draw_verify_tracks();
}


void menu_create_play(GtkWidget *widget, gpointer data) {

        /* if button already pressed ignore and undo click */
        if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)) == 0) {
                gtk_signal_handler_block(GTK_OBJECT(widget),side_handlers2[3]);
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),1);
                gtk_signal_handler_unblock(GTK_OBJECT(widget),side_handlers2[3]);
                return;
        }
        reset_duplicate_buttons2(widget,0);

        dolog(2, "Entering create: play menu\n");
	draw_play_tracks_menu();
}

/* show the create-menu-not-done-yet dialog */
/* to be removed in final version */

void draw_notready_menu() {

	clear_actionspace();
	gtk_widget_show(actionspace);

	show_dialog(ICO_INFO,text(287),T_OK,NULL,NULL,0);
}

void menu_create_master(GtkWidget *widget, gpointer data) {

        /* if button already pressed ignore and undo click */
        if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)) == 0) {
                gtk_signal_handler_block(GTK_OBJECT(widget),side_handlers2[4]);
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),1);
                gtk_signal_handler_unblock(GTK_OBJECT(widget),side_handlers2[4]);
                return;
        }
        reset_duplicate_buttons2(widget,0);

        dolog(2, "Entering create: master menu\n");

	draw_master_menu();
}


void menu_create_write(GtkWidget *widget, gpointer data) {

        /* if button already pressed ignore and undo click */
        if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)) == 0) {
                gtk_signal_handler_block(GTK_OBJECT(widget),side_handlers2[5]);
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),1);
                gtk_signal_handler_unblock(GTK_OBJECT(widget),side_handlers2[5]);
                return;
        }
        reset_duplicate_buttons2(widget,0);

        dolog(2, "Entering create: write menu\n");
	draw_write_tracks();
}


void menu_create_delete(GtkWidget *widget, gpointer data) {

        /* if button already pressed ignore and undo click */
        if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)) == 0) {
                gtk_signal_handler_block(GTK_OBJECT(widget),side_handlers2[6]);
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),1);
                gtk_signal_handler_unblock(GTK_OBJECT(widget),side_handlers2[6]);
                return;
        }
        reset_duplicate_buttons2(widget,0);

        dolog(2, "Entering create: delete menu\n");
	draw_delete_menu();
}


void menu_create_back(GtkWidget *widget, gpointer data) {

	reset_duplicate_buttons2(widget,0); 
	create_main(0);
}


/* called by the create-button */

void create_create() {
GtkWidget *side_t;
GtkWidget *head,*head_l;
GtkWidget *b1;

	submenu = 2;
	clear_sidespace();
	clear_workspace();

	side_t = gtk_table_new(10,10, TRUE);
	gtk_table_set_row_spacings(GTK_TABLE(side_t),10);
	gtk_box_pack_start(GTK_BOX(sidespace), side_t,TRUE,TRUE,0);

	b1 = gtk_toggle_button_new_with_label(text(92));
	gtk_table_attach_defaults(GTK_TABLE(side_t), b1, 0,10,1,2);
	/* preselect the first button */
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b1),1);
	gtk_widget_show(b1);
	side_handlers2[0] = gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(menu_create_info),NULL);
	side_widgets2[0] = b1;
	define_tooltip(b1,help(35));

	b1 = gtk_toggle_button_new_with_label(text(292));
	gtk_table_attach_defaults(GTK_TABLE(side_t), b1, 0,10,2,3);
	gtk_widget_show(b1);
	side_handlers2[1] = gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(menu_create_read),NULL);
	side_widgets2[1] = b1;
	define_tooltip(b1,help(81));

	b1 = gtk_toggle_button_new_with_label(text(293));
	gtk_table_attach_defaults(GTK_TABLE(side_t), b1, 0,10,3,4);
	gtk_widget_show(b1);
	side_handlers2[2] = gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(menu_create_verify),NULL);
	side_widgets2[2] = b1;
	define_tooltip(b1,help(82));

	b1 = gtk_toggle_button_new_with_label(text(138));
	gtk_table_attach_defaults(GTK_TABLE(side_t), b1, 0,10,4,5);
	gtk_widget_show(b1);
	side_handlers2[3] = gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(menu_create_play),NULL);
	side_widgets2[3] = b1;
	define_tooltip(b1,help(38));

	b1 = gtk_toggle_button_new_with_label(text(294));
	gtk_table_attach_defaults(GTK_TABLE(side_t), b1, 0,10,5,6);
	gtk_widget_show(b1);
	side_handlers2[4] = gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(menu_create_master),NULL);
	side_widgets2[4] = b1;
	define_tooltip(b1,help(83));

	b1 = gtk_toggle_button_new_with_label(text(295));
	gtk_table_attach_defaults(GTK_TABLE(side_t), b1, 0,10,6,7);
	gtk_widget_show(b1);
	side_handlers2[5] = gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(menu_create_write),NULL);
	side_widgets2[5] = b1;
	define_tooltip(b1,help(84));

	b1 = gtk_toggle_button_new_with_label(text(184));
	gtk_table_attach_defaults(GTK_TABLE(side_t), b1, 0,10,7,8);
	gtk_widget_show(b1);
	side_handlers2[6] = gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(menu_create_delete),NULL);
	side_widgets2[6] = b1;
	define_tooltip(b1,help(40));


	b1 = gtk_toggle_button_new_with_label(text(91));
	gtk_table_attach_defaults(GTK_TABLE(side_t), b1, 0,10,8,9);
	gtk_widget_show(b1);
	side_handlers2[7] = gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(menu_create_back),NULL);	
	side_widgets2[7] = b1;
	define_tooltip(b1,help(85));

	gtk_widget_show(side_t);
	gtk_widget_show(sidespace);

	/* draw workspace */

	head = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(head),GTK_SHADOW_IN);
	gtk_widget_set_usize(head,0,45);
	gtk_box_pack_start(GTK_BOX(workspace), head,FALSE,TRUE,0);
	gtk_widget_show(head);
	head_l = gtk_label_new(text(6));
	set_font_and_color(head_l,BIGFONT,NULL);
	gtk_container_add(GTK_CONTAINER(head),head_l);
	gtk_widget_show(head_l);
	gtk_widget_show(workspace);

	/* space where sub-windows are placed */
	actionspace = gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(workspace), actionspace,TRUE,FALSE,5);

	/* the default submenu for a start */
	draw_info_menu();
}

