/* $Id: test1.c,v 1.6 2000/04/26 09:08:59 amai Exp $ */

#include <stdlib.h>
#include <stdio.h>
#include <Host.h>
#include <Stroke.h>
#include <BubbleButton.h>
#include <Xm/Form.h>
#include <../../lib/Sound.h>

static char *Fallback[] = {
	"*XmDialogShell*translations: #override" DEFAULT_STROKE_TRANSLATION,
	"*strokes: 456 ParentActivate, \
		   654 ParentCancel",
  	"*HostTranscript*columns: 80",
  	"*HostTranscript*rows: 24",
	NULL
};

static void
InputCallback(Widget W, String client_data, XltHostCallbackStruct *call_data)
{
	printf("InputCallback(%s,%s,%i)\n", XtName(W),client_data,call_data->len);
}

static void
BinaryInputCallback(Widget W, String client_data, XltHostCallbackStruct *call_data)
{
	printf("BinaryInputCallback(%s,%s,%i)\n", XtName(W),client_data,call_data->len);
}

static void
AsciiInputCallback(Widget W, Widget client_data, XltHostCallbackStruct *call_data)
{
	printf("AsciiInputCallback(%s,%s,%s)\n", XtName(W),XtName(client_data),call_data->data);
}

static void
Callback(Widget W)
{
	printf("ConnectCallback(%s)\n", XtName(W));
}

char *Program = "";
int
main(int argc, char **argv)
{
  Widget toplevel, one, form, Connect;
  Widget Host;
  XtAppContext app;

  XtSetLanguageProc(NULL, NULL, NULL);

  toplevel = XtVaAppInitialize(&app, 
  	"Label", 
  	NULL, 0, 
  	&argc, argv, 
  	Fallback, 
  	NULL);
  StrokeInitialize(toplevel);
  XltSoundInitialize(toplevel);
  Host = XltCreateHost(toplevel, "Host", NULL, 0);
  XtVaSetValues(Host,
  	NULL);

  form = XmCreateForm(toplevel, "Form", NULL, 0);
  Connect = XltCreateBubbleButton(form, "Connect", NULL, 0);

  one = XltHostCreateTranscript(form, Host, NULL, 0);
  XtVaSetValues(XtParent(one),
  	XmNtopAttachment, XmATTACH_WIDGET,
  	XmNtopWidget, Connect,
  	XmNbottomAttachment, XmATTACH_FORM,
  	XmNleftAttachment, XmATTACH_FORM,
  	XmNrightAttachment, XmATTACH_FORM,
  	NULL);
  XtVaSetValues(Connect,
  	XmNtopAttachment, XmATTACH_FORM,
  	XmNleftAttachment, XmATTACH_FORM,
  	NULL);
  XtManageChild(one);

  XtManageChild(Connect);
  XtManageChild(form);
  XtAddCallback(Host, XltNconnectCallback, (XtCallbackProc)Callback, NULL);
  XtAddCallback(Host, XltNasciiInputCallback, (XtCallbackProc)AsciiInputCallback, one);
  XtAddCallback(Host, XltNbinaryInputCallback, (XtCallbackProc)BinaryInputCallback, NULL);
  XtAddCallback(Host, XltNinputCallback, (XtCallbackProc)InputCallback, NULL);
  XtAddCallback(Connect, XmNactivateCallback, (XtCallbackProc)XltHostSelect, Host);
  XtRealizeWidget(toplevel);
  {
  String port;

  	XtVaGetValues(Host,
  		XltNport, &port,
  		NULL);
  	printf("PORT >%s<\n",port);
  }
  XtAppMainLoop(app);

  exit(0);
}
