.\" $Xorg: Xsun.man,v 1.3 2000/08/17 19:48:29 cpqbld Exp $
.\" Copyright 1988 Sun Microsystems, Inc.
.\" Copyright 1993, 1994, 1998  The Open Group
.\" 
.\" All Rights Reserved.
.\" 
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of The Open Group shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from The Open Group.
.\"
.\" $XFree86: xc/programs/Xserver/hw/sun/Xsun.man,v 1.7 2001/01/27 18:20:40 dawes Exp $
.\"
.TH XSUN 1 __xorgversion__
.SH NAME
Xsun, XsunMono, Xsun24 \- Sun server for X Version 11
.SH SYNOPSIS
.B Xsun
[ option ] ...
.SH DESCRIPTION
.I Xsun
is the server for Version 11 of the X window system on Sun hardware.
It will normally be started by the \fIxdm(1)\fP daemon or by a script
that runs the program \fIxinit(1)\fP.
.SH CONFIGURATIONS
.PP
.I XsunMono
supports the BW2 monochrome frame buffer.
.I Xsun
supports the CG2, CG3, CG4, and CG6 8-bit color frame buffers in
addition to the BW2 monochrome frame buffer. On Solaris 2.5 it also
supports the TCX as an 8-bit color frame buffer.
.I Xsun24
supports the cgeight 24-bit color frame buffer in addition to the
8-bit color and monochrome frame buffers that
.I Xsun
supports.
.PP
If specific framebuffer device files aren't specified on the command 
line with the \fI\-dev\fP switch or in the \fIXDEVICE\fP environment
variable, the server will search for all installed frame buffers and 
will use all those that it finds.
.PP
Finally, if no specific framebuffers are found, the generic framebuffer 
interface \fI/dev/fb\fP is used.
.PP
.SH KEYBOARDS
.PP
Xsun, Xsun24, and XsunMono support the Type-2, Type-3, and many variations 
of the Type-4 and Type-5 keyboards.
.PP
Type-4 and Type-5 keyboards feature a key labeled \fIAltGraph\fP which 
is a mode-shift key. The mode-shift key is used to generate the symbols 
painted on the fronts of the keys. The mode-shift key works exactly like 
the \fIShift\fP, \fIControl\fP, \fIAlt\fP, and \fI<Meta>\fP keys.
.PP
The ten function keys on the left side of the Type-5 keyboard may be 
considered as having L1..L10 painted on their fronts.  Shift-AltGraph 
will cause different keysyms to be generated for some keys, e.g. the 
Type-5 \fISysRq\fP key.
.PP
For compatibility with Sun's X11/NeWS server, the F11 and F12 keys may 
be made to generate the equivalent X11/NeWS keysyms by using mode-switch.
.PP
For backwards compatibility, the normal and mode-shifted keysyms for 
the ten function keys on the left side of Type-4 and Type-5 keyboards 
may be swapped via command line option. See \fI-swapLkeys\fP.
.PP
The X LEDs 1..4 correspond to the NumLock, ScrollLock, Compose, and
CapsLock LEDs respectively. Pressing the key once turns the corresponding
LED on. Pressing the key again turns the LED off. Turning an LED on or 
off with e.g. 'xset [-]led [1234]' is equivalent to pressing the 
corresponding key.
.SH OPTIONS
.PP
In addition to the normal server options described in the \fIXserver(1)\fP
manual page, \fIXsun\fP accepts the following command line switches:
.TP 8
.B "\-ar1 \fImilliseconds\fP"
This option specifies amount of time in milliseconds before which a 
pressed key should begin to autorepeat.
.TP 8
.B "\-ar2 \fImilliseconds\fP"
This option specifies the interval in milliseconds between autorepeats 
of pressed keys.
.TP 8
.B \-swapLkeys
Swaps the normal keysyms for the function keys on the left side of 
Type-4 and Type-5 keyboards with the alternate keysyms, i.e. the keysyms 
painted on the front of the keys.
.TP 8
.B \-flipPixels
The normal pixel values for white and black are 0 and 1 respectively. 
When -flipPixels is specified these values are reversed.
.TP 8
.B \-mono
When used with the \fBcgtwo\fP, this option indicates that the server 
should emulate a monochrome framebuffer instead of the normal color 
framebuffer.  When used with the \fBcgfour\fP, this option indicates 
that the monochrome screen should be numbered 0 and the color screen 
numbered 1 (instead of the other way around).
.TP 8
.B \-zaphod
This option disables switching between screens by sliding the mouse off 
the left or right edges.  With this disabled, a window manager function 
must be used to switch between screens.
.TP 8
.B \-debug
This option indicates that the server is being run from a debugger, and 
that it should \fBnot\fP put its standard input, output and error files 
into non-blocking mode.
.TP 8
.B "\-dev \fIfilename[:filename]...\fP"
This option specifies the colon separated names of the framebuffer device 
files to be used.
.TP 8
.B "\-fbinfo
This option indicates that the server should enumerate the available
frame buffers that it will use.
.SH ENVIRONMENT
.TP 8
\fBXDEVICE\fP
If present,  and if no explicit \fB-dev\fP options are given, specifies 
the (colon separated) list of display devices to use.
.SH "SEE ALSO"
.PP
X(__miscmansuffix__), Xserver(1), xdm(1), xinit(1)
.SH BUGS
The auto-configuration depends on there being appropriate special files 
in the
.I /dev
directory for the framebuffers which are to be used.  Extra entries can 
confuse the server.  For example,  the X/160C in fact has the hardware 
for a monochrome
.B bwtwo0
on the CPU board.  So if 
.I /dev
has a special file for
.IR /dev/bwtwo0 ,
the server will use it,  even though there is no monitor attached to the
monochrome framebuffer.
The server will appear to start,  but not to paint a cursor,  because the
cursor is on the monochrome frame buffer. The solution is to remove the
.I /dev
entries for any device you don't have a monitor for.
.PP
There is a bug in pre-FCS operating systems for the Sun-4 which causes 
the server to crash driving a \fBcgtwo\fP.
.PP
.SH AUTHORS
.TP 8
U. C. Berkeley
Adam de Boor.
.TP 8
Sun Microsystems
David Rosenthal,  Stuart Marks,  Robin Schaufler,  Mike Schwartz,
Frances Ho,  Geoff Lee,  and Mark Opperman.
.TP 8
MIT Laboratory for Computer Science
.br
Bob Scheifler, Keith Packard, Kaleb Keithley
