/*
 * Copyright (c) 1990,1993 Regents of The University of Michigan.
 * All Rights Reserved. See COPYRIGHT.
 */

#include <stdlib.h>
#include <string.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <net/if.h>
#include <syslog.h>

/* work around for FreeBSD */
#if defined(__FreeBSD__) && (__FreeBSD__ >= 2)
#include <osreldate.h>
#if __FreeBSD_version >= 300000
#include <net/if_dl.h>
#define NO_DATA_LINK_PASSTHROUGH
#endif
#endif

#ifdef __svr4__
#include <sys/sockio.h>
#endif __svr4__

#include <atalk/util.h>
#include <netatalk/endian.h>
#include "zip.h"

static const unsigned char	ethermulti[ 6 ] = {
    0x09, 0x00, 0x07, 0xff, 0xff, 0xff,
};

static const unsigned char	ethermultitab[ 253 ][ 6 ] = {
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x00, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x01, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x02, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x03, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x04, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x05, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x06, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x07, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x08, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x09, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x0a, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x0b, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x0c, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x0d, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x0e, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x0f, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x10, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x11, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x12, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x13, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x14, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x15, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x16, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x17, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x18, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x19, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x1a, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x1b, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x1c, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x1d, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x1e, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x1f, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x20, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x21, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x22, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x23, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x24, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x25, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x26, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x27, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x28, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x29, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x2a, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x2b, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x2c, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x2d, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x2e, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x2f, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x30, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x31, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x32, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x33, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x34, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x35, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x36, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x37, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x38, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x39, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x3a, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x3b, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x3c, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x3d, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x3e, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x3f, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x40, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x41, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x42, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x43, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x44, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x45, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x46, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x47, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x48, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x49, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x4a, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x4b, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x4c, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x4d, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x4e, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x4f, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x50, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x51, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x52, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x53, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x54, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x55, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x56, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x57, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x58, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x59, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x5a, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x5b, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x5c, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x5d, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x5e, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x5f, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x60, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x61, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x62, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x63, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x64, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x65, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x66, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x67, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x68, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x69, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x6a, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x6b, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x6c, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x6d, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x6e, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x6f, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x70, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x71, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x72, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x73, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x74, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x75, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x76, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x77, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x78, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x79, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x7a, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x7b, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x7c, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x7d, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x7e, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x7f, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x80, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x81, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x82, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x83, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x84, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x85, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x86, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x87, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x88, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x89, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x8a, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x8b, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x8c, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x8d, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x8e, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x8f, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x90, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x91, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x92, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x93, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x94, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x95, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x96, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x97, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x98, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x99, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x9a, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x9b, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x9c, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x9d, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x9e, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0x9f, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xa0, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xa1, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xa2, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xa3, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xa4, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xa5, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xa6, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xa7, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xa8, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xa9, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xaa, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xab, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xac, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xad, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xae, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xaf, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xb0, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xb1, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xb2, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xb3, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xb4, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xb5, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xb6, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xb7, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xb8, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xb9, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xba, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xbb, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xbc, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xbd, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xbe, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xbf, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xc0, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xc1, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xc2, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xc3, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xc4, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xc5, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xc6, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xc7, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xc8, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xc9, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xca, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xcb, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xcc, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xcd, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xce, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xcf, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xd0, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xd1, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xd2, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xd3, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xd4, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xd5, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xd6, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xd7, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xd8, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xd9, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xda, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xdb, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xdc, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xdd, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xde, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xdf, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xe0, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xe1, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xe2, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xe3, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xe4, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xe5, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xe6, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xe7, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xe8, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xe9, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xea, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xeb, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xec, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xed, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xee, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xef, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xf0, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xf1, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xf2, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xf3, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xf4, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xf5, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xf6, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xf7, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xf8, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xf9, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xfa, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xfb, },
    { 0x09, 0x00, 0x07, 0x00, 0x00, 0xfc, },
};

static const unsigned char	tokenmulti[ 6 ] = {
    0xc0, 0x00, 0x40, 0x00, 0x00, 0x00,
};

static const unsigned char	tokenmultitab[ 19 ][ 6 ] = {
    { 0xc0, 0x00, 0x00, 0x00, 0x08, 0x00, },
    { 0xc0, 0x00, 0x00, 0x00, 0x10, 0x00, },
    { 0xc0, 0x00, 0x00, 0x00, 0x20, 0x00, },
    { 0xc0, 0x00, 0x00, 0x00, 0x40, 0x00, },
    { 0xc0, 0x00, 0x00, 0x00, 0x80, 0x00, },
    { 0xc0, 0x00, 0x00, 0x01, 0x00, 0x00, },
    { 0xc0, 0x00, 0x00, 0x02, 0x00, 0x00, },
    { 0xc0, 0x00, 0x00, 0x04, 0x00, 0x00, },
    { 0xc0, 0x00, 0x00, 0x08, 0x00, 0x00, },
    { 0xc0, 0x00, 0x00, 0x10, 0x00, 0x00, },
    { 0xc0, 0x00, 0x00, 0x20, 0x00, 0x00, },
    { 0xc0, 0x00, 0x00, 0x40, 0x00, 0x00, },
    { 0xc0, 0x00, 0x00, 0x80, 0x00, 0x00, },
    { 0xc0, 0x00, 0x01, 0x00, 0x00, 0x00, },
    { 0xc0, 0x00, 0x02, 0x00, 0x00, 0x00, },
    { 0xc0, 0x00, 0x04, 0x00, 0x00, 0x00, },
    { 0xc0, 0x00, 0x08, 0x00, 0x00, 0x00, },
    { 0xc0, 0x00, 0x10, 0x00, 0x00, 0x00, },
    { 0xc0, 0x00, 0x20, 0x00, 0x00, 0x00, },
};



/* configure multicast for a given named interface */
int addmulti(const char *name, const unsigned char *data)
{
#ifdef NO_DATA_LINK_PASSTHROUGH
    struct sockaddr_dl sa;
#else
    struct sockaddr sa;
#endif

    memset(&sa, 0, sizeof(sa));
#ifdef NO_DATA_LINK_PASSTHROUGH
    sa.sdl_family = AF_LINK;
    memcpy(LLADDR(&sa), data ? data : ethermulti, sizeof(ethermulti));
    sa.sdl_alen = sizeof(ethermulti);
    sa.sdl_len = sizeof(sa);
#else
    memcpy(sa.sa_data, data ? data : ethermulti, sizeof( ethermulti ));
#endif
    if (ifconfig(name, SIOCADDMULTI, &sa))
      return -1;

    return 0;
}

static u_int16_t
atalk_cksum( data, len )
    u_char	*data;
    int		len;
{
    u_char	*end;
    u_int32_t	cksum = 0;

    for ( end = data + len; data < end; data++ ) {
	cksum = ( cksum + *data ) << 1;
	if ( cksum & 0x00010000 ) {
	    cksum++;
	}
	cksum &= 0x0000ffff;
    }

    if ( cksum == 0 ) {
	cksum = 0x0000ffff;
    }

    return( (u_int16_t) cksum );
}

/*
 * Fill in multicast for zone.  There is a general issue here:  how can
 * we tell the type of interface we're configuring for?  E.g.  Is it
 * ethernet, tokenring, or FDDI?  (Of course, FDDI and Ethernet look just
 * alike.)
 */
int
zone_bcast( zt )
     struct ziptab     *zt;
{
    u_char		uname[ 32 ];
    u_int16_t		cksum;
    int			i;

    if (!zt->zt_bcast &&
	(zt->zt_bcast = (u_char *) malloc(sizeof( ethermulti ))) == NULL) {
       syslog( LOG_ERR, "zone_bcast malloc: %m" );
       return -1;
     }

    for ( i = 0; i < zt->zt_len; i++ ) {
	uname[ i ] = diatoupper(zt->zt_name[ i ]);
    }
    cksum = atalk_cksum( uname, zt->zt_len );
#define elements(a)   (sizeof(a)/sizeof((a)[0]))
    memcpy(zt->zt_bcast, ethermultitab[ cksum % elements( ethermultitab ) ],
	   sizeof( ethermulti ));
    return 0;
}
