/* -*- C++ -*-

  $Id: RemovePointCmd.h,v 1.5 2000/07/28 20:11:48 wtrobin Exp $

  This file is part of KIllustrator.
  Copyright (C) 1998 Kai-Uwe Sattler (kus@iti.cs.uni-magdeburg.de)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef RemovePointCmd_h_
#define RemovePointCmd_h_

#include <Command.h>
#include <GPolygon.h>

class GDocument;
class GPolyline;

class RemovePointCmd : public Command {
  Q_OBJECT
public:
  RemovePointCmd (GDocument* doc, GPolyline* o, int idx);

  ~RemovePointCmd ();

  void execute ();
  void unexecute ();

private:
  GDocument* document;
  GPolyline* obj;
  int index;
  Coord point;
  GPolygon::Kind kind;
};

#endif
