/*
* news.h -- Declaration of class KNewsDrop.
* Generated by newclass on Thu May  7 05:29:29 EST 1998.
*/
#ifndef SSK_NEWS_H
#define SSK_NEWS_H

#include<polldrop.h>

class DwNntpClient;

/**
* NNTP newsgroup monitor implementation for KOrn.
* @author Sirtaj Singh Kang (taj@kde.org)
* @version $Id: news.h,v 1.2 2000/06/14 19:37:24 rikkus Exp $
*/
class KNewsDrop : public KPollableDrop
{
	Q_OBJECT

public:
	static const char *ServerConfigKey;
	static const char *PortConfigKey;
	static const char *GroupConfigKey;
	static const char *PersistenceConfigKey;

	static const char *DefaultServer;
	static const char *DefaultGroup;
	static const int  DefaultPort;
	static const bool DefaultPersistence;

	static const int OkCode;
		
	/**
	* KNewsDrop Constructor
	*/
	KNewsDrop();

	/** 
	 * KNewsDrop Destructor 
	 */
	~KNewsDrop();

	int port() const { return _port; }
	void setPort( int t ) { _port = t; }

  QString server() const { return _server; }
	void setServer( const QString & t ) { _server = t; }

	QString group() const { return _group; }
	void setGroup( const QString & t ) { _group = t; }

	bool persistence() const { return _persistence; }
	void setPersistence( bool p );

	virtual void recheck ();
	virtual bool valid ();


	virtual KMailDrop* clone () const;

	virtual bool readConfigGroup ( const KConfigBase& cfg );
	virtual bool writeConfigGroup ( KConfigBase& cfg ) const;

	virtual QString type () const { return QString::fromUtf8("nntp"); }

        virtual void addConfigPage( KDropCfgDialog * );
	
public slots:
	virtual void forceCountZero();

private:
	KNewsDrop& operator=( KNewsDrop& );
	KNewsDrop( const KNewsDrop& );

	int	_port;
	QString _server;
	QString _group;
	bool	_persistence;

	int	_lastStart;
	int	_lastStop;

	DwNntpClient *_socket;

	int decodeString( const char * );

};

#endif // SSK_NEWS_H
