/*
* dropman.h -- Declaration of class KDropManager.
* Generated by newclass on Fri May  1 19:33:10 EST 1998.
*/
#ifndef SSK_DROPMAN_H
#define SSK_DROPMAN_H

class KConfigBase;

#include<qlist.h>
#include<qstrlist.h>
#include<qdict.h>
#include<qobject.h>

#include"maildrop.h"

/**
* Manage mailbox monitors.
* @author Sirtaj Singh Kang (taj@kde.org)
* @version $Id: dropman.h,v 1.2 2000/06/14 19:37:24 rikkus Exp $
*/
class KDropManager : public QObject
{
	Q_OBJECT

private:
	KDropManager& operator=( const KDropManager& );
	KDropManager( const KDropManager& );

	QDict<KMailDrop>	_prototypes;
	QStringList		_types;	
	QList<KMailDrop>	_monitors;

public:
	static const char *BoxConfigKey;
	static const char *BoxNumConfigKey;
	static const char BoxConfigSep;

	/**
	* KDropManager Constructor
	*/
	KDropManager();

	/**
	* KDropManager Destructor
	*/
	virtual ~KDropManager();

	/** 
	 * Read monitor configuration from the associated group.
	 */
	bool readConfig( KConfigBase& config, const QString & group );
	bool readOldConfig( KConfigBase& config, const QString & group );

	bool writeConfig( KConfigBase& config, const QString & group ) const;

	/**
	* Create a basic configuration for a new user.
	*/
	bool createBasicConfig();

	QListIterator<KMailDrop> monitors() const
		{ return QListIterator<KMailDrop>( _monitors ); }

	void assignMonitors( const QList<KMailDrop>& monitors );

	/**
	* Returns a of all registered monitor types.
	*/
	QStringList types() const { return _types; }
	
	/** 
	 * Creates and registers a new monitor of the
	 * given type.
	 * @return A pointer to a newly created monitor,
	 * 	or 0 on bad type or out of memory.
	 */
	KMailDrop *newMonitor( const QString & type );

	/** 
	 * Creates and registers a new monitor that is a
	 * clone of the original.
	 */
	KMailDrop *cloneMonitor( const KMailDrop *monitor );

	/** 
	 * Delete a registered monitor.
	 */
	bool deleteMonitor( KMailDrop *monitor );

	
protected:
	/**
	* Register a prototype monitor. One prototype for each
	* monitor class should be added.
	*
	* Since prototype monitors persist for the life of the 
	* manager, monitors should allocate minimal resources on
	* construction and allocate more if they are required.
	*
	* @see KMailDrop
	*/
	void addPrototype( const KMailDrop *prototype );

signals:

	void monitorCreated();
	void monitorDeleted();
	void configChanged();

private slots:
	void raiseConfig();
};

#endif // SSK_DROPMAN_H
