/*
 * knewstickerstub.cpp
 *
 * Copyright (c) 2000 Frerich Raabe <raabe@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <kapp.h>
#include <klocale.h>
#include <kcmdlineargs.h>
#include <kconfig.h>
#include <kdebug.h>

#include <dcopclient.h>

#include <qdatastream.h>

static const char *version = "v0.0.1 (c)2001 by Frerich Raabe";
static const char *description = I18N_NOOP("A frontend to the KNewsTicker configuration");
static const KCmdLineOptions options[] =
{
	{"a", 0, 0},
	{"addrdf <url>", I18N_NOOP("Add the RDF/RSS file referenced by <url>"), 0},
	{0, 0, 0}
};

int main(int argc, char **argv)
{
	KLocale::setMainCatalogue("kdelibs");

	KCmdLineArgs::init(argc, argv, "knewstickerstub", description, version);
	KCmdLineArgs::addCmdLineOptions(options);

	KApplication app(false, false);

	DCOPClient *dcopClient = app.dcopClient();
	dcopClient->attach();

	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

	KConfig *config = new KConfig("knewstickerrc", false, false);

	if (args->isSet("addrdf")) {
		config->setGroup("General");
		uint newsSources = config->readNumEntry("News sources", 0) + 1;
		config->writeEntry("News sources", newsSources);

		config->setGroup(QString("News source #%1").arg(newsSources - 1));
		config->writeEntry("Name", i18n("Unknown"));
		config->writeEntry("Address", QString(args->getOption("addrdf")));

		QByteArray data;
		dcopClient->send("knewsticker", "KNewsTicker", "reparseConfig()", data);
	}

	args->clear();

	delete config;

	return 0;
}
