// tron.h
//
// Copyright (C) 2000 Neil Stevens <multivac@fcmail.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
// 
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#ifndef TRON_H
#define TRON_H

#include <klistview.h>
#include <kmainwindow.h>
#include <kurl.h>
#include <qmap.h>

#include "plugin.h"

#include "mcp.h"

class KAction;
class KToggleAction;

/**
 * TronListViewItem is just a QListViewItem with a "special" bit.
 *
 * If the special bit is set, then it draws itself highlighted in red.
 */
class TronListViewItem : public QListViewItem
{
public:
	TronListViewItem(QListView *, QListViewItem *, QString = QString::null, QString = QString::null);
	virtual ~TronListViewItem();

	void setSpecial(bool);
	bool isSpecial(void);

protected:
	virtual void paintCell(QPainter *, const QColorGroup &, int, int, int);

private:
	bool special;
};

/**
 * TronListView handles the drag and drop, and makes sure that only one
 * item at a time is marked "special".
 */
class TronListView : public KListView
{
Q_OBJECT

public:
	TronListView(QWidget *, const char * = 0);
	virtual ~TronListView();

	void setSpecialItem(TronListViewItem *);
	TronListViewItem *specialItem(void);

	virtual void clear(void);
	virtual void takeItem(QListViewItem *);

signals:
	void dropped(KURL::List, QListViewItem *);

protected:
	virtual bool acceptDrag(QDropEvent *) const;

protected slots:
	void myDropEvent(QDropEvent *, QListViewItem *);

private:
	TronListViewItem *special;
};

/**
 * Tron is the plugin itself, and is the view.  It is *not* the playlist.
 * It *has* a playlist, MCP *list.
 */
class Tron : public KMainWindow, public Plugin
{
Q_OBJECT
NOATUNPLUGIND

public:
	Tron();
	virtual ~Tron();

	virtual void init();
	virtual PlayList *playlist(void) const;

protected:
	void closeEvent(QCloseEvent *);
	void hideEvent(QHideEvent *);
	void showEvent(QShowEvent *);

private slots:
	void itemMoved(QListViewItem *, QListViewItem *, QListViewItem *);
	void itemExecuted(QListViewItem *);
	void itemDropped(KURL::List, QListViewItem *);
	void itemSelectionChanged(void);

	void fillView(void);

	void cleared(void);
	void loaded(void);
	void saved(void);
	void tronadded(PlayListItem *);
	void removed(PlayListItem *);
	void modified(PlayListItem *);
	void current(PlayListItem *);
	void moved(PlayListItem *, PlayListItem *);

	void file_opennew(void);
	void file_open(void);
	void file_save(void);
	void file_saveas(void);
	void edit_add(void);
	void edit_remove(void);
	void options_shuffle(void);

private:
	void setModified(bool);

	void addItem(PlayListItem *item);
	void initializeItem(PlayListItem *item);
	QMap<TronListViewItem *, PlayListItem *> viewMap;
	QMap<PlayListItem *, TronListViewItem *> playMap;

	MCP *list;
	TronListView *listView;

	KAction *edit_removeAction;
	KToggleAction *options_shuffleAction;

	KURL currentPlayListURL;
	bool currentPlayListModified;
};

#endif
